<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>
<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->
<!-- This code is useful for content -->
<?php ob_start(); ?>

	<!-- Start::page-header -->
	<div class="page-header-breadcrumb mb-3">
		<div class="d-flex align-center justify-content-between flex-wrap">
			<h1 class="page-title fw-medium fs-18 mb-0">Employee List</h1>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="javascript:void(0);">Pages</a></li>
				<li class="breadcrumb-item active" aria-current="page">Employee List</li>
			</ol>
		</div>
	</div>
	<!-- End::page-header -->

	<!-- Start::row-1 -->
	<div class="row">
		<div class="col-xl-12">
			<div class="card custom-card">
				<div class="card-body">
					<table class="table text-nowrap">
						<thead>
							<tr>
								<th scope="col">Emp ID</th>
								<th scope="col">Status</th>
								<th scope="col">Employee Full Name</th>
								<th scope="col">Member Type</th>
								<th scope="col">Joining Date</th>
								<th scope="col">Team</th>
								<th scope="col">Role</th>
								<th scope="col">Department</th>
								<th scope="col">Functional Reporting</th>
								<th scope="col">Reporting Name</th>
								<th scope="col">Created At</th>
							</tr>
						</thead>

						<tbody>
							<?php
							$sql = "SELECT empid, Status, Employee_Full_Name, Member_Type, Date_of_Joining, Team_Name, Role, Department, Functional_Reporting, Functional_Reporting_Name, created_by, created_at
									FROM hr_dump
									ORDER BY COALESCE(updated_at, created_at) DESC
									LIMIT 10";

							$result = mysqli_query($conn_ic, $sql);

							if (!$result) {
								echo "<tr><td colspan='13'>Query error: " . mysqli_error($conn_ic) . "</td></tr>";
							} else {
								if (mysqli_num_rows($result) > 0) {
									while ($row = mysqli_fetch_assoc($result)) {
										?>
										<tr>
											<td><?php echo !empty($row['empid']) ? htmlspecialchars($row['empid']) : 'NA'; ?></td>
											<td><?php echo !empty($row['Status']) ? htmlspecialchars($row['Status']) : 'NA'; ?></td>
											<td><?php echo !empty($row['Employee_Full_Name']) ? htmlspecialchars($row['Employee_Full_Name']) : 'NA'; ?></td>
											<td><?php echo !empty($row['Member_Type']) ? htmlspecialchars($row['Member_Type']) : 'NA'; ?></td>
											<td><?php echo !empty($row['Date_of_Joining']) ? date('d M Y', strtotime($row['Date_of_Joining'])) : 'NA'; ?></td>
											<td><?php echo !empty($row['Team_Name']) ? htmlspecialchars($row['Team_Name']) : 'NA'; ?></td>
											<td><?php echo !empty($row['Role']) ? htmlspecialchars($row['Role']) : 'NA'; ?></td>
											<td><?php echo !empty($row['Department']) ? htmlspecialchars($row['Department']) : 'NA'; ?></td>
											<td><?php echo !empty($row['Functional_Reporting']) ? htmlspecialchars($row['Functional_Reporting']) : 'NA'; ?></td>
											<td><?php echo !empty($row['Functional_Reporting_Name']) ? htmlspecialchars($row['Functional_Reporting_Name']) : 'NA'; ?></td>
											<td><?php echo !empty($row['created_at']) ? date('d M Y H:i', strtotime($row['created_at'])) : 'NA'; ?></td>
										</tr>
										<?php
									}
								} else {
									echo "<tr><td colspan='13' class='text-muted'>No records found.</td></tr>";
								}
							}
							?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	<!--End::row-1 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->
<?php ob_start(); ?>
<?php $scripts = ob_get_clean(); ?>
<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->