<?php
include("../config-pdo.php");
require '../PhpSpreadsheet/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Get current year and month (can be customized)
$year = date('Y');      // e.g., 2025
$month = date('m');     // e.g., 09
$monthName = date('F'); // e.g., September

// Get total days in the current month
$daysInMonth = cal_days_in_month(CAL_GREGORIAN, $month, $year);

// Generate array of dates
$dates = [];
for ($day = 1; $day <= $daysInMonth; $day++) {
    $dates[] = sprintf('%04d-%02d-%02d', $year, $month, $day); // e.g., 2025-09-01
}

// Build dynamic SQL SELECT part
$dateColumnsSQL = '';
foreach ($dates as $date) {
    $dateColumnsSQL .= "IFNULL(MAX(CASE WHEN OfficeDate = '$date' THEN FinalStatus END), 'A') AS `$date`,\n";
}
$dateColumnsSQL = rtrim($dateColumnsSQL, ",\n");

// Build and execute final SQL
$sql = "
    SELECT af.empid,
           $dateColumnsSQL
    FROM ams_final af
    GROUP BY af.empid
";

$result = mysqli_query($conn_ic, $sql);

// Start Excel
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set headers
$sheet->setCellValue('A1', 'S.No.')
      ->setCellValue('B1', 'Emp ID');

$colIndex = 3; // Starting from column 'C'
foreach ($dates as $date) {
    $sheet->setCellValueByColumnAndRow($colIndex++, 1, date('d-m-Y', strtotime($date)));
}

// Fill data
$rowNum = 2;
$sno = 1;

while ($row = mysqli_fetch_assoc($result)) {
    $sheet->setCellValueByColumnAndRow(1, $rowNum, $sno);       // S.No.
    $sheet->setCellValueByColumnAndRow(2, $rowNum, $row['empid']); // Emp ID
    $colIndex = 3;
    foreach ($dates as $date) {
        $sheet->setCellValueByColumnAndRow($colIndex++, $rowNum, $row[$date]);
    }
    $rowNum++;
    $sno++;
}

// Output Excel file
$filename = "$monthName-export_" . date("Y-m-d") . ".xlsx";

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=\"$filename\"");
$writer = new Xlsx($spreadsheet);
$writer->save("php://output");
exit;
?>
