<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';

$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);

// Helper
function h($string) {
    return htmlspecialchars($string ?? 'NA', ENT_QUOTES, 'UTF-8');
}

// Handle GET parameters safely
$allowed_per_page = [10, 25, 50, 500];
$per_page_input = $_GET['per_page'] ?? 10;
$per_page = in_array((int)$per_page_input, $allowed_per_page) ? (int)$per_page_input : 10;
$per_page = max(1, $per_page); // prevent 0

$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($page - 1) * $per_page;

$search = trim($_GET['search'] ?? '');
$sort = $_GET['sort'] ?? 'created_desc';

// Sorting clause
$orderClause = match($sort) {
    'id_asc'       => 'ORDER BY id ASC',
    'id_desc'      => 'ORDER BY id DESC',
    'created_asc'  => 'ORDER BY created_at ASC',
    'created_desc' => 'ORDER BY created_at DESC',
    'status'       => 'ORDER BY Status ASC',
    'name'         => 'ORDER BY Employee_Full_Name ASC',
    default        => 'ORDER BY id DESC',
};

// WHERE clause for search
$whereClause = '';
$params = [];
$paramTypes = '';

if (!empty($search)) {
    $whereClause = "WHERE empid LIKE ? OR Employee_Full_Name LIKE ? OR LeaveCategory LIKE ?";
    $params = ["%$search%", "%$search%", "%$search%"];
    $paramTypes = str_repeat('s', count($params));
}

// Count total rows
$countSql = "SELECT COUNT(*) AS total FROM emp_leave $whereClause";
$countStmt = mysqli_prepare($conn_ic, $countSql);
if (!empty($params)) {
    mysqli_stmt_bind_param($countStmt, $paramTypes, ...$params);
}
mysqli_stmt_execute($countStmt);
$countResult = mysqli_stmt_get_result($countStmt);
$totalRows = mysqli_fetch_assoc($countResult)['total'] ?? 0;
$totalPages = ceil($totalRows / $per_page);

// Data query
$dataSql = "SELECT id, empid, Employee_Full_Name, Team_Name, LeaveCategory, ProspectID, LocationAddress, LeaveType, LQTY, DateFrom, DateCoff, Remarks, Functional_Reporting, Functional_Reporting_Remakrs, Status, created_at
            FROM emp_leave
            $whereClause
            $orderClause
            LIMIT ?, ?";

$params[] = $offset;
$params[] = $per_page;
$paramTypes .= 'ii';

$dataStmt = mysqli_prepare($conn_ic, $dataSql);
mysqli_stmt_bind_param($dataStmt, $paramTypes, ...$params);
mysqli_stmt_execute($dataStmt);
$dataResult = mysqli_stmt_get_result($dataStmt);
?>


<?php ob_start(); ?>
<?php $styles = ob_get_clean(); ?>
<?php ob_start(); ?>
<!-- Page Header -->
<div class="page-header-breadcrumb mb-3">
    <div class="d-flex align-center justify-content-between flex-wrap">
        <h1 class="page-title fw-medium fs-18 mb-0">AMS Employee Leave</h1>
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="#">Pages</a></li>
            <li class="breadcrumb-item active">AMS Employee Leaves</li>
        </ol>
    </div>
</div>
<!-- Search, sort, pagination controls -->
<form method="GET" class="row g-2 align-items-center mb-3">
    <div class="col-md-3">
        <label class="form-label">Search</label>
		<input type="text" name="search" class="form-control" placeholder="Search by name or ID..." value="<?= h($search) ?>">
    </div>

    <div class="col-md-2">
        <label class="form-label">Sort By</label>
		<select name="sort" class="form-select">
			<option value="id_desc" <?= $sort === 'id_desc' ? 'selected' : '' ?>>ID (Latest First)</option>
			<option value="id_asc" <?= $sort === 'id_asc' ? 'selected' : '' ?>>ID (Oldest First)</option>
			<option value="created_desc" <?= $sort === 'created_desc' ? 'selected' : '' ?>>Created (Newest)</option>
			<option value="created_asc" <?= $sort === 'created_asc' ? 'selected' : '' ?>>Created (Oldest)</option>
			<option value="status" <?= $sort === 'status' ? 'selected' : '' ?>>Status</option>
			<option value="name" <?= $sort === 'name' ? 'selected' : '' ?>>Employee Name</option>
		</select>
    </div>
    <div class="col-md-2">
        <label class="form-label">Rows</label>
		<select name="per_page" class="form-select">
            <?php foreach ([10, 25, 50, 500] as $opt): ?>
                <option value="<?= $opt ?>" <?= $opt == $per_page ? 'selected' : '' ?>><?= $opt ?> rows</option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-auto">
        <label class="form-label d-block">&nbsp;</label>
		<button type="submit" class="btn btn-primary">Apply</button>
        <a href="ams-leaves.php" class="btn btn-outline-secondary">Reset</a>
    </div>
</form>

<div class="card custom-card">
    <div class="card-body table-responsive">
        <table class="table table-bordered table-hover">
            <thead>
				<tr>
					<th>ID</th>
					<th>Emp ID</th>
					<th>Employee Name</th>
					<th>Prospect ID</th>
					<th>Location</th>
					<th>Category</th>
					<th>LQTY</th>
					<th>Date For</th>
					<th>Remarks</th>
					<th>Fn. Reporting</th>
					<th>Status</th>
					<th>Apply Date</th>
				</tr>
			</thead>
			<tbody>
				<?php if ($dataResult && mysqli_num_rows($dataResult) > 0): ?>
					<?php while ($row = mysqli_fetch_assoc($dataResult)): ?>
						<tr>
							<td><?= h($row['id']) ?></td>
							<td><?= h($row['empid']) ?></td>
							<td><?= h($row['Employee_Full_Name']) ?></td>
							<td><?= h($row['ProspectID']) ?></td>
							<td><?= h($row['LocationAddress']) ?></td>
							<td><?= h($row['LeaveCategory']) ?></td>
							<td><?= h($row['LQTY']) ?></td>
							<td><?= !empty($row['DateFrom']) ? date('d M Y', strtotime($row['DateFrom'])) : 'NA' ?></td>
							<td><?= h($row['Remarks']) ?></td>
							<td><?= h($row['Functional_Reporting']) ?></td>
							<td><?= h($row['Status']) ?></td>
							<td><?= !empty($row['created_at']) ? date('d M Y H:i', strtotime($row['created_at'])) : 'NA' ?></td>
						</tr>
					<?php endwhile; ?>
				<?php else: ?>
					<tr><td colspan="16" class="text-center text-muted">No records found.</td></tr>
				<?php endif; ?>
			</tbody>
        </table>
    </div>
</div>
<!-- Pagination -->
<nav class="mt-3">
    <ul class="pagination justify-content-end">
        <?php if ($page > 1): ?>
            <li class="page-item">
                <a class="page-link" href="?<?= http_build_query(['search' => $search, 'sort' => $sort, 'per_page' => $per_page, 'page' => $page - 1]) ?>">Previous</a>
            </li>
        <?php endif; ?>

        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
            <li class="page-item <?= $i === $page ? 'active' : '' ?>">
                <a class="page-link" href="?<?= http_build_query(['search' => $search, 'sort' => $sort, 'per_page' => $per_page, 'page' => $i]) ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>

        <?php if ($page < $totalPages): ?>
            <li class="page-item">
                <a class="page-link" href="?<?= http_build_query(['search' => $search, 'sort' => $sort, 'per_page' => $per_page, 'page' => $page + 1]) ?>">Next</a>
            </li>
        <?php endif; ?>
    </ul>
</nav>
<?php $content = ob_get_clean(); ?>
<?php ob_start(); ?>
<?php $scripts = ob_get_clean(); ?>
<?php include 'layouts/base.php'; ?>