<?php
include("../config-pdo.php");
require '../PhpSpreadsheet/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Get the first day of the current month and today's date
$start_date = date('Y-m-01');
$end_date = date('Y-m-d');

// Fetch only available columns
$query = "
    SELECT 
        empid, Employee_Full_Name, Team_Name, Functional_Reporting,
        location, out_location, status, OfficeDate,
        OfficeIn, OfficeLate, OfficeEarly, OfficeOut
    FROM tracker
    WHERE OfficeDate BETWEEN '$start_date' AND '$end_date'
    ORDER BY OfficeDate ASC
";
$result = mysqli_query($conn_ic, $query);

// Create new spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set headers (no S.No. and no ID)
$headers = [
    'Emp ID', 'Employee Name', 'Team Name', 'Functional Reporting',
    'Location', 'Out Location', 'Status', 'Office Date',
    'Office In', 'Office Late', 'Office Early', 'Office Out'
];

// Write headers to sheet
$col = 1;
foreach ($headers as $header) {
    $sheet->setCellValueByColumnAndRow($col++, 1, $header);
}

// Fill data
$rowNum = 2;
while ($data = mysqli_fetch_assoc($result)) {
    $col = 1;
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['empid']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['Employee_Full_Name']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['Team_Name']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['Functional_Reporting']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['location']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['out_location']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['status']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['OfficeDate']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['OfficeIn']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['OfficeLate']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['OfficeEarly']);
    $sheet->setCellValueByColumnAndRow($col++, $rowNum, $data['OfficeOut']);
    
    $rowNum++;
}

// Output Excel file
$monthName = date('F'); // e.g., September
$filename = "$monthName-tracker-export_" . date("Y-m-d") . ".xlsx";

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=\"$filename\"");
$writer = new Xlsx($spreadsheet);
$writer->save("php://output");
exit;
?>
