<?php
/* pages/header_admin.php — Manage header/sidebar and per-item scripts */

ini_set('display_errors',1); ini_set('display_startup_errors',1); error_reporting(E_ALL);
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__.'/../config.php';      // mysqli $conn
require_once __DIR__.'/../functions.php';   // h(), post(), etc.
mysqli_set_charset($conn,'utf8mb4');

if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8'); } }
if (!function_exists('iget')) { function iget($k,$d=0){ return isset($_GET[$k])?intval($_GET[$k]):$d; } }
if (!function_exists('ensure_dir')) { function ensure_dir($p){ if(!is_dir($p)) @mkdir($p,0775,true); } }

/* ---- simple admin gate (adjust to your auth) ---- */
$role = strtolower((string)($_SESSION['role'] ?? ''));
if (!in_array($role,['admin','administrator','superadmin'])) { header('Location: ../sign-in-cover.php'); exit; }

/* ---- schema (same as renderer) ---- */
mysqli_query($conn, "CREATE TABLE IF NOT EXISTS ui_menu (
  id INT AUTO_INCREMENT PRIMARY KEY,
  position ENUM('header','sidebar') NOT NULL DEFAULT 'sidebar',
  section VARCHAR(60) NULL,
  parent_id INT NULL,
  label VARCHAR(120) NOT NULL,
  sublabel VARCHAR(120) NULL,
  url VARCHAR(255) NOT NULL,
  target ENUM('_self','_blank') NOT NULL DEFAULT '_self',
  icon_class VARCHAR(120) NULL,
  icon_image VARCHAR(255) NULL,
  icon_svg MEDIUMTEXT NULL,
  badge_text VARCHAR(24) NULL,
  badge_class VARCHAR(120) NULL,
  visible_to ENUM('all','admin','broker','user') NOT NULL DEFAULT 'all',
  sort_order INT NOT NULL DEFAULT 0,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  script_js MEDIUMTEXT NULL,
  script_run ENUM('click','load','both') NOT NULL DEFAULT 'click',
  data_json JSON NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NULL ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci");

$self = basename(__FILE__);

/* ---- actions ---- */
$action = $_GET['action'] ?? '';
$id     = iget('id',0);
$msg=''; $err='';

if ($action==='delete' && $id>0) {
  $rs = mysqli_query($conn,"SELECT icon_image FROM ui_menu WHERE id=".$id);
  if ($r=mysqli_fetch_assoc($rs)) { if ($r['icon_image'] && is_file(__DIR__.'/../'.$r['icon_image'])) @unlink(__DIR__.'/../'.$r['icon_image']); }
  if (!mysqli_query($conn,"DELETE FROM ui_menu WHERE id=".$id)) $err="Delete failed: ".h(mysqli_error($conn)); else $msg="Deleted.";
}
if ($action==='toggle' && $id>0) {
  if (!mysqli_query($conn,"UPDATE ui_menu SET is_active=1-is_active WHERE id=".$id)) $err="Toggle failed: ".h(mysqli_error($conn)); else $msg="Toggled.";
}
if ($action==='clear_icon' && $id>0) {
  $rs = mysqli_query($conn,"SELECT icon_image FROM ui_menu WHERE id=".$id);
  if ($r=mysqli_fetch_assoc($rs)) { if ($r['icon_image'] && is_file(__DIR__.'/../'.$r['icon_image'])) @unlink(__DIR__.'/../'.$r['icon_image']); }
  if (!mysqli_query($conn,"UPDATE ui_menu SET icon_image=NULL WHERE id=".$id)) $err="Clear icon failed: ".h(mysqli_error($conn)); else $msg="Icon cleared.";
}

/* ---- save (create/update) ---- */
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $position   = post('position','sidebar');
  $section    = post('section','Main');
  $parent_id  = (int)post('parent_id',0);
  $label      = post('label','');
  $sublabel   = post('sublabel','');
  $url        = post('url','');
  $target     = post('target','_self')==='_blank' ? '_blank' : '_self';
  $icon_class = post('icon_class','');
  $icon_svg   = post('icon_svg','');
  $sort_order = (int)post('sort_order',0);
  $visible_to = post('visible_to','all');
  $badge_text = post('badge_text','');
  $badge_class= post('badge_class','bg-primary-transparent ms-2');
  $is_active  = isset($_POST['is_active'])?1:0;
  $script_js  = post('script_js','');
  $script_run = post('script_run','click');
  $data_json  = trim((string)post('data_json',''));

  if ($label==='' || $url==='') $err="Label & URL are required.";
  $icon_image_path = null;

  if (!$err && !empty($_FILES['icon_image']['name']) && is_uploaded_file($_FILES['icon_image']['tmp_name'])) {
    $mime = @mime_content_type($_FILES['icon_image']['tmp_name']);
    $ok = in_array($mime,['image/png','image/jpeg','image/webp','image/gif','image/svg+xml'],true);
    if (!$ok) { $err="Invalid icon image type."; }
    else {
      $dir = __DIR__.'/../uploads/menu'; ensure_dir($dir);
      $base = preg_replace('~[^A-Za-z0-9._-]+~','-', $_FILES['icon_image']['name']);
      $base = trim($base,'-');
      $name = time().'_'.$base;
      if (move_uploaded_file($_FILES['icon_image']['tmp_name'],$dir.'/'.$name)) $icon_image_path = 'uploads/menu/'.$name;
      else $err="Failed to move icon image.";
    }
  }

  if (!$err) {
    if ($action==='save_new') {
      $stmt = mysqli_prepare($conn,"INSERT INTO ui_menu
       (position,section,parent_id,label,sublabel,url,target,icon_class,icon_image,icon_svg,badge_text,badge_class,visible_to,sort_order,is_active,script_js,script_run,data_json)
       VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
      mysqli_stmt_bind_param($stmt,'ssissssssssssissss',
        $position,$section,$parent_id,$label,$sublabel,$url,$target,$icon_class,$icon_image_path,$icon_svg,$badge_text,$badge_class,$visible_to,$sort_order,$is_active,$script_js,$script_run,$data_json
      );
      if (mysqli_stmt_execute($stmt)) $msg="Created."; else $err="Create failed: ".h(mysqli_stmt_error($stmt));
      mysqli_stmt_close($stmt);
    } elseif ($action==='save_edit' && $id>0) {
      if ($icon_image_path) {
        $stmt = mysqli_prepare($conn,"UPDATE ui_menu SET
          position=?,section=?,parent_id=?,label=?,sublabel=?,url=?,target=?,icon_class=?,icon_image=?,icon_svg=?,badge_text=?,badge_class=?,visible_to=?,sort_order=?,is_active=?,script_js=?,script_run=?,data_json=? WHERE id=?");
        mysqli_stmt_bind_param($stmt,'ssissssssssssissssi',
          $position,$section,$parent_id,$label,$sublabel,$url,$target,$icon_class,$icon_image_path,$icon_svg,$badge_text,$badge_class,$visible_to,$sort_order,$is_active,$script_js,$script_run,$data_json,$id
        );
      } else {
        $stmt = mysqli_prepare($conn,"UPDATE ui_menu SET
          position=?,section=?,parent_id=?,label=?,sublabel=?,url=?,target=?,icon_class=?,icon_svg=?,badge_text=?,badge_class=?,visible_to=?,sort_order=?,is_active=?,script_js=?,script_run=?,data_json=? WHERE id=?");
        mysqli_stmt_bind_param($stmt,'ssisssssssssisissi',
          $position,$section,$parent_id,$label,$sublabel,$url,$target,$icon_class,$icon_svg,$badge_text,$badge_class,$visible_to,$sort_order,$is_active,$script_js,$script_run,$data_json,$id
        );
      }
      if (mysqli_stmt_execute($stmt)) $msg="Updated."; else $err="Update failed: ".h(mysqli_stmt_error($stmt));
      mysqli_stmt_close($stmt);
    }
  }
}

/* ---- edit row (if any) ---- */
$edit=null;
if ($action==='edit' && $id>0) {
  $rs = mysqli_query($conn,"SELECT * FROM ui_menu WHERE id=".$id." LIMIT 1");
  $edit = mysqli_fetch_assoc($rs);
}

/* ---- helpers for dropdowns ---- */
function optSel($v,$cur){ return $v==$cur?'selected':''; }

/* ---- page (barebones bootstrap classes—fits most themes) ---- */
?>
<!doctype html><html><head><meta charset="utf-8"><title>Header/Sidebar Admin</title>
<link rel="stylesheet" href="../assets/libs/bootstrap/css/bootstrap.min.css">
<style>
textarea.code{font-family: ui-monospace,SFMono-Regular,Consolas,monospace}
svg.side-menu__icon,svg.side-menu-doublemenu__icon{vertical-align:middle}
</style>
</head><body class="p-3">
<div class="d-flex align-items-center justify-content-between mb-3">
  <h3 class="mb-0">Header & Sidebar (DB)</h3>
  <a class="btn btn-outline-secondary" href="../index.php">Back</a>
</div>

<?php if($msg): ?><div class="alert alert-success"><?php echo h($msg); ?></div><?php endif; ?>
<?php if($err): ?><div class="alert alert-danger"><?php echo h($err); ?></div><?php endif; ?>

<div class="row">
  <div class="col-lg-5">
    <div class="card mb-3"><div class="
