<?php
function getUserPermissions($roleId, $conn_sa) {
    if ($roleId == 1) {
        return ['all'];
    }

    $permissions = [];
    $stmt = $conn_sa->prepare("SELECT permissions FROM roles WHERE id = ?");
    $stmt->bind_param("i", $roleId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        if (!empty($row['permissions']) && is_string($row['permissions'])) {
            $decoded = json_decode($row['permissions'], true);
            if (json_last_error() === JSON_ERROR_NONE) {
                $permissions = $decoded;
            }
        }
    }
    $stmt->close();

    return $permissions;
}

function checkPageAccessOrRedirect($currentPage, $conn_sa) {
    if (!isset($_SESSION['role_id'])) {
        header("Location: login.php");
        exit;
    }
    $roleId = $_SESSION['role_id'];
    $permissions = getUserPermissions($roleId, $conn_sa);
    if (in_array('all', $permissions) || in_array($currentPage, $permissions)) {
        return;
    }
    if (!empty($permissions)) {
        foreach ($permissions as $page) {
            if (str_ends_with($page, '.php') && $page !== $currentPage) {
                header("Location: $page");
                exit;
            }
        }
    }
    echo "<h3>You don't have access to this page.</h3>";
    exit;
}

?>
