
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Analytics</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Analytics</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row">
                        <div class="col-xxl-9">
                            <div class="row">
                                <div class="col-xxl-3 col-lg-6">
                                    <div class="card custom-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start gap-3">
                                                <div>
                                                    <span class="avatar avatar-md bg-primary svg-white">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 4c1.93 0 3.5 1.57 3.5 3.5S13.93 13 12 13s-3.5-1.57-3.5-3.5S10.07 6 12 6zm0 14c-2.03 0-4.43-.82-6.14-2.88C7.55 15.8 9.68 15 12 15s4.45.8 6.14 2.12C16.43 19.18 14.03 20 12 20z"/></g></svg>
                                                    </span>
                                                </div>
                                                <div>
                                                    <span class="d-block text-muted">Total Users</span>
                                                    <h5 class="fw-semibold mb-1">42,643</h5>
                                                    <div class="text-muted fs-12">
                                                        <span class="text-success"><i class="ti ti-arrow-narrow-up me-1"></i>0.45%</span>
                                                        This Year
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-3 col-lg-6">
                                    <div class="card custom-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start gap-3">
                                                <div>
                                                    <span class="avatar avatar-md bg-secondary svg-white">
                                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 17H7v-5h2v5zm4 0h-2v-3h2v3zm0-5h-2v-2h2v2zm4 5h-2V7h2v10z"/></svg>
                                                    </span>
                                                </div>
                                                <div>
                                                    <span class="d-block text-muted">Total Sessions</span>
                                                    <h5 class="fw-semibold mb-1">143K</h5>
                                                    <div class="text-muted fs-12">
                                                        <span class="text-success"><i class="ti ti-arrow-narrow-up me-1"></i>2.76%</span>
                                                        This Year
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-3 col-lg-6">
                                    <div class="card custom-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start gap-3">
                                                <div>
                                                    <span class="avatar avatar-md bg-success svg-white">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><g><g><g><path d="M7.5,11C9.43,11,11,9.43,11,7.5S9.43,4,7.5,4S4,5.57,4,7.5S5.57,11,7.5,11z M7.5,6C8.33,6,9,6.67,9,7.5S8.33,9,7.5,9 S6,8.33,6,7.5S6.67,6,7.5,6z"/></g></g><g><rect height="2" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -4.9706 12)" width="20.63" x="1.69" y="11"/></g><g><g><path d="M16.5,13c-1.93,0-3.5,1.57-3.5,3.5s1.57,3.5,3.5,3.5s3.5-1.57,3.5-3.5S18.43,13,16.5,13z M16.5,18 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S17.33,18,16.5,18z"/></g></g></g></g></svg>
                                                    </span>
                                                </div>
                                                <div>
                                                    <span class="d-block text-muted">Bounce Rate</span>
                                                    <h5 class="fw-semibold mb-1">91.6%</h5>
                                                    <div class="text-muted fs-12">
                                                        <span class="text-success"><i class="ti ti-arrow-narrow-up me-1"></i>3.85%</span>
                                                        This Year
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-3 col-lg-6">
                                    <div class="card custom-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start gap-3">
                                                <div>
                                                    <span class="avatar avatar-md bg-warning svg-white">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><g><rect height="2" width="6" x="9" y="1"/><path d="M19.03,7.39l1.42-1.42c-0.43-0.51-0.9-0.99-1.41-1.41l-1.42,1.42C16.07,4.74,14.12,4,12,4c-4.97,0-9,4.03-9,9 c0,4.97,4.02,9,9,9s9-4.03,9-9C21,10.88,20.26,8.93,19.03,7.39z M13,14h-2V8h2V14z"/></g></g></svg>
                                                    </span>
                                                </div>
                                                <div>
                                                    <span class="d-block text-muted">Avg Session Duration</span>
                                                    <h5 class="fw-semibold mb-1">2m 27s</h5>
                                                    <div class="text-muted fs-12">
                                                        <span class="text-danger"><i class="ti ti-arrow-narrow-down me-1"></i>2.44%</span>
                                                        This Year
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-4">
                                    <div class="card custom-card">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Sessions By Device
                                            </div>
                                            <div class="dropdown"> 
                                                <a href="javascript:void(0);" class="p-2 fs-12 text-muted" data-bs-toggle="dropdown" aria-expanded="false"> View All<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i> </a> 
                                                <ul class="dropdown-menu" role="menu"> 
                                                    <li><a class="dropdown-item" href="javascript:void(0);">Day</a></li> 
                                                    <li><a class="dropdown-item" href="javascript:void(0);">Month</a></li> 
                                                    <li><a class="dropdown-item" href="javascript:void(0);">Year</a></li> 
                                                </ul> 
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div id="sessions-device"></div>
                                        </div>
                                        <div class="card-footer p-0">
                                            <div class="row">
                                                <div class="col">
                                                    <div class="p-3 text-center border-end">
                                                        <h5 class="fw-semibold mb-1">46.75%</h5>
                                                        <span class="fs-12 d-block">Mobile</span>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="p-3 text-center custom-border-end">
                                                        <h5 class="fw-semibold mb-1">31.79%</h5>
                                                        <span class="fs-12 d-block">Tablet</span>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="p-3 text-center">
                                                        <h5 class="fw-semibold mb-1">22.46%</h5>
                                                        <span class="fs-12 d-block">Desktop</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-8">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Audience Metrics
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div id="audience-metrics"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-4">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Visitors By Countries
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div class="table-responsive">
                                                <table class="table text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th>S.No</th>
                                                            <th>Country</th>
                                                            <th>Visitors</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td class="border-bottom-0">1</td>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/us_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">USA</div>
                                                                </div>
                                                            </td>
                                                            <td class="border-bottom-0"><span class="fs-12 text-muted me-2">(<i class="ti ti-arrow-up text-success fs-16 align-middle"></i>2.15% )</span>45,234</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="border-bottom-0">2</td>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/argentina_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">Argentina</div>
                                                                </div>
                                                            </td>
                                                            <td class="border-bottom-0"><span class="fs-12 text-muted me-2">(<i class="ti ti-arrow-up text-success fs-16 align-middle"></i>1.62% )</span>12,234</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="border-bottom-0">3</td>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/italy_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">Italy</div>
                                                                </div>
                                                            </td>
                                                            <td class="border-bottom-0"><span class="fs-12 text-muted me-2">(<i class="ti ti-arrow-down text-danger fs-16 align-middle"></i>0.85% )</span>7,234</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="border-bottom-0">4</td>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/russia_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">Russia</div>
                                                                </div>
                                                            </td>
                                                            <td class="border-bottom-0"><span class="fs-12 text-muted me-2">(<i class="ti ti-arrow-up text-success fs-16 align-middle"></i>3.51% )</span>3,543</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="border-bottom-0">5</td>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/spain_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">Spain</div>
                                                                </div>
                                                            </td>
                                                            <td class="border-bottom-0"><span class="fs-12 text-muted me-2">(<i class="ti ti-arrow-up text-success fs-16 align-middle"></i>0.56% )</span>2,463</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="border-bottom-0">6</td>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/uae_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">Uae</div>
                                                                </div>
                                                            </td>
                                                            <td class="border-bottom-0"><span class="fs-12 text-muted me-2">(<i class="ti ti-arrow-up text-success fs-16 align-middle"></i>1.92% )</span>1,832</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-8">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Top Campaigns
                                            </div>
                                            <div class="dropdown">
                                                <a href="javascript:void(0);" class="p-2 fs-12 text-muted tag-link" data-bs-toggle="dropdown">
                                                    View All<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
                                                </a>
                                                <ul class="dropdown-menu" role="menu">
                                                    <li><a class="dropdown-item" href="javascript:void(0);">Download</a></li>
                                                    <li><a class="dropdown-item" href="javascript:void(0);">Import</a></li>
                                                    <li><a class="dropdown-item" href="javascript:void(0);">Export</a></li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div class="table-responsive campaigntable">
                                                <table class="table text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th scope="col">Provider</th>
                                                            <th scope="col">Sales</th>
                                                            <th scope="col">Goal</th>
                                                            <th scope="col">Status</th>
                                                            <th scope="col">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center lh-1">
                                                                        <span class="avatar avatar-sm p-1 bg-light me-2">
                                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg">
                                                                        </span>
                                                                    <div><p class="fw-medium mb-1">Leo Phillips</p><span class="fs-12 text-muted">Influencer</span></div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                            $12,465
                                                            </td>
                                                            <td>
                                                                <span class="text-primary">23.3%</span>
                                                            </td>
                                                            <td><span class="badge bg-info-transparent">On process</span></td>
                                                            <td class="">
                                                                <div class="btn-list">
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Edit" aria-label="Edit"><i class="bi bi-pencil-square"></i></a>
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Delete" aria-label="Delete"><i class="bi bi-trash"></i></a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center lh-1">
                                                                    <span class="avatar avatar-sm p-1 bg-light me-2">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg">
                                                                    </span>
                                                                <div><p class="fw-medium mb-1">Noah Russell</p><span class="fs-12 text-muted">Influencer</span></div>
                                                            </div>
                                                            </td>
                                                            <td>
                                                            $3,576
                                                            </td>
                                                            <td>
                                                                <span class="text-secondary">19.4%</span>
                                                            </td>
                                                            <td><span class="badge bg-success-transparent">Achieved</span></td>
                                                            <td class="">
                                                                <div class="btn-list">
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Edit" aria-label="Edit"><i class="bi bi-pencil-square"></i></a>
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Delete" aria-label="Delete"><i class="bi bi-trash"></i></a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center lh-1">
                                                                    <span class="avatar avatar-sm p-1 bg-light me-2">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg">
                                                                    </span>
                                                                <div><p class="fw-medium mb-1">Henry Morgan</p><span class="fs-12 text-muted">Youtuber</span></div>
                                                            </div>
                                                            </td>
                                                            <td>
                                                            $12,764
                                                            </td>
                                                            <td>
                                                                <span class="text-success">12.76%</span>
                                                            </td>
                                                            <td><span class="badge bg-info-transparent">On Process</span></td>
                                                            <td class="">
                                                                <div class="btn-list">
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Edit" aria-label="Edit"><i class="bi bi-pencil-square"></i></a>
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Delete" aria-label="Delete"><i class="bi bi-trash"></i></a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center lh-1">
                                                                    <span class="avatar avatar-sm p-1 bg-light me-2">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg">
                                                                    </span>
                                                                <div><p class="fw-medium mb-1">Ava Taylor</p><span class="fs-12 text-muted">Content Creator</span></div>
                                                            </div>
                                                            </td>
                                                            <td>
                                                            $13,864
                                                            </td>
                                                            <td>
                                                                <span class="text-warning">16.78%</span>
                                                            </td>
                                                            <td><span class="badge bg-success-transparent">Achieved</span></td>
                                                            <td class="">
                                                                <div class="btn-list">
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Edit" aria-label="Edit"><i class="bi bi-pencil-square"></i></a>
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Delete" aria-label="Delete"><i class="bi bi-trash"></i></a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center lh-1">
                                                                    <span class="avatar avatar-sm p-1 bg-light me-2">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg">
                                                                    </span>
                                                                <div><p class="fw-medium mb-1">Liam Parker</p><span class="fs-12 text-muted">Youtuber</span></div>
                                                            </div>
                                                            </td>
                                                            <td class="border-bottom-0">
                                                            $9,756
                                                            </td><td class="border-bottom-0">
                                                                <span class="text-info">6.13%</span>
                                                            </td>
                                                            <td class="border-bottom-0"><span class="badge bg-success-transparent">Achieved</span></td>
                                                            <td class="border-bottom-0">
                                                                <div class="btn-list">
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Edit" aria-label="Edit"><i class="bi bi-pencil-square"></i></a>
                                                                    <a href="javascript:void(0);" class="btn btn-light btn-icon btn-sm" data-bs-toggle="tooltip" title="" data-bs-original-title="Delete" aria-label="Delete"><i class="bi bi-trash"></i></a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Engagement Metrics
                                            </div>
                                            <div class="d-flex flex-wrap gap-2"> 
                                                <div> 
                                                    <input class="form-control form-control-sm" type="text" placeholder="Search Here" aria-label=".form-control-sm example"> 
                                                </div> 
                                                <div class="dropdown"> 
                                                    <a href="javascript:void(0);" class="btn btn-primary btn-sm btn-wave waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="false"> Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i> 
                                                    </a> 
                                                    <ul class="dropdown-menu" role="menu"> 
                                                        <li><a class="dropdown-item" href="javascript:void(0);">New</a></li> 
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Popular</a></li> 
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Relevant</a></li> 
                                                    </ul> 
                                                </div> 
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div class="table-responsive">
                                                <table class="table text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center">
                                                                S.No
                                                            </th>
                                                            <th>
                                                                User
                                                            </th>
                                                            <th>
                                                                Sessions	
                                                            </th>
                                                            <th>
                                                                Country
                                                            </th>
                                                            <th>
                                                                Page Views
                                                            </th>
                                                            <th>
                                                                Bounce Rate
                                                            </th>
                                                            <th class="text-center">
                                                                Conversion Rate
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td class="text-center">1</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        John Doe
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>120</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/us_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        United States
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>350</td>
                                                            <td>45%</td>
                                                            <td class="text-center">5.2%</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="text-center">2</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        Jane Smith
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>95</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/germany_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        Germany
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>240</td>
                                                            <td>38%</td>
                                                            <td class="text-center">6.8%</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="text-center">3</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        Chris Johnson
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>110</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/canada_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        Canada
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>290</td>
                                                            <td>40%</td>
                                                            <td class="text-center">4.5%</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="text-center">4</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        Emily Davis
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>75</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/argentina_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        Argentina
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>200</td>
                                                            <td>50%</td>
                                                            <td class="text-center">3.8%</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="text-center">5</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/15.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        Michael Brown
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>135</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xs avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/india_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        India
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>400</td>
                                                            <td>30%</td>
                                                            <td class="text-center">7.1%</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="card-footer border-top-0"> 
                                            <div class="d-flex align-items-center flex-wrap"> 
                                                <div> Showing 5 Entries <i class="bi bi-arrow-right ms-2 fw-semibold"></i> </div>
                                                <div class="ms-auto"> 
                                                <nav aria-label="Page navigation" class="pagination-style-4"> 
                                                    <ul class="pagination mb-0"> 
                                                        <li class="page-item disabled"> <a class="page-link" href="javascript:void(0);"> Prev </a> </li>
                                                            <li class="page-item active"><a class="page-link" href="javascript:void(0);">1</a></li> 
                                                            <li class="page-item"><a class="page-link" href="javascript:void(0);">2</a></li> 
                                                            <li class="page-item"> <a class="page-link text-primary" href="javascript:void(0);"> next </a> </li> 
                                                        </ul> 
                                                    </nav> 
                                                </div> 
                                            </div> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Browser Insights
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-unstyled browser-insights-list">
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded avatar-sm">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/browsers/chrome.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-medium">Google</span>
                                                            <span class="d-block text-muted fs-12">Google,Inc</span>
                                                        </div>
                                                        <div class="text-end w-25">
                                                            <span class="d-block mb-1 fw-semibold">
                                                                1,215
                                                            </span>
                                                            <div class="progress progress-animate progress-xs w-75 ms-auto"> 
                                                                <div class="progress-bar bg-primary" role="progressbar" style="width: 78%" aria-valuenow="78" aria-valuemin="0" aria-valuemax="100"> </div> 
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded avatar-sm">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/browsers/edge.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-medium">Edge</span>
                                                            <span class="d-block text-muted fs-12">Microsoft Corp,Inc</span>
                                                        </div>
                                                        <div class="text-end w-25">
                                                            <span class="d-block mb-1 fw-semibold">
                                                                978
                                                            </span>
                                                            <div class="progress progress-animate progress-xs w-75 ms-auto">
                                                                <div class="progress-bar bg-secondary" role="progressbar" style="width: 72%" aria-valuenow="72" aria-valuemin="0" aria-valuemax="100">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded avatar-sm">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/browsers/firefox.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-medium">Firefox</span>
                                                            <span class="d-block text-muted fs-12">Mozilla,Inc</span>
                                                        </div>
                                                        <div class="text-end w-25">
                                                            <span class="d-block mb-1 fw-semibold">
                                                                815
                                                            </span>
                                                            <div class="progress progress-animate progress-xs w-75 ms-auto">
                                                                <div class="progress-bar bg-warning" role="progressbar" style="width: 64%" aria-valuenow="64" aria-valuemin="0" aria-valuemax="100">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded avatar-sm">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/browsers/opera.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-medium">Opera</span>
                                                            <span class="d-block text-muted fs-12">Opera,Inc</span>
                                                        </div>
                                                        <div class="text-end w-25">
                                                            <span class="d-block mb-1 fw-semibold">
                                                                1,347
                                                            </span>
                                                            <div class="progress progress-animate progress-xs w-75 ms-auto">
                                                                <div class="progress-bar bg-info" role="progressbar" style="width: 58%" aria-valuenow="58" aria-valuemin="0" aria-valuemax="100">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded avatar-sm">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/browsers/safari.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-medium">Safari</span>
                                                            <span class="d-block text-muted fs-12">Apple Corp,Inc</span>
                                                        </div>
                                                        <div class="text-end w-25">
                                                            <span class="d-block mb-1 fw-semibold">
                                                                1,123
                                                            </span>
                                                            <div class="progress progress-animate progress-xs w-75 ms-auto">
                                                                <div class="progress-bar bg-success" role="progressbar" style="width: 63%" aria-valuenow="63" aria-valuemin="0" aria-valuemax="100">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded avatar-sm">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/browsers/uc.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-medium">Uc Browser</span>
                                                            <span class="d-block text-muted fs-12">Uc Browser,Inc</span>
                                                        </div>
                                                        <div class="text-end w-25">
                                                            <span class="d-block mb-1 fw-semibold">
                                                                1,189
                                                            </span>
                                                            <div class="progress progress-animate progress-xs w-75 ms-auto">
                                                                <div class="progress-bar bg-danger" role="progressbar" style="width: 55%" aria-valuenow="55" aria-valuemin="0" aria-valuemax="100">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Users By Time Of Week
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div id="users-by-time"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">    
                                                Top Referral Pages
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3 flex-wrap">
                                                <h4 class="fw-bold mb-0">4,289</h4>
                                                <div class="ms-2">
                                                    <span class="badge bg-success-transparent">1.02<i class="ri-arrow-up-s-fill align-mmiddle ms-1"></i></span>
                                                    <span class="text-muted ms-1 text-nowrap">compared to last week</span>
                                                </div>
                                            </div>
                                            <div class="progress-stacked progress-animate progress-sm mb-4">
                                                <div class="progress-bar" role="progressbar" style="width: 21%" aria-valuenow="21" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-info" role="progressbar" style="width: 26%" aria-valuenow="26" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-warning" role="progressbar" style="width: 35%" aria-valuenow="35" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-success" role="progressbar" style="width: 18%" aria-valuenow="18" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <ul class="list-unstyled mb-0 pt-2 top-referral-pages">
                                                <li class="primary">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <div>blog/how-to-improve-seo</div>
                                                        <div class="fs-12 text-muted">1,250</div>
                                                    </div>
                                                </li>
                                                <li class="info">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <div>products/new-launch</div>
                                                        <div class="fs-12 text-muted">1,100</div>
                                                    </div>
                                                </li>
                                                <li class="warning">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <div>services/digital-marketing</div>
                                                        <div class="fs-12 text-muted">950</div>
                                                    </div>
                                                </li>
                                                <li class="success">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <div>pricing</div>
                                                        <div class="fs-12 text-muted">890</div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Average Sessions
                                            </div>
                                        </div>
                                        <div class="card-body pb-0">
                                            <div class="d-flex gap-3 flex-wrap align-items-center mb-3"> 
                                                <svg xmlns="http://www.w3.org/2000/svg" width="32px" height="32px" class="text-primary bg-primary-transparent rounded-1 px-1" viewBox="0 0 24 24"><g fill="currentColor"><path fill-opacity="0.5" d="M8 13h6v4H8z"></path><path d="M6 6H4v12h2zm14 1H8v4h12z"></path></g></svg> <div> 
                                                    <h6 class="fw-medium mb-0">3m 45s</h6> 
                                                </div> 
                                                <div class="ms-auto text-muted fs-11 text-end"> 
                                                    <div class="fw-medium">From Last Week</div> 
                                                    <span class="text-success fw-semibold"> 1.25% <i class="ri-arrow-up-line lh-1 align-center fs-14 fw-normal"></i></span> 
                                                </div> 
                                            </div>
                                            <div id="analytics-avgsession"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-1 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

        <!-- Analytics Dashboard --> 
        <script src="<?php echo $baseUrl; ?>/assets/js/analytics-dashboard.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
