<?php
/* ============================================================================
 * File: app_helpers.php
 * Purpose: Centralized app-wide helpers with redeclare guards
 * Notes  : Include this ONCE (e.g., in your header or each page top).
 *          Safe with utf8mb4, no PDO, no DB required here.
 * ========================================================================== */

if (!function_exists('h')) {
    function h($s) { return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8'); }
}

if (!function_exists('valid_hex')) {
    function valid_hex($c) { return (bool)preg_match('/^#[0-9a-fA-F]{6}$/', (string)$c); }
}

if (!function_exists('slugify')) {
    function slugify($text) {
        $text = trim(mb_strtolower((string)$text, 'UTF-8'));
        $text = preg_replace('/[^a-z0-9]+/u', '-', $text);
        $text = trim($text, '-');
        if ($text === '') $text = 'slug-' . substr(md5(mt_rand()), 0, 6);
        return substr($text, 0, 64);
    }
}
