<?php
// layouts/components/save_theme_settings.php
// Saves GLOBAL theme settings (applies to all users). MySQLi, utf8mb4_general_ci, config.php.

@session_start();

/* include config.php (no PDO) */
$__candidates = [
  __DIR__ . '/../../config.php',
  __DIR__ . '/../config.php',
  __DIR__ . '/config.php',
  dirname(__DIR__, 3) . '/config.php'
];
foreach ($__candidates as $__c) { if (is_file($__c)) { require_once $__c; break; } }

if (!isset($conn) || !$conn) {
  http_response_code(500);
  header('Content-Type: application/json');
  echo json_encode(['ok'=>false,'msg'=>'DB connection not found (config.php)']);
  exit;
}
mysqli_set_charset($conn, 'utf8mb4');

/* ensure table (single global row keyed by scope='global' AND user_id=0) */
@mysqli_query($conn, "CREATE TABLE IF NOT EXISTS `theme_settings` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `scope` ENUM('global','user') NOT NULL DEFAULT 'global',
  `user_id` INT UNSIGNED NOT NULL DEFAULT 0,
  `settings_json` JSON NOT NULL,
  `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_scope_user` (`scope`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci");

/* read input */
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!is_array($data)) { $data = $_POST; }

/* reset => delete the single global row */
if (isset($data['reset']) && (int)$data['reset'] === 1) {
  @mysqli_query($conn, "DELETE FROM theme_settings WHERE scope='global' AND user_id=0");
  header('Content-Type: application/json');
  echo json_encode(['ok'=>true,'msg'=>'reset']);
  exit;
}

/* sanitize + whitelist radio groups */
$allowed = ['theme-style','direction','navigation-style','navigation-menu-styles','sidemenu-layout-styles','page-styles','layout-width','menu-positions','header-positions','page-loader','menu-colors','header-colors','theme-primary','theme-background','menu-background'];
$settings = isset($data['settings']) && is_array($data['settings']) ? $data['settings'] : [];
$clean = [];
foreach ($allowed as $k) {
  if (isset($settings[$k]) && is_string($settings[$k])) {
    $clean[$k] = substr($settings[$k], 0, 100); // store the selected input id
  }
}
$json = json_encode($clean, JSON_UNESCAPED_UNICODE);

/* upsert the GLOBAL row (scope='global', user_id=0) */
$ok=false; $err='';
if ($stmt = mysqli_prepare($conn, "INSERT INTO theme_settings (`scope`,`user_id`,`settings_json`,`updated_at`)
                                   VALUES ('global',0, ?, NOW())
                                   ON DUPLICATE KEY UPDATE settings_json=VALUES(settings_json), updated_at=NOW()")) {
  mysqli_stmt_bind_param($stmt, "s", $json);
  $ok = mysqli_stmt_execute($stmt);
  $err = mysqli_error($conn);
  mysqli_stmt_close($stmt);
}

header('Content-Type: application/json');
echo json_encode(['ok'=>(bool)$ok,'msg'=>$ok?'saved':('db-error: '.$err),'data'=>$clean]);
