<?php
/* admin/applications/submitted-list.php
 * Purpose: List "Submitted" employee applications using your theme’s Jobs List look & feel
 * Stack: Core PHP + MySQLi (no PDO). DB connection in ../../config.php. DB collation utf8mb4_general_ci assumed.
 * Notes:
 * - Uses theme layout pattern ($styles, $content, $scripts) and includes ../../layouts/base.php so header/sidebar render automatically.
 * - Client-side search, check-all, and simple server-side pagination (?page=, ?per_page=10|25|50|500).
 */

session_start();
require_once 'onboarding-config.php';
/*if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
    header("Location: " . BASE_URL . "admin/login");
    exit;
} */
require_once __DIR__ . '/../config.php';
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
/* ---------- Helpers ---------- */
function h($v){ return htmlspecialchars((string)($v??''), ENT_QUOTES, 'UTF-8'); }

/* ---------- Admin fetch (optional use) ---------- */
/*$username = mysqli_real_escape_string($conn, $_SESSION['username']); */
/*$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1"); */
/*$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null; */

/* ---------- Pagination ---------- */
$allowed_per = [10,25,50,500];
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 10;
if (!in_array($per_page, $allowed_per, true)) { $per_page = 10; }
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($page - 1) * $per_page;

/* ---------- Totals ---------- */
$total_q = mysqli_query($conn, "SELECT COUNT(*) AS c FROM employee_applications WHERE application_status='submitted'");
$total = ($total_q && ($r=mysqli_fetch_assoc($total_q))) ? (int)$r['c'] : 0;
$total_pages = max(1, (int)ceil($total / $per_page));

/* ---------- Data query ---------- */
$sql = "SELECT id, title, first_name, surname, email, country, application_status, created_at 
        FROM employee_applications 
        WHERE application_status='submitted'
        ORDER BY created_at DESC
        LIMIT {$offset}, {$per_page}";
$app_q = mysqli_query($conn, $sql);

/* ---------- Optional quick stats for future use (not rendered as chips to match Jobs List) ---------- */
$stat_today = 0;
$stat_today_q = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='submitted' AND DATE(created_at)=CURDATE()");
if ($stat_today_q) { $stat_today = (int)mysqli_fetch_assoc($stat_today_q)['c']; }

/* ---------- Internal styles ---------- */
ob_start();
?>
<!-- Internal styles (kept minimal to respect theme) -->
<style>
/* Avatar initials (to mimic logo circle from Jobs List) */
.avatar-initial {
    width: 40px; height: 40px; border-radius: 50%;
    display: inline-grid; place-items: center;
    font-weight: 700; color: #fff; background: var(--primary03, #0d6efd);
}
.joblist-list .text-sub { font-size: 12px; color: var(--default-text-color, #6c757d); margin: 0; }
.joblist-list .fw-medium a { text-decoration: none; }
.badge-submitted { background: rgba(13,110,253,.12); color:#0d6efd; border:1px solid rgba(13,110,253,.2); }
.badge-inprogress { background: rgba(255,193,7,.15); color:#b58100; border:1px solid rgba(255,193,7,.25); }
.badge-other { background: rgba(108,117,125,.15); color:#6c757d; border:1px solid rgba(108,117,125,.25); }
.table-hover tbody tr:hover { background: rgba(13,110,253,.04); }
</style>
<?php
$styles = ob_get_clean();

/* ---------- Page content (Jobs List look) ---------- */
ob_start();
?>
<!-- Start::page-header -->
<div class="page-header-breadcrumb mb-3">
    <div class="d-flex align-center justify-content-between flex-wrap">
        <h1 class="page-title fw-medium fs-18 mb-0">Submitted Applications</h1>
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);">Applications</a></li>
            <li class="breadcrumb-item active" aria-current="page">Submitted</li>
        </ol>
    </div>
</div>
<!-- End::page-header -->

<!-- Start::row-1 -->
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card overflow-hidden">
            <div class="card-header justify-content-between">
                <div class="card-title">
                    All Submitted Applications
                </div>
                <div class="d-flex flex-wrap gap-2">
                    <a href="javascript:void(0);" class="btn btn-primary btn-wave" id="btnRefresh">
                        <i class="ri-refresh-line me-1 align-middle"></i>Refresh
                    </a>
                    <div>
                        <input id="tableSearch" class="form-control" type="text" placeholder="Search Here" aria-label="search">
                    </div>
                    <div class="dropdown">
                        <a href="javascript:void(0);" class="btn btn-primary btn-wave" data-bs-toggle="dropdown" aria-expanded="false">
                            Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
                        </a>
                        <ul class="dropdown-menu" role="menu" id="sortMenu">
                            <li><a class="dropdown-item" data-sort="created_desc" href="javascript:void(0);">Newest</a></li>
                            <li><a class="dropdown-item" data-sort="created_asc" href="javascript:void(0);">Oldest</a></li>
                            <li><a class="dropdown-item" data-sort="status" href="javascript:void(0);">Status</a></li>
                            <li><a class="dropdown-item" data-sort="name" href="javascript:void(0);">Applicant Name</a></li>
                        </ul>
                    </div>
                    <div class="dropdown">
                        <a href="javascript:void(0);" class="btn btn-outline-primary btn-wave" data-bs-toggle="dropdown" aria-expanded="false">
                            Rows<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
                        </a>
                        <ul class="dropdown-menu">
                            <?php
                            foreach ([10,25,50,500] as $opt) {
                                $active = ($opt===$per_page) ? ' active' : '';
                                $link = '?per_page='.$opt.'&page=1';
                                echo '<li><a class="dropdown-item'.$active.'" href="'.h($link).'">'.h($opt).'</a></li>';
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover text-nowrap" id="appsTable">
                        <thead>
                            <tr>
                                <th scope="row" class="ps-4"><input class="form-check-input check-all" type="checkbox" id="checkAllApps" aria-label="..."></th>
                                <th scope="col">Applicant</th>
                                <th scope="col">Email</th>
                                <th scope="col">Country</th>
                                <th scope="col">Status</th>
                                <th scope="col">Submitted</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if ($app_q && mysqli_num_rows($app_q) > 0): ?>
                            <?php while($app = mysqli_fetch_assoc($app_q)):
                                $full_name = trim(($app['title'] ? $app['title'].' ' : '').($app['first_name'] ?? '').' '.($app['surname'] ?? ''));
                                $full_name = $full_name !== '' ? $full_name : 'Unknown';
                                $initials  = strtoupper(mb_substr($app['first_name'] ?? 'U',0,1).mb_substr($app['surname'] ?? 'N',0,1));
                                $country   = $app['country'] ?: '-';
                                $email     = $app['email'] ?: '-';
                                $status    = strtolower($app['application_status'] ?? '');
                                $createdAt = !empty($app['created_at']) ? date('M d, Y', strtotime($app['created_at'])) : '-';

                                $badge = '<span class="badge rounded-pill badge-other">Unknown</span>';
                                if ($status === 'submitted')    $badge = '<span class="badge rounded-pill badge-submitted">Submitted</span>';
                                elseif ($status === 'in-progress') $badge = '<span class="badge rounded-pill badge-inprogress">In Progress</span>';
                            ?>
                            <tr class="joblist-list">
                                <td class="ps-4 joblist-checkbox"><input class="form-check-input row-check" type="checkbox" value="<?= (int)$app['id']; ?>" aria-label="..."></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="lh-1">
                                            <span class="avatar avatar-md avatar-rounded">
                                                <span class="avatar-initial"><?= h($initials); ?></span>
                                            </span>
                                        </div>
                                        <div class="ms-2">
                                            <p class="fw-medium mb-0 d-flex align-items-center">
                                              <a href="application-update.php?id=<?= (int)$app['id']; ?>"><?= h($full_name); ?></a>
                                            </p>
                                            <p class="text-sub"><?= h($country); ?></p>
                                        </div>
                                    </div>
                                </td>
                                <td><a href="mailto:<?= h($email); ?>"><?= h($email); ?></a></td>
                                <td><?= h($country); ?></td>
                                <td><?= $badge; ?></td>
                                <td><?= h($createdAt); ?></td>
                                <td>
                                    <a href="<?= 'application-update.php?id='.(int)$app['id']; ?>" class="btn btn-icon btn-sm btn-primary-light btn-wave waves-effect waves-light" title="View">
                                        <i class="ri-eye-line"></i>
                                    </a>

                                   <a href="<?= 'application-update.php?id='.(int)$app['id'].'&action=approve'; ?>" class="btn btn-icon btn-sm btn-success-light btn-wave waves-effect waves-light" title="Approve">
    <i class="ri-check-line"></i>
</a>
<a href="<?= 'application-update.php?id='.(int)$app['id'].'&action=reject'; ?>" class="btn btn-icon btn-sm btn-danger-light btn-wave waves-effect waves-light" title="Reject">
    <i class="ri-close-line"></i>
</a>

                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr><td colspan="7" class="text-center text-muted py-5">No submitted applications.</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer border-top-0">
                <div class="d-flex align-items-center flex-wrap overflow-auto">
                    <?php
                        $showing_from = ($total === 0) ? 0 : ($offset + 1);
                        $showing_to   = min($offset + $per_page, $total);
                    ?>
                    <div class="mb-2 mb-sm-0">
                        Showing <b><?= h($showing_from); ?></b> to <b><?= h($showing_to); ?></b> of <b><?= h($total); ?></b> entries
                        <i class="bi bi-arrow-right ms-2 fw-medium"></i>
                    </div>
                    <div class="ms-auto">
                        <ul class="pagination mb-0 overflow-auto">
                            <?php
                            $prev_disabled = ($page<=1) ? ' disabled' : '';
                            $next_disabled = ($page>=$total_pages) ? ' disabled' : '';
                            $linkBase = '?per_page='.$per_page.'&page=';
                            ?>
                            <li class="page-item<?= $prev_disabled; ?>">
                                <a class="page-link" href="<?= h($linkBase . max(1,$page-1)); ?>">Previous</a>
                            </li>
                            <?php
                            // simple windowed pagination like example
                            $window = 5;
                            $start = max(1, $page - (int)floor($window/2));
                            $end   = min($total_pages, $start + $window - 1);
                            $start = max(1, min($start, $end - $window + 1));
                            for ($p=$start; $p<=$end; $p++):
                                $active = ($p===$page) ? ' active' : '';
                            ?>
                                <li class="page-item<?= $active; ?>"><a class="page-link" href="<?= h($linkBase.$p); ?>"><?= h($p); ?></a></li>
                            <?php endfor; ?>
                            <li class="page-item<?= $next_disabled; ?>">
                                <a class="page-link" href="<?= h($linkBase . min($total_pages,$page+1)); ?>">Next</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<!--End::row-1 -->
<?php
$content = ob_get_clean();

/* ---------- Internal scripts ---------- */
ob_start();
?>
<!-- job list JS from theme (keep for consistency) -->
<script src="<?php echo $baseUrl; ?>/assets/js/job-list.js"></script>
<script>
(function(){
    const searchInput = document.getElementById('tableSearch');
    const table = document.getElementById('appsTable');
    const tbody = table ? table.querySelector('tbody') : null;
    const rows = tbody ? Array.from(tbody.querySelectorAll('tr.joblist-list')) : [];
    const checkAll = document.getElementById('checkAllApps');
    const refresh  = document.getElementById('btnRefresh');

    function norm(s){ return (s||'').toString().toLowerCase().trim(); }

    // Search filter (client-side like example)
    if (searchInput && rows.length){
        searchInput.addEventListener('input', function(){
            const q = norm(this.value);
            rows.forEach(tr=>{
                const show = !q || norm(tr.innerText).includes(q);
                tr.style.display = show ? '' : 'none';
            });
        });
    }

    // Check-all
    if (checkAll && rows.length){
        checkAll.addEventListener('change', function(){
            const cbs = tbody.querySelectorAll('.row-check');
            cbs.forEach(cb => { cb.checked = checkAll.checked; });
        });
    }

    // Sort menu (client-only visual sort)
    const sortMenu = document.getElementById('sortMenu');
    if (sortMenu && rows.length){
        sortMenu.querySelectorAll('.dropdown-item').forEach(item=>{
            item.addEventListener('click', function(){
                const mode = this.getAttribute('data-sort');
                const getName = (tr)=>tr.querySelector('td:nth-child(2) .fw-medium a')?.textContent?.trim()||'';
                const getDate = (tr)=>tr.querySelector('td:nth-child(6)')?.textContent?.trim()||'';
                const getStatusText = (tr)=>tr.querySelector('td:nth-child(5) .badge')?.textContent?.trim()||'';

                // Simple date parser (MMM DD, YYYY)
                function parseDate(txt){
                    const d = Date.parse(txt);
                    return isNaN(d) ? 0 : d;
                }

                const sorted = rows.slice();
                if (mode==='name'){
                    sorted.sort((a,b)=>getName(a).localeCompare(getName(b)));
                } else if (mode==='status'){
                    sorted.sort((a,b)=>getStatusText(a).localeCompare(getStatusText(b)));
                } else if (mode==='created_asc'){
                    sorted.sort((a,b)=>parseDate(getDate(a)) - parseDate(getDate(b)));
                } else { // created_desc default
                    sorted.sort((a,b)=>parseDate(getDate(b)) - parseDate(getDate(a)));
                }

                // Re-append in new order (visible rows only)
                sorted.forEach(tr=>tbody.appendChild(tr));
            });
        });
    }

    if (refresh){ refresh.addEventListener('click', ()=>location.reload()); }
})();
</script>
<?php
$scripts = ob_get_clean();

/* ---------- Render with theme base (header/sidebar included there) ---------- */
 
  include 'layouts/base.php';  
