<?php
/* =============================================================================
 * project_form.php  (Melody theme blocks + base renderer)
 * - Uses broker-config.php (MySQLi, no PDO) and functions.php
 * - No header.php; renders via layouts/base.php with $styles/$content/$scripts
 * - Collation: utf8mb4_general_ci
 * ============================================================================= */

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* Required includes (per your request) */
require_once 'broker-config.php';
require_once 'functions.php';

/* Ensure DB + collation */
if (!isset($conn) || !($conn instanceof mysqli)) { die('DB connection missing'); }
mysqli_set_charset($conn,'utf8mb4');
@mysqli_query($conn,"SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
@mysqli_query($conn,"SET collation_connection='utf8mb4_general_ci'");

/* --- Constants / Options --- */
$AMENITIES_OPTIONS = [
  'Pool','Gym','Club','Park','Kids Play Area','Security','Power Backup','Elevator',
  'Community Hall','Jogging Track','Indoor Games','Cafeteria'
];
$PROJECT_CLASS_OPTIONS = ['Exclusive','Special','Featured']; // "Special" shows star on cards
$CATEGORY_OPTIONS = [
  'Apartment','Villa','Plots','Commercial','Land','Studio','Townhouse','Penthouse',
  'Duplex','Row House','Bungalow','Farmhouse','Other'
];

/* --- Helpers (fallbacks if not defined elsewhere) --- */
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8'); } }

/* --- Load Project (defaults) --- */
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$project = [
  'code'=>'','name'=>'','developer'=>'','rera_no'=>'',
  'project_type'=>'Residential',
  'project_class'=>'',
  'category'=>'',
  'address1'=>'','address2'=>'','city'=>'','state'=>'','pincode'=>'',
  'latitude'=>'','longitude'=>'','possession_status'=>'Under Construction','expected_possession'=>'',
  'land_area'=>'','land_area_unit'=>'Acres','total_towers'=>'','total_units'=>'','floors_per_tower'=>'',
  'amenities'=>'','maintenance_agency'=>'','maintenance_rate'=>'','parking_policy'=>'',
  'payment_plans'=>'','sales_email'=>'','sales_phone'=>'','status'=>'Active'
];

if($id){
  $rs = mysqli_query($conn,"SELECT * FROM projects WHERE id=$id");
  if($rs && mysqli_num_rows($rs)){ $project = array_merge($project, mysqli_fetch_assoc($rs)); }
}
$selectedAmenities = array_filter(array_map('trim', explode(',', (string)$project['amenities'])));

/* --- Ensure media table --- */
mysqli_query($conn,"CREATE TABLE IF NOT EXISTS project_media (
  id INT AUTO_INCREMENT PRIMARY KEY,
  project_id INT NOT NULL,
  media_type ENUM('image','video','floorplan') NOT NULL,
  file_url VARCHAR(500) COLLATE utf8mb4_general_ci NOT NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  INDEX idx_proj_media (project_id, media_type)
) COLLATE=utf8mb4_general_ci");

/* --- Fetch existing media --- */
$media = ['image'=>[], 'video'=>[], 'floorplan'=>[]];
if($id){
  $mrs = mysqli_query($conn,"SELECT id,media_type,file_url FROM project_media WHERE project_id=$id ORDER BY id DESC");
  if($mrs){ while($row = mysqli_fetch_assoc($mrs)){ if(isset($media[$row['media_type']])) $media[$row['media_type']][] = $row; } }
}

/* ------------------------- THEME BLOCKS ------------------------- */

/* ============ STYLES ============ */
ob_start(); ?>
<link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/quill/quill.snow.css">
<link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/quill/quill.bubble.css">
<link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/filepond/filepond.min.css">
<link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.css">
<link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-edit/filepond-plugin-image-edit.min.css">
<?php $styles = ob_get_clean();

/* ============ CONTENT ============ */
ob_start(); ?>

<!-- Start::page-header -->
<div class="page-header-breadcrumb mb-3">
  <div class="d-flex align-center justify-content-between flex-wrap">
    <h1 class="page-title fw-medium fs-18 mb-0"><?php echo $id ? 'Edit Project' : 'Create Project'; ?></h1>
    <ol class="breadcrumb mb-0">
      <li class="breadcrumb-item"><a href="javascript:void(0);">Apps</a></li>
      <li class="breadcrumb-item"><a href="projects.php">Projects</a></li>
      <li class="breadcrumb-item active" aria-current="page"><?php echo $id ? 'Edit' : 'Create'; ?> Project</li>
    </ol>
  </div>
</div>
<!-- End::page-header -->

<!-- Start::row-1 -->
<div class="row">
  <div class="col-xl-12">
    <div class="card custom-card">
      <div class="card-header">
        <div class="card-title">
          <?php echo $id ? 'Update Project' : 'Create Project'; ?>
        </div>
        <div class="ms-auto">
          <a href="projects.php" class="btn btn-outline-secondary btn-sm"><i class="ri-arrow-go-back-line me-1"></i>Back</a>
        </div>
      </div>

      <div class="card-body">
        <form method="post" action="project_save.php" enctype="multipart/form-data" class="row gy-3">
          <input type="hidden" name="id" value="<?php echo (int)$id; ?>">

          <!-- Basic Details -->
          <div class="col-xl-3">
            <label class="form-label">Project Code</label>
            <input type="text" name="code" class="form-control" value="<?php echo h($project['code']); ?>" required>
          </div>
          <div class="col-xl-5">
            <label class="form-label">Project Name</label>
            <input type="text" name="name" class="form-control" value="<?php echo h($project['name']); ?>" required>
          </div>
          <div class="col-xl-4">
            <label class="form-label">Developer / Owner</label>
            <input type="text" name="developer" class="form-control" value="<?php echo h($project['developer']); ?>">
          </div>

          <div class="col-xl-4">
            <label class="form-label">RERA Number</label>
            <input type="text" name="rera_no" class="form-control" value="<?php echo h($project['rera_no']); ?>">
          </div>
          <div class="col-xl-4">
            <label class="form-label">Project Type</label>
            <select name="project_type" class="form-control">
              <option <?php echo $project['project_type']=='Residential'?'selected':''; ?>>Residential</option>
              <option <?php echo $project['project_type']=='Commercial'?'selected':''; ?>>Commercial</option>
              <option <?php echo $project['project_type']=='Mixed'?'selected':''; ?>>Mixed</option>
            </select>
          </div>
          <div class="col-xl-4">
            <label class="form-label">Project Class</label>
            <select name="project_class" class="form-control">
              <option value="">— Select —</option>
              <?php foreach($PROJECT_CLASS_OPTIONS as $opt): ?>
                <option value="<?php echo h($opt); ?>" <?php echo ($project['project_class']===$opt?'selected':''); ?>><?php echo h($opt); ?></option>
              <?php endforeach; ?>
            </select>
            <small class="text-muted">Selecting <b>Special</b> will show a gold star on cards.</small>
          </div>
          <div class="col-xl-4">
            <label class="form-label">Category</label>
            <select name="category" class="form-control">
              <option value="">— Select —</option>
              <?php foreach($CATEGORY_OPTIONS as $opt): ?>
                <option value="<?php echo h($opt); ?>" <?php echo ($project['category']===$opt?'selected':''); ?>><?php echo h($opt); ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <!-- Address -->
          <div class="col-xl-12">
            <label class="form-label">Address Line 1</label>
            <input type="text" name="address1" class="form-control" value="<?php echo h($project['address1']); ?>">
          </div>
          <div class="col-xl-12">
            <label class="form-label">Address Line 2</label>
            <input type="text" name="address2" class="form-control" value="<?php echo h($project['address2']); ?>">
          </div>
          <div class="col-xl-3">
            <label class="form-label">City</label>
            <input type="text" name="city" class="form-control" value="<?php echo h($project['city']); ?>">
          </div>
          <div class="col-xl-3">
            <label class="form-label">State</label>
            <input type="text" name="state" class="form-control" value="<?php echo h($project['state']); ?>">
          </div>
          <div class="col-xl-3">
            <label class="form-label">Pincode</label>
            <input type="text" name="pincode" class="form-control" value="<?php echo h($project['pincode']); ?>">
          </div>
          <div class="col-xl-1">
            <label class="form-label">Lat</label>
            <input type="text" name="latitude" class="form-control" value="<?php echo h($project['latitude']); ?>">
          </div>
          <div class="col-xl-2">
            <label class="form-label">Long</label>
            <input type="text" name="longitude" class="form-control" value="<?php echo h($project['longitude']); ?>">
          </div>

          <!-- Build / Possession -->
          <div class="col-xl-4">
            <label class="form-label">Possession Status</label>
            <select name="possession_status" class="form-control">
              <option <?php echo $project['possession_status']=='Under Construction'?'selected':''; ?>>Under Construction</option>
              <option <?php echo $project['possession_status']=='Ready'?'selected':''; ?>>Ready</option>
            </select>
          </div>
          <div class="col-xl-4">
            <label class="form-label">Expected Possession</label>
            <input type="date" name="expected_possession" class="form-control" value="<?php echo h($project['expected_possession']); ?>">
          </div>
          <div class="col-xl-2">
            <label class="form-label">Land Area</label>
            <input type="number" step="0.01" name="land_area" class="form-control" value="<?php echo h($project['land_area']); ?>">
          </div>
          <div class="col-xl-2">
            <label class="form-label">Area Unit</label>
            <input type="text" name="land_area_unit" class="form-control" value="<?php echo h($project['land_area_unit']); ?>">
          </div>

          <div class="col-xl-4">
            <label class="form-label">Total Towers</label>
            <input type="number" name="total_towers" class="form-control" value="<?php echo h($project['total_towers']); ?>">
          </div>
          <div class="col-xl-4">
            <label class="form-label">Total Units</label>
            <input type="number" name="total_units" class="form-control" value="<?php echo h($project['total_units']); ?>">
          </div>
          <div class="col-xl-4">
            <label class="form-label">Floors / Tower</label>
            <input type="number" name="floors_per_tower" class="form-control" value="<?php echo h($project['floors_per_tower']); ?>">
          </div>

          <!-- Amenities -->
          <div class="col-xl-12">
            <label class="form-label">Amenities</label>
            <div class="d-flex flex-wrap gap-2">
              <?php foreach($AMENITIES_OPTIONS as $opt): $checked = in_array($opt,$selectedAmenities)?'checked':''; ?>
                <label class="badge bg-light text-dark border d-inline-flex align-items-center p-2" style="border-radius:999px; gap:.5rem; cursor:pointer;">
                  <input type="checkbox" class="form-check-input me-1" name="amenities[]" value="<?php echo h($opt); ?>" <?php echo $checked; ?>> <?php echo h($opt); ?>
                </label>
              <?php endforeach; ?>
            </div>
          </div>

          <!-- Maintenance / Sales -->
          <div class="col-xl-4">
            <label class="form-label">Maintenance Agency</label>
            <input type="text" name="maintenance_agency" class="form-control" value="<?php echo h($project['maintenance_agency']); ?>">
          </div>
          <div class="col-xl-4">
            <label class="form-label">Maintenance Rate (/sqft)</label>
            <input type="number" step="0.01" name="maintenance_rate" class="form-control" value="<?php echo h($project['maintenance_rate']); ?>">
          </div>
          <div class="col-xl-12">
            <label class="form-label">Parking Policy</label>
            <textarea name="parking_policy" class="form-control" rows="2"><?php echo h($project['parking_policy']); ?></textarea>
          </div>
          <div class="col-xl-6">
            <label class="form-label">Payment Plans (CSV)</label>
            <input type="text" name="payment_plans" class="form-control" value="<?php echo h($project['payment_plans']); ?>">
          </div>
          <div class="col-xl-3">
            <label class="form-label">Sales Email</label>
            <input type="email" name="sales_email" class="form-control" value="<?php echo h($project['sales_email']); ?>">
          </div>
          <div class="col-xl-3">
            <label class="form-label">Sales Phone</label>
            <input type="text" name="sales_phone" class="form-control" value="<?php echo h($project['sales_phone']); ?>">
          </div>

          <div class="col-xl-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-control">
              <option <?php echo $project['status']=='Active'?'selected':''; ?>>Active</option>
              <option <?php echo $project['status']=='Inactive'?'selected':''; ?>>Inactive</option>
            </select>
          </div>

          <div class="col-12"><hr></div>

          <!-- Media Uploads -->
          <div class="col-xl-12">
            <label class="form-label">Project Images (JPG/PNG/WebP) — Multiple</label>
            <input type="file" name="project_images[]" accept=".jpg,.jpeg,.png,.webp" class="form-control multiple-filepond" multiple>
            <?php if(!empty($media['image'])): ?>
              <div class="d-flex flex-wrap mt-3" style="gap:.75rem">
                <?php foreach($media['image'] as $m): ?>
                  <div class="card" style="width: 180px;">
                    <img src="<?php echo h($m['file_url']); ?>" class="card-img-top" style="height:110px;object-fit:cover">
                    <div class="card-body p-2 text-center">
                      <a class="btn btn-xs btn-outline-danger" href="project_media_delete.php?id=<?php echo (int)$m['id']; ?>&pid=<?php echo (int)$id; ?>" onclick="return confirm('Delete image?')">
                        <i class="ri-delete-bin-line me-1"></i>Delete
                      </a>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php endif; ?>
          </div>

          <div class="col-xl-12">
            <label class="form-label">Project Videos (MP4/WebM) — Multiple</label>
            <input type="file" name="project_videos[]" accept=".mp4,.webm" class="form-control multiple-filepond" multiple>
            <?php if(!empty($media['video'])): ?>
              <div class="d-flex flex-wrap mt-3" style="gap:.75rem">
                <?php foreach($media['video'] as $m): ?>
                  <div class="card" style="width: 220px;">
                    <video src="<?php echo h($m['file_url']); ?>" class="card-img-top" style="height:140px;object-fit:cover" controls></video>
                    <div class="card-body p-2 text-center">
                      <a class="btn btn-xs btn-outline-danger" href="project_media_delete.php?id=<?php echo (int)$m['id']; ?>&pid=<?php echo (int)$id; ?>" onclick="return confirm('Delete video?')">
                        <i class="ri-delete-bin-line me-1"></i>Delete
                      </a>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php endif; ?>
          </div>

          <div class="col-xl-12">
            <label class="form-label">Floorplan Images (JPG/PNG/WebP) — Multiple</label>
            <input type="file" name="project_floorplans[]" accept=".jpg,.jpeg,.png,.webp" class="form-control multiple-filepond" multiple>
            <?php if(!empty($media['floorplan'])): ?>
              <div class="d-flex flex-wrap mt-3" style="gap:.75rem">
                <?php foreach($media['floorplan'] as $m): ?>
                  <div class="card" style="width: 220px;">
                    <img src="<?php echo h($m['file_url']); ?>" class="card-img-top" style="height:140px;object-fit:cover">
                    <div class="card-body p-2 text-center">
                      <a class="btn btn-xs btn-outline-danger" href="project_media_delete.php?id=<?php echo (int)$m['id']; ?>&pid=<?php echo (int)$id; ?>" onclick="return confirm('Delete floorplan?')">
                        <i class="ri-delete-bin-line me-1"></i>Delete
                      </a>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php endif; ?>
          </div>

          <div class="card-footer bg-transparent px-0">
            <button class="btn btn-primary-light btn-wave ms-auto float-end" type="submit">
              <i class="ri-save-3-line me-1"></i> <?php echo $id ? 'Update Project' : 'Create Project'; ?>
            </button>
          </div>
        </form>
      </div>

    </div>
  </div>
</div>
<!-- End::row-1 -->

<?php $content = ob_get_clean();

/* ============ SCRIPTS ============ */
ob_start(); ?>
<!-- Quill Editor JS -->
<script src="<?php echo $baseUrl; ?>/assets/libs/quill/quill.js"></script>

<!-- Filepond JS -->
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond/filepond.min.js"></script>
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.js"></script>
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-exif-orientation/filepond-plugin-image-exif-orientation.min.js"></script>
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-validate-size/filepond-plugin-file-validate-size.min.js"></script>
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-encode/filepond-plugin-file-encode.min.js"></script>
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-edit/filepond-plugin-image-edit.min.js"></script>
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-validate-type/filepond-plugin-file-validate-type.min.js"></script>
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-crop/filepond-plugin-image-crop.min.js"></script>
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-resize/filepond-plugin-image-resize.min.js"></script>
<script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-transform/filepond-plugin-image-transform.min.js"></script>

<!-- Flatpickr (if you later need date pickers beyond native) -->
<script src="<?php echo $baseUrl; ?>/assets/libs/flatpickr/flatpickr.min.js"></script>

<!-- Optional: your initializer -->
<script src="<?php echo $baseUrl; ?>/assets/js/create-project.js"></script>

<script>
/* Minimal FilePond init (keeps your field names like project_images[]) */
FilePond.registerPlugin(
  FilePondPluginImagePreview,
  FilePondPluginImageExifOrientation,
  FilePondPluginFileValidateSize,
  FilePondPluginFileEncode,
  FilePondPluginImageEdit,
  FilePondPluginFileValidateType,
  FilePondPluginImageCrop,
  FilePondPluginImageResize,
  FilePondPluginImageTransform
);
Array.from(document.querySelectorAll('.multiple-filepond')).forEach(function(input){
  FilePond.create(input, {
    allowMultiple: true,
    storeAsFile: true // keep normal form POST to project_save.php
  });
});
</script>
<?php $scripts = ob_get_clean();

/* Render base layout */
include 'layouts/base.php';
