<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_user'])) {
    $user_id = $_POST['user_id'];
    $first_name = trim($_POST['first_name']);
    $last_name = trim($_POST['last_name']);
    $email = trim($_POST['email']);
    $role_id = $_POST['role_id'];
    $password = trim($_POST['password'] ?? '');

    if (!empty($password)) {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $conn_sa->prepare("UPDATE users SET first_name = ?, last_name = ?, email = ?, role_id = ?, password = ? WHERE id = ?");
        $stmt->bind_param("sssisi", $first_name, $last_name, $email, $role_id, $hashed_password, $user_id);
    } else {
        $stmt = $conn_sa->prepare("UPDATE users SET first_name = ?, last_name = ?, email = ?, role_id = ? WHERE id = ?");
        $stmt->bind_param("sssii", $first_name, $last_name, $email, $role_id, $user_id);
    }

    $stmt->execute();
    $stmt->close();
    $_SESSION['success_message'] = "User updated successfully.";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_user'])) {
    $user_id = $_POST['delete_user_id'];
    $stmt = $conn_sa->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->close();

    $_SESSION['success_message'] = "User deleted successfully.";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

$roles = [];
$res = $conn_sa->query("SELECT id, role_name FROM roles");
if ($res) {
    while ($r = $res->fetch_assoc()) {
        $roles[$r['id']] = $r['role_name'];
    }
}
?>
<?php ob_start(); ?>
<link rel="stylesheet" href="<?= $baseUrl; ?>/assets/libs/prismjs/themes/prism-coy.min.css">
<link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
<?php $styles = ob_get_clean(); ?>

<?php ob_start(); ?>
<div class="container py-5">
    <h2 class="mb-4">User List</h2>
      <?php if (isset($_SESSION['success_message'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= $_SESSION['success_message']; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>
    <div class="table-responsive">
        <table id="usersTable" class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Role</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $query = "SELECT users.id, users.first_name, users.last_name, users.email, users.role_id, roles.role_name 
                          FROM users 
                          LEFT JOIN roles ON users.role_id = roles.id";
                $result = $conn_sa->query($query);
                if ($result && $result->num_rows > 0) {
                    $count = 1;
                    while ($row = $result->fetch_assoc()) {
                       echo "<tr>
                                <td>{$count}</td>
                                <td>" . htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) . "</td>
                                <td>" . htmlspecialchars($row['email']) . "</td>
                                <td>" . htmlspecialchars($row['role_name']) . "</td>
                                <td>
                                    <button 
                                        class='btn btn-sm btn-primary editBtn'
                                        data-id='{$row['id']}'
                                        data-first_name='" . htmlspecialchars($row['first_name'], ENT_QUOTES) . "'
                                        data-last_name='" . htmlspecialchars($row['last_name'], ENT_QUOTES) . "'
                                        data-email='" . htmlspecialchars($row['email'], ENT_QUOTES) . "'
                                        data-role_id='{$row['role_id']}'
                                    >Edit</button>

                                    <button 
                                        class='btn btn-sm btn-danger deleteBtn ms-1'
                                        data-id='{$row['id']}'
                                    >Delete</button>
                                </td>
                            </tr>";
                        $count++;
                    }
                } else {
                    echo '<tr><td colspan="5" class="text-center">No users found.</td></tr>';
                }
                ?>
            </tbody>
        </table>
    </div>
</div>
<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteUserModal" tabindex="-1" aria-labelledby="deleteUserModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" class="modal-content">
        <input type="hidden" name="delete_user_id" id="delete_user_id">
        <div class="modal-header">
            <h5 class="modal-title">Confirm Delete</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            Are you sure you want to delete this user?
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" name="delete_user" class="btn btn-danger">Yes, Delete</button>
        </div>
    </form>
  </div>
</div>

<div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="editUserModalLabel">Edit User</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <input type="hidden" name="user_id" id="edit_user_id">
            <div class="mb-3">
                <label for="edit_first_name" class="form-label">First Name</label>
                <input type="text" class="form-control" id="edit_first_name" name="first_name" required>
            </div>
            <div class="mb-3">
                <label for="edit_last_name" class="form-label">Last Name</label>
                <input type="text" class="form-control" id="edit_last_name" name="last_name" required>
            </div>
            <div class="mb-3">
                <label for="edit_email" class="form-label">Email</label>
                <input type="email" class="form-control" id="edit_email" name="email" required>
            </div>
            <div class="mb-3">
                <label for="edit_password" class="form-label">Password <small class="text-muted">(leave blank to keep unchanged)</small></label>
                <div class="input-group">
                    <input type="password" class="form-control" id="edit_password" name="password">
                    <button class="btn btn-outline-secondary" type="button" id="togglePassword">Show</button>
                </div>
            </div>
            <div class="mb-3">
                <label for="edit_role_id" class="form-label">Role</label>
                <select name="role_id" id="edit_role_id" class="form-select" required>
                    <option value="">-- Select Role --</option>
                    <?php foreach ($roles as $id => $role_name): ?>
                        <option value="<?= $id ?>"><?= htmlspecialchars($role_name) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" name="edit_user" class="btn btn-primary">Save Changes</button>
        </div>
    </form>
  </div>
</div>
<?php $content = ob_get_clean(); ?>

<?php ob_start(); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script>
    $(document).ready(function() {
        $('#usersTable').DataTable({
            responsive: true,
            pageLength: 10,
            language: {
                search: "_INPUT_",
                searchPlaceholder: "Search users..."
            }
        });
        $('.editBtn').on('click', function() {
            const button = $(this);
            $('#edit_user_id').val(button.data('id'));
            $('#edit_first_name').val(button.data('first_name'));
            $('#edit_last_name').val(button.data('last_name'));
            $('#edit_email').val(button.data('email'));
            $('#edit_role_id').val(button.data('role_id'));
            $('#edit_password').val('');
            const editModal = new bootstrap.Modal(document.getElementById('editUserModal'));
            editModal.show();
        });
        $('#togglePassword').on('click', function () {
            const passwordInput = $('#edit_password');
            const type = passwordInput.attr('type') === 'password' ? 'text' : 'password';
            passwordInput.attr('type', type);
            $(this).text(type === 'password' ? 'Show' : 'Hide');
        });
    });
    $('.deleteBtn').on('click', function() {
        const userId = $(this).data('id');
        $('#delete_user_id').val(userId);

        const deleteModal = new bootstrap.Modal(document.getElementById('deleteUserModal'));
        deleteModal.show();
    });
</script>

<?php $scripts = ob_get_clean(); ?>

<?php include 'layouts/base.php'; ?>
