<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $roleId = $_POST['role_id'];
    $permissions = isset($_POST['permissions']) ? $_POST['permissions'] : [];
    $permissionsJson = json_encode($permissions);

    $stmt = $conn_sa->prepare("UPDATE roles SET permissions = ? WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("si", $permissionsJson, $roleId);
        if ($stmt->execute()) {
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Update failed']);
        }
        $stmt->close();
    } else {
        echo json_encode(['status' => 'error', 'message' => $conn_sa->error]);
    }
    exit;
}

$allPerms = [
    'Onboarding' => [
        'index7.php' => 'Dashboard',
        'onb-submitted-application.php' => 'Submitted',
        'onb-approved-application.php' => 'Approved',
        'onb-inprogress-application.php' => 'In-Progress',
        'onb-rejected-application.php' => 'Rejected',
        'onb-without-applications.php' => 'Without Applications',
    ],
    'AMS' => [
        'ams-dasboard.php' => 'Dashboard',
        'ams-employee-add.php' => 'Employee Add',
        'ams-employee-list.php' => 'Employee List',
        'ams-tracker.php' => 'Office In/Out (Tracker)',
        'ams-final-cm.php' => 'Report Final',
        'ams-report-ap-cm.php' => 'Report A/P Format',
        'ams-leaves.php' => 'Leaves',
        'ams-locations.php' => 'Locations',
    ],
    'CRM' => [
        'index3.php' => 'Dashboard',
        'crm-contacts.php' => 'Contacts',
        'crm-companies.php' => 'Companies',
        'crm-deals.php' => 'Deals',
        'crm-leads.php' => 'Leads',
    ],
    'Lead Activities' => [
        'calendar.php' => 'Calendar',
        'activities-calls.php' => 'Calls',
        'activities-meetings.php' => 'Meetings',
        'activities-tasks.php' => 'Tasks',
    ],
    'Projects' => [
        'index6.php' => 'Dashboard',
        'projects-list.php' => 'Projects List',
        'projects-overview.php' => 'Project Overview',
        'projects-create.php' => 'Create Project',
    ],
    'Sales' => [
        'index.php' => 'Sales',
    ],
    'Analytics' => [
        'index1.php' => 'Analytics',
    ],
    'Courses' => [
        'index9.php' => 'Courses',
    ],
    'Broker' => [
        'index2.php' => 'Dashboard',
        'projects.php' => 'Projects',
        'broker_onboarding.php' => 'Broker Onboarding',
        'cart.php' => 'Cart',
        'checkout.php' => 'Checkout',
        'customers-list.php' => 'Customers',
        'orders.php' => 'Orders',
        'orders-details.php' => 'Order Details',
        'add-product.php' => 'Add Product',
    ],
    'User Tables' => [
        'user-roles.php' => 'User Roles',
        'user-list.php' => 'User List',
        'user-create.php' => 'Create User',
        'grid-tables.php' => 'Grid JS Tables',
        'data-tables.php' => 'Data Tables',
    ],
];
?>

<?php ob_start(); ?>
<link rel="stylesheet" href="<?= $baseUrl; ?>/assets/libs/prismjs/themes/prism-coy.min.css">
<style>
    .badge-custom { margin-right: 0.25rem; }
</style>
<?php $styles = ob_get_clean(); ?>

<?php ob_start(); ?>
<div class="container py-5">
    <h1 class="mb-4">Role Management</h1>
    <div class="card mb-4">
        <div class="card-body p-0">
            <table class="table table-hover table-bordered mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Role</th>
                        <th>Permissions</th>
                        <th>Edit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $res = $conn_sa->query("SELECT id, role_name, permissions FROM roles");
                    $counter = 1;
                    while ($row = $res->fetch_assoc()):
                        if ($row['id'] == 1) continue;
                        $perms = $row['permissions'] ? json_decode($row['permissions'], true) : [];
                    ?>
                        <tr>
                            <td><?= $counter++ ?></td>
                            <td><?= htmlspecialchars($row['role_name']) ?></td>
                            <td>
                                <?php if ($perms): ?>
                                    <?php foreach ($perms as $p): ?>
                                        <span class="badge bg-info badge-custom">
                                            <?php
                                            $label = '';
                                            foreach ($allPerms as $section) {
                                                if (isset($section[$p])) {
                                                    $label = $section[$p];
                                                    break;
                                                }
                                            }
                                            echo htmlspecialchars($label ?: ucfirst($p));
                                            ?>
                                        </span>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <span class="text-muted">None</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary edit-role-btn"
                                        data-role-id="<?= $row['id'] ?>"
                                        data-role-name="<?= htmlspecialchars($row['role_name']) ?>"
                                        data-permissions='<?= json_encode($perms) ?>'>
                                    Edit
                                </button>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="editRoleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <form id="rolePermissionForm" class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Permissions - <span id="modalRoleName"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="role_id" id="modalRoleId">
                <label class="form-label">Permissions</label>
                <?php foreach ($allPerms as $section => $permList): ?>
                    <h6 class="mt-3 mb-2"><?= htmlspecialchars($section) ?> Section</h6>
                    <?php foreach ($permList as $key => $label): ?>
                        <div class="form-check">
                            <input class="form-check-input perm-checkbox" type="checkbox"
                                   name="permissions[]" value="<?= $key ?>"
                                   id="perm<?= md5($key) ?>">
                            <label class="form-check-label" for="perm<?= md5($key) ?>">
                                <?= htmlspecialchars($label) ?>
                            </label>
                        </div>
                    <?php endforeach; ?>
                <?php endforeach; ?>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">Save</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </form>
    </div>
</div>
<?php $content = ob_get_clean(); ?>

<?php ob_start(); ?>

<script>
document.addEventListener("DOMContentLoaded", () => {
    const modal = new bootstrap.Modal(document.getElementById('editRoleModal'));
    document.querySelectorAll('.edit-role-btn').forEach(btn => {
        btn.addEventListener('click', () => {
            const perms = JSON.parse(btn.dataset.permissions);
            document.getElementById('modalRoleName').textContent = btn.dataset.roleName;
            document.getElementById('modalRoleId').value = btn.dataset.roleId;
            document.querySelectorAll('.perm-checkbox').forEach(cb => {
                cb.checked = perms.includes(cb.value);
            });
            modal.show();
        });
    });

    document.getElementById('rolePermissionForm').addEventListener('submit', e => {
        e.preventDefault();
        const data = new FormData(e.target);
        fetch('', { method: 'POST', body: data })
            .then(res => res.json())
            .then(res => {
                if (res.status === 'success') {
                    location.reload();
                } else {
                    alert(res.message || 'Update failed');
                }
            })
            .catch(err => {
                console.error(err);
                alert('Error saving permissions');
            });
    });
});
</script>
<?php $scripts = ob_get_clean(); ?>

<?php include 'layouts/base.php'; ?>
