/* Image upload */
let loadFile = function (event) {
  const reader = new FileReader();
  reader.onload = function () {
    const output = document.getElementById("profile-img");
    if (event.target.files[0].type.match("image.*")) {
      if(output) {
        output.src = reader.result;
      }
    } else {
      event.target.value = "";
      alert("please select a valid image");
    }
  };
  reader.readAsDataURL(event.target.files[0]);
};

// for profile photo update
let ProfileChange = document.querySelector("#profile-change");
if(ProfileChange) ProfileChange.addEventListener("change", loadFile);

/* multi select with remove button */
const multipleCancelButton = new Choices("#choices-multiple-remove-button1", {
  allowHTML: true,
  removeItemButton: true,
});
const multipleCancelButton1 = new Choices("#choices-multiple-remove-button2", {
  allowHTML: true,
  removeItemButton: true,
});

/* TargetDate Picker */
flatpickr("#targetDate", {
  enableTime: true,
  dateFormat: "Y-m-d H:i",
});

/* For Delete Contact */
let invoicebtn = document.querySelectorAll(".contact-delete");
invoicebtn.forEach((eleBtn) => {
  eleBtn.onclick = () => {
    let invoice = eleBtn.closest(".crm-contact");
    invoice.remove();
  };
});
