<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<?php
/* ============================================================================
 * File: config.php
 * Purpose: Central config + ALL DB connections (MySQLi only; no PDO)
 * Defaults: $conn points to broriserin_onb (as requested)
 * Collation: utf8mb4_general_ci on every connection
 * URL bases: BASE_URL + sectioned URLs (ONBOARDING, AMS, crmplus) + ASSETS_URL
 * ========================================================================== */

if (function_exists('mysqli_report')) { mysqli_report(MYSQLI_REPORT_OFF); }
date_default_timezone_set('Asia/Kolkata');

/* Helper: set charset & connection collation */
function _set_charset_and_collation($link){
    if ($link instanceof mysqli) {
        @mysqli_set_charset($link, 'utf8mb4');
        @mysqli_query($link, "SET NAMES utf8mb4");
        @mysqli_query($link, "SET collation_connection = 'utf8mb4_general_ci'");
       
    }
}


 



if (session_status() !== PHP_SESSION_ACTIVE) {
    ini_set('session.cookie_secure', '1');
    ini_set('session.cookie_httponly', '1');
    ini_set('session.use_only_cookies', '1');
    ini_set('session.cookie_samesite', 'Lax');
}
/* ======================= DB CONNECTIONS (edit creds if needed) ======================= */
/* HR Dump (superadmin) */
$conn_sa = mysqli_connect("localhost","broriserin_superadmin","broriserin@123","broriserin_superadmin");                _set_charset_and_collation($conn_sa);

/* HR Dump (HRD) */
$hrd = mysqli_connect("localhost","broriserin_hrd","broriserin@123","broriserin_hrd");                _set_charset_and_collation($hrd);

/* IC Attendance (IC) */
$conn_ic = mysqli_connect("localhost","broriserin_ic_attendance","broriserin@123","broriserin_ic_attendance"); _set_charset_and_collation($conn_ic);

/* IC Reports */
$cron = mysqli_connect("localhost","broriserin_icreports","broriserin@123","broriserin_icreports");       _set_charset_and_collation($cron);

/* Project Empanel */
$connpe = mysqli_connect("localhost","broriserin_project_empanel","broriserin@123","broriserin_project_empanel"); _set_charset_and_collation($connpe);

/* Legacy Attendance DB */
$connwo = mysqli_connect("localhost","broriserin_attendance","broriserin@123","broriserin_attendance"); _set_charset_and_collation($connwo);

/* Web API */
$conwebapi = mysqli_connect("localhost","broriserin_web_api","broriserin@123","broriserin_web_api");       _set_charset_and_collation($conwebapi);

/* WhatsApp */
$conwhatsapp = mysqli_connect("localhost","broriserin_whatsapp","broriserin@123","broriserin_whatsapp");   _set_charset_and_collation($conwhatsapp);

/* ONB (DEFAULT) — $conn must point to broriserin_onb */
$conn = mysqli_connect("localhost","broriserin_onb","broriserin@123","broriserin_onb");  _set_charset_and_collation($conn);

/* CRMPLUS (NEW) — houses ui_crm, crm_enquiries, etc. */
$conn_crmplus = mysqli_connect("localhost","broriserin_broriserin","broriserin@123","broriserin_broriserin"); _set_charset_and_collation($conn_crmplus);

/* Readable aliases */
$conn_hrd               = $hrd;            // HR dump
$conn_attendance_ic     = $conn_ic;        // IC attendance
$conn_icreports         = $cron;           // IC reports
$conn_project_empanel   = $connpe;         // Project empanel
$conn_attendance_legacy = $connwo;         // Legacy attendance
$conn_web_api           = $conwebapi;      // Web API
$conn_whatsapp          = $conwhatsapp;    // WhatsApp
$conn_onb               = $conn;           // ONB (default)
$conn_crm               = $conn_crmplus;   // CRMPLUS (use this in CRM pages)

/* Safe query helper (no exceptions) */
function dbq($dbc, $sql){
    if (!$dbc || !($dbc instanceof mysqli)) return false;
    $res = @mysqli_query($dbc, $sql);
    return $res ?: false;
}

/* ======================= BASE URLS ======================= */
/* Root site URL (keep trailing slash). Update to your real public URL. */
if (!defined('BASE_URL')) {
    define('BASE_URL', 'https://broriser.in/'); // <-- you can change this once for all sections
}
/* Sectioned URLs (no trailing slash here) */
if (!defined('BASE_URL_ONBOARDING')) define('BASE_URL_ONBOARDING', rtrim(BASE_URL, '/').'/onboarding');
if (!defined('BASE_URL_AMS'))        define('BASE_URL_AMS',        rtrim(BASE_URL, '/').'/ams');
if (!defined('BASE_URL_crmplus'))      define('BASE_URL_crmplus',      rtrim(BASE_URL, '/').'/crmplus');
// Ensure BASE_URL_mobile is defined (your file already does this)
if (!defined('BASE_URL_mobile')) {
    define('BASE_URL_mobile', rtrim(BASE_URL, '/') . '/mobile'); // no trailing slash in constant
}

// Provide a convenient $ASSET variable used by theme files (always has trailing slash)
if (!isset($ASSET)) {
    // Prefer mobile-specific base if defined, otherwise fall back to root BASE_URL
    $base_for_assets = defined('BASE_URL_mobile') ? BASE_URL_mobile : BASE_URL;
    $ASSET = rtrim($base_for_assets, '/') . '/';  // e.g. https://broriser.in/mobile/
}


/* Shared assets URL (point this where your theme assets live). 
   Here I assume your app assets are inside /crmplus/assets */
if (!defined('ASSETS_URL'))          define('ASSETS_URL',          BASE_URL_crmplus.'/assets');


/* Optional light error logs (non-fatal) */
if (!$hrd)         { error_log('config.php: HRD connection failed: '.(@mysqli_connect_error() ?: 'unknown')); }
if (!$conn_ic)     { error_log('config.php: IC attendance connection failed: '.(@mysqli_connect_error() ?: 'unknown')); }
if (!$cron)        { error_log('config.php: IC reports connection failed: '.(@mysqli_connect_error() ?: 'unknown')); }
if (!$connpe)      { error_log('config.php: Project empanel connection failed: '.(@mysqli_connect_error() ?: 'unknown')); }
if (!$connwo)      { error_log('config.php: Legacy attendance connection failed: '.(@mysqli_connect_error() ?: 'unknown')); }
if (!$conwebapi)   { error_log('config.php: Web API connection failed: '.(@mysqli_connect_error() ?: 'unknown')); }
if (!$conwhatsapp) { error_log('config.php: WhatsApp connection failed: '.(@mysqli_connect_error() ?: 'unknown')); }
if (!$conn)        { error_log('config.php: ONB (DEFAULT $conn) connection failed: '.(@mysqli_connect_error() ?: 'unknown')); }
if (!$conn_crmplus){ error_log('config.php: CRMPLUS ($conn_crmplus) connection failed: '.(@mysqli_connect_error() ?: 'unknown')); }


// (7) Google Map key
$GOOGLE_MAPS_API_KEY = 'AIzaSyB-FZbEtDvYXFk3M7ALNt11S4kfMO1XVPo';

// (8) Don’t redeclare constants if config is included again
if (!defined('BASE_URL'))           define('BASE_URL', '/onboarding/');   // <-- change to your actual base URL
if (!defined('SENDGRID_API_KEY'))   define('SENDGRID_API_KEY', 'SG.xY0yT2WTTtGBS4P5b717QQ.troBssYTjXtJy2JtSEaGh0t1TdhxAO6nSJ0PEsKqqbE');
if (!defined('SENDGRID_FROM_EMAIL'))define('SENDGRID_FROM_EMAIL', 'info@broriser.in');
if (!defined('SENDGRID_FROM_NAME')) define('SENDGRID_FROM_NAME', 'BroRiser');




if (!defined('SENDGRID_API_KEY'))
    define('SENDGRID_API_KEY', 'PHtE6r0FEOi/jWN7+xEDtvbqF8fwPdkvq+NgKVJPsYYTD/8GTE0Bo9B/mmSxoxsoAPlEQfWewI1v472Zs+yAc23qPTtFDWqyqK3sx/VYSPOZsbq6x00ftF0cdkfVV4fqdNFs0CTRst3aNA==');
if (!defined('SENDGRID_FROM_EMAIL'))
    define('SENDGRID_FROM_EMAIL', 'noreply@broriser.in');
if (!defined('SENDGRID_FROM_NAME'))
    define('SENDGRID_FROM_NAME', 'Broriser');


if (!defined('ZEPTO_API_URL'))   define('ZEPTO_API_URL', 'https://api.zeptomail.in/v1.1/email');
if (!defined('ZEPTO_API_KEY'))   define('ZEPTO_API_KEY', 'PHtE6r0FEOi/jWN7+xEDtvbqF8fwPdkvq+NgKVJPsYYTD/8GTE0Bo9B/mmSxoxsoAPlEQfWewI1v472Zs+yAc23qPTtFDWqyqK3sx/VYSPOZsbq6x00ftF0cdkfVV4fqdNFs0CTRst3aNA=='); // from ZeptoMail
if (!defined('ZEPTO_FROM_EMAIL'))define('ZEPTO_FROM_EMAIL', 'noreply@broriser.in');
if (!defined('ZEPTO_FROM_NAME')) define('ZEPTO_FROM_NAME', 'Broriser');






?>