<?php
/* =============================================================================
 * File: config.php
 * Goal: Central configuration + ALL database connections (MySQLi only)
 * Charset: utf8mb4 / COLLATE=utf8mb4_general_ci
 * Default connection: $conn → intbroriser_onb
 * ============================================================================= */

if (function_exists('mysqli_report')) { mysqli_report(MYSQLI_REPORT_OFF); }
date_default_timezone_set('Asia/Kolkata');


/* -------------------------- AUTO BASE URL DETECTION -------------------------- */
$rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on'
    ? 'https://' : 'http://')
    . $_SERVER['HTTP_HOST']
    . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));

if (!defined('BASE_URL')) {
    // If unknown → fall back to auto-detected base
    define('BASE_URL', rtrim($baseUrl, '/') . '/');
}
if (!defined('BASE_URL_DOCUMENT')) {
    define('BASE_URL_DOCUMENT', (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') 
        . $_SERVER['HTTP_HOST'] 
        . '/onboarding/');
}

/* ------------------------- CHARSET + COLLATION HELPER ------------------------- */
function _set_charset_and_collation($link){
    if ($link instanceof mysqli) {
        @mysqli_set_charset($link, 'utf8mb4');
        @mysqli_query($link, "SET NAMES utf8mb4");
        @mysqli_query($link, "SET collation_connection = 'utf8mb4_general_ci'");
    }
}


/* ------------------------------- DB CONNECTIONS ------------------------------- */
/* HR Dump (superadmin) */
$conn_sa = mysqli_connect(
    "localhost","intbroriser_superadmin","intbroriser@123","intbroriser_superadmin"
); _set_charset_and_collation($conn_sa);

/* HR Database (HRD) */
$hrd = mysqli_connect(
    "localhost","intbroriser_hrd","intbroriser@123","intbroriser_hrd"
); _set_charset_and_collation($hrd);

/* IC Attendance DB */
$conn_ic = mysqli_connect(
    "localhost","intbroriser_ic_attendance","intbroriser@123","intbroriser_ic_attendance"
); _set_charset_and_collation($conn_ic);

/* IC Reports */
$cron = mysqli_connect(
    "localhost","intbroriser_icreports","intbroriser@123","intbroriser_icreports"
); _set_charset_and_collation($cron);

/* Project Empanel */
$connpe = mysqli_connect(
    "localhost","intbroriser_project_empanel","intbroriser@123","intbroriser_project_empanel"
); _set_charset_and_collation($connpe);

/* Legacy Attendance */
$connwo = mysqli_connect(
    "localhost","intbroriser_attendance","intbroriser@123","intbroriser_attendance"
); _set_charset_and_collation($connwo);

/* Web API */
$conwebapi = mysqli_connect(
    "localhost","intbroriser_web_api","intbroriser@123","intbroriser_web_api"
); _set_charset_and_collation($conwebapi);

/* WhatsApp API */
$conwhatsapp = mysqli_connect(
    "localhost","intbroriser_whatsapp","intbroriser@123","intbroriser_whatsapp"
); _set_charset_and_collation($conwhatsapp);

/* ONB (DEFAULT) — $conn must point here */
$conn = mysqli_connect("localhost","intbroriser_root","intbroriser_root","intbroriser_onboarding"
); _set_charset_and_collation($conn);

$conn_user = mysqli_connect("localhost","intbroriser_root","intbroriser_root","intbroriser_users_login");                _set_charset_and_collation($conn_user);
/* ------------------------------- READABLE ALIASES ------------------------------- */
$conn_hrd               = $hrd;
$conn_attendance_ic     = $conn_ic;
$conn_icreports         = $cron;
$conn_project_empanel   = $connpe;
$conn_attendance_legacy = $connwo;
$conn_web_api           = $conwebapi;
$conn_whatsapp          = $conwhatsapp;
$conn_onb               = $conn;   // default site connection


/* ------------------------------ SAFE QUERY HELPER ------------------------------ */
function dbq($dbc, $sql){
    if (!$dbc || !($dbc instanceof mysqli)) return false;
    $res = @mysqli_query($dbc, $sql);
    return $res ?: false;
}


/* ------------------------------- SECTIONED URLs -------------------------------- */
if (!defined('BASE_URL_ONBOARDING'))
    define('BASE_URL_ONBOARDING', rtrim(BASE_URL, '/') . '/onboarding');

if (!defined('BASE_URL_AMS'))
    define('BASE_URL_AMS', rtrim(BASE_URL, '/') . '/ams');

if (!defined('BASE_URL_VYZOR'))
    define('BASE_URL_VYZOR', rtrim(BASE_URL, '/') . '/vyzor');

/* Shared Assets URL */
if (!defined('BASE_URL_crmplus'))      define('BASE_URL_crmplus',      rtrim(BASE_URL, '/').'/crmplus');

if (!isset($ASSET)) {
    $base_for_assets = defined('BASE_URL_mobile') ? BASE_URL_mobile : BASE_URL;
    $ASSET = rtrim($base_for_assets, '/') . '/';
}
if (!defined('ASSETS_URL'))          define('ASSETS_URL',          BASE_URL_crmplus.'/assets');


/* ---------------------------- LIGHT ERROR MONITORING ---------------------------- */
if (!$conn_sa)       error_log('config.php: HR Superadmin connection failed: '.mysqli_connect_error());
if (!$hrd)           error_log('config.php: HRD connection failed: '.mysqli_connect_error());
if (!$conn_ic)       error_log('config.php: IC Attendance connection failed: '.mysqli_connect_error());
if (!$cron)          error_log('config.php: IC Reports connection failed: '.mysqli_connect_error());
if (!$connpe)        error_log('config.php: Project Empanel connection failed: '.mysqli_connect_error());
if (!$connwo)        error_log('config.php: Legacy Attendance connection failed: '.mysqli_connect_error());
if (!$conwebapi)     error_log('config.php: Web API connection failed: '.mysqli_connect_error());
if (!$conwhatsapp)   error_log('config.php: WhatsApp connection failed: '.mysqli_connect_error());
if (!$conn)          error_log('config.php: ONB DEFAULT ($conn) connection failed: '.mysqli_connect_error());

?>
