<?php
/* admin/applications/review_by_section_readonly.php
 * Purpose: Read-only review page for approved applications. Hides all action controls (OK/Not OK, Approve, Reject, Remarks, etc.).
 * Behavior: Shows "Print / Save PDF" button ONLY when application_status = 'approved'.
 * Stack: Core PHP + MySQLi (no PDO). DB connection in ../config.php. Collation utf8mb4_general_ci.
 */

session_start();
require_once __DIR__ . '/../config.php';

/* Charset & collation */
mysqli_set_charset($conn, 'utf8mb4');
@mysqli_query($conn, "SET collation_connection = 'utf8mb4_general_ci'");

/* Auth guard */
if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

/* Validate ID */
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
  echo "Invalid application ID.";
  exit;
}
$app_id = (int)$_GET['id'];

/* Fetch application */
$q = mysqli_query($conn, "SELECT * FROM employee_applications WHERE id={$app_id} LIMIT 1");
if (!$q || mysqli_num_rows($q)===0){ echo "Application not found."; exit; }
$app = mysqli_fetch_assoc($q);

/* Helpers */
function h($v){ return htmlspecialchars((string)($v??''), ENT_QUOTES, 'UTF-8'); }
$employee_id = !empty($app['employee_id']) ? $app['employee_id'] : (!empty($app['user_id']) ? $app['user_id'] : $app['id']);
function file_url($sid,$fn){ return "/onboarding/employee/employee-app/uploads/".rawurlencode($sid)."/".rawurlencode($fn); }
function is_img($n){ $e=strtolower(pathinfo((string)$n,PATHINFO_EXTENSION)); return in_array($e,['jpg','jpeg','png','gif','webp','bmp','avif']); }
function badge_class($s){
  $s=strtolower((string)$s);
  if($s==='approved') return 'bg-success';
  if($s==='rejected') return 'bg-danger';
  if($s==='submitted'||$s==='pending') return 'bg-warning text-dark';
  return 'bg-secondary';
}
$no_img = "/onboarding/employee/employee-app/uploads/no-image.png";

/* Subsection data (extend as needed) */
$sub_identity = [
  'First Name'     => $app['first_name'] ?? '',
  'Surname'        => $app['surname'] ?? '',
  'Gender'         => $app['gender'] ?? '',
  'Date of Birth'  => $app['dob'] ?? '',
  'Nationality'    => $app['nationality'] ?? '',
];
$att_identity = [ 'Photo' => $app['passport_photo'] ?? '' ];

$status       = trim(strtolower($app['application_status'] ?? 'submitted'));
$isApproved   = ($status === 'approved');
$submitted_at = $app['submitted_at'] ?? '';
$status_date  = $app['status_date'] ?? '';

/* -------------------- STYLES -------------------- */
ob_start();
?>
<style>
.card-soft{border:0;box-shadow:0 4px 18px rgba(0,0,0,.08);border-radius:1rem}
.badge{padding:6px 10px;border-radius:999px;font-weight:700;font-size:12px}
.sec-head{display:flex;align-items:center;gap:12px;padding:12px 14px;border-bottom:1px dashed rgba(0,0,0,.08)}
.sec-title{font-weight:800;font-size:18px}
.kv{display:grid;grid-template-columns:repeat(2,1fr);gap:12px}
.kv .formish{display:flex;flex-direction:column}
.kv label{font-weight:700;font-size:.9rem;color:#0f172a;margin-bottom:6px}
.kv .ro{background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:.65rem .8rem;min-height:40px}
.att-card img{width:200px;height:200px;object-fit:cover;border-radius:10px;border:2px solid #fff;background:#f0f7d7}
.print-only{display:none}
@media print{
  .screen-only{display:none!important;}
  .print-only{display:block}
}
</style>
<?php
$styles = ob_get_clean();

/* -------------------- CONTENT -------------------- */
ob_start();
?>
<div class="page-header-breadcrumb mb-3">
  <div class="d-flex align-center justify-content-between flex-wrap">
    <h1 class="page-title fw-medium fs-18 mb-0">Application Review (Read-Only)</h1>
    <ol class="breadcrumb mb-0">
      <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
      <li class="breadcrumb-item"><a href="javascript:void(0);">Applications</a></li>
      <li class="breadcrumb-item active">Read Only</li>
    </ol>
  </div>
</div>

<div class="row">
  <div class="col-xl-12">
    <div class="card custom-card overflow-hidden card-soft">
      <div class="card-header justify-content-between">
        <div class="card-title">Review (Read Only)</div>
        <div class="d-flex flex-wrap gap-2">
          <span class="badge <?= h(badge_class($status)) ?>"><?= strtoupper(h($status)) ?></span>
          <?php if($submitted_at){ ?><span class="badge bg-light text-dark">Submitted: <?= h($submitted_at) ?></span><?php } ?>
          <?php if($status_date){ ?><span class="badge bg-light text-dark">Last Action: <?= h($status_date) ?></span><?php } ?>
          <?php if($isApproved){ ?>
            <a href="javascript:void(0);" class="btn btn-outline-dark btn-wave ms-2 screen-only" onclick="window.print()"><i class="ri-printer-line me-1 align-middle"></i>Print / Save PDF</a>
          <?php } ?>
        </div>
      </div>

      <div class="card-body">
        <?php if(!$isApproved){ ?>
          <div class="alert alert-warning mb-3">
            This read-only page is intended for <strong>Approved</strong> applications. Printing is disabled until the application is approved.
          </div>
        <?php } ?>

        <div class="sec-head"><div class="sec-title">Personal Information</div></div>
        <div class="sec-body">
          <div class="kv">
            <?php foreach($sub_identity as $lbl=>$val){ ?>
              <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
            <?php } ?>
          </div>
          <div class="att-card mt-3">
            <?php if(!empty($att_identity['Photo'])){ ?>
              <img src="<?= h(file_url($employee_id,$att_identity['Photo'])) ?>" alt="Photo" onerror="this.src='<?= h($no_img) ?>'">
            <?php } else { ?>
              <img src="<?= h($no_img) ?>" alt="No Image">
            <?php } ?>
          </div>
        </div>

        <!-- Add more sections below as needed, all in read-only style -->
        <!-- Example skeleton:
        <div class="sec-head mt-4"><div class="sec-title">Academic Information</div></div>
        <div class="sec-body">
          <div class="kv">
            <div class="formish"><label>Highest Qualification</label><div class="ro"><?= h($app['highest_qualification'] ?? '') ?></div></div>
            <div class="formish"><label>Passing Year</label><div class="ro"><?= h($app['passing_year'] ?? '') ?></div></div>
          </div>
        </div>
        -->
      </div>
    </div>
  </div>
</div>
<?php
$content = ob_get_clean();

/* -------------------- SCRIPTS -------------------- */
$scripts = ""; // No extra scripts needed

/* Render with theme base (header + sidebar) */
include 'layouts/base.php';
