<?php
/* ============================================================================
 * File: includes/rbac_header.php
 * Purpose: Drop-in header helper to enforce page policy + expose client perms
 * Stack : Core PHP + MySQLi, uses includes/rbac.php (must be loaded first)
 * Usage :
 *   // In your layout header (before rendering page body):
 *   require_once __DIR__ . '/rbac.php';
 *   // (Optional) define page policy before including header:
 *   // $RBAC_REQUIRE_LOGIN = true;
 *   // $RBAC_REQUIRE_ALL   = ['opportunities.view'];
 *   // $RBAC_REQUIRE_ANY   = [];
 *   rbac_auto_guard();          // enforce login + required perms (if any)
 *   rbac_export_client_perms(); // push CURRENT_PERMISSIONS to the DOM
 * ========================================================================== */

if (!function_exists('rbac_auto_guard') || !function_exists('rbac_export_client_perms')) {
  require_once __DIR__ . '/rbac.php';
}

/* Enforce declared page policy (uses $RBAC_REQUIRE_* globals if set) */
rbac_auto_guard();

/* Expose permissions to the client and auto-hide unauthorized elements */
rbac_export_client_perms();
