
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Medical</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Medical</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row">
                        <div class="col-xxl-5">
                            <div class="row">
                                <div class="col-xl-6">
                                    <div class="card custom-card dashboard-main-card medical-main-card primary">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start justify-content-between mb-2">
                                                <div class="flex-fill">
                                                    <div class="mb-2">Total Visitors</div>
                                                    <h4 class="fw-semibold text-primary mb-0">11,232</h4>
                                                </div>
                                                <div>
                                                    <span class="avatar avatar-md bg-primary-transparent svg-primary">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 4c1.93 0 3.5 1.57 3.5 3.5S13.93 13 12 13s-3.5-1.57-3.5-3.5S10.07 6 12 6zm0 14c-2.03 0-4.43-.82-6.14-2.88C7.55 15.8 9.68 15 12 15s4.45.8 6.14 2.12C16.43 19.18 14.03 20 12 20z"/></g></svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="d-flex fs-13 align-items-center justify-content-between">
                                                <div class="text-muted">Since Last Month</div>
                                                <div class="text-success fw-medium d-inline-flex"><i class="ti ti-trending-up align-middle me-1"></i>3.24%</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="card custom-card dashboard-main-card medical-main-card secondary">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start justify-content-between mb-2">
                                                <div class="flex-fill">
                                                    <div class="mb-2">Appointments Booked</div>
                                                    <h4 class="fw-semibold text-secondary mb-0">2,976</h4>
                                                </div>
                                                <div>
                                                    <span class="avatar avatar-md bg-secondary-transparent svg-secondary">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><rect fill="none" height="24" width="24"/><g><path d="M17,1H7C5.9,1,5,1.9,5,3v18c0,1.1,0.9,2,2,2h10c1.1,0,2-0.9,2-2V3C19,1.9,18.1,1,17,1z M7,18V6h10v12H7z M16,11V9.14 C16,8.51,15.55,8,15,8H9C8.45,8,8,8.51,8,9.14l0,1.96c0.55,0,1,0.45,1,1c0,0.55-0.45,1-1,1l0,1.76C8,15.49,8.45,16,9,16h6 c0.55,0,1-0.51,1-1.14V13c-0.55,0-1-0.45-1-1C15,11.45,15.45,11,16,11z M12.5,14.5h-1v-1h1V14.5z M12.5,12.5h-1v-1h1V12.5z M12.5,10.5h-1v-1h1V10.5z"/></g></svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="d-flex fs-13 align-items-center justify-content-between">
                                                <div class="text-muted">Since Last Month</div>
                                                <div class="text-success fw-medium d-inline-flex"><i class="ti ti-trending-up align-middle me-1"></i>15.69%</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="card custom-card dashboard-main-card medical-main-card warning">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start justify-content-between mb-2">
                                                <div class="flex-fill">
                                                    <div class="mb-2">Total Patients</div>
                                                    <h4 class="fw-semibold text-warning mb-0">535</h4>
                                                </div>
                                                <div>
                                                    <span class="avatar avatar-md bg-warning-transparent svg-warning">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><rect fill="none" height="24" width="24"/><g><path d="M8,6c0-2.21,1.79-4,4-4s4,1.79,4,4c0,2.21-1.79,4-4,4S8,8.21,8,6z M17,22h1c1.1,0,2-0.9,2-2l0-4.78 c0-1.12-0.61-2.15-1.61-2.66c-0.43-0.22-0.9-0.43-1.39-0.62L17,22z M12.34,17L15,11.33C14.07,11.12,13.07,11,12,11 c-2.53,0-4.71,0.7-6.39,1.56C4.61,13.07,4,14.1,4,15.22L4,22h2.34C6.12,21.55,6,21.04,6,20.5C6,18.57,7.57,17,9.5,17H12.34z M10,22 l1.41-3H9.5C8.67,19,8,19.67,8,20.5S8.67,22,9.5,22H10z"/></g></svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="d-flex fs-13 align-items-center justify-content-between">
                                                <div class="text-muted">Since Last Month</div>
                                                <div class="text-danger fw-medium d-inline-flex"><i class="ti ti-trending-down align-middle me-1"></i>1.07%</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="card custom-card dashboard-main-card medical-main-card success">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start justify-content-between mb-2">
                                                <div class="flex-fill">
                                                    <div class="mb-2">Available Rooms</div>
                                                    <h4 class="fw-semibold text-success mb-0">180</h4>
                                                </div>
                                                <div>
                                                    <span class="avatar avatar-md bg-success-transparent svg-success">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><path d="M0,0h24v24H0V0z" fill="none"/></g><g><g><path d="M16.5,12h-9c-0.55,0-1,0.45-1,1v1h11v-1C17.5,12.45,17.05,12,16.5,12z"/><rect height="2" width="4" x="7.25" y="8.5"/><rect height="2" width="4" x="12.75" y="8.5"/><path d="M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M19,17h-1.5v-1.5h-11V17H5v-3.83 c0-0.66,0.25-1.26,0.65-1.72V9c0-1.1,0.9-2,2-2H11c0.37,0,0.72,0.12,1,0.32C12.28,7.12,12.63,7,13,7h3.35c1.1,0,2,0.9,2,2v2.45 c0.4,0.46,0.65,1.06,0.65,1.72V17z"/></g></g></svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="d-flex fs-13 align-items-center justify-content-between">
                                                <div class="text-muted">Total Rooms</div>
                                                <div class="fw-medium">250</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Patient Statistics
                                            </div>
                                            <div class="btn-group" role="group" aria-label="Basic example">
                                                <button type="button" class="btn btn-primary btn-sm btn-wave waves-effect waves-light">1D</button>
                                                <button type="button" class="btn btn-primary-light btn-sm btn-wave waves-effect waves-light">1W</button>
                                                <button type="button" class="btn btn-primary-light btn-sm btn-wave waves-effect waves-light">1M</button>
                                                <button type="button" class="btn btn-primary-light btn-sm btn-wave waves-effect waves-light">6M</button>
                                                <button type="button" class="btn btn-primary-light btn-sm btn-wave waves-effect waves-light">1Y</button>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div id="patients-statistics"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-7">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="card custom-card available-treatments-card">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Available Treatments
                                            </div>
                                            <a href="javascript:void(0);" class="text-muted fs-13">View All<i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                        </div>
                                        <div class="card-body">
                                            <div class="row gy-sm-0 gy-3 gx-3 flex-wrap"> 
                                                <div class="col-xxl-2 col-xl-2 col-lg-3 col-md-3 col-sm-3 col text-center"> 
                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-primary-light btn-icon"> 
                                                        <i class="ti ti-heartbeat"></i> 
                                                    </a> 
                                                    <a href="javascript:void(0);" class="d-block mt-3 fw-medium">Cardiology</a> 
                                                </div> 
                                                <div class="col-xxl-2 col-xl-2 col-lg-3 col-md-3 col-sm-3 col text-center"> 
                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-secondary-light btn-icon"> 
                                                        <i class="ti ti-baby-carriage "></i> 
                                                    </a> 
                                                    <a href="javascript:void(0);" class="d-block mt-3 fw-medium">Pediatrics</a> 
                                                </div> 
                                                <div class="col-xxl-2 col-xl-2 col-lg-3 col-md-3 col-sm-3 col text-center"> 
                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-success-light btn-icon"> 
                                                        <i class="ti ti-bone"></i> 
                                                    </a> 
                                                    <a href="javascript:void(0);" class="d-block mt-3 fw-medium">Orthopedic</a> 
                                                </div> 
                                                <div class="col-xxl-2 col-xl-2 col-lg-3 col-md-3 col-sm-3 col text-center"> 
                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-orange-light btn-icon"> 
                                                        <i class="ti ti-activity-heartbeat"></i> 
                                                    </a> 
                                                    <a href="javascript:void(0);" class="d-block mt-3 fw-medium">Neurology</a> 
                                                </div> 
                                                <div class="col-xxl-2 col-xl-2 col-lg-3 col-md-3 col-sm-3 col text-center">
                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-info-light btn-icon"> 
                                                        <i class="ti ti-brand-debian"></i> 
                                                    </a> 
                                                    <a href="javascript:void(0);" class="d-block mt-3 fw-medium">Psychiatry</a> 
                                                </div> 
                                                <div class="col-xxl-2 col-xl-2 col-lg-3 col-md-3 col-sm-3 col text-center"> 
                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-warning-light btn-icon"> 
                                                        <i class="bi bi-three-dots"></i> 
                                                    </a> 
                                                    <a href="javascript:void(0);" class="d-block mt-3 fw-medium">More</a> 
                                                </div> 
                                            </div> 
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-7">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Today's Appointments
                                            </div>
                                            <a href="javascript:void(0);" class="text-muted fs-13">View All<i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                        </div>
                                        <div class="card-body p-0">
                                            <div class="table-responsive">
                                                <table class="table text-nowrap appointments-table">
                                                    <tbody>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold d-block">John Doe</span>
                                                                        <span class="fs-13 text-muted">Male,32Yrs</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span class="badge bg-primary-transparent">General Checkup</span>
                                                            </td>
                                                            <td>
                                                                10:00 AM
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold d-block">Sarah Smith</span>
                                                                        <span class="fs-13 text-muted">Female,45Yrs</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span class="badge bg-secondary-transparent">Dermatology</span>
                                                            </td>
                                                            <td>
                                                                10:30 AM
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold d-block">Mark Johnson</span>
                                                                        <span class="fs-13 text-muted">Male,29Yrs</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span class="badge bg-warning-transparent">Cardiology</span>
                                                            </td>
                                                            <td>
                                                                11:00 AM
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold d-block">Emily Clark</span>
                                                                        <span class="fs-13 text-muted">Female,38Yrs</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span class="badge bg-info-transparent">Gynecology</span>
                                                            </td>
                                                            <td>
                                                                11:30 AM
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/7.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold d-block">Lisa White</span>
                                                                        <span class="fs-13 text-muted">Female,27Yrs</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td class="border-bottom-0">
                                                                <span class="badge bg-success-transparent">Pediatrics</span>
                                                            </td>
                                                            <td class="border-bottom-0">
                                                                12:30 PM
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-5">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Available Doctors
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <nav class="nav nav-style-1 nav-pills mb-4 nav-justified" role="tablist">
                                                <a class="nav-link px-2" data-bs-toggle="tab" role="tab" href="#tue" aria-selected="false" tabindex="-1">
                                                    <span class="d-block mb-1">22</span>
                                                    <span class="op-6 fs-12">Sat</span>
                                                </a>
                                                <a class="nav-link px-2" data-bs-toggle="tab" role="tab" href="#wed" aria-selected="false" tabindex="-1">
                                                    <span class="d-block mb-1">23</span>
                                                    <span class="op-6 fs-12">Sun</span>
                                                </a>
                                                <a class="nav-link px-2 active" data-bs-toggle="tab" aria-current="page" role="tab" href="#thu" aria-selected="true" tabindex="-1">
                                                    <span class="d-block mb-1">24</span>
                                                    <span class="op-6 fs-12">Mon</span>
                                                </a>
                                                <a class="nav-link px-2" data-bs-toggle="tab" role="tab" href="#fri" aria-selected="false" tabindex="-1">
                                                    <span class="d-block mb-1">25</span>
                                                    <span class="op-6 fs-12">Tue</span>
                                                </a>
                                                <a class="nav-link px-2" data-bs-toggle="tab" role="tab" href="#sat" aria-selected="false" tabindex="-1">
                                                    <span class="d-block mb-1">26</span>
                                                    <span class="op-6 fs-12">Wed</span>
                                                </a>
                                            </nav>
                                            <ul class="list-unstyled availabe-doctors-list" id="available-doctors">
                                                <li>
                                                    <div class="d-flex align-items-start gap-2">
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold">Dr. John Miller</span>
                                                            <span class="text-primary fs-13">Cardiology</span>
                                                        </div>
                                                        <div class="fs-13 text-muted d-flex align-items-center gap-1"><i class="ti ti-clock-hour-3"></i>9:00 AM - 12:00 PM</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-2">
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold">Dr. Sarah Williams</span>
                                                            <span class="text-secondary fs-13">Dermatology</span>
                                                        </div>
                                                        <div class="fs-13 text-muted d-flex align-items-center gap-1"><i class="ti ti-clock-hour-3"></i>10:00 AM - 1:00 PM</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-2">
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold">Dr. Mark Thompson</span>
                                                            <span class="text-warning fs-13">Neurology</span>
                                                        </div>
                                                        <div class="fs-13 text-muted d-flex align-items-center gap-1"><i class="ti ti-clock-hour-3"></i>1:30 PM - 4:30 PM</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-2">
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold">Dr. Emily Davis</span>
                                                            <span class="text-success fs-13">Gynecology</span>
                                                        </div>
                                                        <div class="fs-13 text-muted d-flex align-items-center gap-1"><i class="ti ti-clock-hour-3"></i>9:30 AM - 12:30 PM</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-2">
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold">Dr. James Clark</span>
                                                            <span class="text-info fs-13">Orthopedics</span>
                                                        </div>
                                                        <div class="fs-13 text-muted d-flex align-items-center gap-1"><i class="ti ti-clock-hour-3"></i>10:00 AM - 1:00 PM</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-2">
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold">Dr. Lisa Harris</span>
                                                            <span class="text-danger fs-13">Pediatrics</span>
                                                        </div>
                                                        <div class="fs-13 text-muted d-flex align-items-center gap-1"><i class="ti ti-clock-hour-3"></i>8:00 AM - 11:00 AM</div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-1 -->

                    <!-- Start:: row-2 -->
                    <div class="row">
                        <div class="col-xxl-3 col-xl-6">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-header">
                                    <div class="card-title">
                                        Patients Visits
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div id="patients-visits"></div>
                                </div>
                                <div class="card-footer p-0">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-primary-transparent">
                                                        <i class="ti ti-gender-male fs-5"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="fw-semibold d-block">Male</span>
                                                    <span class="fs-13 d-block text-muted"><span class="text-success me-2 d-inline-flex align-items-center"><i class="ti ti-trending-up me-1 align-middle"></i>5.23%</span>Since Last Week</span>
                                                </div>
                                                <div class="text-primary fw-semibold">89%</div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-secondary-transparent">
                                                        <i class="ti ti-gender-female fs-5"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="fw-semibold d-block">Female</span>
                                                    <span class="fs-13 d-block text-muted"><span class="text-danger me-2 d-inline-flex align-items-center"><i class="ti ti-trending-down me-1 align-middle"></i>8.85%</span>Since Last Week</span>
                                                </div>
                                                <div class="text-secondary fw-semibold">75%</div>
                                            </div>
                                        </li> 
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Top Doctors
                                    </div>
                                    <a href="javascript:void(0);" class="fs-13 text-muted">View All<i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                </div>
                                <div class="card-body p-0">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item">
                                            <a href="javascript:void(0);" class="stretched-link"></a>
                                            <div class="d-flex align-items-center gap-3">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-light">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/1.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Dr. John Miller</span>
                                                    <span class="d-block fs-13 text-muted">Cardiologist</span>
                                                </div>
                                                <div class="text-end">
                                                    <div>
                                                        <span class="d-inline-flex align-items-center">4.9<i class="ti ti-star-filled m-1 text-warning"></i></span>
                                                    </div>
                                                    <span class="fs-13 text-muted">12+ Years Exp</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="javascript:void(0);" class="stretched-link"></a>
                                            <div class="d-flex align-items-center gap-3">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-light">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/4.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Dr. Sarah Williams</span>
                                                    <span class="d-block fs-13 text-muted">Dermatologist</span>
                                                </div>
                                                <div class="text-end">
                                                    <div>
                                                        <span class="d-inline-flex align-items-center">4.8<i class="ti ti-star-filled ms-1 text-warning"></i></span>
                                                    </div>
                                                    <span class="fs-13 text-muted">10+ Years Exp</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="javascript:void(0);" class="stretched-link"></a>
                                            <div class="d-flex align-items-center gap-3">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-light">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/2.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Dr. Mark Thompson</span>
                                                    <span class="d-block fs-13 text-muted">Neurologist</span>
                                                </div>
                                                <div class="text-end">
                                                    <div>
                                                        <span class="d-inline-flex align-items-center">4.7<i class="ti ti-star-filled ms-1 text-warning"></i></span>
                                                    </div>
                                                    <span class="fs-13 text-muted">15+ Years Exp</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="javascript:void(0);" class="stretched-link"></a>
                                            <div class="d-flex align-items-center gap-3">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-light">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/5.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Dr. Emily Davis</span>
                                                    <span class="d-block fs-13 text-muted">Gynecologist</span>
                                                </div>
                                                <div class="text-end">
                                                    <div>
                                                        <span class="d-inline-flex align-items-center">4.6<i class="ti ti-star-filled ms-1 text-warning"></i></span>
                                                    </div>
                                                    <span class="fs-13 text-muted">9+ Years Exp</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="javascript:void(0);" class="stretched-link"></a>
                                            <div class="d-flex align-items-center gap-3">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-light">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/3.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Dr. James Clark</span>
                                                    <span class="d-block fs-13 text-muted">Orthopedic Surgeon</span>
                                                </div>
                                                <div class="text-end">
                                                    <div>
                                                        <span class="d-inline-flex align-items-center">4.9<i class="ti ti-star-filled ms-1 text-warning"></i></span>
                                                    </div>
                                                    <span class="fs-13 text-muted">14+ Years Exp</span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Patients Reports
                                    </div>
                                    <a href="javascript:void(0);" class="fs-13 text-muted">View All<i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled patients-reports-list">
                                        <li>
                                            <div class="d-flex align-items-center gap-2 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-danger-transparent avatar-rounded">
                                                        <i class="ti ti-droplet-filled fs-20"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">John Doe</span>
                                                    <span class="d-block fs-13 text-muted">Blood Test</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="d-flex align-items-center gap-1"><i class="ti ti-circle-check-filled text-success fs-20"></i>Completed</span>
                                                    <span class="fs-13 text-muted">Feb 25, 2025</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-info-transparent avatar-rounded">
                                                        <i class="ti ti-brain fs-20"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Emma Johnson</span>
                                                    <span class="d-block fs-13 text-muted">MRI Scan</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="d-flex align-items-center gap-1"><i class="ti ti-clock-hour-3 text-primary fs-20"></i>Pending</span>
                                                    <span class="fs-13 text-muted">Feb 26, 2025</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-warning-transparent avatar-rounded">
                                                    <i class="ti ti-bone fs-20"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Michael Smith</span>
                                                    <span class="d-block fs-13 text-muted">X-Ray</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="d-flex align-items-center gap-1"><i class="ti ti-circle-check-filled text-success fs-20"></i>Completed</span>
                                                    <span class="fs-13 text-muted">Feb 24, 2025</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-success-transparent avatar-rounded">
                                                        <i class="ti ti-heartbeat fs-20"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Sophia Williams</span>
                                                    <span class="d-block fs-13 text-muted">ECG</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="d-flex align-items-center gap-1"><i class="ti ti-reload text-info fs-20"></i>In Progress</span>
                                                    <span class="fs-13 text-muted">Feb 25, 2025</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-primary-transparent avatar-rounded">
                                                        <i class="ti ti-report fs-20"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">James Brown</span>
                                                    <span class="d-block fs-13 text-muted">CT Scan</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="d-flex align-items-center gap-1"><i class="ti ti-circle-check-filled text-success fs-20"></i>Completed</span>
                                                    <span class="fs-13 text-muted">Feb 23, 2025</span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Top Departments
                                    </div>
                                </div>
                                <div class="card-body py-0">
                                    <div id="top-departments"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-2 -->

                    <!-- Start:: row-3 -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Patient Records
                                    </div>
                                    <div class="d-flex flex-wrap gap-2">
                                        <div>
                                            <input class="form-control form-control-sm" type="text" placeholder="Search Here" aria-label=".form-control-sm example">
                                        </div>
                                        <div class="dropdown">
                                            <a href="javascript:void(0);" class="btn btn-primary btn-sm btn-wave waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="false"> Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
                                            </a>
                                            <ul class="dropdown-menu" role="menu">
                                                <li><a class="dropdown-item" href="javascript:void(0);">New</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Popular</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Relevant</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table text-nowrap">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        Patient ID
                                                    </th>
                                                    <th>Name</th>
                                                    <th>Age</th>
                                                    <th>Gender</th>
                                                    <th>Consultation Type</th>
                                                    <th>Doctor</th>
                                                    <th>Status</th>
                                                    <th>Appointment Date</th>
                                                    <th>Time</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        SPK001
                                                    </td>
                                                    <td>
                                                        John Doe
                                                    </td>
                                                    <td>
                                                        45
                                                    </td>
                                                    <td>
                                                        Male
                                                    </td>
                                                    <td>
                                                        General Checkup
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/1.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                Dr. Smith
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <th>
                                                        <span class="badge bg-success-transparent">Completed</span>
                                                    </th>
                                                    <th>
                                                        Feb 25, 2025
                                                    </th>
                                                    <th>
                                                        10:00 AM
                                                    </th>
                                                    <th>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class="btn btn-icon btn-sm btn-light"> 
                                                                <i class="ti ti-dots-vertical"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </th>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        SPK002
                                                    </td>
                                                    <td>
                                                        Emma Johnson
                                                    </td>
                                                    <td>
                                                        30
                                                    </td>
                                                    <td>
                                                        Female
                                                    </td>
                                                    <td>
                                                        Cardiology
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/2.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                Dr. Wilson
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <th>
                                                        <span class="badge bg-warning-transparent">Pending</span>
                                                    </th>
                                                    <th>
                                                        Feb 26, 2025
                                                    </th>
                                                    <th>
                                                        11:30 AM
                                                    </th>
                                                    <th>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class="btn btn-icon btn-sm btn-light"> 
                                                                <i class="ti ti-dots-vertical"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </th>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        SPK003
                                                    </td>
                                                    <td>
                                                        Michael Lee
                                                    </td>
                                                    <td>
                                                        50
                                                    </td>
                                                    <td>
                                                        Male
                                                    </td>
                                                    <td>
                                                        Orthopedic
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/5.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                Dr. Brown
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <th>
                                                        <span class="badge bg-success-transparent">	Completed</span>
                                                    </th>
                                                    <th>
                                                        Feb 24, 2025	
                                                    </th>
                                                    <th>
                                                        01:00 PM
                                                    </th>
                                                    <th>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class="btn btn-icon btn-sm btn-light"> 
                                                                <i class="ti ti-dots-vertical"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </th>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        SPK004
                                                    </td>
                                                    <td>
                                                        Olivia Davis
                                                    </td>
                                                    <td>
                                                        28
                                                    </td>
                                                    <td>
                                                        Female
                                                    </td>
                                                    <td>
                                                        Dermatology
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/6.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                Dr. Martinez
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <th>
                                                        <span class="badge bg-primary-transparent">Ongoing</span>
                                                    </th>
                                                    <th>
                                                        Feb 25, 2025
                                                    </th>
                                                    <th>
                                                        02:45 PM
                                                    </th>
                                                    <th>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class="btn btn-icon btn-sm btn-light"> 
                                                                <i class="ti ti-dots-vertical"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </th>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        SPK005
                                                    </td>
                                                    <td>
                                                        Ethan White
                                                    </td>
                                                    <td>
                                                        40
                                                    </td>
                                                    <td>
                                                        Male
                                                    </td>
                                                    <td>
                                                        Neurology
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/3.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                Dr. Anderson
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <th>
                                                        <span class="badge bg-success-transparent">Completed</span>
                                                    </th>
                                                    <th>
                                                        Feb 23, 2025
                                                    </th>
                                                    <th>
                                                        09:00 AM
                                                    </th>
                                                    <th>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class="btn btn-icon btn-sm btn-light"> 
                                                                <i class="ti ti-dots-vertical"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </th>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        SPK006
                                                    </td>
                                                    <td>
                                                        Sophia Lewis
                                                    </td>
                                                    <td>
                                                        35
                                                    </td>
                                                    <td>
                                                        Female
                                                    </td>
                                                    <td>
                                                        Gastroenterology
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/doctors/4.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                Dr. Roberts
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <th>
                                                        <span class="badge bg-warning-transparent">Pending</span>
                                                    </th>
                                                    <th>
                                                        Feb 27, 2025
                                                    </th>
                                                    <th>
                                                        12:15 PM
                                                    </th>
                                                    <th>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class="btn btn-icon btn-sm btn-light"> 
                                                                <i class="ti ti-dots-vertical"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item d-inline-flex align-items-cente" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </th>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="card-footer border-top-0">
                                    <div class="d-flex align-items-center"> 
                                        <div> Showing 6 Entries <i class="bi bi-arrow-right ms-2 fw-semibold"></i> </div> 
                                        <div class="ms-auto"> 
                                            <nav aria-label="Page navigation" class="pagination-style-2">
                                                <ul class="pagination mb-0 flex-wrap">
                                                    <li class="page-item disabled">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            Prev
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                                    <li class="page-item active"><a class="page-link" href="javascript:void(0);">2</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            <i class="bi bi-three-dots"></i>
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">17</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link text-primary" href="javascript:void(0);">
                                                            next
                                                        </a>
                                                    </li>
                                                </ul>
                                            </nav>
                                        </div> 
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-3 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

        <!-- Medical Dashboard --> 
        <script src="<?php echo $baseUrl; ?>/assets/js/medical-dashboard.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
