
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap gap-2">
                            <h1 class="page-title fw-medium fs-18 mb-0">Podcast</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Podcast</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row">
                        <div class="col-xxl-9">
                            <div class="row">
                                <div class="col-xxl-8">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="card custom-card podcast-banner-card border-0 shadow-none">
                                                <div class="card-body">
                                                    <div class="podcast-banner-card-background">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/backgrounds/6.png" alt="">
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-xl-8">
                                                            <span class="badge bg-primary rounded-pill">Featured Track</span>
                                                            <h2 class="fw-semibold mt-2">Echoes of Tomorrow</h2>
                                                            <p class="fs-16 mb-3">
                                                                Tune in to 'Echoes of Tomorrow'—exclusive insights and an <br> artist interview, only on our podcast.
                                                            </p>
                                                            <div class="fw-medium text-primary mb-4"><i class="ti ti-music mx-1"></i>30 + Eps <span class="ms-2 text-default fs-12 op-8"><i class="ri-play-circle-line fs-13 mx-1"></i>260.517/ Monthly Listenders</span>  </div>
                                                            <div class="btn-list">
                                                                <button class="btn btn-lg btn-primary btn-w-lg">
                                                                    Listen Now
                                                                </button>
                                                                <button class="btn btn-lg btn-primary-ghost btn-w-lg">
                                                                    Try Premium
                                                                </button>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-4">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/media/media-70.png" alt="" class="podcast-banner-img img-fluid d-md-block d-none">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-12">
                                            <div class="mb-4 d-flex align-items-center justify-content-between"> 
                                                <h6 class="fw-medium mb-0">Categories :</h6> 
                                                <span class="text-muted fs-13">View All<i class="ti ti-arrow-narrow-right ms-1"></i></span>
                                            </div>
                                            <div class="d-flex align-items-center gap-2 mb-4 flex-wrap">
                                                <div class="nft-tag nft-tag-primary active">
                                                    <a href="javascript:void(0);" class="stretched-link"></a>
                                                    <span class="nft-tag-icon"><i class="ti ti-world fs-16"></i></span>
                                                    <span class="nft-tag-text podcast-category-text">All</span>
                                                </div>
                                                <div class="nft-tag nft-tag-secondary">
                                                    <a href="javascript:void(0);" class="stretched-link"></a>
                                                    <span class="nft-tag-icon"><i class="ti ti-flame fs-16"></i></span>
                                                    <span class="nft-tag-text podcast-category-text">New Trends</span>
                                                </div>
                                                <div class="nft-tag nft-tag-info">
                                                    <a href="javascript:void(0);" class="stretched-link"></a>
                                                    <span class="nft-tag-icon"><i class="ti ti-palette fs-16"></i></span>
                                                    <span class="nft-tag-text podcast-category-text">Art Work</span>
                                                </div>
                                                <div class="nft-tag nft-tag-success">
                                                    <a href="javascript:void(0);" class="stretched-link"></a>
                                                    <span class="nft-tag-icon"><i class="ti ti-device-gamepad-2 fs-16"></i></span>
                                                    <span class="nft-tag-text podcast-category-text">Games</span>
                                                </div>
                                                <div class="nft-tag nft-tag-danger">
                                                    <a href="javascript:void(0);" class="stretched-link"></a>
                                                    <span class="nft-tag-icon"><i class="ti ti-tie fs-16"></i></span>
                                                    <span class="nft-tag-text podcast-category-text">Fashion</span>
                                                </div>
                                                <div class="nft-tag nft-tag-purple">
                                                    <a href="javascript:void(0);" class="stretched-link"></a>
                                                    <span class="nft-tag-icon"><i class="ti ti-music fs-16"></i></span>
                                                    <span class="nft-tag-text podcast-category-text">Music</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-4">
                                    <div class="card custom-card">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Top Podcasters
                                            </div>
                                            <a href="javascript:void(0);" class="text-muted fs-13">View All<i class="ti ti-arrow-narrow-right ms-1 align-middle"></i></a>
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-unstyled top-podcasters-list">
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">John Doe</span>
                                                            <span class="fs-13 d-block text-muted">Tech Talks</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <span class="badge bg-primary-transparent">Technology</span>
                                                            <span class="fs-13 d-block mt-1">1.2M - Followers</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">Sarah Lee</span>
                                                            <span class="fs-13 d-block text-muted">Fitness Fuel</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <span class="badge bg-secondary-transparent">Health & Fitness</span>
                                                            <span class="fs-13 d-block mt-1">850K - Followers</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">Emily Stone</span>
                                                            <span class="fs-13 d-block text-muted">True Crime Chronicles</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <span class="badge bg-success-transparent">True Crime</span>
                                                            <span class="fs-13 d-block mt-1">2.1M - Followers</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/15.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">Mark Taylor</span>
                                                            <span class="fs-13 d-block text-muted">Financial Futures</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <span class="badge bg-info-transparent">Finance & Economics</span>
                                                            <span class="fs-13 d-block mt-1">1M - Followers</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">David Brown</span>
                                                            <span class="fs-13 d-block text-muted">The Comedy Show</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <span class="badge bg-warning-transparent">Comedy</span>
                                                            <span class="fs-13 d-block mt-1">1.5M - Followers</span>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="row">
                                        <div class="mb-4 d-flex align-items-center justify-content-between"> 
                                            <h6 class="fw-medium mb-0">Recommendations :</h6> 
                                            <a href="javascript:void(0);" class="fs-12 text-muted"> View All<i class="ti ti-arrow-narrow-right ms-1"></i> </a>
                                        </div>
                                        <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                            <div class="card custom-card">
                                                <div class="row g-0">
                                                    <div class="col-3">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-71.jpg" class="img-fluid rounded-start h-100 w-100" alt="...">
                                                    </div>
                                                    <div class="col-9">
                                                        <div class="card-body p-4">
                                                            <div class="d-flex align-items-center justify-content-between">
                                                                <div>
                                                                    <a href="javascript:void(0);"><h6 class="fw-medium mb-0">The Culture Lab</h6></a>
                                                                    <span class="text-muted fs-12">By Sophia Miller</span>
                                                                </div>
                                                                <div>
                                                                    <button class="btn btn-primary-light btn-icon btn-wave">
                                                                        <i class="ri-play-fill"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                            <div class="card custom-card">
                                                <div class="row g-0">
                                                    <div class="col-3">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-73.jpg" class="img-fluid rounded-start h-100 w-100" alt="...">
                                                    </div>
                                                    <div class="col-9">
                                                        <div class="card-body p-4">
                                                            <div class="d-flex align-items-center justify-content-between">
                                                                <div>
                                                                    <a href="javascript:void(0);"><h6 class="fw-medium mb-0">Morning Brew</h6></a>
                                                                    <span class="text-muted fs-12">By Jake Matthews</span>
                                                                </div>
                                                                <div>
                                                                    <button class="btn btn-primary-light btn-icon btn-wave">
                                                                        <i class="ri-play-fill"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                            <div class="card custom-card">
                                                <div class="row g-0">
                                                    <div class="col-3">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-79.jpg" class="img-fluid rounded-start h-100 w-100" alt="...">
                                                    </div>
                                                    <div class="col-9">
                                                        <div class="card-body p-4">
                                                            <div class="d-flex align-items-center justify-content-between">
                                                                <div>
                                                                    <a href="javascript:void(0);"><h6 class="fw-medium mb-0">Future of Finance</h6></a>
                                                                    <span class="text-muted fs-12">By Sarah Lee</span>
                                                                </div>
                                                                <div>
                                                                    <button class="btn btn-primary-light btn-icon btn-wave">
                                                                        <i class="ri-play-fill"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                            <div class="card custom-card">
                                                <div class="row g-0">
                                                    <div class="col-3">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-77.jpg" class="img-fluid rounded-start h-100 w-100" alt="...">
                                                    </div>
                                                    <div class="col-9">
                                                        <div class="card-body p-4">
                                                            <div class="d-flex align-items-center justify-content-between">
                                                                <div>
                                                                    <a href="javascript:void(0);"><h6 class="fw-medium mb-0">Waves of Change</h6></a>
                                                                    <span class="text-muted fs-12">By David Green</span>
                                                                </div>
                                                                <div>
                                                                    <button class="btn btn-primary-light btn-icon btn-wave">
                                                                        <i class="ri-play-fill"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                            <div class="card custom-card">
                                                <div class="row g-0">
                                                    <div class="col-3">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-76.jpg" class="img-fluid rounded-start h-100 w-100" alt="...">
                                                    </div>
                                                    <div class="col-9">
                                                        <div class="card-body p-4">
                                                            <div class="d-flex align-items-center justify-content-between">
                                                                <div>
                                                                    <a href="javascript:void(0);"><h6 class="fw-medium mb-0">Tech Deep Dive</h6></a>
                                                                    <span class="text-muted fs-12">By Emily Scott</span>
                                                                </div>
                                                                <div>
                                                                    <button class="btn btn-primary-light btn-icon btn-wave">
                                                                        <i class="ri-play-fill"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                                            <div class="card custom-card">
                                                <div class="row g-0">
                                                    <div class="col-3">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-75.jpg" class="img-fluid rounded-start h-100 w-100" alt="...">
                                                    </div>
                                                    <div class="col-9">
                                                        <div class="card-body p-4">
                                                            <div class="d-flex align-items-center justify-content-between">
                                                                <div>
                                                                    <a href="javascript:void(0);"><h6 class="fw-medium mb-0">Unsolved Mysteries</h6></a>
                                                                    <span class="text-muted fs-12">By Rachel Adams</span>
                                                                </div>
                                                                <div>
                                                                    <button class="btn btn-primary-light btn-icon btn-wave">
                                                                        <i class="ri-play-fill"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-4 d-flex align-items-center justify-content-between"> 
                                            <h6 class="fw-medium mb-0">Recently Played :</h6> 
                                            <a href="javascript:void(0);" class="fs-12 text-muted"> View All<i class="ti ti-arrow-narrow-right ms-1"></i> </a>
                                        </div>
                                        <div class="col-xl-12">
                                            <div class="row row-cols-xxl-5">
                                                <div class="col">
                                                    <div class="card custom-card">
                                                        <a href="javascript:void(0);" class="card-anchor"></a>
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-43.jpg" class="card-img-top" alt="...">
                                                        <div class="card-body">
                                                            <h6 class="card-title fw-medium mb-0">The Digital Revolution</h6>
                                                            <span class="fs-13 text-muted">By Alex Turner</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card custom-card">
                                                        <a href="javascript:void(0);" class="card-anchor"></a>
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-44.jpg" class="card-img-top" alt="...">
                                                        <div class="card-body">
                                                            <h6 class="card-title fw-medium mb-0">Unsolved Mysteries</h6>
                                                            <span class="fs-13 text-muted">By Rachel Adams</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card custom-card">
                                                        <a href="javascript:void(0);" class="card-anchor"></a>
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-45.jpg" class="card-img-top" alt="...">
                                                        <div class="card-body">
                                                            <h6 class="card-title fw-medium mb-0">Startup Stories</h6>
                                                            <span class="fs-13 text-muted">By James Hawkins</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card custom-card">
                                                        <a href="javascript:void(0);" class="card-anchor"></a>
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-46.jpg" class="card-img-top" alt="...">
                                                        <div class="card-body">
                                                            <h6 class="card-title fw-medium mb-0">Healthy Habits</h6>
                                                            <span class="fs-13 text-muted">By Olivia Reed</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card custom-card">
                                                        <a href="javascript:void(0);" class="card-anchor"></a>
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-41.jpg" class="card-img-top" alt="...">
                                                        <div class="card-body">
                                                            <h6 class="card-title fw-medium mb-0">Beyond the Horizon</h6>
                                                            <span class="fs-13 text-muted">By Michael Harris</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="row">
                                <div class="col-xl-12">
                                    <h6 class="fw-semibold mb-3">Now Playing</h6>
                                    <div class="card custom-card">
                                        <div class="card-body p-4">
                                            <div class="text-center mb-4">
                                                <span class="avatar mb-3 podcast-playing-now-avatar shadow">
                                                    <img src="<?php echo $baseUrl; ?>/assets/images/media/media-78.jpg" alt="">
                                                </span>
                                                <a href="javascript:void(0);"><h6 class="fw-medium mb-1">Echoes of Tomorrow</h6></a>
                                                <span class="fs-12">By Alice Mumbleton</span>
                                            </div>
                                            <div class="row justify-content-center">
                                                <div class="col-xl-9">
                                                    <div class="d-flex gap-3 align-items-center mb-4">
                                                        <div class="fs-12">12.25</div>
                                                        <div class="progress progress-xs progress-custom progress-animate podcast-playing-progress bg-light" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-success" style="width: 50%">
                                                            </div>
                                                        </div>
                                                        <div class="fs-12">23.45</div>
                                                    </div>
                                                    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 lh-1 p-3 bg-light rounded">
                                                        <a href="javascript:void(0);">
                                                            <i class="ri-repeat-2-fill fs-5  text-muted"></i>
                                                        </a>
                                                        <a href="javascript:void(0);">
                                                            <i class="ri-skip-back-fill fs-5  text-muted"></i>
                                                        </a>
                                                        <a href="javascript:void(0);" class="btn btn-primary btn-icon rounded-circle">
                                                            <i class="ri-play-fill"></i>
                                                        </a>
                                                        <a href="javascript:void(0);">
                                                            <i class="ri-skip-forward-fill fs-5  text-muted"></i>
                                                        </a>
                                                        <a href="javascript:void(0);">
                                                            <i class="ri-shuffle-fill fs-5  text-muted"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Top Charts Today
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="me-3">
                                                            01
                                                        </div>
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/media-73.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">Voices of the Future</span>
                                                            <span class="d-block text-muted fs-13">By John Harris</span>
                                                        </div>
                                                        <div class="d-block fw-medium d-flex align-items-center gap-2 justify-content-end">340<i class="ti ti-heart-filled text-danger"></i></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="me-3">
                                                            02
                                                        </div>
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/media-79.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">The Art of Storytelling</span>
                                                            <span class="d-block text-muted fs-13">By Mia Roberts</span>
                                                        </div>
                                                        <div class="d-block fw-medium d-flex align-items-center gap-2 justify-content-end">133<i class="ti ti-heart-filled text-danger"></i></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="me-3">
                                                            03
                                                        </div>
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/media-77.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">The Healthy Life</span>
                                                            <span class="d-block text-muted fs-13">By Laura Collins</span>
                                                        </div>
                                                        <div class="d-block fw-medium d-flex align-items-center gap-2 justify-content-end">234<i class="ti ti-heart-filled text-danger"></i></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="me-3">
                                                            04
                                                        </div>
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/media-76.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">Crisis Management</span>
                                                            <span class="d-block text-muted fs-13">By Robert Blake</span>
                                                        </div>
                                                        <div class="d-block fw-medium d-flex align-items-center gap-2 justify-content-end">432<i class="ti ti-heart-filled text-danger"></i></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="me-3">
                                                            05
                                                        </div>
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/media-75.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">Gastronomic Adventures</span>
                                                            <span class="d-block text-muted fs-13">By Lily Jackson</span>
                                                        </div>
                                                        <div class="d-block fw-medium d-flex align-items-center gap-2 justify-content-end">153<i class="ti ti-heart-filled text-danger"></i></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="me-3">
                                                            06
                                                        </div>
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/media-71.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold">Innovate to Win</span>
                                                            <span class="d-block text-muted fs-13">By Chris Brooks</span>
                                                        </div>
                                                        <div class="d-block fw-medium d-flex align-items-center gap-2 justify-content-end">355<i class="ti ti-heart-filled text-danger"></i></div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-1 -->

                    <!-- Start:: row-2 -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Podcast Analytics
                                    </div>
                                    <div class="d-flex flex-wrap gap-2">
                                        <div>
                                            <input class="form-control form-control-sm" type="text" placeholder="Search Here" aria-label=".form-control-sm example">
                                        </div>
                                        <div class="dropdown">
                                            <a href="javascript:void(0);" class="btn btn-primary btn-sm btn-wave waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="false"> Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
                                            </a>
                                            <ul class="dropdown-menu" role="menu">
                                                <li><a class="dropdown-item" href="javascript:void(0);">New</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Popular</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Relevant</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table text-nowrap">
                                            <thead>
                                                <tr>
                                                    <th>S.No</th>
                                                    <th>Podcast Name</th>
                                                    <th>Genre</th>
                                                    <th>Episodes</th>
                                                    <th>Total Listeners</th>
                                                    <th>Avg. Play Time</th>
                                                    <th>Likes</th>
                                                    <th>Comments</th>
                                                    <th>Shares</th>
                                                    <th>Rating</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        1
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/media/media-71.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">The Digital Revolution</span>
                                                                <span class="text-muted fs-13">By Alex Turner</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Technology	
                                                    </td>
                                                    <td>25</td>
                                                    <td>
                                                        1.2M
                                                    </td>
                                                    <td>35 min</td>
                                                    <td>24K</td>
                                                    <td>5K</td>
                                                    <td>1.5K</td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.8<i class="ti ti-star-filled ms-1 text-warning"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-success-transparent">Active</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        2
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/media/media-79.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Unsolved Mysteries</span>
                                                                <span class="text-muted fs-13">By Rachel Adams</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        True Crime	
                                                    </td>
                                                    <td>40</td>
                                                    <td>
                                                        3.1M
                                                    </td>
                                                    <td>50 min</td>
                                                    <td>32K</td>
                                                    <td>8K</td>
                                                    <td>3.2K</td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.9<i class="ti ti-star-filled ms-1 text-warning"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-success-transparent">Active</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        3
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/media/media-78.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Startup Stories</span>
                                                                <span class="text-muted fs-13">By James Hawkins</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Business
                                                    </td>
                                                    <td>15</td>
                                                    <td>
                                                        850K
                                                    </td>
                                                    <td>45 min</td>
                                                    <td>19K</td>
                                                    <td>3K</td>
                                                    <td>1K</td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.7<i class="ti ti-star-filled ms-1 text-warning"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-danger-transparent">Inactive</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        4
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/media/media-77.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Healthy Habits</span>
                                                                <span class="text-muted fs-13">By Olivia Reed</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Health & Fitness
                                                    </td>
                                                    <td>20</td>
                                                    <td>
                                                        900K
                                                    </td>
                                                    <td>38 min</td>
                                                    <td>22K</td>
                                                    <td>4.5K</td>
                                                    <td>1.2K</td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.5<i class="ti ti-star-filled ms-1 text-warning"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-success-transparent">Active</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        5
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/media/media-76.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Beyond the Horizon</span>
                                                                <span class="text-muted fs-13">By Michael Harris</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Travel
                                                    </td>
                                                    <td>12</td>
                                                    <td>
                                                        500K
                                                    </td>
                                                    <td>40 min</td>
                                                    <td>15K</td>
                                                    <td>2K</td>
                                                    <td>800</td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.6<i class="ti ti-star-filled ms-1 text-warning"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-success-transparent">Active</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        6
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/media/media-75.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">The Culture Lab</span>
                                                                <span class="text-muted fs-13">By Sophia Miller</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Culture
                                                    </td>
                                                    <td>30</td>
                                                    <td>
                                                        1.8M
                                                    </td>
                                                    <td>28 min</td>
                                                    <td>27K</td>
                                                    <td>6K</td>
                                                    <td>2.5K</td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.8<i class="ti ti-star-filled ms-1 text-warning"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-success-transparent">Active</span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="card-footer border-top-0">
                                    <div class="d-flex align-items-center"> 
                                        <div> Showing 6 Entries <i class="bi bi-arrow-right ms-2 fw-semibold"></i> </div> 
                                        <div class="ms-auto"> 
                                            <nav aria-label="Page navigation" class="pagination-style-2">
                                                <ul class="pagination mb-0 flex-wrap">
                                                    <li class="page-item disabled">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            Prev
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                                    <li class="page-item active"><a class="page-link" href="javascript:void(0);">2</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            <i class="bi bi-three-dots"></i>
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">17</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link text-primary" href="javascript:void(0);">
                                                            next
                                                        </a>
                                                    </li>
                                                </ul>
                                            </nav>
                                        </div> 
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-2 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	


<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
