
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">School</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item active" aria-current="page">School</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row">
                        <div class="col-xxl-3">
                            <div class="row">
                                <div class="col-xxl-12 col-lg-6">
                                    <div class="card custom-card dashboard-main-card primary school-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center gap-2 justify-content-between flex-wrap">
                                                <div>
                                                    <span class="d-block mb-1">Students</span>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <h5 class="fw-semibold mb-0">28,754</h5>
                                                        <div class="fs-12 text-muted">
                                                            <span class="badge bg-success-transparent rounded-pill  d-inline-flex align-items-center"><i class="ti ti-trending-up me-1 align-middle"></i>12.75%</span>
                                                            This Year
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="lh-1">
                                                    <span class="avatar avatar-lg bg-primary-transparent svg-primary">
                                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0z" fill="none"/><path d="M5 13.18v4L12 21l7-3.82v-4L12 17l-7-3.82zM12 3 1 9l11 6 9-4.91V17h2V9L12 3z"/></svg>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-12 col-lg-6">
                                    <div class="card custom-card dashboard-main-card secondary school-card flex-wrap">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center gap-2 justify-content-between">
                                                <div>
                                                    <span class="d-block mb-1 text-muted">Teachers</span>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <h5 class="fw-semibold mb-0">385</h5>
                                                        <div class="fs-12 text-muted">
                                                            <span class="badge bg-success-transparent rounded-pill d-inline-flex align-items-center"><i class="ti ti-trending-up me-1 align-middle"></i>8.65%</span>
                                                            This Year
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="lh-1">
                                                    <span class="avatar avatar-lg bg-secondary-transparent svg-secondary">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><path d="M20,7h-5V4c0-1.1-0.9-2-2-2h-2C9.9,2,9,2.9,9,4v3H4C2.9,7,2,7.9,2,9v11c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V9 C22,7.9,21.1,7,20,7z M9,12c0.83,0,1.5,0.67,1.5,1.5S9.83,15,9,15s-1.5-0.67-1.5-1.5S8.17,12,9,12z M12,18H6v-0.75c0-1,2-1.5,3-1.5 s3,0.5,3,1.5V18z M13,9h-2V4h2V9z M18,16.5h-4V15h4V16.5z M18,13.5h-4V12h4V13.5z"/></g></svg>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-12 col-lg-6">
                                    <div class="card custom-card dashboard-main-card success school-card flex-wrap">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center gap-2 justify-content-between">
                                                <div>
                                                    <span class="d-block mb-1 text-muted">Awards</span>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <h5 class="fw-semibold mb-0">32</h5>
                                                        <div class="fs-12 text-muted">
                                                            <span class="badge bg-danger-transparent rounded-pill d-inline-flex align-items-center"><i class="ti ti-trending-down me-1 align-middle"></i>0.75%</span>
                                                            This Year
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="lh-1">
                                                    <span class="avatar avatar-lg bg-success-transparent svg-success">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><rect fill="none" height="24" width="24"/><path d="M19,5h-2V3H7v2H5C3.9,5,3,5.9,3,7v1c0,2.55,1.92,4.63,4.39,4.94c0.63,1.5,1.98,2.63,3.61,2.96V19H7v2h10v-2h-4v-3.1 c1.63-0.33,2.98-1.46,3.61-2.96C19.08,12.63,21,10.55,21,8V7C21,5.9,20.1,5,19,5z M5,8V7h2v3.82C5.84,10.4,5,9.3,5,8z M19,8 c0,1.3-0.84,2.4-2,2.82V7h2V8z"/></svg>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-12 col-lg-6">
                                    <div class="card custom-card dashboard-main-card warning school-card flex-wrap">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center gap-2 justify-content-between">
                                                <div>
                                                    <span class="d-block mb-1 text-muted">Earning</span>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <h5 class="fw-semibold mb-0">$12,765,233</h5>
                                                        <div class="fs-12 text-muted">
                                                            <span class="badge bg-success-transparent rounded-pill d-inline-flex align-items-center"><i class="ti ti-trending-up me-1 align-middle"></i>4.07%</span>
                                                            This Year
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="lh-1">
                                                    <span class="avatar avatar-lg bg-warning-transparent svg-warning">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><path d="M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12.88,17.76V19h-1.75v-1.29 c-0.74-0.18-2.39-0.77-3.02-2.96l1.65-0.67c0.06,0.22,0.58,2.09,2.4,2.09c0.93,0,1.98-0.48,1.98-1.61c0-0.96-0.7-1.46-2.28-2.03 c-1.1-0.39-3.35-1.03-3.35-3.31c0-0.1,0.01-2.4,2.62-2.96V5h1.75v1.24c1.84,0.32,2.51,1.79,2.66,2.23l-1.58,0.67 c-0.11-0.35-0.59-1.34-1.9-1.34c-0.7,0-1.81,0.37-1.81,1.39c0,0.95,0.86,1.31,2.64,1.9c2.4,0.83,3.01,2.05,3.01,3.45 C15.9,17.17,13.4,17.67,12.88,17.76z"/></g></svg>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>            
                        <div class="col-xxl-6">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        School Revenue
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div id="school-revenue"></div>
                                </div>
                            </div>
                        </div>            
                        <div class="col-xxl-3">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Events
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled school-events-list">
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap flex-xxl-nowrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-primary-transparent">
                                                        <i class="ti ti-alarm fs-5"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="d-flex align-items-center gap-3 justify-content-between flex-wrap">
                                                        <span class="d-block fw-semibold">School Timings Update</span>
                                                        <span class="badge bg-light text-default border">Mar 10,2025</span>
                                                    </div>
                                                    <div class="text-muted fs-13 event-description">New school hours are now in effect. Check the updated schedule.</div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap flex-xxl-nowrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-secondary-transparent">
                                                        <i class="ti ti-file-text fs-5"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="d-flex align-items-center gap-3 justify-content-between flex-wrap">
                                                        <span class="d-block fw-semibold">Exam Guidelines</span>
                                                        <span class="badge bg-light text-default border">March 18, 2025</span>
                                                    </div>
                                                    <div class="text-muted fs-13 event-description">Students must adhere to exam rules and bring valid ID cards.</div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap flex-xxl-nowrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-warning-transparent">
                                                        <i class="ti ti-search fs-5"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="d-flex align-items-center gap-3 justify-content-between flex-wrap">
                                                        <span class="d-block fw-semibold">Lost & Found</span>
                                                        <span class="badge bg-light text-default border">March 20, 2025</span>
                                                    </div>
                                                    <div class="text-muted fs-13 event-description">A wallet was found near the library. Contact the admin office to claim.</div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap flex-xxl-nowrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-info-transparent">
                                                        <i class="ti ti-hanger-2 fs-5"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="d-flex align-items-center gap-3 justify-content-between flex-wrap">
                                                        <span class="d-block fw-semibold">School Uniform</span>
                                                        <span class="badge bg-light text-default border">March 25, 2025</span>
                                                    </div>
                                                    <div class="text-muted fs-13 event-description">Students must follow proper uniform guidelines.</div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap flex-xxl-nowrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-success-transparent">
                                                        <i class="ti ti-tools-kitchen fs-5"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="d-flex align-items-center gap-3 justify-content-between flex-wrap">
                                                        <span class="d-block fw-semibold">Canteen Menu Change</span>
                                                        <span class="badge bg-light text-default border">March 28, 2025</span>
                                                    </div>
                                                    <div class="text-muted fs-13 event-description">The new weekly cafeteria menu is now available.</div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap flex-xxl-nowrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-danger-transparent">
                                                        <i class="ti ti-phone fs-5"></i>
                                                    </span>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="d-flex align-items-center gap-3 justify-content-between flex-wrap">
                                                        <span class="d-block fw-semibold">Emergency Update</span>
                                                        <span class="badge bg-light text-default border">March 25, 2025</span>
                                                    </div>
                                                    <div class="text-muted fs-13 event-description">Parents must update emergency contact details in the portal.</div>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>            
                    </div>
                    <!-- End:: row-1 -->

                    <!-- Start:: row-2 -->
                    <div class="row">
                        <div class="col-xxl-3">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Students Activity
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled students-activity-list">
                                        <li>
                                            <div class="d-flex align-items-start gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-start justify-content-between gap-3">
                                                        <span class="d-block fw-semibold">Aarav Sharma</span>
                                                        <span class="badge bg-primary-transparent">Mar 10, 2025</span>
                                                    </div>
                                                    <span class="fs-13 text-muted">Submitted the Math Assignment on time</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-start justify-content-between gap-3">
                                                        <span class="d-block fw-semibold">Sophia Patel</span>
                                                        <span class="badge bg-secondary-transparent">Mar 11, 2025</span>
                                                    </div>
                                                    <span class="fs-13 text-muted">Borrowed "Physics Essentials" from the library</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-warning">
                                                        RV
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-start justify-content-between gap-3">
                                                        <span class="d-block fw-semibold">Ryan Verma</span>
                                                        <span class="badge bg-warning-transparent">Mar 11, 2025</span>
                                                    </div>
                                                    <span class="fs-13 text-muted">Won 1st place in the Inter-School Debate Competition</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-start justify-content-between gap-3">
                                                        <span class="d-block fw-semibold">Neha Kapoor</span>
                                                        <span class="badge bg-info-transparent">Mar 13, 2025</span>
                                                    </div>
                                                    <span class="fs-13 text-muted">Uploaded a new Art Project for review.</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/15.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-start justify-content-between gap-3">
                                                        <span class="d-block fw-semibold">Karan Singh</span>
                                                        <span class="badge bg-success-transparent">Mar 14, 2025</span>
                                                    </div>
                                                    <span class="fs-13 text-muted">Missed the deadline for the Science Project Submission.</span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Students Overview
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div id="students-overview"></div>
                                </div>
                                <div class="card-footer">
                                    <div class="row g-0">
                                        <div class="col border-end border-inline-end-dashed">
                                            <div class="text-center">
                                                <span class="student-overview-type boys">Boys</span>
                                                <h5 class="mb-0 mt-1 fw-semibold d-flex align-items-center justify-content-center gap-1">6,560
                                                    <span class="badge bg-success-transparent rounded-pill  d-inline-flex align-items-center">
                                                        <i class="ti ti-arrow-up me-1"></i>2.45%
                                                    </span>
                                                </h5>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="text-center">
                                                <span class="student-overview-type girls">Girls</span>
                                                <h5 class="mb-0 mt-1 fw-semibold d-flex align-items-center justify-content-center gap-1">3,354
                                                    <span class="badge bg-danger-transparent rounded-pill  d-inline-flex align-items-center">
                                                        <i class="ti ti-arrow-down me-1"></i>6.76%
                                                    </span>
                                                </h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Top Students
                                    </div>
                                    <a href="javascript:void(0);" class="text-muted fs-13">View All<i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                </div>
                                <div class="card-body p-0">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Aarav Sharma</span>
                                                    <span class="fs-13 text-muted">Grade-10</span>
                                                </div>
                                                <div class="text-end">
                                                    <span>GPA : <span class="fw-medium text-primary">9.8</span></span>
                                                    <span class="text-primary fs-13 d-block">Science Olympiad Winner</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Sophia Patel</span>
                                                    <span class="fs-13 text-muted">Grade-9</span>
                                                </div>
                                                <div class="text-end">
                                                    <span>GPA : <span class="fw-medium text-primary">9.7</span></span>
                                                    <span class="text-secondary fs-13 d-block">Best Speaker in Debate</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Ryan Verma</span>
                                                    <span class="fs-13 text-muted">Grade-12</span>
                                                </div>
                                                <div class="text-end">
                                                    <span>GPA : <span class="fw-medium text-primary">9.6</span></span>
                                                    <span class="text-warning fs-13 d-block">Top Scorer in Math</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/7.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Neha Kapoor</span>
                                                    <span class="fs-13 text-muted">Grade-11</span>
                                                </div>
                                                <div class="text-end">
                                                    <span>GPA : <span class="fw-medium text-primary">9.5</span></span>
                                                    <span class="text-info fs-13 d-block">Art Competition Champion</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Karan Singh</span>
                                                    <span class="fs-13 text-muted">Grade-8</span>
                                                </div>
                                                <div class="text-end">
                                                    <span>GPA : <span class="fw-medium text-primary">9.4</span></span>
                                                    <span class="text-success fs-13 d-block">Chess Tournament Winner</span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Students Fee Analytics
                                    </div>
                                    <a href="javascript:void(0);" class="text-muted fs-13">View All<i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table text-nowrap">
                                            <tbody>
                                                <tr>
                                                    <td class="">#SP01</td>
                                                    <td class="">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="img">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="d-block fw-semibold lh-1 mb-1">Aarav Sharma</span>
                                                                <span class="fs-13 text-muted">Tuition Fees</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="text-end">
                                                        <span class="text-success fs-13 fw-semibold">Paid</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="">#SP02</td>
                                                    <td class="">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg" alt="img">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="d-block fw-semibold lh-1 mb-1">Sophia Patel</span>
                                                                <span class="fs-13 text-muted">Library Fees</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="text-end">
                                                        <span class="text-danger fs-13 fw-semibold">Pending</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="">#SP03</td>
                                                    <td class="">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/15.jpg" alt="img">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="d-block fw-semibold lh-1 mb-1">Ryan Verma</span>
                                                                <span class="fs-13 text-muted">Exam Fees</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="text-end">
                                                        <span class="text-success fs-13 fw-semibold">Paid</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="">#SP04</td>
                                                    <td class="">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="img">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="d-block fw-semibold lh-1 mb-1">Neha Kapoor</span>
                                                                <span class="fs-13 text-muted">Sports Fees</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="text-end">
                                                        <span class="text-warning fs-13 fw-semibold">Overdue</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="border-bottom-0">#SP05</td>
                                                    <td class="border-bottom-0">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="img">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="d-block fw-semibold lh-1 mb-1">Karan Singh</span>
                                                                <span class="fs-13 text-muted">Lab Fees</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="text-end border-bottom-0">
                                                        <span class="text-success fs-13 fw-semibold">Paid</span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-2 -->

                    <!-- Start:: row-3 -->
                    <div class="row">
                        <div class="col-xxl-9">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Student Summary
                                    </div>
                                    <div class="d-flex flex-wrap gap-2">
                                        <div>
                                            <input class="form-control form-control-sm" type="text" placeholder="Search Here" aria-label=".form-control-sm example">
                                        </div>
                                        <div class="dropdown">
                                            <a href="javascript:void(0);" class="btn btn-primary btn-sm btn-wave waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="false"> Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
                                            </a>
                                            <ul class="dropdown-menu" role="menu">
                                                <li><a class="dropdown-item" href="javascript:void(0);">New</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Popular</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Relevant</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table text-nowrap">
                                            <thead>
                                                <th>
                                                    Student ID
                                                </th>
                                                <th>Name</th>
                                                <th>Grade</th>
                                                <th>Fee Status</th>
                                                <th>Attendance (%)</th>
                                                <th>Marks (%)</th>
                                                <th>Last Payment Date</th>
                                                <th>Total Fees Paid</th>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>SPK01</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-semibold">Aarav Sharma</div>
                                                        </div>
                                                    </td>
                                                    <td>10</td>
                                                    <td>
                                                        <span class="badge bg-success">Paid</span>
                                                    </td>
                                                    <td>95%</td>
                                                    <td>92%</td>
                                                    <td>March 1, 2025</td>
                                                    <td>₹50,000</td>
                                                </tr>
                                                <tr>
                                                    <td>SPK02</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-semibold">Sophia Patel</div>
                                                        </div>
                                                    </td>
                                                    <td>9</td>
                                                    <td>
                                                        <span class="badge bg-warning">Pending</span>
                                                    </td>
                                                    <td>88%</td>
                                                    <td>85%</td>
                                                    <td>January 15, 2025</td>
                                                    <td>₹20,000</td>
                                                </tr>
                                                <tr>
                                                    <td>SPK03</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-semibold">Ryan Verma</div>
                                                        </div>
                                                    </td>
                                                    <td>12</td>
                                                    <td>
                                                        <span class="badge bg-danger">Overdue</span>
                                                    </td>
                                                    <td>80%</td>
                                                    <td>78%</td>
                                                    <td>February 10, 2025</td>
                                                    <td>₹40,000</td>
                                                </tr>
                                                <tr>
                                                    <td>SPK04</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-semibold">Karan Singh</div>
                                                        </div>
                                                    </td>
                                                    <td>8</td>
                                                    <td>
                                                        <span class="badge bg-success">Paid</span>
                                                    </td>
                                                    <td>70%</td>
                                                    <td>65%</td>
                                                    <td>March 5, 2025</td>
                                                    <td>₹25,000</td>
                                                </tr>
                                                <tr>
                                                    <td>SPK05</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-semibold">Karan Singh</div>
                                                        </div>
                                                    </td>
                                                    <td>8</td>
                                                    <td>
                                                        <span class="badge bg-success">Paid</span>
                                                    </td>
                                                    <td>70%</td>
                                                    <td>65%</td>
                                                    <td>March 5, 2025</td>
                                                    <td>₹25,000</td>
                                                </tr>
                                                <tr>
                                                    <td>SPK06</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-semibold">Aditi Rao</div>
                                                        </div>
                                                    </td>
                                                    <td>10</td>
                                                    <td>
                                                        <span class="badge bg-warning">Pending</span>
                                                    </td>
                                                    <td>85%</td>
                                                    <td>88%</td>
                                                    <td>February 25, 2025</td>
                                                    <td>₹30,000</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="card-footer border-top-0">
                                    <div class="d-flex align-items-center"> 
                                        <div> Showing 6 Entries <i class="bi bi-arrow-right ms-2 fw-semibold"></i> </div> 
                                        <div class="ms-auto"> 
                                            <nav aria-label="Page navigation" class="pagination-style-2">
                                                <ul class="pagination mb-0 flex-wrap">
                                                    <li class="page-item disabled">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            Prev
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                                    <li class="page-item active"><a class="page-link" href="javascript:void(0);">2</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            <i class="bi bi-three-dots"></i>
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">17</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link text-primary" href="javascript:void(0);">
                                                            next
                                                        </a>
                                                    </li>
                                                </ul>
                                            </nav>
                                        </div> 
                                    </div> 
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Attendance Overview
                                    </div>
                                    <a href="javascript:void(0)" class="btn btn-primary-light btn-sm">View All</a>
                                </div>
                                <div class="card-body">
                                    <div id="attendance-overview"></div>
                                </div>
                                <div class="card-footer p-0">
                                    <div class="row mt-0 g-0">
                                        <div class="col-6 border-end border-inline-end-dashed text-center p-3">
                                            <p class="mb-1 fw-medium">Boys</p>
                                            <h5 class="text-warning fw-semibold mb-0">12.34K</h5>
                                        </div>
                                        <div class="col-6 text-center p-3">
                                            <p class="mb-1 fw-medium">Girls</p>
                                            <h5 class="text-primary fw-semibold mb-0">10.19K</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-3 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

        <!-- School dashboard -->
        <script src="<?php echo $baseUrl; ?>/assets/js/school-dashboard.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
