
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Social Media</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Social Media</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row">
                        <div class="col-xxl-9">
                            <div class="row">
                                <div class="col-xxl-3 col-md-6">
                                    <div class="card custom-card dashboard-main-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start gap-2 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-primary-transparent svg-primary">
                                                        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><g/><g><g><path d="M16.67,13.13C18.04,14.06,19,15.32,19,17v3h4v-3 C23,14.82,19.43,13.53,16.67,13.13z" fill-rule="evenodd"/></g><g><circle cx="9" cy="8" fill-rule="evenodd" r="4"/></g><g><path d="M15,12c2.21,0,4-1.79,4-4c0-2.21-1.79-4-4-4c-0.47,0-0.91,0.1-1.33,0.24 C14.5,5.27,15,6.58,15,8s-0.5,2.73-1.33,3.76C14.09,11.9,14.53,12,15,12z" fill-rule="evenodd"/></g><g><path d="M9,13c-2.67,0-8,1.34-8,4v3h16v-3C17,14.34,11.67,13,9,13z" fill-rule="evenodd"/></g></g></g></svg>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-end justify-content-between">
                                                        <span class="d-block mb-1">Total Visitors</span>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm rounded-circle btn-light"> 
                                                                <i class="ti ti-dots text-muted fs-5"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">Today</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Week</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Month</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Year</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </div>
                                                    <div class="d-flex align-items-end justify-content-between">
                                                        <h4 class="fw-semibold mb-0">125,350</h4>
                                                        <div class="text-success fs-13"><i class="ti ti-arrow-up"></i>2.38%</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-3 col-md-6">
                                    <div class="card custom-card dashboard-main-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start gap-2 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-secondary-transparent svg-secondary">
                                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0z" fill="none"/><path d="M11.99 2c-5.52 0-10 4.48-10 10s4.48 10 10 10 10-4.48 10-10-4.48-10-10-10zm3.61 6.34c1.07 0 1.93.86 1.93 1.93 0 1.07-.86 1.93-1.93 1.93-1.07 0-1.93-.86-1.93-1.93-.01-1.07.86-1.93 1.93-1.93zm-6-1.58c1.3 0 2.36 1.06 2.36 2.36 0 1.3-1.06 2.36-2.36 2.36s-2.36-1.06-2.36-2.36c0-1.31 1.05-2.36 2.36-2.36zm0 9.13v3.75c-2.4-.75-4.3-2.6-5.14-4.96 1.05-1.12 3.67-1.69 5.14-1.69.53 0 1.2.08 1.9.22-1.64.87-1.9 2.02-1.9 2.68zM11.99 20c-.27 0-.53-.01-.79-.04v-4.07c0-1.42 2.94-2.13 4.4-2.13 1.07 0 2.92.39 3.84 1.15-1.17 2.97-4.06 5.09-7.45 5.09z"/></svg>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-end justify-content-between">
                                                        <span class="d-block mb-1">Engagement</span>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm rounded-circle btn-light"> 
                                                                <i class="ti ti-dots text-muted fs-5"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">Today</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Week</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Month</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Year</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </div>
                                                    <div class="d-flex align-items-end justify-content-between">
                                                        <h4 class="fw-semibold mb-0">28,754</h4>
                                                        <div class="text-success fs-13"><i class="ti ti-arrow-up"></i>1.23%</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-3 col-md-6">
                                    <div class="card custom-card dashboard-main-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start gap-2 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-success-transparent svg-success">
                                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0z" fill="none"/><path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/></svg>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-end justify-content-between">
                                                        <span class="d-block mb-1">Like</span>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm rounded-circle btn-light"> 
                                                                <i class="ti ti-dots text-muted fs-5"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">Today</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Week</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Month</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Year</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </div>
                                                    <div class="d-flex align-items-end justify-content-between">
                                                        <h4 class="fw-semibold mb-0">34,890</h4>
                                                        <div class="text-danger fs-13"><i class="ti ti-arrow-down"></i>0.96%</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-3 col-md-6">
                                    <div class="card custom-card dashboard-main-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start gap-2 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded bg-info-transparent svg-info">
                                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0z" fill="none"/><path d="M16 6l2.29 2.29-4.88 4.88-4-4L2 16.59 3.41 18l6-6 4 4 6.3-6.29L22 12V6z"/></svg>
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-end justify-content-between">
                                                        <span class="d-block mb-1">Bounce Rate</span>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm rounded-circle btn-light"> 
                                                                <i class="ti ti-dots text-muted fs-5"></i> 
                                                            </a> 
                                                            <ul class="dropdown-menu" role="menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">Today</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Week</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Month</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);">This Year</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </div>
                                                    <div class="d-flex align-items-end justify-content-between">
                                                        <h4 class="fw-semibold mb-0">15.4%</h4>
                                                        <div class="text-success fs-13"><i class="ti ti-arrow-up me-1"></i>6.06%</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-8">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Profile Visits
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div id="profile-analysis"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-4">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Audience By Gender
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div id="audience-by-gender"></div>
                                            <div class="row mt-0"> 
                                                <div class="col-6 border-end border-inline-end-dashed text-center"> 
                                                    <p class="text-muted mb-1 fs-12">Male</p>
                                                    <h6 class="text-primary mb-0">12.34K</h6> 
                                                </div> 
                                                <div class="col-6 text-center"> 
                                                    <p class="text-muted mb-1 fs-12">Female</p>
                                                    <h6 class="text-secondary mb-0">10.19K</h6> 
                                                </div> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Top Audience Countries
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div class="table-responsive">
                                                <table class="table text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th>S.No</th>
                                                            <th>Country</th>
                                                            <th>Engagement</th>
                                                            <th>Followers</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>1</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/us_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">United States</div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span class="d-block">
                                                                    15,000 <i class="ti ti-thumb-up text-muted fs-18"></i>
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <div class="d-block">
                                                                    35,000 <span class="fs-12 text-success ms-1 d-inline-flex">
                                                                        <i class="ti ti-trending-up me-1 align-middle"></i>34.6%
                                                                    </span>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>2</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/india_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">India</div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span class="d-block">
                                                                    12,000 <i class="ti ti-thumb-up text-muted fs-18 ms-1"></i>
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <div class="d-block">
                                                                    25,000 
                                                                    <span class="fs-12 text-danger ms-1 d-inline-flex">
                                                                        <i class="ti ti-trending-down me-1 align-middle"></i>18.74%
                                                                    </span>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>3</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/canada_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">Canada</div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span class="d-block">
                                                                    8,500 <i class="ti ti-thumb-up text-muted fs-18 ms-1"></i>
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <div class="d-block">
                                                                    20,000
                                                                    <span class="fs-12 text-success ms-1 d-inline-flex">
                                                                        <i class="ti ti-trending-up me-1 align-middle"></i>16.06%
                                                                    </span>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>4</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/germany_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">Germany</div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span class="d-block">
                                                                    4,800 <i class="ti ti-thumb-up text-muted fs-18 ms-1"></i>
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <div class="d-block">
                                                                    12,500
                                                                    <span class="fs-12 text-success ms-1 d-inline-flex">
                                                                        <i class="ti ti-trending-up me-1 align-middle"></i>53.22%
                                                                    </span>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="border-bottom-0">5</td>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/flags/french_flag.jpg" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div class="fw-semibold">France</div>
                                                                </div>
                                                            </td>
                                                            <td class="border-bottom-0">
                                                                <span class="d-block">
                                                                    4,000 <i class="ti ti-thumb-up text-muted fs-18 ms-1"></i>
                                                                </span>
                                                            </td>
                                                            <td class="border-bottom-0">
                                                                <div class="d-block">
                                                                    11,000
                                                                    <span class="fs-12 text-danger ms-1 d-inline-flex">
                                                                        <i class="ti ti-trending-down me-1 align-middle"></i>31.54%
                                                                    </span>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Post Insights
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div class="table-responsive">
                                                <table class="table text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th scope="col">Post Name</th>
                                                            <th scope="col">Posted</th>
                                                            <th scope="col">Platform</th>
                                                            <th scope="col">Views</th>
                                                            <th scope="col">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/media/media-23.jpg">
                                                                        </span>
                                                                    </div>
                                                                    <span class="fw-medium">Behind the Scenes</span>
                                                            </div>
                                                            </td>
                                                            <td>
                                                                02,feb
                                                            </td>
                                                            <td><span class="badge bg-primary-transparent">Youtube</span></td>
                                                            <td>
                                                            9.5k+
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-primary-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item  d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item  d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/media/media-24.jpg">
                                                                        </span>
                                                                    </div>    
                                                                    <span class="fw-medium">Monday Motivation</span>
                                                            </div>
                                                            </td>
                                                            <td>
                                                                14,Feb
                                                            </td>
                                                            <td><span class="badge bg-secondary-transparent">Instagram</span></td>
                                                            <td>
                                                            1M+
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-primary-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/media/media-25.jpg">
                                                                        </span>
                                                                    </div>    
                                                                    <span class="fw-medium">Travel Diaries</span>
                                                            </div>
                                                            </td>
                                                            <td>
                                                                13,Feb
                                                            </td>
                                                            <td><span class="badge bg-success-transparent">Twitter</span></td>
                                                            <td>
                                                            10k+
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-primary-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/media/media-26.jpg">
                                                                        </span>
                                                                    </div>    
                                                                    <span class="fw-medium">Recipe of the Day</span>
                                                            </div>
                                                            </td>
                                                            <td>
                                                                12,Feb
                                                            </td>
                                                            <td><span class="badge bg-warning-transparent">Linked In</span></td>
                                                            <td>
                                                            3.5k
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-primary-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td  class="border-bottom-0">
                                                            <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/media/media-27.jpg">
                                                                        </span>
                                                                    </div>    
                                                                    <span class="fw-medium">Fashion Forward</span>
                                                            </div>
                                                            </td>
                                                            <td  class="border-bottom-0">
                                                                11,Feb
                                                            </td>
                                                            <td  class="border-bottom-0"><span class="badge bg-primary-transparent">Pinterest</span></td>  
                                                            <td  class="border-bottom-0">
                                                            1.6M+
                                                            </td>
                                                            <td class="text-end border-bottom-0">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-primary-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-edit me-2"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-trash me-2"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Social Media Performance Overview
                                            </div>
                                            <div class="d-flex flex-wrap gap-2">
                                                <div>
                                                    <input class="form-control form-control-sm" type="text" placeholder="Search Here" aria-label=".form-control-sm example">
                                                </div>
                                                <div class="dropdown">
                                                    <a href="javascript:void(0);" class="btn btn-primary btn-sm btn-wave waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="false"> Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
                                                    </a>
                                                    <ul class="dropdown-menu" role="menu">
                                                        <li><a class="dropdown-item" href="javascript:void(0);">New</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Popular</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Relevant</a></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div class="table-responsive">
                                                <table class="table text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th><input class="form-check-input" type="checkbox" id="checkAll" value="" aria-label="..."></th>
                                                            <th>Platform</th>
                                                            <th>Posts</th>
                                                            <th>Likes</th>
                                                            <th>Shares</th>
                                                            <th>Comments</th>
                                                            <th>Impressions</th>
                                                            <th>Followers</th>
                                                            <th>CTR (%)</th>
                                                            <th>Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>
                                                                <input class="form-check-input" type="checkbox" id="checkSocial1" value="" aria-label="..." checked>
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm bg-primary-transparent">
                                                                            <i class="ri-facebook-line fs-5"></i>
                                                                        </span>
                                                                    </div>
                                                                    <div>Facebook</div>
                                                                </div>
                                                            </td>
                                                            <td>120</td>
                                                            <td>8,500</td>
                                                            <td>1,200</td>
                                                            <td>950</td>
                                                            <td>12.5%</td>
                                                            <td>35K</td>
                                                            <td>
                                                                <span class="badge bg-primary-transparent">4.2%</span>
                                                            </td>
                                                            <td>
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-eye me-2 d-inline-flex"></i>View</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-edit me-2 d-inline-flex"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-trash me-2 d-inline-flex"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <input class="form-check-input" type="checkbox" id="checkSocial2" value="" aria-label="...">
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm bg-secondary-transparent">
                                                                            <i class="ri-instagram-line fs-5"></i>
                                                                        </span>
                                                                    </div>
                                                                    <div>Instagram</div>
                                                                </div>
                                                            </td>
                                                            <td>95</td>
                                                            <td>12,000</td>
                                                            <td>2,100</td>
                                                            <td>1,800</td>
                                                            <td>14.3%</td>
                                                            <td>42K</td>
                                                            <td>
                                                                <span class="badge bg-secondary-transparent">5.0%</span>
                                                            </td>
                                                            <td>
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-eye me-2 d-inline-flex"></i>View</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-edit me-2 d-inline-flex"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-trash me-2 d-inline-flex"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <input class="form-check-input" type="checkbox" id="checkSocial3" value="" aria-label="...">
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm bg-warning-transparent">
                                                                            <i class="ri-twitter-x-line fs-5"></i>
                                                                        </span>
                                                                    </div>
                                                                    <div>Twitter</div>
                                                                </div>
                                                            </td>
                                                            <td>180</td>
                                                            <td>5,600</td>
                                                            <td>1,500</td>
                                                            <td>1,000</td>
                                                            <td>9.8%</td>
                                                            <td>28K</td>
                                                            <td>
                                                                <span class="badge bg-warning-transparent">3.5%</span>
                                                            </td>
                                                            <td>
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-eye me-2 d-inline-flex"></i>View</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-edit me-2 d-inline-flex"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-trash me-2 d-inline-flex"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <input class="form-check-input" type="checkbox" id="checkSocial4" value="" aria-label="..." checked>
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm bg-info-transparent">
                                                                            <i class="ri-linkedin-box-line fs-5"></i>
                                                                        </span>
                                                                    </div>
                                                                    <div>LinkedIn</div>
                                                                </div>
                                                            </td>
                                                            <td>75</td>
                                                            <td>4,200</td>
                                                            <td>800</td>
                                                            <td>600</td>
                                                            <td>11.2%</td>
                                                            <td>20K</td>
                                                            <td>
                                                                <span class="badge bg-info-transparent">3.8%</span>
                                                            </td>
                                                            <td>
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-eye me-2 d-inline-flex"></i>View</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-edit me-2 d-inline-flex"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-trash me-2 d-inline-flex"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <input class="form-check-input" type="checkbox" id="checkSocial5" value="" aria-label="..." checked>
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm bg-success-transparent">
                                                                            <i class="ri-youtube-line fs-5"></i>
                                                                        </span>
                                                                    </div>
                                                                    <div>YouTube</div>
                                                                </div>
                                                            </td>
                                                            <td>30</td>
                                                            <td>22,000</td>
                                                            <td>4,000</td>
                                                            <td>3,800</td>
                                                            <td>18.5%</td>
                                                            <td>65K</td>
                                                            <td>
                                                                <span class="badge bg-info-transparent">7.8%</span>
                                                            </td>
                                                            <td>
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-eye me-2 d-inline-flex"></i>View</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-edit me-2 d-inline-flex"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-trash me-2 d-inline-flex"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <input class="form-check-input" type="checkbox" id="checkSocial6" value="" aria-label="...">
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm bg-danger-transparent">
                                                                            <i class="ri-snapchat-line fs-5"></i>
                                                                        </span>
                                                                    </div>
                                                                    <div>Snapchat</div>
                                                                </div>
                                                            </td>
                                                            <td>60</td>
                                                            <td>6,500</td>
                                                            <td>1,200</td>
                                                            <td>900</td>
                                                            <td>10.1%</td>
                                                            <td>22K</td>
                                                            <td>
                                                                <span class="badge bg-info-transparent">3.9%</span>
                                                            </td>
                                                            <td>
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class=" btn btn-icon btn-sm btn-light"> 
                                                                        <i class="ti ti-dots-vertical"></i> 
                                                                    </a> 
                                                                    <ul class="dropdown-menu" role="menu"> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-eye me-2 d-inline-flex"></i>View</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-edit me-2 d-inline-flex"></i>Edit</a></li> 
                                                                        <li><a class="dropdown-item" href="javascript:void(0);"><i class="ti ti-trash me-2 d-inline-flex"></i>Delete</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="card-footer border-top-0">
                                            <div class="d-flex align-items-center"> 
                                                <div> Showing 6 Entries <i class="bi bi-arrow-right ms-2 fw-semibold"></i> </div> 
                                                <div class="ms-auto"> 
                                                    <nav aria-label="Page navigation" class="pagination-style-2">
                                                        <ul class="pagination mb-0 flex-wrap">
                                                            <li class="page-item disabled">
                                                                <a class="page-link" href="javascript:void(0);">
                                                                    Prev
                                                                </a>
                                                            </li>
                                                            <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                                            <li class="page-item active"><a class="page-link" href="javascript:void(0);">2</a></li>
                                                            <li class="page-item">
                                                                <a class="page-link" href="javascript:void(0);">
                                                                    <i class="bi bi-three-dots"></i>
                                                                </a>
                                                            </li>
                                                            <li class="page-item"><a class="page-link" href="javascript:void(0);">17</a></li>
                                                            <li class="page-item">
                                                                <a class="page-link text-primary" href="javascript:void(0);">
                                                                    next
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </nav>
                                                </div> 
                                            </div> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Recent Activity
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-unstyled social-recent-activity-list">
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded bg-primary-transparent">
                                                                <i class="ri-facebook-line fs-5"></i>
                                                            </span>
                                                        </div> 
                                                        <div class="flex-fill">
                                                            <div class="d-flex align-items-start gap-2 justify-content-between mb-1">
                                                                <span class="fw-semibold d-block">Facebook</span>
                                                                <span class="badge bg-primary-transparent">10:15 AM</span>
                                                            </div>
                                                            <div class="fs-13 text-muted social-activity">Published new post on "Spring Sale Launch"</div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded bg-secondary-transparent">
                                                                <i class="ri-instagram-line fs-5"></i>
                                                            </span>
                                                        </div> 
                                                        <div class="flex-fill">
                                                            <div class="d-flex align-items-start gap-2 justify-content-between mb-1">
                                                                <span class="fw-semibold d-block">Instagram</span>
                                                                <span class="badge bg-secondary-transparent">3:45 PM</span>
                                                            </div>
                                                            <div class="fs-13 text-muted social-activity">Uploaded 3 new photos to "Beach Vacation Highlights" album</div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded bg-info-transparent">
                                                                <i class="ri-linkedin-box-line fs-5"></i>
                                                            </span>
                                                        </div> 
                                                        <div class="flex-fill">
                                                            <div class="d-flex align-items-start gap-2 justify-content-between mb-1">
                                                                <span class="fw-semibold d-block">LinkedIn</span>
                                                                <span class="badge bg-info-transparent">11:30 AM</span>
                                                            </div>
                                                            <div class="fs-13 text-muted social-activity">Updated job position for "Marketing Manager"</div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded bg-dark-transparent">
                                                                <i class="ri-twitter-x-line fs-5"></i>
                                                            </span>
                                                        </div> 
                                                        <div class="flex-fill">
                                                            <div class="d-flex align-items-start gap-2 justify-content-between mb-1">
                                                                <span class="fw-semibold d-block">Twitter</span>
                                                                <span class="badge bg-dark-transparent">6:00 PM</span>
                                                            </div>
                                                            <div class="fs-13 text-muted social-activity">Tweeted "Exciting product launch tomorrow!"</div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded bg-danger-transparent">
                                                                <i class="ri-pinterest-line fs-5"></i>
                                                            </span>
                                                        </div> 
                                                        <div class="flex-fill">
                                                            <div class="d-flex align-items-start gap-2 justify-content-between mb-1">
                                                                <span class="fw-semibold d-block">Pinterest</span>
                                                                <span class="badge bg-danger-transparent">11:30 AM</span>
                                                            </div>
                                                            <div class="fs-13 text-muted social-activity">Pinned new "Holiday Decoration Ideas" board</div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Audience Age Metrics
                                            </div>
                                        </div>
                                        <div class="card-body py-0">
                                            <div id="audience-age-metrics"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Suggestions
                                            </div>
                                            <a href="javascript:void(0);" class="text-muted">View All<i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-unstyled social-suggestions-list">
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Socrates Itumay</span>
                                                            <span class="text-muted d-block">3 Mutual Friends</span>
                                                        </div>
                                                        <div>
                                                            <button aria-label="buton" type="button" class="btn btn-sm btn-icon btn-light border"><i class="ri-user-add-line"></i></button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Ryan Gercia</span>
                                                            <span class="text-muted d-block">1 Mutual Friend</span>
                                                        </div>
                                                        <div>
                                                            <button aria-label="buton" type="button" class="btn btn-sm btn-icon btn-light border"><i class="ri-user-add-line"></i></button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Prax Bhav</span>
                                                            <span class="text-muted d-block">2 Mutual Friends</span>
                                                        </div>
                                                        <div>
                                                            <button aria-label="buton" type="button" class="btn btn-sm btn-icon btn-light border"><i class="ri-user-add-line"></i></button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Jackie Chen</span>
                                                            <span class="text-muted d-block">12 Mutual Friends</span>
                                                        </div>
                                                        <div>
                                                            <button aria-label="buton" type="button" class="btn btn-sm btn-icon btn-light border"><i class="ri-user-add-line"></i></button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Samantha Sam</span>
                                                            <span class="text-muted d-block">6 Mutual Friends</span>
                                                        </div>
                                                        <div>
                                                            <button aria-label="buton" type="button" class="btn btn-sm btn-icon btn-light border"><i class="ri-user-add-line"></i></button>
                                                        </div>
                                                    </div>
                                                </li>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">Engagement</div>
                                            <div class="d-flex align-items-center gap-2">
                                                <span class="fs-12 text-success"><i class="ti ti-arrow-up"></i>2.45%</span>
                                                <h5 class="fw-semibold mb-0">231,232</h5>
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div id="social-engagement"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-1 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

        <!-- Social Media dashboard -->
        <script src="<?php echo $baseUrl; ?>/assets/js/social-media-dashboard.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
