
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/swiper/swiper-bundle.min.css">

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">NFT</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item active" aria-current="page">NFT</li>
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboard</a></li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row">
                        <div class="col-xxl-9">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="card custom-card nft-main-banner-card border-0">
                                        <div class="card-body">
                                            <div class="nft-main-bannr-background">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/1.png" alt="" class="d-md-block d-none">
                                            </div>
                                            <h2 class="text-fixed-white">Discover, buy, and sell unique NFTs</h2>
                                            <p class="fs-16 op-8 mb-4">Immerse yourself in a world where digital creativity <br> meets blockchain technology</p>
                                            <div class="btn-list">
                                                <button class="btn btn-lg btn-light">Explore</button>
                                                <button class="btn btn-lg btn-outline-light text-fixed-white">Sell Artwork</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-4 d-flex align-items-center justify-content-between flex-wrap gap-2"> 
                                    <h6 class="fw-medium mb-0">Trending NFT'S :</h6> 
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Basic example"> 
                                        <button type="button" class="btn btn-primary btn-sm btn-wave waves-effect waves-light">1D</button> 
                                        <button type="button" class="btn btn-primary-light btn-sm btn-wave waves-effect waves-light">1W</button> 
                                        <button type="button" class="btn btn-primary-light btn-sm btn-wave waves-effect waves-light">1M</button> 
                                        <button type="button" class="btn btn-primary-light btn-sm btn-wave waves-effect waves-light">1Y</button> 
                                    </div> 
                                </div>
                                <div class="d-flex align-items-center gap-4 mb-4 flex-wrap"> 
                                    <div class="nft-tag nft-tag-primary active"> 
                                        <a href="javascript:void(0);" class="stretched-link"></a> 
                                        <span class="nft-tag-text">Music</span> 
                                    </div> 
                                    <div class="nft-tag nft-tag-secondary"> 
                                        <a href="javascript:void(0);" class="stretched-link"></a> 
                                        <span class="nft-tag-text">Games</span> 
                                    </div> 
                                    <div class="nft-tag nft-tag-info"> 
                                        <a href="javascript:void(0);" class="stretched-link"></a> 
                                        <span class="nft-tag-text">Art</span> 
                                    </div> 
                                    <div class="nft-tag nft-tag-success"> 
                                        <a href="javascript:void(0);" class="stretched-link"></a> 
                                        <span class="nft-tag-text">Photography</span> 
                                    </div> 
                                    <div class="nft-tag nft-tag-danger"> 
                                        <a href="javascript:void(0);" class="stretched-link"></a> 
                                        <span class="nft-tag-text">Sport</span> 
                                    </div> 
                                    <div class="nft-tag nft-tag-purple"> 
                                        <a href="javascript:void(0);" class="stretched-link"></a> 
                                        <span class="nft-tag-text">Cartoon</span> 
                                    </div> 
                                </div>
                                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                                    <div class="card custom-card">
                                        <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                            <div class="flex-fill">
                                                <button class="btn btn-sm btn-icon btn-danger rounded-pill btn-wave">
                                                    <i class="ri-heart-fill"></i>
                                                </button>
                                            </div>
                                            <div>
                                                <span class="badge nft-like-badge text-default"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>1.32k</span>
                                            </div>
                                            <p class="mb-0 nft-auction-time">
                                                04hrs : 24m : 38s
                                            </p>
                                        </div>
                                        <div class="card-body p-2">
                                            <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/2.png" class="card-img mb-3" alt="...">
                                            <div class="p-2">
                                                <div class="mb-3">
                                                    <a href="nft-details.php"><h6 class="fw-semibold mb-1 text-truncate">Neon Samurai: Blade of the Future</h6></a>
                                                    <a href="javascript:void(0);"><span class="fs-13 text-muted fw-medium">By Kairo Tetsuo</span></a>
                                                </div>
                                                <div class="d-flex align-items-end justify-content-between flex-wrap gap-2">
                                                    <div class="flex-fill">
                                                        <span class="text-muted fs-12 d-block mb-1">Current Bid</span>
                                                        <div class="d-flex align-items-center gap-2 fw-semibold">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/crypto-icons/ethereum-eth-logo.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                12.45ETH
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <button class="btn btn-primary">Place a Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                                    <div class="card custom-card">
                                        <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                            <div class="flex-fill">
                                                <button class="btn btn-sm btn-icon btn-danger rounded-pill btn-wave">
                                                    <i class="ri-heart-fill"></i>
                                                </button>
                                            </div>
                                            <div>
                                                <span class="badge nft-like-badge text-default"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>1.26k</span>
                                            </div>
                                            <p class="mb-0 nft-auction-time">
                                                04hrs : 24m : 38s
                                            </p>
                                        </div>
                                        <div class="card-body p-2">
                                            <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/3.png" class="card-img mb-3" alt="...">
                                            <div class="p-2">
                                                <div class="mb-3">
                                                    <a href="nft-details.php"><h6 class="fw-semibold mb-1 text-truncate">Cybercity Uprising: Rebels of the Neon Streets</h6></a>
                                                    <a href="javascript:void(0);"><span class="fs-13 text-muted fw-medium">By Aiko Nakamura</span></a>
                                                </div>
                                                <div class="d-flex align-items-end justify-content-between flex-wrap gap-2">
                                                    <div class="flex-fill">
                                                        <span class="text-muted fs-12 d-block mb-1">Current Bid</span>
                                                        <div class="d-flex align-items-center gap-2 fw-semibold">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/crypto-icons/ethereum-eth-logo.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                18.34ETH
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <button class="btn btn-primary">Place a Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                                    <div class="card custom-card">
                                        <div class="d-flex align-items-center justify-content-between nft-like-section w-100 px-3">
                                            <div class="flex-fill">
                                                <button class="btn btn-sm btn-icon btn-danger rounded-pill btn-wave">
                                                    <i class="ri-heart-fill"></i>
                                                </button>
                                            </div>
                                            <div>
                                                <span class="badge nft-like-badge text-default"><i class="ri-heart-fill me-1 text-danger align-middle d-inline-block"></i>2.45k</span>
                                            </div>
                                            <p class="mb-0 nft-auction-time">
                                                04hrs : 24m : 38s
                                            </p>
                                        </div>
                                        <div class="card-body p-2">
                                            <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/4.png" class="card-img mb-3" alt="...">
                                            <div class="p-2">
                                                <div class="mb-3">
                                                    <a href="nft-details.php"><h6 class="fw-semibold mb-1 text-truncate">Holo-Vision: The Last Cyberpunk Hero</h6></a>
                                                    <a href="javascript:void(0);"><span class="fs-13 text-muted fw-medium">By Ryo Takahashi</span></a>
                                                </div>
                                                <div class="d-flex align-items-end justify-content-between flex-wrap gap-2">
                                                    <div class="flex-fill">
                                                        <span class="text-muted fs-12 d-block mb-1">Current Bid</span>
                                                        <div class="d-flex align-items-center gap-2 fw-semibold">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/crypto-icons/ethereum-eth-logo.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                26.50ETH
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <button class="btn btn-primary">Place a Bid</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start gap-3 mb-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-primary-transparent svg-primary"> 
                                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#000000"><path d="M0 0h24v24H0V0z" fill="none"></path><path d="M21 7.28V5c0-1.1-.9-2-2-2H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-2.28c.59-.35 1-.98 1-1.72V9c0-.74-.41-1.37-1-1.72zM20 9v6h-7V9h7zM5 19V5h14v2h-6c-1.1 0-2 .9-2 2v6c0 1.1.9 2 2 2h6v2H5z"></path><circle cx="16" cy="12" r="1.5"></circle></svg> 
                                                    </span>
                                                </div>
                                                <div>
                                                    <span class="d-block fs-13">Your Balance</span>
                                                    <h4 class="fw-semibold mb-1">162.87ETH</h4>
                                                    <span class="text-muted fs-12 d-inline-flex align-items-center"><span class="text-success me-2"><i class="ti ti-arrow-narrow-up me-1"></i>2.55%</span>This Year</span>
                                                </div>
                                            </div>
                                            <div id="nft-balance-chart"></div>
                                            <div class="d-grid mt-3">
                                                <button class="btn btn-primary d-inline-flex align-items-center justify-content-center"><i class="ti ti-circle-plus me-1 align-middle fs-14"></i>Top Up Balance</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Top Creators
                                            </div>
                                            <a href="javascript:void(0);" class="text-muted fs-13">View All <i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-unstyled nft-top-collectors-list">
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/6.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Kairo Tetsuo<i class="bi bi-patch-check-fill text-primary align-middle ms-2"></i></span>
                                                            <span class="text-muted fs-13">@KairoX</span>
                                                        </div>
                                                        <div>
                                                            <button class="btn btn-light rounded-pill">Follow</button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/15.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Aiko Nakamura<i class="bi bi-patch-check-fill text-primary align-middle ms-2"></i></span>
                                                            <span class="text-muted fs-13">@NamiGhost</span>
                                                        </div>
                                                        <div>
                                                            <button class="btn btn-primary rounded-pill">Following</button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/16.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Kairo Tetsuo<i class="bi bi-patch-check-fill text-primary align-middle ms-2"></i></span>
                                                            <span class="text-muted fs-13">@KairoX</span>
                                                        </div>
                                                        <div>
                                                            <button class="btn btn-light rounded-pill">Follow</button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/17.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Ryo Takahashi<i class="bi bi-patch-check-fill text-primary align-middle ms-2"></i></span>
                                                            <span class="text-muted fs-13">@TakaraVision</span>
                                                        </div>
                                                        <div>
                                                            <button class="btn btn-light rounded-pill">Follow</button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/11.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Nova Cypher<i class="bi bi-patch-check-fill text-primary align-middle ms-2"></i></span>
                                                            <span class="text-muted fs-13">@CypherNova	</span>
                                                        </div>
                                                        <div>
                                                            <button class="btn btn-light rounded-pill">Follow</button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/9.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Zara Kai<i class="bi bi-patch-check-fill text-primary align-middle ms-2"></i></span>
                                                            <span class="text-muted fs-13">@ZaraKx</span>
                                                        </div>
                                                        <div>
                                                            <button class="btn btn-light rounded-pill">Follow</button>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/8.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="fw-semibold d-block">Maxim Xeno<i class="bi bi-patch-check-fill text-primary align-middle ms-2"></i></span>
                                                            <span class="text-muted fs-13">@XenoMax</span>
                                                        </div>
                                                        <div>
                                                            <button class="btn btn-light rounded-pill">Follow</button>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-1 -->

                    <!-- Start:: row-2 -->
                    <div class="row">
                        <div class="col-xxl-6">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        NFT Statistics
                                    </div>
                                </div>
                                <div class="card-body pb-2">
                                    <div class="p-3 border border-dashed rounded mb-4">
                                        <div class="d-flex align-items-center justify-content-center flex-wrap gap-5">
                                            <div>
                                                <div class="mb-2">Growth<span class="badge bg-success ms-2"><i class="ti ti-arrow-up me-1"></i>2.35%</span></div>
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="fs-13 text-muted">NFT's Sold</div>
                                                    <h5 class="fw-semibold mb-0">3,297</h5>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="mb-2">Market<span class="badge bg-success ms-2"><i class="ti ti-arrow-up me-1"></i>6.96%</span></div>
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="fs-13 text-muted">Total Market</div>
                                                    <h5 class="fw-semibold mb-0">$1.45M</h5>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="mb-2">Bid<span class="badge bg-danger ms-2"><i class="ti ti-arrow-down me-1"></i>3.85%</span></div>
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="fs-13 text-muted">Highest Bid</div>
                                                    <h5 class="fw-semibold mb-0">128ETH</h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="nft-statistics"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Top Drops
                                    </div>
                                    <a href="javascript:void(0);" class="text-muted fs-13">View All<i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled nft-top-drops-list">
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/36.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Blade of the Future</span>
                                                    <span class="fs-13 text-muted">By Kairo Tetsuo</span>
                                                </div>
                                                <div class="text-end">
                                                    <div class="d-flex align-items-center gap-1">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/crypto-icons/ethereum-eth-logo.svg" alt="">
                                                            </span>
                                                        </div>
                                                        <span class="fw-semibold">
                                                            10 ETH
                                                        </span>
                                                    </div>
                                                    <span class="fs-13 text-muted d-block">Sold At</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/38.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Rebels of the Neon Streets</span>
                                                    <span class="fs-13 text-muted">By Aiko Nakamura</span>
                                                </div>
                                                <div class="text-end">
                                                    <div class="d-flex align-items-center gap-1">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/crypto-icons/ethereum-eth-logo.svg" alt="">
                                                            </span>
                                                        </div>
                                                        <span class="fw-semibold">
                                                            5 ETH
                                                        </span>
                                                    </div>
                                                    <span class="fs-13 text-muted d-block">Sold At</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/40.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">The Last Cyberpunk Hero</span>
                                                    <span class="fs-13 text-muted">By Ryo Takahashi</span>
                                                </div>
                                                <div class="text-end">
                                                    <div class="d-flex align-items-center gap-1">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/crypto-icons/ethereum-eth-logo.svg" alt="">
                                                            </span>
                                                        </div>
                                                        <span class="fw-semibold">
                                                            7 ETH
                                                        </span>
                                                    </div>
                                                    <span class="fs-13 text-muted d-block">Sold At</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/41.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Reborn in the Matrix</span>
                                                    <span class="fs-13 text-muted">By Nova Cypher</span>
                                                </div>
                                                <div class="text-end">
                                                    <div class="d-flex align-items-center gap-1">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/crypto-icons/ethereum-eth-logo.svg" alt="">
                                                            </span>
                                                        </div>
                                                        <span class="fw-semibold">
                                                            12 ETH
                                                        </span>
                                                    </div>
                                                    <span class="fs-13 text-muted d-block">Sold At</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/42.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Neon Rage</span>
                                                    <span class="fs-13 text-muted">By Zara Kai</span>
                                                </div>
                                                <div class="text-end">
                                                    <div class="d-flex align-items-center gap-1">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/crypto-icons/ethereum-eth-logo.svg" alt="">
                                                            </span>
                                                        </div>
                                                        <span class="fw-semibold">
                                                            7 ETH
                                                        </span>
                                                    </div>
                                                    <span class="fs-13 text-muted d-block">Sold At</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/43.png" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="d-block fw-semibold">Dawn of Darkness</span>
                                                    <span class="fs-13 text-muted">By Maxim Xeno</span>
                                                </div>
                                                <div class="text-end">
                                                    <div class="d-flex align-items-center gap-1">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/crypto-icons/ethereum-eth-logo.svg" alt="">
                                                            </span>
                                                        </div>
                                                        <span class="fw-semibold">
                                                            8 ETH
                                                        </span>
                                                    </div>
                                                    <span class="fs-13 text-muted d-block">Sold At</span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Featured Authors
                                    </div>
                                    <a href="javascript:void(0);" class="text-muted fs-13">View All <i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                </div>
                                <div class="card-body p-2">
                                    <div class="swiper pagination-dynamic text-start featured-collections" id="nft-collections-slide">
                                        <div class="swiper-wrapper">
                                            <div class="swiper-slide">
                                                <div class="card custom-card border-0 shadow-none mb-0">
                                                    <div class="card-body p-0">
                                                        <div class="row g-2">
                                                            <div class="col-12">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/38.png" alt="" class="nft-featuredcollect-image rounded">
                                                            </div>
                                                            <div class="col-6">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/40.png" alt="" class="nft-featuredcollect-image rounded">
                                                            </div>
                                                            <div class="col-6">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/41.png" alt="" class="nft-featuredcollect-image rounded">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="card-footer border-top-0 pb-0">
                                                        <div class="d-flex align-items-center">
                                                            <div class="d-flex align-items-center flex-fill">
                                                                <div class="me-2 lh-1">
                                                                    <span class="avatar avatar-md avatar-rounded">
                                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt=""> 
                                                                        <a href="javascript:void(0);" class="badge rounded-pill bg-primary avatar-badge"><i class="ri-check-line align-mmiddle"></i></a>
                                                                    </span>
                                                                </div>
                                                                <div>
                                                                    <p class="mb-0 fw-semibold"><a href="javascript:void(0);">Melissa Smith</a></p>
                                                                    <p class="text-muted fs-12 mb-0">@melissa</p>
                                                                </div>
                                                            </div>
                                                            <div class="dropdown">
                                                                <a href="javascript:void(0);" class="btn btn-icon btn-sm btn-primary-light" data-bs-toggle="dropdown">
                                                                    <i class="fe fe-more-vertical"></i>
                                                                </a>
                                                                <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item" href="javascript:void(0);">Action</a></li>
                                                                    <li><a class="dropdown-item" href="javascript:void(0);">Another action</a></li>
                                                                    <li><a class="dropdown-item" href="javascript:void(0);">Something else here</a></li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="card custom-card border-0 shadow-none mb-0">
                                                    <div class="card-body p-0">
                                                        <div class="row g-2">
                                                            <div class="col-12">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/35.png" alt="" class="nft-featuredcollect-image rounded">
                                                            </div>
                                                            <div class="col-6">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/36.png" alt="" class="nft-featuredcollect-image rounded">
                                                            </div>
                                                            <div class="col-6">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/37.png" alt="" class="nft-featuredcollect-image rounded">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="card-footer border-top-0 pb-0">
                                                        <div class="d-flex align-items-center">
                                                            <div class="d-flex align-items-center flex-fill">
                                                                <div class="me-2 lh-1">
                                                                    <span class="avatar avatar-md avatar-rounded">
                                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/15.jpg" alt=""> 
                                                                        <a href="javascript:void(0);" class="badge rounded-pill bg-primary avatar-badge"><i class="ri-check-line align-mmiddle"></i></a>
                                                                    </span>
                                                                </div>
                                                                <div>
                                                                    <p class="mb-0 fw-semibold"><a href="javascript:void(0);">Simon Cowell</a></p>
                                                                    <p class="text-muted fs-12 mb-0">@simon</p>
                                                                </div>
                                                            </div>
                                                            <div class="dropdown">
                                                                <a href="javascript:void(0);" class="btn btn-icon btn-sm btn-primary-light" data-bs-toggle="dropdown">
                                                                    <i class="fe fe-more-vertical"></i>
                                                                </a>
                                                                <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item" href="javascript:void(0);">Action</a></li>
                                                                    <li><a class="dropdown-item" href="javascript:void(0);">Another action</a></li>
                                                                    <li><a class="dropdown-item" href="javascript:void(0);">Something else here</a></li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="card custom-card border-0 shadow-none mb-0">
                                                    <div class="card-body p-0">
                                                        <div class="row g-2">
                                                            <div class="col-12">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/39.png" alt="" class="nft-featuredcollect-image rounded">
                                                            </div>
                                                            <div class="col-6">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/42.png" alt="" class="nft-featuredcollect-image rounded">
                                                            </div>
                                                            <div class="col-6">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/43.png" alt="" class="nft-featuredcollect-image rounded">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="card-footer border-top-0 pb-0">
                                                        <div class="d-flex align-items-center">
                                                            <div class="d-flex align-items-center flex-fill">
                                                                <div class="me-2 lh-1">
                                                                    <span class="avatar avatar-md avatar-rounded">
                                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt=""> 
                                                                        <a href="javascript:void(0);" class="badge rounded-pill bg-primary avatar-badge"><i class="ri-check-line align-mmiddle"></i></a>
                                                                    </span>
                                                                </div>
                                                                <div>
                                                                    <p class="mb-0 fw-semibold"><a href="javascript:void(0);">Json Talor</a></p>
                                                                    <p class="text-muted fs-12 mb-0">@taylor</p>
                                                                </div>
                                                            </div>
                                                            <div class="dropdown">
                                                                <a href="javascript:void(0);" class="btn btn-icon btn-sm btn-primary-light" data-bs-toggle="dropdown">
                                                                    <i class="fe fe-more-vertical"></i>
                                                                </a>
                                                                <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item" href="javascript:void(0);">Action</a></li>
                                                                    <li><a class="dropdown-item" href="javascript:void(0);">Another action</a></li>
                                                                    <li><a class="dropdown-item" href="javascript:void(0);">Something else here</a></li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>  
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-2 -->

                    <!-- Start:: row-3 -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        NFT Collection Overview
                                    </div>
                                    <div class="d-flex flex-wrap gap-2"> 
                                        <div class="dropdown"> 
                                            <a href="javascript:void(0);" class="btn btn-outline-light btn-wave waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="false">Price<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i> </a> 
                                            <ul class="dropdown-menu" role="menu"> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">All</a></li> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">Under 5 ETH</a></li> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">5 ETH - 10 ETH</a></li> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">10 ETH - 20 ETH</a></li> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">Above 20 ETH</a></li> 
                                            </ul> 
                                        </div> 
                                        <div> 
                                            <input class="form-control" type="text" placeholder="Search Here" aria-label=".form-control-sm example"> 
                                        </div> 
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table text-nowrap">
                                            <thead>
                                                <tr>
                                                    <th>S.No</th>
                                                    <th>NFT Name</th>
                                                    <th>Creator</th>
                                                    <th>Release Date</th>
                                                    <th>Price</th>
                                                    <th>Status</th>
                                                    <th>Category</th>
                                                    <th>Blockchain</th>
                                                    <th>Ownership</th>
                                                    <th>Volume (ETH)</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>1</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/40.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Neon Samurai</span>
                                                                <span class="fs-13 text-muted">@KairoX</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>Kairo Tetsuo</td>
                                                    <td>Feb 25, 2025</td>
                                                    <td>10 ETH</td>
                                                    <td><span class="badge bg-success-transparent">Sold Out</span></td>
                                                    <td>Cyberpunk</td>
                                                    <td>Ethereum</td>
                                                    <td>1 of 1</td>
                                                    <td>50 ETH</td>
                                                </tr>
                                                <tr>
                                                    <td>2</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/42.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Cybercity Uprising</span>
                                                                <span class="fs-13 text-muted">@NamiGhost</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>Aiko Nakamura</td>
                                                    <td>Mar 10, 2025</td>
                                                    <td>5 ETH</td>
                                                    <td><span class="badge bg-success-transparent">50% Sold</span></td>
                                                    <td>Cyberpunk</td>
                                                    <td>Polygon</td>
                                                    <td>3 of 10</td>
                                                    <td>15 ETH</td>
                                                </tr>
                                                <tr>
                                                    <td>3</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/35.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Holo-Vision Hero</span>
                                                                <span class="fs-13 text-muted">@TakaraVision</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>Ryo Takahashi</td>
                                                    <td>Mar 18, 2025</td>
                                                    <td>7 ETH</td>
                                                    <td><span class="badge bg-success-transparent">80% Sold</span></td>
                                                    <td>Sci-Fi</td>
                                                    <td>Ethereum</td>
                                                    <td>5 of 5</td>
                                                    <td>20 ETH</td>
                                                </tr>
                                                <tr>
                                                    <td>4</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/36.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Cyber Phoenix</span>
                                                                <span class="fs-13 text-muted">@CypherNova</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>Nova Cypher</td>
                                                    <td>Apr 2, 2025</td>
                                                    <td>12 ETH</td>
                                                    <td><span class="badge bg-success-transparent">10% Sold</span></td>
                                                    <td>Cyberpunk</td>
                                                    <td>Binance</td>
                                                    <td>10 of 20</td>
                                                    <td>10 ETH</td>
                                                </tr>
                                                <tr>
                                                    <td>5</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/37.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Digital Outlaws</span>
                                                                <span class="fs-13 text-muted">@ZaraKx</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>Zara Kai</td>
                                                    <td>Apr 15, 2025</td>
                                                    <td>15 ETH</td>
                                                    <td><span class="badge bg-primary-transparent">Coming Soon</span></td>
                                                    <td>Cyberpunk</td>
                                                    <td>Solana</td>
                                                    <td>1 of 1</td>
                                                    <td>0 ETH</td>
                                                </tr>
                                                <tr>
                                                    <td>6</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-md avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/nft-images/38.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <span class="fw-semibold d-block">Cyber Reaper</span>
                                                                <span class="fs-13 text-muted">@XenoMax</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>Maxim Xeno</td>
                                                    <td>Apr 20, 2025</td>
                                                    <td>8 ETH</td>
                                                    <td><span class="badge bg-warning-transparent">Pre-Sale</span></td>
                                                    <td>Cyberpunk</td>
                                                    <td>Ethereum</td>
                                                    <td>7 of 10</td>
                                                    <td>25 ETH</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="card-footer border-top-0">
                                    <div class="d-flex align-items-center"> 
                                        <div> Showing 6 Entries <i class="bi bi-arrow-right ms-2 fw-semibold"></i> </div> 
                                        <div class="ms-auto"> 
                                            <nav aria-label="Page navigation" class="pagination-style-2">
                                                <ul class="pagination mb-0 flex-wrap">
                                                    <li class="page-item disabled">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            Prev
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                                    <li class="page-item active"><a class="page-link" href="javascript:void(0);">2</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            <i class="bi bi-three-dots"></i>
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">17</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link text-primary" href="javascript:void(0);">
                                                            next
                                                        </a>
                                                    </li>
                                                </ul>
                                            </nav>
                                        </div> 
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-3 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

        <!-- Swiper JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/swiper/swiper-bundle.min.js"></script>

        <!-- NFT Dashboard --> 
        <script src="<?php echo $baseUrl; ?>/assets/js/nft-dashboard.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
