
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Courses</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Courses</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row row-cols-xxl-5">
                        <div class="col">
                            <div class="card custom-card bg-primary-transparent border-0 shadow-none">
                                <div class="card-body">
                                    <div class="d-flex align-items-start gap-3 flex-wrap">
                                        <div class="lh-1">
                                            <span class="avatar avatar-lg avatar-rounded bg-primary svg-white">
                                                <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0z" fill="none"/><path d="M4 6H2v14c0 1.1.9 2 2 2h14v-2H4V6zm16-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-1 9H9V9h10v2zm-4 4H9v-2h6v2zm4-8H9V5h10v2z"/></svg>
                                            </span>
                                        </div>
                                        <div>
                                            <span class="d-block mb-1">
                                                Total Courses
                                            </span>
                                            <div class="d-flex align-items-center gap-2">
                                                <h5 class="fw-semibold mb-0">643</h5>
                                                <span class="badge bg-primary-transparent rounded-pill"><i class="ti ti-arrow-up me-1"></i>5.32%</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card custom-card bg-success-transparent border-0 shadow-none">
                                <div class="card-body">
                                    <div class="d-flex align-items-start gap-3 flex-wrap">
                                        <div class="lh-1">
                                            <span class="avatar avatar-lg avatar-rounded bg-success svg-white">
                                                <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><path d="M0 0h24v24H0z" fill="none"/><path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/></svg>
                                            </span>
                                        </div>
                                        <div>
                                            <span class="d-block mb-1">
                                                Total Students
                                            </span>
                                            <div class="d-flex align-items-center gap-2">
                                                <h5 class="fw-semibold mb-0">16,332</h5>
                                                <span class="badge bg-success-transparent rounded-pill"><i class="ti ti-arrow-up me-1"></i>2.43%</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card custom-card bg-info-transparent border-0 shadow-none">
                                <div class="card-body">
                                    <div class="d-flex align-items-start gap-3 flex-wrap">
                                        <div class="lh-1">
                                            <span class="avatar avatar-lg avatar-rounded bg-info svg-white">
                                                <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><path d="M20,7h-5V4c0-1.1-0.9-2-2-2h-2C9.9,2,9,2.9,9,4v3H4C2.9,7,2,7.9,2,9v11c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V9 C22,7.9,21.1,7,20,7z M9,12c0.83,0,1.5,0.67,1.5,1.5S9.83,15,9,15s-1.5-0.67-1.5-1.5S8.17,12,9,12z M12,18H6v-0.75c0-1,2-1.5,3-1.5 s3,0.5,3,1.5V18z M13,9h-2V4h2V9z M18,16.5h-4V15h4V16.5z M18,13.5h-4V12h4V13.5z"/></g></svg>
                                            </span>
                                        </div>
                                        <div>
                                            <span class="d-block mb-1">
                                                Total Instructors
                                            </span>
                                            <div class="d-flex align-items-center gap-2">
                                                <h5 class="fw-semibold mb-0">231</h5>
                                                <span class="badge bg-info-transparent rounded-pill"><i class="ti ti-arrow-up me-1"></i>0.98%</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card custom-card bg-danger-transparent border-0 shadow-none">
                                <div class="card-body">
                                    <div class="d-flex align-items-start gap-3 flex-wrap">
                                        <div class="lh-1">
                                            <span class="avatar avatar-lg avatar-rounded bg-danger svg-white">
                                                <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><path d="M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12.88,17.76V19h-1.75v-1.29 c-0.74-0.18-2.39-0.77-3.02-2.96l1.65-0.67c0.06,0.22,0.58,2.09,2.4,2.09c0.93,0,1.98-0.48,1.98-1.61c0-0.96-0.7-1.46-2.28-2.03 c-1.1-0.39-3.35-1.03-3.35-3.31c0-0.1,0.01-2.4,2.62-2.96V5h1.75v1.24c1.84,0.32,2.51,1.79,2.66,2.23l-1.58,0.67 c-0.11-0.35-0.59-1.34-1.9-1.34c-0.7,0-1.81,0.37-1.81,1.39c0,0.95,0.86,1.31,2.64,1.9c2.4,0.83,3.01,2.05,3.01,3.45 C15.9,17.17,13.4,17.67,12.88,17.76z"/></g></svg>
                                            </span>
                                        </div>
                                        <div>
                                            <span class="d-block mb-1">
                                                Total Earnings
                                            </span>
                                            <div class="d-flex align-items-center gap-2">
                                                <h5 class="fw-semibold mb-0">$1.45M</h5>
                                                <span class="badge bg-danger-transparent rounded-pill"><i class="ti ti-arrow-up me-1"></i>1.55%</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card custom-card bg-warning-transparent border-0 shadow-none">
                                <div class="card-body">
                                    <div class="d-flex align-items-start gap-3 flex-wrap">
                                        <div class="lh-1">
                                            <span class="avatar avatar-lg avatar-rounded bg-warning svg-white">
                                                <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#5f6368"><g><rect fill="none" height="24" width="24"/></g><g><g><g><g><path d="M7.5,11C9.43,11,11,9.43,11,7.5S9.43,4,7.5,4S4,5.57,4,7.5S5.57,11,7.5,11z M7.5,6C8.33,6,9,6.67,9,7.5S8.33,9,7.5,9 S6,8.33,6,7.5S6.67,6,7.5,6z"/></g></g><g><rect height="2" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -4.9706 12)" width="20.63" x="1.69" y="11"/></g><g><g><path d="M16.5,13c-1.93,0-3.5,1.57-3.5,3.5s1.57,3.5,3.5,3.5s3.5-1.57,3.5-3.5S18.43,13,16.5,13z M16.5,18 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S17.33,18,16.5,18z"/></g></g></g></g></svg>
                                            </span>
                                        </div>
                                        <div>
                                            <span class="d-block mb-1">
                                                Engegement Ratio
                                            </span>
                                            <div class="d-flex align-items-center gap-2">
                                                <h5 class="fw-semibold mb-0">45%</h5>
                                                <span class="badge bg-warning-transparent rounded-pill"><i class="ti ti-arrow-up me-1"></i>3.45%</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-1 -->

                    <!-- Start:: row-2 -->
                    <div class="row">
                        <div class="col-xl-6">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Students Analysis
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div id="students-analysis"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Courses List
                                    </div>
                                    <a href="javascript:void(0);" class="text-muted">View All <i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                </div>
                                <div class="card-body p-0">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-start flex-wrap gap-3">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xl">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-25.jpg" alt="img">
                                                    </span>
                                                </div>
                                                <div class="flex-fill fw-medium">
                                                    <a href="javascript:void(0);" class="text-muted d-block mb-1 fs-10" title="Category"><i class="ti ti-tag fs-11 align-middle"></i>&nbsp;UI/UX</a>
                                                    <a href="javascript:void(0);" class="d-block mb-2 fs-14">CSS Zero to Hero Class-11</a>
                                                    <div class="d-flex align-items-center flex-wrap gap-3">
                                                        <div class="d-flex align-items-center">
                                                            <a href="javascript:void(0);" class="me-2 lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="img">
                                                                </span>
                                                            </a>
                                                            <a href="javascript:void(0);" class="flex-fill fs-12">Natasha Sil</a>
                                                        </div>
                                                        <div class="fs-12">
                                                            <span class="me-2">2,189 Views</span>
                                                            <span class="d-inline-flex align-items-center"><i class="ri-star-fill fs-16 text-warning me-1"></i>(4.2)</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-start flex-wrap gap-3">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xl">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-13.jpg" alt="img">
                                                    </span>
                                                </div>
                                                <div class="flex-fill fw-medium">
                                                    <a href="javascript:void(0);" class="text-muted d-block mb-1 fs-10" title="Category"><i class="ti ti-tag fs-11 align-middle"></i>&nbsp;Marketing</a>
                                                    <a href="javascript:void(0);" class="d-block mb-2 fs-14">Marketing Class-27</a>
                                                    <div class="d-flex align-items-center flex-wrap gap-3">
                                                        <div class="d-flex align-items-center">
                                                            <a href="javascript:void(0);" class="me-2 lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="img">
                                                                </span>
                                                            </a>
                                                            <a href="javascript:void(0);" class="flex-fill fs-12">John Doe</a>
                                                        </div>
                                                        <div class="fs-12">
                                                            <span class="me-2">1,116 Views</span>
                                                            <span class="d-inline-flex align-items-center"><i class="ri-star-fill fs-16 text-warning me-1"></i>(4.5)</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-start flex-wrap gap-3">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xl">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-24.jpg" alt="img">
                                                    </span>
                                                </div>
                                                <div class="flex-fill fw-medium">
                                                    <a href="javascript:void(0);" class="text-muted d-block mb-1 fs-10" title="Category"><i class="ti ti-tag fs-11 align-middle"></i>&nbsp;Programming</a>
                                                    <a href="javascript:void(0);" class="d-block mb-2 fs-14">Learn Python-16</a>
                                                    <div class="d-flex align-items-center flex-wrap gap-3">
                                                        <div class="d-flex align-items-center">
                                                            <a href="javascript:void(0);" class="me-2 lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="img">
                                                                </span>
                                                            </a>
                                                            <a href="javascript:void(0);" class="flex-fill fs-12">Jane Smith</a>
                                                        </div>
                                                        <div class="fs-12">
                                                            <span class="me-2">2,125 Views</span>
                                                            <span class="d-inline-flex align-items-center"><i class="ri-star-fill fs-16 text-warning me-1"></i>(4.8)</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-start flex-wrap gap-3">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xl">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-18.jpg" alt="img">
                                                    </span>
                                                </div>
                                                <div class="flex-fill fw-medium">
                                                    <a href="javascript:void(0);" class="text-muted d-block mb-1 fs-10" title="Category"><i class="ti ti-tag fs-11 align-middle"></i>&nbsp;UI/UX Design</a>
                                                    <a href="javascript:void(0);" class="d-block mb-2 fs-14">Javascript-45</a>
                                                    <div class="d-flex align-items-center flex-wrap gap-3">
                                                        <div class="d-flex align-items-center">
                                                            <a href="javascript:void(0);" class="me-2 lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="img">
                                                                </span>
                                                            </a>
                                                            <a href="javascript:void(0);" class="flex-fill fs-12">Robert White</a>
                                                        </div>
                                                        <div class="fs-12">
                                                            <span class="me-2">3,677 Views</span>
                                                            <span class="d-inline-flex align-items-center"><i class="ri-star-fill fs-16 text-warning me-1"></i>(4.9)</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Top Course Categories
                                    </div>
                                    <a href="javascript:void(0);" class="text-muted">View All <i class="ti ti-arrow-narrow-right ms-1"></i></a>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled top-course-categories-list">
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-primary-transparent">
                                                        SD
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="fw-semibold d-block">
                                                        Software Development
                                                    </span>
                                                    <span class="fs-12">25 Courses</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold">1,200</span>
                                                    <span class="d-block text-muted">Students</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-secondary-transparent">
                                                        DA
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="fw-semibold d-block">
                                                        Data Science & Analytics
                                                    </span>
                                                    <span class="fs-12">18 Courses</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold">1,000</span>
                                                    <span class="d-block text-muted">Students</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-warning-transparent">
                                                        BM
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="fw-semibold d-block">
                                                        Business & Management
                                                    </span>
                                                    <span class="fs-12">22 Courses</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold">1,500</span>
                                                    <span class="d-block text-muted">Students</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-info-transparent">
                                                        DC
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="fw-semibold d-block">
                                                        Design & Creativity
                                                    </span>
                                                    <span class="fs-12">15 Courses</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold">800</span>
                                                    <span class="d-block text-muted">Students</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-success-transparent">
                                                        PD
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="fw-semibold d-block">
                                                        Personal Development
                                                    </span>
                                                    <span class="fs-12">12 Courses</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold">600</span>
                                                    <span class="d-block text-muted">Students</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md bg-danger-transparent">
                                                        MS
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <span class="fw-semibold d-block">
                                                        Marketing & Sales
                                                    </span>
                                                    <span class="fs-12">17 Courses</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold">1,100</span>
                                                    <span class="d-block text-muted">Students</span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-2 -->

                    <!-- Start:: row-3 -->
                    <div class="row">
                        <div class="col-xxl-3 col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Top Instructors
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled top-instructors-list">
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md online avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-center gap-2 lh-1 mb-1">
                                                        <span class="fw-semibold d-block">Dr. John Smith</span>
                                                        <div class="vr"></div>
                                                        <div class="d-inline-flex align-items-center">4.5<i class="ti ti-star-filled ms-1 text-warning"></i></div>
                                                    </div>
                                                    <span class="text-muted fs-13">2000 Students</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold d-block">$15,000.00</span>
                                                    <span class="fw-semibold fs-13 text-muted">Earnings</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md online avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-center gap-2 lh-1 mb-1">
                                                        <span class="fw-semibold d-block">Sarah Miller</span>
                                                        <div class="vr"></div>
                                                        <div class="d-inline-flex align-items-center">4.7<i class="ti ti-star-filled ms-1 text-warning"></i></div>
                                                    </div>
                                                    <span class="text-muted fs-13">1,800 Students</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold d-block">$12,500.00</span>
                                                    <span class="fw-semibold fs-13 text-muted">Earnings</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md online avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-center gap-2 lh-1 mb-1">
                                                        <span class="fw-semibold d-block">Emily Clark</span>
                                                        <div class="vr"></div>
                                                        <div class="d-inline-flex align-items-center">4.9<i class="ti ti-star-filled ms-1 text-warning"></i></div>
                                                    </div>
                                                    <span class="text-muted fs-13">1,500 Students</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold d-block">$10,200.00</span>
                                                    <span class="fw-semibold fs-13 text-muted">Earnings</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md online avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-center gap-2 lh-1 mb-1">
                                                        <span class="fw-semibold d-block">Mark Taylor</span>
                                                        <div class="vr"></div>
                                                        <div class="d-inline-flex align-items-center">4.6<i class="ti ti-star-filled ms-1 text-warning"></i></div>
                                                    </div>
                                                    <span class="text-muted fs-13">1,200 Students</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold d-block">$8,800.00</span>
                                                    <span class="fw-semibold fs-13 text-muted">Earnings</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md online avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="">
                                                    </span> 
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-center gap-2 lh-1 mb-1">
                                                        <span class="fw-semibold d-block">Mark Taylor</span>
                                                        <div class="vr"></div>
                                                        <div class="d-inline-flex align-items-center">4.6<i class="ti ti-star-filled ms-1 text-warning"></i></div>
                                                    </div>
                                                    <span class="text-muted fs-13">1,200 Students</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold d-block">$8,800.00</span>
                                                    <span class="fw-semibold fs-13 text-muted">Earnings</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-md online avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="">
                                                    </span> 
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex align-items-center gap-2 lh-1 mb-1">
                                                        <span class="fw-semibold d-block">Jessica Lee</span>
                                                        <div class="vr"></div>
                                                        <div class="d-inline-flex align-items-center">4.7<i class="ti ti-star-filled ms-1 text-warning"></i></div>
                                                    </div>
                                                    <span class="text-muted fs-13">1,000 Students</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-semibold d-block">$7,500.00</span>
                                                    <span class="fw-semibold fs-13 text-muted">Earnings</span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Upcoming Schedules
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled upcoming-schedules-list">
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between gap-1">
                                                <div class="w-50">
                                                    <div class="mb-1 fw-semibold text-truncate">
                                                        Introduction to Web Development
                                                    </div>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>Dr. John Smith</div>
                                                    </div>
                                                </div>
                                                <div class="text-end w-50">
                                                    <div class="mb-1">
                                                        Feb 20 - Mar 20
                                                    </div>
                                                    <span class="d-block fs-12 text-muted">
                                                        10:00 AM - 12:00 PM
                                                    </span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between gap-1">
                                                <div class="w-50">
                                                    <div class="mb-1 fw-semibold text-truncate">
                                                        Advanced Python Programming
                                                    </div>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>Sarah Miller</div>
                                                    </div>
                                                </div>
                                                <div class="text-end w-50">
                                                    <div class="mb-1">
                                                        Feb 22 - Mar 20
                                                    </div>
                                                    <span class="d-block fs-12 text-muted">
                                                        2:00 PM - 4:00 PM
                                                    </span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between gap-1">
                                                <div class="w-50">
                                                    <div class="mb-1 fw-semibold text-truncate">
                                                        Data Science for Beginners
                                                    </div>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>Emily Clark</div>
                                                    </div>
                                                </div>
                                                <div class="text-end w-50">
                                                    <div class="mb-1">
                                                        Feb 25 - Apr 21
                                                    </div>
                                                    <span class="d-block fs-12 text-muted">
                                                        9:00 AM - 11:00 AM
                                                    </span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between gap-1">
                                                <div class="w-50">
                                                    <div class="mb-1 fw-semibold text-truncate">
                                                        Digital Marketing Mastery
                                                    </div>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/15.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>Mark Taylor</div>
                                                    </div>
                                                </div>
                                                <div class="text-end w-50">
                                                    <div class="mb-1">
                                                        Feb 28 - Apr 04
                                                    </div>
                                                    <span class="d-block fs-12 text-muted">
                                                        1:00 PM - 3:00 PM
                                                    </span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between gap-1">
                                                <div class="w-50">
                                                    <div class="mb-1 fw-semibold text-truncate">
                                                        Graphic Design Fundamentals
                                                    </div>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/6.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>Jessica Lee</div>
                                                    </div>
                                                </div>
                                                <div class="text-end w-50">
                                                    <div class="mb-1">
                                                        MAr 05 - Apr 19
                                                    </div>
                                                    <span class="d-block fs-12 text-muted">
                                                        11:00 AM - 1:00 PM
                                                    </span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Payout Report
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row gy-4 mb-5">
                                        <div class="col">
                                            <div class="d-flex align-items-center p-2 border border-dashed rounded">
                                                <div class="me-3">
                                                    <span class="avatar radius-5 bg-primary-transparent text-primary"><i class="ti ti-cash fs-5"></i></span>
                                                </div>
                                                <div class="flex-1">
                                                    <span class="fs-12 text-muted">Paid</span>
                                                    <span class="fs-16 fw-semibold d-flex align-items-center">$68,400</span>
                                                    <span class="text-success fs-12"><i class="ti ti-arrow-up me-1"></i>4.26%</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="d-flex align-items-center p-2 border border-dashed rounded">
                                                <div class="me-3">
                                                    <span class="avatar radius-5 bg-secondary-transparent text-secondary"><i class="ti ti-x fs-5"></i></span>
                                                </div>
                                                <div class="flex-1">
                                                    <span class="fs-12 text-muted">Unpaid</span>
                                                    <span class="fs-16 fw-semibold d-flex align-items-center">$21,300</span>
                                                    <span class="text-danger fs-12"><i class="ti ti-arrow-down me-1"></i>0.86%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="payout-Report"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header flex-between justify-content-between">
                                    <div class="card-title">Ongoing Courses</div>
                                    <div class="dropdown">
                                        <a href="javascript:void(0);" class="text-muted" data-bs-toggle="dropdown" aria-expanded="false">
                                            View All<i class="ri-arrow-down-s-line align-middle ms-1"></i>
                                        </a>
                                        <ul class="dropdown-menu" role="menu">
                                            <li><a class="dropdown-item border-bottom" href="javascript:void(0);">Today</a></li>
                                            <li><a class="dropdown-item border-bottom" href="javascript:void(0);">This Week</a></li>
                                            <li><a class="dropdown-item border-bottom" href="javascript:void(0);">Last Week</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled ongoing-courses-list">
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div>
                                                    <span class="avatar avatar-md bg-primary-transparent"><i class="bx bx-store fs-5"></i></span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex justify-content-between mb-1 flex-wrap">
                                                        <span class="fw-semibold d-block w-75 text-truncate">
                                                            Introduction to Web Design
                                                        </span>
                                                        <div>
                                                            <p class="mb-0 fs-13 text-muted">
                                                                <i class='ti ti-arrow-up align-middle me-1 text-success'></i>93.0%
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-animate progress-xs">
                                                        <div class="progress-bar progress-bar-striped progress-bar-animated" style="width: 93%;"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div>
                                                    <span class="avatar avatar-md bg-secondary-transparent"><i class="bx bx-layout fs-5"></i></span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex justify-content-between mb-1 flex-wrap">
                                                        <span class="fw-semibold d-block w-75 text-truncate">
                                                            Advanced Python Programming
                                                        </span>
                                                        <div>
                                                            <p class="mb-0 fs-13 text-muted">
                                                                <i class='ti ti-arrow-up align-middle  me-1 text-success' ></i>75.0%
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-animate progress-xs">
                                                        <div class="progress-bar progress-bar-striped progress-bar-animated bg-secondary" style="width: 70%;"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div>
                                                    <span class="avatar avatar-md bg-warning-transparent"><i class="bx bx-code fs-5"></i></span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex justify-content-between mb-1 flex-wrap">
                                                        <span class="fw-semibold d-block w-75 text-truncate">
                                                            Data Science for Beginners
                                                        </span>
                                                        <div>
                                                            <p class="mb-0 fs-13 text-muted">
                                                                <i class='ti ti-arrow-up align-middle me-1 text-success' ></i>85.0%
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-animate progress-xs">
                                                        <div class="progress-bar progress-bar-striped progress-bar-animated bg-warning" style="width: 85%;"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div>
                                                    <span class="avatar avatar-md bg-info-transparent"><i class="bx bx-layer fs-5"></i></span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex justify-content-between mb-1 flex-wrap">
                                                        <span class="fw-semibold d-block w-75 text-truncate">
                                                            Digital Marketing Mastery
                                                        </span>
                                                        <div>
                                                            <p class="mb-0 fs-13 text-muted">
                                                                <i class="ti ti-arrow-up align-middle me-1 text-success"></i>73.0%
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-animate progress-xs">
                                                        <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" style="width: 73%;"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div>
                                                    <span class="avatar avatar-md bg-success-transparent"><i class="bx bx-recycle fs-5"></i></span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex justify-content-between mb-1 flex-wrap">
                                                        <span class="fw-semibold d-block w-75 text-truncate">
                                                            Graphic Design Fundamentals
                                                        </span>
                                                        <div>
                                                            <p class="mb-0 fs-13 text-muted">
                                                                <i class="ti ti-arrow-up align-middle me-1 text-success"></i>60.0%
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-animate progress-xs">
                                                        <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" style="width: 60%;"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div>
                                                    <span class="avatar avatar-md bg-danger-transparent"><i class="bx bx-recycle fs-5"></i></span>
                                                </div>
                                                <div class="flex-fill">
                                                    <div class="d-flex justify-content-between mb-1 flex-wrap">
                                                        <span class="fw-semibold d-block w-75 text-truncate">
                                                            Mastering Adobe Photoshop
                                                        </span>
                                                        <div>
                                                            <p class="mb-0 fs-13 text-muted">
                                                                <i class="ti ti-arrow-up align-middle me-1 text-success"></i>60.0%
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-animate progress-xs">
                                                        <div class="progress-bar progress-bar-striped progress-bar-animated bg-danger" style="width: 45%;"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-3 -->

                    <!-- Start:: row-4 -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Courses Overview
                                    </div>
                                    <div class="d-flex flex-wrap gap-2"> 
                                        <div> 
                                            <input class="form-control form-control-sm" type="text" placeholder="Search Here" aria-label=".form-control-sm example"> 
                                        </div> 
                                        <div class="dropdown"> 
                                            <a href="javascript:void(0);" class="btn btn-primary btn-sm btn-wave waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="false"> Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i> 
                                            </a> 
                                            <ul class="dropdown-menu" role="menu"> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">New</a></li> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">Popular</a></li> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">Relevant</a></li> 
                                            </ul> 
                                        </div> 
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table text-nowrap">
                                            <thead>
                                                <th>
                                                    <input class="form-check-input" type="checkbox" id="checkboxAll" value="" aria-label="..."> 
                                                </th>
                                                <th>Course Name</th>
                                                <th>Instructor</th>
                                                <th>Start Date</th>
                                                <th>Total Enrolled</th>
                                                <th>Average Rating</th>
                                                <th>Status</th>
                                                <th>Revenue</th>
                                                <th>Actions</th>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        <input class="form-check-input" type="checkbox" id="checkbox1" value="" aria-label="..."> 
                                                    </td>
                                                    <td>Introduction to Web Development</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>Dr. John Smith</div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Feb 20, 2025
                                                    </td>
                                                    <td>
                                                        500
                                                    </td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.8<i class="ti ti-star-filled text-warning ms-1"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-primary-transparent">Active</span>
                                                    </td>
                                                    <td>
                                                        $5,000.00
                                                    </td>
                                                    <td>    
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <input class="form-check-input" type="checkbox" id="checkbox2" value="" aria-label="..."> 
                                                    </td>
                                                    <td>Advanced Python Programming</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>Sarah Miller</div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Feb 22, 2025
                                                    </td>
                                                    <td>
                                                        400
                                                    </td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.7<i class="ti ti-star-filled text-warning ms-1"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-primary-transparent">Active</span>
                                                    </td>
                                                    <td>
                                                        $4,200.00
                                                    </td>
                                                    <td>    
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <input class="form-check-input" type="checkbox" id="checkbox3" value="" aria-label="..."> 
                                                    </td>
                                                    <td>Data Science for Beginners</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>Emily Clark</div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Feb 25, 2025
                                                    </td>
                                                    <td>
                                                        350
                                                    </td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.9<i class="ti ti-star-filled text-warning ms-1"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-primary-transparent">Active</span>
                                                    </td>
                                                    <td>
                                                        $4,500.00
                                                    </td>
                                                    <td>    
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <input class="form-check-input" type="checkbox" id="checkbox4" value="" aria-label="..."> 
                                                    </td>
                                                    <td>Digital Marketing Mastery</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>Mark Taylor</div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Feb 28, 2025
                                                    </td>
                                                    <td>
                                                        450
                                                    </td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.6<i class="ti ti-star-filled text-warning ms-1"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-primary-transparent">Active</span>
                                                    </td>
                                                    <td>
                                                        $6,000.00
                                                    </td>
                                                    <td>    
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <input class="form-check-input" type="checkbox" id="checkbox5" value="" aria-label="..."> 
                                                    </td>
                                                    <td>Graphic Design Fundamentals</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>Jessica Lee</div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Mar 5, 2025
                                                    </td>
                                                    <td>
                                                        300
                                                    </td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.7<i class="ti ti-star-filled text-warning ms-1"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-warning-transparent">Pending</span>
                                                    </td>
                                                    <td>
                                                        $3,000.00
                                                    </td>
                                                    <td>    
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <input class="form-check-input" type="checkbox" id="checkbox6" value="" aria-label="..."> 
                                                    </td>
                                                    <td>Building Mobile Apps with React Native</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                                </span>
                                                            </div>
                                                            <div>Dr. John Smith</div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        Mar 8, 2025
                                                    </td>
                                                    <td>
                                                        250
                                                    </td>
                                                    <td>
                                                        <div class="d-inline-flex align-items-center">
                                                            4.8<i class="ti ti-star-filled text-warning ms-1"></i>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-primary-transparent">Active</span>
                                                    </td>
                                                    <td>
                                                        $3,800.00
                                                    </td>
                                                    <td>    
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="card-footer border-top-0">
                                    <div class="d-flex align-items-center"> 
                                        <div> Showing 6 Entries <i class="bi bi-arrow-right ms-2 fw-semibold"></i> </div> 
                                        <div class="ms-auto"> 
                                            <nav aria-label="Page navigation" class="pagination-style-2">
                                                <ul class="pagination mb-0 flex-wrap">
                                                    <li class="page-item disabled">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            Prev
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                                    <li class="page-item active"><a class="page-link" href="javascript:void(0);">2</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            <i class="bi bi-three-dots"></i>
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">17</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link text-primary" href="javascript:void(0);">
                                                            next
                                                        </a>
                                                    </li>
                                                </ul>
                                            </nav>
                                        </div> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-4 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

        <!-- Courses Dashboard --> 
        <script src="<?php echo $baseUrl; ?>/assets/js/courses-dashboard.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
