
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/swiper/swiper-bundle.min.css">

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Candidate Details</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Jobs</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Candidate Details</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start::row-2 -->
                    <div class="row">
                        <div class="col-xxl-9 col-xl-8">
                            <div class="card custom-card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center flex-wrap justify-content-between gap-2">
                                        <div class="d-flex flex-wrap gap-2 w-75">
                                            <div>
                                                <span class="avatar avatar-xxl">
                                                    <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" class="img-fluid" alt="">
                                                </span>
                                            </div>    
                                            <div class="ms-3 w-75">
                                                <h4 class="fw-medium mb-0 d-flex align-items-center gap-2">
                                                    <a href="javascript:void(0);" class="lh-1">Jhon Doe</a>
                                                    <span class="text-success fs-13 lh-1"><i class="ti ti-star-filled me-1 text-warning"></i>4.5</span>
                                                </h4>
                                                <div class="my-1">
                                                    <a href="javascript:void(0);" class="fw-medium"><i class="bi bi-briefcase me-1 align-middle"></i> Software Engineer</a>
                                                </div>
                                                <div class="popular-tags">
                                                    <a href="javascript:void(0);" class="badge rounded-pill bg-info-transparent"><i class="bi bi-moon-stars me-1"></i>Full Time</a>
                                                    <a href="javascript:void(0);" class="badge rounded-pill bg-danger-transparent"><i class="bi bi-clock me-1"></i> Immediate Joinee</a>
                                                </div>
                                                <div class="row mt-3 gy-2">
                                                    <div class="col-xl-6">
                                                        <div><i class="bi bi-geo-alt me-2"></i>Hyderabad, India</div>
                                                    </div>
                                                    <div class="col-xl-6">
                                                        <div><i class="bi bi-briefcase me-2"></i>6 Years Experience</div>
                                                    </div>
                                                    <div class="col-xl-6">
                                                        <div>
                                                            <i class="bi bi-coin me-2"></i>Package (Yearly) : $80,000 - $100,000
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-6">
                                                        <i class="bi bi-mortarboard me-2"></i>B.Sc. in Computer Science
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="btn-list">
                                            <a href="javascript:void(0);" class="btn btn-primary"><i class="bi bi-download me-1"></i> Download CV</a>
                                            <a href="javascript:void(0);" class="btn btn-icon btn-primary-light btn-wave">
                                                <i class="ri-heart-line fs-13"></i>
                                            </a>
                                            <a href="javascript:void(0);" class="btn btn-icon btn-primary-light btn-wave">
                                                <i class="ri-share-line"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card custom-card">
                                <div class="card-body p-0">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item">
                                            <h6 class="fw-semibold mb-3">About</h6>
                                            <div>
                                                <p class="text-muted">Hi, I'm John Doe, a passionate Software Engineer with over 8 years of experience in developing full-stack applications. My expertise lies in JavaScript, Node.js, and React, which I’ve used to build scalable web applications and optimize performance across various platforms. I am a problem-solver at heart, and I love tackling complex challenges while ensuring my code is clean and efficient.</p>
                                                <p class="text-muted">I believe in continuous learning and always strive to stay updated with the latest technologies in the industry. I am well-versed in both front-end and back-end development, allowing me to contribute to all phases of software development. I’m also passionate about working in agile environments, collaborating with cross-functional teams to meet project goals and deadlines.</p>
                                                <p class="mb-0 text-muted">When I’m not coding, you’ll find me mentoring junior developers, where I share my knowledge and help others grow in their careers. I’m always looking for new opportunities to push the boundaries of technology and contribute to innovative projects. I thrive in a team-oriented environment and am excited to collaborate with others to create impactful solutions.</p>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <h6 class="fw-semibold mb-3">Projects</h6>
                                            <div class="row">
                                                <div class="col-xl-6">
                                                    <div class="card custom-card">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-start gap-3 mb-4 flex-wrap">
                                                                <div>
                                                                    <span class="avatar avatar-lg avatar-rounded bg-light">
                                                                        <img src="<?php echo $baseUrl; ?>/assets/images/company-logos/1.png" alt="">
                                                                    </span>
                                                                </div>
                                                                <div class="flex-fill w-50">
                                                                    <a href="javascript:void(0);" class="fw-semibold fs-14 d-block text-truncate project-list-title">Weather Forecast Web App</a>
                                                                    <span class="d-block text-muted fs-13">A weather forecasting application using React and OpenWeatherMap API.</span>
                                                                </div>
                                                                <a href="javascript:void(0);" class="btn btn-primary-light"><i class="ti ti-eye me-1 align-middle"></i>View</a>
                                                            </div>
                                                            <div class="d-flex align-items-center flex-wrap justify-content-between">
                                                                <div>
                                                                    <span class="text-muted fs-11 d-block">Assigned Date :</span>
                                                                    <span class="fw-semibold d-block">January 10, 2025</span>
                                                                </div>
                                                                <div>
                                                                    <span class="text-muted fs-11 d-block">Status :</span>
                                                                    <span class="badge bg-success-transparent">Completed</span>
                                                                </div>
                                                                <div class="text-end">
                                                                    <span class="text-muted fs-11 d-block">Due Date :</span>
                                                                    <span class="fw-semibold d-block">June 15, 2025</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xl-6">
                                                    <div class="card custom-card">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-start gap-3 mb-4 flex-wrap">
                                                                <div>
                                                                    <span class="avatar avatar-lg avatar-rounded bg-light">
                                                                        <img src="<?php echo $baseUrl; ?>/assets/images/company-logos/10.png" alt="">
                                                                    </span>
                                                                </div>
                                                                <div class="flex-fill w-50">
                                                                    <a href="javascript:void(0);" class="fw-semibold fs-14 d-block text-truncate project-list-title">E-Commerce Website</a>
                                                                    <span class="d-block text-muted fs-13">Developed a full-stack e-commerce site using Node.js and MongoDB.</span>
                                                                </div>
                                                                <a href="javascript:void(0);" class="btn btn-primary-light"><i class="ti ti-eye me-1 align-middle"></i>View</a>
                                                            </div>
                                                            <div class="d-flex align-items-center flex-wrap justify-content-between">
                                                                <div>
                                                                    <span class="text-muted fs-11 d-block">Assigned Date :</span>
                                                                    <span class="fw-semibold d-block">March 1, 2025</span>
                                                                </div>
                                                                <div>
                                                                    <span class="text-muted fs-11 d-block">Status :</span>
                                                                    <span class="badge bg-success-transparent">Completed</span>
                                                                </div>
                                                                <div class="text-end">
                                                                    <span class="text-muted fs-11 d-block">Due Date :</span>
                                                                    <span class="fw-semibold d-block">September 30, 2025</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="row gy-3">
                                                <div class="col-xl-6">
                                                    <h6 class="fw-semibold mb-3">
                                                        Certifications
                                                    </h6>   
                                                    <ul class="list-group">
                                                        <li class="list-group-item">
                                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                                <div class="fw-medium">Certified JavaScript Developer</div>
                                                                <div>-</div>
                                                                <div>Code Academy</div>
                                                                <div>-</div>
                                                                <div>2015</div>
                                                            </div>
                                                        </li>
                                                        <li class="list-group-item">
                                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                                <div class="fw-medium">Certified Scrum Master</div>
                                                                <div>-</div>
                                                                <div>Scrum Alliance</div>
                                                                <div>-</div>
                                                                <div>2017</div>
                                                            </div>
                                                        </li>
                                                        <li class="list-group-item">
                                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                                <div class="fw-medium">Certified Full-Stack Web Developer</div>
                                                                <div>-</div>
                                                                <div>Code Academy</div>
                                                                <div>-</div>
                                                                <div>2023</div>
                                                            </div>
                                                        </li>
                                                        <li class="list-group-item">
                                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                                <div class="fw-medium">AWS Certified Solutions Architect</div>
                                                                <div>-</div>
                                                                <div>Web Services (AWS)</div>
                                                                <div>-</div>
                                                                <div>2024</div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="col-xl-6">
                                                    <h6 class="fw-semibold mb-3">
                                                        Job Preferences
                                                    </h6>   
                                                    <ul class="list-group">
                                                        <li class="list-group-item">
                                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                                <div class="fw-medium">Preferred Job Type:</div>
                                                                <div>Full-Time</div>
                                                            </div>
                                                        </li>
                                                        <li class="list-group-item">
                                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                                <div class="fw-medium">Preferred Salary:</div>
                                                                <div>$80,000 - $100,000 per year</div>
                                                            </div>
                                                        </li>
                                                        <li class="list-group-item">
                                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                                <div class="fw-medium">Availability:</div>
                                                                <div>Immediate</div>
                                                            </div>
                                                        </li>
                                                        <li class="list-group-item">
                                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                                <div class="fw-medium">Preferred Location:</div>
                                                                <div>Remote or New York</div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Experience Overview                                     
                                    </div>
                                </div>
                                <div class="card-body p-0 candidate-edu-timeline">
                                    <div class="p-4 border-bottom">
                                        <div class="d-flex align-items-start gap-3 flex-wrap flex-sm-nowrap">
                                            <div>
                                                <span class="avatar avatar-xl bg-light">
                                                    <img src="<?php echo $baseUrl; ?>/assets/images/company-logos/10.png" alt="">
                                                </span>
                                            </div>
                                            <div>
                                                <span class="d-block fw-medium fs-14 mb-1">Software Engineer (June 2014 - Present)</span>
                                                <div class="d-flex gap-2 mb-3 flex-wrap">
                                                    <span class="d-block">Tech Innovations Inc.</span>
                                                    <div class="mb-0 fs-13 text-muted"><i class="bi bi-geo-alt me-1 align-middle"></i>New York, USA</div>
                                                </div>
                                                <div class="fw-semibold mb-2">Key Responsibilities :</div>
                                                <ol class="list-group border-0 list-bullets">
                                                    <li class="border-0 py-1">Develop and maintain web applications.</li>
                                                    <li class="border-0 py-1">Collaborate with cross-functional teams.</li> 
                                                    <li class="border-0 py-1">Write clean and scalable code using JavaScript, React, and Node.js.</li> 
                                                </ol>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="p-4">
                                        <div class="d-flex align-items-start gap-3 flex-wrap flex-sm-nowrap">
                                            <div>
                                                <span class="avatar avatar-xl bg-light">
                                                    <img src="<?php echo $baseUrl; ?>/assets/images/company-logos/4.png" alt="">
                                                </span>
                                            </div>
                                            <div>
                                                <div class="fw-medium fs-14 mb-1">Junior Developer (May 2012 - May 2014)</div>
                                                <div class="d-flex gap-2 mb-3 flex-wrap">
                                                    <div>CodeLabs Pvt Ltd.</div>
                                                    <div class="mb-0 fs-13 text-muted"><i class="bi bi-geo-alt me-1"></i>San Francisco, USA</div>
                                                </div>
                                                <div class="fw-medium mb-2">Key Responsibilities :</div>
                                                <ol class="list-group border-0 list-bullets">
                                                    <li class="border-0 py-1">Assisted in designing and developing software solutions.</li>
                                                    <li class="border-0 py-1">Wrote unit tests and ensured software stability.</li> 
                                                    <li class="border-0 py-1">Supported senior developers in various projects.</li> 
                                                </ol>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>     
                        </div>
                        <div class="col-xxl-3 col-xl-4">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Personal Information
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled candidate-personal-info-list">
                                        <li>
                                            <div class="d-flex align-items-start gap-2 justify-content-between">
                                                <span class="d-block text-muted  d-inline-flex align-items-center"><i class="ti ti-mail me-2 align-middle fs-16"></i>Email</span>
                                                <span class="fw-medium d-block text-end text-truncate">johndoe@example.com
                                                </span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2 justify-content-between">
                                                <span class="d-block text-muted  d-inline-flex align-items-center"><i class="ti ti-phone me-2 align-middle fs-16"></i>Phone</span>
                                                <span class="fw-medium d-block text-end">+1 234 567 8901
                                                </span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2 justify-content-between">
                                                <span class="d-block text-muted  d-inline-flex align-items-center"><i class="ti ti-gender-female me-2 align-middle fs-16"></i>Gender</span>
                                                <span class="fw-medium d-block text-end">Male
                                                </span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2 justify-content-between">
                                                <span class="d-block text-muted  d-inline-flex align-items-center"><i class="ti ti-cake me-2 align-middle fs-16"></i>Date of Birth</span>
                                                <span class="fw-medium d-block text-end">January 15, 1990</span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2 justify-content-between">
                                                <span class="d-block text-muted  d-inline-flex align-items-center"><i class="ti ti-flag me-2 align-middle fs-16"></i>Nationality</span>
                                                <span class="fw-medium d-block text-end">American
                                                </span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2 justify-content-between">
                                                <span class="d-block text-muted  d-inline-flex align-items-center"><i class="ti ti-language me-2 align-middle fs-16"></i>Languages Known</span>
                                                <span class="fw-medium d-block text-end">English, Spanish
                                                </span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-start gap-2 justify-content-between">
                                                <span class="d-block text-muted  d-inline-flex align-items-center personal-info-type"><i class="ti ti-map-pin me-2 align-middle fs-16"></i>Address</span>
                                                <span class="fw-medium d-block text-end">1234 Elm Street,New York,10001,United States
                                                </span>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Skills
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled job-candidate-skills-list">
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                <span class="d-block">
                                                    JavaScript
                                                </span>
                                                <span class="d-block fw-medium">80%</span>
                                            </div>
                                            <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar progress-bar-striped" style="width: 80%">
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                <span class="d-block">
                                                    Python
                                                </span>
                                                <span class="d-block fw-medium">64%</span>
                                            </div>
                                            <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="64" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-warning progress-bar-striped" style="width: 64%">
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                <span class="d-block">
                                                    React
                                                </span>
                                                <span class="d-block fw-medium">53%</span>
                                            </div>
                                            <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="53" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-success progress-bar-striped" style="width: 53%">
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                <span class="d-block">
                                                    Node.js
                                                </span>
                                                <span class="d-block fw-medium">90%</span>
                                            </div>
                                            <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-info progress-bar-striped" style="width: 90%">
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                <span class="d-block">
                                                    Mongo DB
                                                </span>
                                                <span class="d-block fw-medium">35%</span>
                                            </div>
                                            <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="35" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-danger progress-bar-striped" style="width: 35%">
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                <span class="d-block">
                                                    My SQL
                                                </span>
                                                <span class="d-block fw-medium">70%</span>
                                            </div>
                                            <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-secondary progress-bar-striped" style="width: 70%">
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card custom-card overflow-hidden">
                                <div class="card-header">
                                    <div class="card-title">
                                        Portfolio
                                    </div>
                                </div>
                                <div class="card-body d-flex flex-wrap gap-2">
                                    <div class="btn-list">
                                        <a href="javascript:void(0);" class="btn btn-pink btn-icon rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Dribbble">
                                            <i class="ti ti-brand-dribbble"></i>
                                        </a>
                                        <a href="javascript:void(0);" class="btn btn-github btn-icon rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Github">
                                            <i class="ti ti-brand-github"></i>
                                        </a>
                                        <a href="javascript:void(0);" class="btn btn-primary btn-icon rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Behance">
                                            <i class="ti ti-brand-behance"></i>
                                        </a>
                                        <a href="javascript:void(0);" class="btn btn-success btn-icon rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Web">
                                            <i class="ti ti-world"></i>
                                        </a>
                                        <a href="javascript:void(0);" class="btn btn-danger btn-icon rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Pinterest">
                                            <i class="ti ti-brand-pinterest"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End::row-2 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Swiper JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/swiper/swiper-bundle.min.js"></script>

        <!-- Candidate Details JS -->
        <script src="<?php echo $baseUrl; ?>/assets/js/job-candidate-details.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
