
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/nouislider/nouislider.min.css">

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Search Candidate</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Jobs</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Search Candidate</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start::row-1 -->
                    <div class="row">
                        <div class="col-xxl-3">
                            <div class="card custom-card products-navigation-card">
                                <div class="card-body p-0">
                                    <div class="px-2 py-4 px-sm-4 border-bottom">
                                        <h6 class="fw-medium mb-0">Categories</h6>
                                        <div class="px-2 py-3 pb-0">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="c-1" checked>
                                                <label class="form-check-label" for="c-1">
                                                    Software Engineer
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">2,712</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="c-2">
                                                <label class="form-check-label" for="c-2">
                                                    Data Analyst
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">536</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="c-3" checked>
                                                <label class="form-check-label" for="c-3">
                                                    Product Manager
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">18,289</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="c-4" checked>
                                                <label class="form-check-label" for="c-4">
                                                    UI/UX Designer
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">3,453</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="c-5">
                                                <label class="form-check-label" for="c-5">
                                                    HR Manager
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">7,165</span>
                                            </div>
                                            <div class="collapse" id="category-more">
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="c-6">
                                                    <label class="form-check-label" for="c-6">
                                                        Marketing Specialist
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">5,964</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="c-7">
                                                    <label class="form-check-label" for="c-7">
                                                        Sales Manager
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">2,123</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="c-8">
                                                    <label class="form-check-label" for="c-8">
                                                        Customer Support Lead
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">1,645</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="c-9">
                                                    <label class="form-check-label" for="c-9">
                                                        Full Stack Developer
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">1,432</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="c-10">
                                                    <label class="form-check-label" for="c-10">
                                                        Network Administrator
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">1,231</span>
                                                </div>
                                            </div>
                                            <a class="badge bg-primary-transparent" data-bs-toggle="collapse" href="#category-more" role="button" aria-expanded="false" aria-controls="category-more">More</a>
                                        </div>
                                    </div>
                                    <div class="px-2 py-4 px-sm-4 border-bottom">
                                        <h6 class="fw-medium mb-0">Notice Period</h6>
                                        <div class="px-2 py-3 pb-0">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="available-1" checked>
                                                <label class="form-check-label" for="available-1">
                                                    Immediate
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">512</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="available-2">
                                                <label class="form-check-label" for="available-2">
                                                    1 Week
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">2,186</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="available-3">
                                                <label class="form-check-label" for="available-3">
                                                    2 Weeks
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">734</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="available-4">
                                                <label class="form-check-label" for="available-4">
                                                    1 Month
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">734</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="available-5">
                                                <label class="form-check-label" for="available-5">
                                                    2 Months
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">734</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="available-6">
                                                <label class="form-check-label" for="available-6">
                                                    3+ Months
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">734</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="px-2 py-4 px-sm-4 border-bottom">
                                        <h6 class="fw-medium mb-0">Job Type</h6>
                                        <div class="px-2 py-3 pb-0">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="j-1" checked>
                                                <label class="form-check-label" for="j-1">
                                                    Full Time
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">512</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="j-2" checked>
                                                <label class="form-check-label" for="j-2">
                                                    Part Time
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">2,186</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="j-3" checked>
                                                <label class="form-check-label" for="j-3">
                                                    Internship
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">734</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="j-4">
                                                <label class="form-check-label" for="j-4">
                                                    Freelancer
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">16</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="j-5">
                                                <label class="form-check-label" for="j-5">
                                                    Remote Job
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">1,432</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="px-2 py-4 px-sm-4 border-bottom">
                                        <h6 class="fw-medium mb-0">Salary Range</h6>
                                        <div class="px-2 py-3 pb-0">
                                            <div id="nonlinear"></div>
                                            <div class="d-flex mt-4 justify-content-center">
                                                <div class="fw-medium h6 mb-0">$<span id="lower-value"></span></div>
                                                &nbsp; -- &nbsp; 
                                                <div class="fw-medium h6 mb-0">$<span id="upper-value"></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="px-2 py-4 px-sm-4 border-bottom">
                                        <h6 class="fw-medium mb-0">Qualification</h6>
                                        <div class="px-2 py-3 pb-0">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="q-1">
                                                <label class="form-check-label" for="q-1">
                                                    High School
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">16,563</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="q-2" checked>
                                                <label class="form-check-label" for="q-2">
                                                    Associate Degree
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">15,234</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="q-3">
                                                <label class="form-check-label" for="q-3">
                                                    Bachelor’s Degree
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">6,278</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="q-4" checked>
                                                <label class="form-check-label" for="q-4">
                                                    Master’s Degree
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">4,531</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="q-5">
                                                <label class="form-check-label" for="q-5">
                                                    PhD
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">2,405</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="q-6">
                                                <label class="form-check-label" for="q-6">
                                                    Diploma/Certification
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">2,142</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="px-2 py-4 px-sm-4">
                                        <h6 class="fw-medium mb-0">Skills</h6>
                                        <div class="px-2 py-3 pb-0">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="s-1" checked>
                                                <label class="form-check-label" for="s-1">
                                                    JavaScript
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">23,156</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="s-2" checked>
                                                <label class="form-check-label" for="s-2">
                                                    Python
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">15,632</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="s-3">
                                                <label class="form-check-label" for="s-3">
                                                    React
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">15,032</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input me-2" type="checkbox" value="" id="s-4" checked>
                                                <label class="form-check-label" for="s-4">
                                                    Node.js
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">7,154</span>
                                            </div>
                                            <div class="collapse" id="sizes-more">
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="s-5">
                                                    <label class="form-check-label" for="s-5">
                                                        SQL
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">5,946</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="s-6">
                                                    <label class="form-check-label" for="s-6">
                                                        Product Management
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">3,267</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="s-7">
                                                    <label class="form-check-label" for="s-7">
                                                        Agile/Scrum
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">578</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="s-8">
                                                    <label class="form-check-label" for="s-8">
                                                        Data Analysis
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">142</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="s-9">
                                                    <label class="form-check-label" for="s-9">
                                                        Digital Marketing
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">633</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="s-10">
                                                    <label class="form-check-label" for="s-10">
                                                        UX/UI Design
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">452</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="s-11">
                                                    <label class="form-check-label" for="s-11">
                                                        Networking
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">32</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input me-2" type="checkbox" value="" id="s-12">
                                                    <label class="form-check-label" for="s-12">
                                                        CRM Software
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">12</span>
                                                </div>
                                            </div>
                                            <a class="badge bg-primary-transparent" data-bs-toggle="collapse" href="#sizes-more" role="button" aria-expanded="false" aria-controls="sizes-more">More</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-9">
                            <div class="row align-items-center">
                                <div class="col-lg-12">
                                    <div class="card custom-card border-0 shadow-none">
                                        <div class="card-body p-md-0">
                                            <div class="input-group companies-search-input">
                                                <input type="text" class="form-control form-control-lg w-25" aria-label="Text input with segmented dropdown button" placeholder="Enter your keyword here">
                                                <select class="form-select form-select-lg rounded-0" data-trigger>
                                                    <option value="">All Categories</option>
                                                    <option value="Choice 1">Software Dveloper</option>
                                                    <option value="Choice 2">Web Developer</option>
                                                    <option value="Choice 3">Software Architect</option>
                                                    <option value="Choice 4">IT Hardware</option>
                                                    <option value="Choice 5">Network Engineer</option>
                                                    <option value="Choice 6">Angular Developer</option>
                                                    <option value="Choice 7">React Developer</option>
                                                </select>
                                                <input type="text" class="form-control form-control-lg w-25" aria-label="Text input with segmented dropdown button" placeholder="Search by location">
                                                <select class="form-select form-select-lg rounded-0" data-trigger>
                                                    <option value="Choice 1">Fresher's</option>
                                                    <option value="Choice 2">1 Year Exp</option>
                                                    <option value="Choice 3">2 Year Exp</option>
                                                    <option value="Choice 4">3 Year Exp</option>
                                                    <option value="Choice 5">4 Year Exp</option>
                                                    <option value="Choice 6">5 Years Exp</option>
                                                </select>
                                                <button type="button" class="btn btn-lg btn-primary"><i class="ri-search-line"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-body">
                                            <div class="d-flex flex-wrap gap-2 align-items-center">
                                                <h5 class="fw-medium mb-0 flex-grow-1">1287 <span class="fw-normal fs-18">Candidates match your search</span> </h5>
                                                <div class="btn-group">
                                                    <button class="btn btn-outline-light border dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        Sort By
                                                    </button>
                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Premium</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Newest</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Most Relevant</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Fresher</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Experienced</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Flexible Shift</a></li>
                                                        <li><a class="dropdown-item" href="javascript:void(0);">Day Shift</a></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card overflow-hidden border-bottom-0">
                                        <div class="card-body p-0">
                                            <div class="table-responsive">
                                                <table class="table text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th>Details</th>
                                                            <th>Education</th>
                                                            <th>Skills</th>
                                                            <th>Job Type</th>
                                                            <th>Salary Expectation</th>
                                                            <th>Notice Period</th>
                                                            <th class="text-center">Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">John Doe</span>
                                                                            <span class="">Software Engineer</span>
                                                                            <span class="text-muted fs-13 d-block mb-1">New York, NY</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 5 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                B.Tech in CS
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-primary-transparent">
                                                                        JavaScript
                                                                    </span>
                                                                    <span class="badge bg-info-transparent">React</span>
                                                                    <span class="badge bg-warning-transparent">React</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$70,000 - $90,000</span>
                                                            </td>
                                                            <td>
                                                                2 Weeks
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">Alice Smith</span>
                                                                            <span class="">Data Analyst</span>
                                                                            <span class="text-muted fs-13 d-block">London, UK</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 3 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                M.Sc in Data Science
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-secondary-transparent">
                                                                        Python
                                                                    </span>
                                                                    <span class="badge bg-success-transparent">SQL</span>
                                                                    <span class="badge bg-danger-transparent">Tableau</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$60,000 - $75,000</span>
                                                            </td>
                                                            <td>
                                                                Immediate
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">Mark Johnson</span>
                                                                            <span class="">Product Manager</span>
                                                                            <span class="text-muted fs-13 d-block">San Francisco, CA</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 6 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                MBA in Marketing
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-teal-transparent">
                                                                        Product Management
                                                                    </span>
                                                                    <span class="badge bg-warning-transparent">Agile</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$100,000 - $120,000</span>
                                                            </td>
                                                            <td>
                                                                1 Month
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">Sarah Williams</span>
                                                                            <span class="">UI/UX Designer</span>
                                                                            <span class="text-muted fs-13 d-block">Berlin, Germany</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 4 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                B.Des in Design
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-primary-transparent">
                                                                        Figma
                                                                    </span>
                                                                    <span class="badge bg-pink-transparent">Adobe XD</span>
                                                                    <span class="badge bg-purple-transparent">HTML</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$55,000 - $70,000</span>
                                                            </td>
                                                            <td>
                                                                2 Weeks
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">David Brown</span>
                                                                            <span class="">Marketing Specialist</span>
                                                                            <span class="text-muted fs-13 d-block">Tokyo, Japan</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 4 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                B.A. in Marketing
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-success-transparent">
                                                                        SEO
                                                                    </span>
                                                                    <span class="badge bg-danger-transparent">Google Analytics</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$45,000 - $60,000</span>
                                                            </td>
                                                            <td>
                                                                Immediate
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">Emma White</span>
                                                                            <span class="">HR Manager</span>
                                                                            <span class="text-muted fs-13 d-block">Mumbai, India</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 7 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                MBA in HR
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-primary-transparent">
                                                                        Recruitment
                                                                    </span>
                                                                    <span class="badge bg-pink-transparent">Training</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$65,000 - $85,000</span>
                                                            </td>
                                                            <td>
                                                                1 Month
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">James Green</span>
                                                                            <span class="">Full Stack Developer</span>
                                                                            <span class="text-muted fs-13 d-block">Singapore</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 5 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                B.Tech in IT
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-primary-transparent">
                                                                        JavaScript
                                                                    </span>
                                                                    <span class="badge bg-secondary-transparent">Node.js</span>
                                                                    <span class="badge bg-info-transparent">MongoDB</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$75,000 - $95,000</span>
                                                            </td>
                                                            <td>
                                                                2 Weeks
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/6.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">Linda Harris</span>
                                                                            <span class="">Network Administrator</span>
                                                                            <span class="text-muted fs-13 d-block">Toronto, Canada</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 3 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                B.Sc in Networking
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-primary-transparent">
                                                                        Networking
                                                                    </span>
                                                                    <span class="badge bg-danger-transparent">Cisco</span>
                                                                    <span class="badge bg-teal-transparent">VPN</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$50,000 - $70,000</span>
                                                            </td>
                                                            <td>
                                                                Immediate
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/15.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">Chris Black</span>
                                                                            <span class="">Sales Manager</span>
                                                                            <span class="text-muted fs-13 d-block">Paris, France</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 5 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                B.Com in Sales
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-purple-transparent">
                                                                        Sales Strategy
                                                                    </span>
                                                                    <span class="badge bg-orange-transparent">Negotiation</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$60,000 - $80,000</span>
                                                            </td>
                                                            <td>
                                                                1 Month
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div>
                                                                    <div class="d-flex align-items-start gap-3">
                                                                        <div class="lh-1">
                                                                            <span class="avatar avatar-lg">
                                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/7.jpg" alt="">
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="fw-semibold d-block">Laura Adams</span>
                                                                            <span class="">Customer Support Lead</span>
                                                                            <span class="text-muted fs-13 d-block">Sydney, Australia</span>
                                                                            <span href="javascript:void(0);" class="badge badge-md rounded-pill bg-primary-transparent"><i class="bi bi-briefcase me-1 align-middle"></i>Exp : 4 Years</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                B.A. in Communication
                                                            </td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-1 skills-container flex-wrap">
                                                                    <span class="badge bg-success-transparent">
                                                                        Customer Service
                                                                    </span>
                                                                    <span class="badge bg-warning-transparent">CRM</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                Full-Time
                                                            </td>
                                                            <td>
                                                                <span class="fw-medium">$45,000 - $55,000</span>
                                                            </td>
                                                            <td>
                                                                Immediate
                                                            </td>
                                                            <td class="text-center">
                                                                <div class="dropdown"> 
                                                                    <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                                    <ul class="dropdown-menu"> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-file-text me-2"></i>Download CV</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-eye me-2"></i>View</a></li> 
                                                                        <li><a class="dropdown-item d-inline-flex align-items-center" href="javascript:void(0);"><i class="ti ti-checklist me-2"></i>Shortlist</a></li> 
                                                                    </ul> 
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <ul class="pagination mb-4 justify-content-end">
                                <li class="page-item disabled">
                                    <a class="page-link" href="javascript:void(0);">
                                        Prev
                                    </a>
                                </li>
                                <li class="page-item active"><a class="page-link" href="javascript:void(0);">1</a></li>
                                <li class="page-item"><a class="page-link" href="javascript:void(0);">2</a></li>
                                <li class="page-item"><a class="page-link" href="javascript:void(0);">3</a></li>
                                <li class="page-item">
                                    <a class="page-link text-primary" href="javascript:void(0);">
                                        next
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <!--End::row-1 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- noUiSlider JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/nouislider/nouislider.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/wnumb/wNumb.min.js"></script>

        <!-- Search Candidate JS -->
        <script src="<?php echo $baseUrl; ?>/assets/js/job-search-candidate.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
