
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Task List View</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Apps</a></li>
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Task</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Task List View</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start::row-2 -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="row">
                                <div class="col-xl-3 col-lg-6">
                                    <div class="card custom-card dashboard-main-card primary">
                                        <div class="card-body p-4">
                                            <div class="d-flex align-items-start gap-3">
                                                <div class="flex-fill">
                                                    <h6 class="mb-2 fs-12">New Tasks</h6> 
                                                    <div class="pb-0 mt-0"> 
                                                        <div> 
                                                            <div class="d-flex align-items-center gap-2 mb-2">
                                                                <h4 class="fw-medium mb-0"><span class="count-up" data-count="42">42</span> </h4> 
                                                                <span class="badge bg-primary">12,345</span>
                                                            </div>
                                                            <p class="text-muted fs-11 mb-0 lh-1">
                                                                <span class="text-success me-1 fw-medium">
                                                                    <i class="ri-arrow-up-s-line me-1 align-middle"></i>3.25%
                                                                </span>
                                                                <span>this month</span>
                                                            </p>
                                                        </div> 
                                                    </div> 
                                                </div>
                                                <div class="avatar avatar-lg bg-primary-transparent mb-3 svg-primary mx-auto"> 
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M216,40H40A16,16,0,0,0,24,56V208a8,8,0,0,0,11.58,7.15L64,200.94l28.42,14.21a8,8,0,0,0,7.16,0L128,200.94l28.42,14.21a8,8,0,0,0,7.16,0L192,200.94l28.42,14.21A8,8,0,0,0,232,208V56A16,16,0,0,0,216,40ZM176,144H80a8,8,0,0,1,0-16h96a8,8,0,0,1,0,16Zm0-32H80a8,8,0,0,1,0-16h96a8,8,0,0,1,0,16Z"/></svg>
                                                </div> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-3 col-lg-6">
                                    <div class="card custom-card dashboard-main-card secondary">
                                        <div class="card-body p-4">
                                            <div class="d-flex align-items-start gap-3">
                                                <div class="flex-fill">
                                                    <h6 class="mb-2 fs-12">Completed Tasks</h6> 
                                                    <div> 
                                                        <div class="d-flex align-items-center gap-2 mb-2">
                                                            <h4 class="fw-medium mb-0"><span class="count-up" data-count="320">320</span></h4> 
                                                            <span class="badge bg-secondary">4,176</span>
                                                        </div>    
                                                        <p class="text-muted fs-11 mb-0 lh-1">
                                                            <span class="text-danger me-1 fw-medium">
                                                                <i class="ri-arrow-down-s-line me-1 align-middle"></i>1.16%
                                                            </span>
                                                            <span>this month</span>
                                                        </p>
                                                    </div> 
                                                </div>
                                                <div class="avatar avatar-lg bg-secondary-transparent mb-3 svg-secondary mx-auto"> 
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M128,24A104,104,0,1,0,232,128,104.11,104.11,0,0,0,128,24Zm45.66,85.66-56,56a8,8,0,0,1-11.32,0l-24-24a8,8,0,0,1,11.32-11.32L112,148.69l50.34-50.35a8,8,0,0,1,11.32,11.32Z"/></svg>
                                                </div> 
                                            </div>    
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-3 col-lg-6">
                                    <div class="card custom-card dashboard-main-card success">
                                        <div class="card-body p-4">
                                            <div class="d-flex align-items-start gap-3">
                                                <div class="flex-fill">
                                                    <h6 class="mb-2 fs-12">Pending Tasks</h6> 
                                                    <div> 
                                                        <div class="d-flex align-items-center gap-2 mb-2">
                                                            <h4 class="fw-medium mb-0"><span class="count-up" data-count="81">81</span></h4> 
                                                            <span class="badge bg-success">7,064</span>
                                                        </div>    
                                                        <p class="text-muted fs-11 mb-0 lh-1">
                                                            <span class="text-success me-1 fw-medium">
                                                                <i class="ri-arrow-up-s-line me-1 align-middle"></i>0.25%
                                                            </span>
                                                            <span>this month</span>
                                                        </p>
                                                    </div> 
                                                </div>
                                                <div class="avatar avatar-lg bg-success-transparent mb-3 svg-success mx-auto"> 
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M100,116.43a8,8,0,0,0,4-6.93v-72A8,8,0,0,0,93.34,30,104.06,104.06,0,0,0,25.73,147a8,8,0,0,0,4.52,5.81,7.86,7.86,0,0,0,3.35.74,8,8,0,0,0,4-1.07ZM88,49.62v55.26L40.12,132.51C40,131,40,129.48,40,128A88.12,88.12,0,0,1,88,49.62ZM232,128A104,104,0,0,1,38.32,180.7a8,8,0,0,1,2.87-11L120,123.83V32a8,8,0,0,1,8-8,104.05,104.05,0,0,1,89.74,51.48c.11.16.21.32.31.49s.2.37.29.55A103.34,103.34,0,0,1,232,128Z"/></svg>
                                                </div> 
                                            </div>    
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-3 col-lg-6">
                                    <div class="card custom-card dashboard-main-card warning">
                                        <div class="card-body p-4">
                                            <div class="d-flex align-items-start gap-3">
                                                <div class="flex-fill">
                                                    <h6 class="mb-2 fs-12">Inprogress Tasks</h6> 
                                                    <div> 
                                                        <div class="d-flex align-items-center gap-2 mb-2">
                                                            <h4 class="fw-medium mb-0"><span class="count-up" data-count="33">33</span>K</h4> 
                                                            <span class="badge bg-warning border">1,105</span>
                                                        </div>    
                                                        <p class="text-muted fs-11 mb-0 lh-1">
                                                            <span class="text-success me-1 fw-semibFold">
                                                                <i class="ri-arrow-up-s-line me-1 align-middle"></i>0.46%
                                                            </span>
                                                            <span>this month</span>
                                                        </p>
                                                    </div> 
                                                </div>
                                                <div class="avatar avatar-lg bg-warning-transparent mb-3 svg-warning mx-auto"> 
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M200,75.64V40a16,16,0,0,0-16-16H72A16,16,0,0,0,56,40V76a16.07,16.07,0,0,0,6.4,12.8L114.67,128,62.4,167.2A16.07,16.07,0,0,0,56,180v36a16,16,0,0,0,16,16H184a16,16,0,0,0,16-16V180.36a16.09,16.09,0,0,0-6.35-12.77L141.27,128l52.38-39.59A16.09,16.09,0,0,0,200,75.64ZM184,40V64H72V40Zm0,176H72V180l56-42,56,42.35Z"/></svg>
                                                </div> 
                                            </div>    
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-12 col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Total Tasks
                                    </div>
                                    <div class="d-flex">
                                        <button class="btn btn-sm btn-primary btn-wave waves-light" data-bs-toggle="modal" data-bs-target="#create-task"><i class="ri-add-line fw-medium align-middle me-1"></i> Create Task</button>
                                        <div class="dropdown ms-2">
                                            <button class="btn btn-icon btn-secondary-light btn-sm btn-wave waves-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i class="ti ti-dots-vertical"></i>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><a class="dropdown-item" href="javascript:void(0);">New Tasks</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Pending Tasks</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Completed Tasks</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Inprogress Tasks</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table text-nowrap">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>
                                                        <input class="form-check-input check-all" type="checkbox" id="all-tasks" value="" aria-label="...">
                                                    </th>
                                                    <th scope="col">Task</th>
                                                    <th scope="col">Task ID</th>
                                                    <th scope="col">Assigned Date</th>
                                                    <th scope="col">Status</th>
                                                    <th scope="col">Due Date</th>
                                                    <th scope="col">Priority</th>
                                                    <th scope="col">Assigned To</th>
                                                    <th scope="col">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..."></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Design Homepage</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1001</span>
                                                    </td>
                                                    <td>
                                                        2025-03-01
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-orange">In Progress</span>
                                                    </td>
                                                    <td>
                                                        2025-03-10
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-danger-transparent">High</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                            </span>
                                                            <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                                +2
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..." checked></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Implement Login Feature</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1002</span>
                                                    </td>
                                                    <td>
                                                        2025-03-02
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-success">Completed</span>
                                                    </td>
                                                    <td>
                                                        2025-03-05
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-warning-transparent">Medium</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="img">
                                                            </span>
                                                            <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                                +4
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..."></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Develop Admin Dashboard</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1003</span>
                                                    </td>
                                                    <td>
                                                        2025-03-03
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-info">Pending</span>
                                                    </td>
                                                    <td>
                                                        2025-03-15
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-danger-transparent">High</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/9.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="img">
                                                            </span>
                                                            <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                                +5
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..."></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Fix Bugs in User Profile</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1004</span>
                                                    </td>
                                                    <td>
                                                        2025-03-04
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-orange">In Progress</span>
                                                    </td>
                                                    <td>
                                                        2025-03-12
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-teal-transparent">Low</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                            </span>
                                                            <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                                +2
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..." checked></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Update API Integration</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1005</span>
                                                    </td>
                                                    <td>
                                                        2025-03-05
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-success">Completed</span>
                                                    </td>
                                                    <td>
                                                        2025-03-06
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-danger-transparent">High</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/15.jpg" alt="img">
                                                            </span>
                                                            <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                                +3
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..." checked></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Create User Notifications</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1006</span>
                                                    </td>
                                                    <td>
                                                        2025-03-06
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-info">Pending</span>
                                                    </td>
                                                    <td>
                                                        2025-03-20
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-warning-transparent">Medium</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="img">
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..."></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Test Payment Gateway</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1007</span>
                                                    </td>
                                                    <td>
                                                        2025-03-07
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-orange">In Progress</span>
                                                    </td>
                                                    <td>
                                                        2025-03-14
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-danger-transparent">High</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="img">
                                                            </span>
                                                            <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                                +1
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..." checked></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Implement Search Feature</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1008</span>
                                                    </td>
                                                    <td>
                                                        2025-03-08
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-success">Completed</span>
                                                    </td>
                                                    <td>
                                                        2025-03-09
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-teal-transparent">Low</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/9.jpg" alt="img">
                                                            </span>
                                                            <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                                +2
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..."></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Set Up Analytics Dashboard</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1009</span>
                                                    </td>
                                                    <td>
                                                        2025-03-09
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-info">Pending</span>
                                                    </td>
                                                    <td>
                                                        2025-03-25
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-warning-transparent">Medium</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="img">
                                                            </span>
                                                            <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                                +1
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                                <tr class="task-list">
                                                    <td class="task-checkbox"><input class="form-check-input" type="checkbox" value="" aria-label="..."></td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="fw-medium" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">Finalize Reporting Module</a>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">SPK-1010</span>
                                                    </td>
                                                    <td>
                                                        2025-03-10
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium text-orange">In Progress</span>
                                                    </td>
                                                    <td>
                                                        2025-03-18	
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-danger-transparent">High</span>
                                                    </td>
                                                    <td>
                                                        <div class="avatar-list-stacked">
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="img">
                                                            </span>
                                                            <span class="avatar avatar-sm avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/6.jpg" alt="img">
                                                            </span>
                                                            <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                                +4
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-primary-light btn-icon btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-edit-line"></i></button>
                                                        <button class="btn btn-danger-light btn-icon ms-1 btn-sm task-delete-btn"><i class="ri-delete-bin-5-line"></i></button>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="card-footer border-top-0">
                                    <nav aria-label="Page navigation" class="pagination-style-2">
                                        <ul class="pagination mb-0 flex-wrap justify-content-end">
                                            <li class="page-item disabled">
                                                <a class="page-link" href="javascript:void(0);">
                                                    Prev
                                                </a>
                                            </li>
                                            <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                            <li class="page-item active"><a class="page-link" href="javascript:void(0);">2</a></li>
                                            <li class="page-item">
                                                <a class="page-link" href="javascript:void(0);">
                                                    <i class="bi bi-three-dots"></i>
                                                </a>
                                            </li>
                                            <li class="page-item"><a class="page-link" href="javascript:void(0);">17</a></li>
                                            <li class="page-item">
                                                <a class="page-link text-primary" href="javascript:void(0);">
                                                    next
                                                </a>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--End::row-2 -->

                    <!-- Task Details Offcanvas -->
                    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
                        <div class="offcanvas-header">
                        <h5 class="offcanvas-title task-title" id="offcanvasRightLabel">Redesign Product Page</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                        </div>
                        <div class="offcanvas-body">
                            <div class="fs-15 fw-medium mb-2">Task Description :</div>
                            <p class="text-muted task-description mb-4 fs-13">The current product page layout is outdated and does not provide a smooth user experience across all devices. This task involves redesigning the product page to make it more visually appealing, responsive, and user-friendly.</p>
                            <div class="card custom-card overflow-hidden border-0 shadow-none">
                                <div class="card-body p-0">
                                    <ul class="list-unstyled task-additional-list">
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="lh-1">
                                                        <span class="avatar avatar-sm avatar-rounded bg-primary-transparent svg-primary text-primary">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><polyline points="88 136 112 160 168 104" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></polyline><circle cx="128" cy="128" r="96" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></circle></svg>
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="text-muted fs-13">Task ID :</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    SPK - 123
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="lh-1">
                                                        <span class="avatar avatar-sm avatar-rounded bg-secondary-transparent svg-secondary text-secondary">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><path d="M32,200H187.72a8,8,0,0,0,6.65-3.56L240,128,194.37,59.56A8,8,0,0,0,187.72,56H32l48,72Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path></svg>
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="text-muted fs-13">Task Tags :</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    <span class="badge bg-light border text-default">Web Design</span>
                                                    <span class="badge bg-light border text-default">Responsive Design</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="lh-1">
                                                        <span class="avatar avatar-sm avatar-rounded bg-warning-transparent svg-warning text-warning">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><path d="M200,224H56a8,8,0,0,1-8-8V40a8,8,0,0,1,8-8h96l56,56V216A8,8,0,0,1,200,224Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path><polyline points="148 32 148 92 208 92" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></polyline></svg>
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="text-muted fs-13">Project Name :</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    Digital Marketing Portal
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="lh-1">
                                                        <span class="avatar avatar-sm avatar-rounded bg-info-transparent svg-info-transparent text-info-transparent">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><path d="M42.34,138.34A8,8,0,0,1,40,132.69V40h92.69a8,8,0,0,1,5.65,2.34l99.32,99.32a8,8,0,0,1,0,11.31L153,237.66a8,8,0,0,1-11.31,0Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path><circle cx="88" cy="88" r="16"></circle></svg>
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="text-muted fs-13">Project Status :</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    <span class="fw-medium text-secondary">Inprogress</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="lh-1">
                                                        <span class="avatar avatar-sm avatar-rounded bg-success-transparent svg-success text-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><line x1="48" y1="224" x2="48" y2="56" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></line><path d="M48,176c64-55.43,112,55.43,176,0V56C160,111.43,112,.57,48,56" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path></svg>
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="text-muted fs-13">Project Priority :</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    <span class="badge bg-danger-transparent">High</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="lh-1">
                                                        <span class="avatar avatar-sm avatar-rounded bg-danger-transparent svg-danger text-danger">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><rect x="40" y="40" width="176" height="176" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></rect><line x1="176" y1="24" x2="176" y2="52" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></line><line x1="80" y1="24" x2="80" y2="52" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></line><line x1="40" y1="88" x2="216" y2="88" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></line></svg>
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="text-muted fs-13">Date Created :</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    24,Feb 2025
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="lh-1">
                                                        <span class="avatar avatar-sm avatar-rounded bg-teal-transparent svg-teal text-teal">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><rect x="40" y="40" width="176" height="176" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></rect><line x1="176" y1="24" x2="176" y2="52" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></line><line x1="80" y1="24" x2="80" y2="52" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></line><line x1="40" y1="88" x2="216" y2="88" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></line></svg>
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="text-muted fs-13">Due Date :</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    15,Mar 2025
                                                </div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="lh-1">
                                                        <span class="avatar avatar-sm avatar-rounded bg-pink-transparent svg-pink text-pink">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><circle cx="84" cy="108" r="52" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></circle><path d="M13,196a88,88,0,0,1,142,0" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path><path d="M172,160a87.86,87.86,0,0,1,71,36" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path><path d="M158.62,57.74A52,52,0,1,1,172,160" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path></svg>
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="text-muted fs-13">Assigned To :</span>
                                                    </div>
                                                </div>
                                                <div class="avatar-list-stacked">
                                                    <span class="avatar avatar-sm avatar-rounded" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-primary" data-bs-original-title="Simon">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                    </span>
                                                    <span class="avatar avatar-sm avatar-rounded" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-primary" data-bs-original-title="Sasha">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="img">
                                                    </span>
                                                    <span class="avatar avatar-sm avatar-rounded" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-primary" data-bs-original-title="Anagha">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                    </span>
                                                    <span class="avatar avatar-sm avatar-rounded" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-primary" data-bs-original-title="Hishen">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="img">
                                                    </span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card custom-card overflow-hidden">
                                <div class="card-header p-0">
                                    <ul class="nav nav-tabs nav-justified w-100 tab-style-8 scaleX activity-details-tabs" id="myTab4" role="tablist"> 
                                        <li class="nav-item" role="presentation"> 
                                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#sub-task" type="button" role="tab" aria-controls="sub-task" aria-selected="true">Sub Tasks<span class="badge bg-primary ms-2">8</span></button> 
                                        </li> 
                                        <li class="nav-item" role="presentation"> 
                                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#comments" type="button" role="tab" aria-controls="comments" aria-selected="false" tabindex="-1">Comments</button> 
                                        </li> 
                                        <li class="nav-item" role="presentation"> 
                                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#files" type="button" role="tab" aria-controls="files" aria-selected="false" tabindex="-1">Files</button> 
                                        </li> 
                                    </ul>
                                </div>
                                <div class="card-body">
                                    <div class="tab-content" id="myTabContent3">
                                        <div class="tab-pane overflow-hidden active show p-0 border-0" id="sub-task" role="tabpanel" aria-labelledby="sub-task" tabindex="0">
                                            <ul class="list-unstyled sub-tasks-list">
                                                <li>
                                                    <div class="form-check mb-0"> 
                                                        <input class="form-check-input form-checked-gray" type="checkbox" value="" id="subtask1" checked> 
                                                        <label class="form-check-label" for="subtask1">Creating new wireframes for the product page</label> 
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="form-check mb-0">
                                                        <input class="form-check-input form-checked-gray" type="checkbox" value="" id="subtask2"> 
                                                        <label class="form-check-label" for="subtask2">Updating the UI/UX design</label> 
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="form-check mb-0"> 
                                                        <input class="form-check-input form-checked-gray" type="checkbox" value="" id="subtask3"> 
                                                        <label class="form-check-label" for="subtask3">Integrating customer reviews section</label> 
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="form-check mb-0"> 
                                                        <input class="form-check-input form-checked-gray" type="checkbox" value="" id="subtask4" checked> 
                                                        <label class="form-check-label" for="subtask4">Optimizing for mobile devices</label> 
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="form-check mb-0"> 
                                                        <input class="form-check-input form-checked-gray" type="checkbox" value="" id="subtask5" checked> 
                                                        <label class="form-check-label" for="subtask5">Testing performance and functionality across browsers</label> 
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="form-check mb-0"> 
                                                        <input class="form-check-input form-checked-gray" type="checkbox" value="" id="subtask6"> 
                                                        <label class="form-check-label" for="subtask6">Set up user authentication backend</label> 
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="form-check mb-0"> 
                                                        <input class="form-check-input form-checked-gray" type="checkbox" value="" id="subtask7" checked> 
                                                        <label class="form-check-label" for="subtask7">Set up user authentication backend</label> 
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="form-check mb-0"> 
                                                        <input class="form-check-input form-checked-gray" type="checkbox" value="" id="subtask8"> 
                                                        <label class="form-check-label" for="subtask8">Implement password strength validation</label> 
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane overflow-hidden p-0 border-0" id="comments" role="tabpanel" aria-labelledby="comments" tabindex="0">
                                            <ul class="list-unstyled profile-timeline task-profile-timeline" id="task-comments-area">
                                                <li>
                                                    <div class="d-flex align-items-start">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-sm bg-primary-transparent avatar-rounded profile-timeline-avatar">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                                <div class="fw-medium d-flex align-items-center">John Doe<span class="badge bg-primary-transparent ms-2">Project Manager</span></div>
                                                                <div class="text-muted fs-13">10:15 AM</div>
                                                            </div>
                                                            <div class="fs-13 text-muted">
                                                                Let's make sure we prioritize the mobile responsiveness for this feature. We don’t want any issues on smaller screens &#128187;.
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-sm bg-primary-transparent avatar-rounded profile-timeline-avatar">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                                <div class="fw-medium d-flex align-items-center">Jane Smith<span class="badge bg-secondary-transparent ms-2">Developer</span></div>
                                                                <div class="text-muted fs-13">11:00 AM</div>
                                                            </div>
                                                            <div class="fs-13 text-muted">
                                                                The design is a bit tricky. I'm facing some alignment issues with the elements. Can someone take a look at it?&#128247;
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-sm bg-primary-transparent avatar-rounded profile-timeline-avatar">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                                <div class="fw-medium d-flex align-items-center">Alice Cooper<span class="badge bg-warning-transparent ms-2">UI Designer</span></div>
                                                                <div class="text-muted fs-13">1:45 PM</div>
                                                            </div>
                                                            <div class="fs-13 text-muted">
                                                                I’ve updated the mockups to better fit the requirements. Check them out and let me know if we need any tweaks &#128221;.
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-sm bg-primary-transparent avatar-rounded profile-timeline-avatar">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                                <div class="fw-medium d-flex align-items-center">Bob Brown<span class="badge bg-info-transparent ms-2">QA Tester</span></div>
                                                                <div class="text-muted fs-13">2:30 PM</div>
                                                            </div>
                                                            <div class="fs-13 text-muted">
                                                                I’ve tested the task on all browsers. The issue on Safari is resolved, but there’s still a minor glitch on Firefox &#128221;.
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-start">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-sm bg-primary-transparent avatar-rounded profile-timeline-avatar">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                                <div class="fw-medium d-flex align-items-center">Charlie Evans<span class="badge bg-success-transparent ms-2">Developer</span></div>
                                                                <div class="text-muted fs-13">3:00 PM</div>
                                                            </div>
                                                            <div class="fs-13 text-muted">
                                                                I’ve fixed the issue and pushed the update. The styling should be consistent across browsers now. Let me know if anything looks off &#128073;.
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                            <div class="d-sm-flex align-items-center lh-1 task-comment-new">
                                                <div class="me-sm-3 mb-2 mb-sm-0">
                                                    <span class="avatar avatar-md avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/9.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="flex-fill me-sm-2">
                                                    <div class="input-group">
                                                        <input type="text" class="form-control shadow-none border" placeholder="Post Anything" aria-label="Recipient's username with two button addons">
                                                        <button type="button" aria-label="button" class="btn btn-outline-light px-3 border btn-wave border-start-0 waves-effect waves-light"><i class="bi bi-emoji-smile"></i></button>
                                                        <button type="button" aria-label="button" class="btn btn-outline-light px-3 border btn-wave border-start-0 waves-effect waves-light"><i class="bi bi-paperclip"></i></button>
                                                        <button type="button" aria-label="button" class="btn btn-outline-light px-3 border btn-wave border-start-0 waves-effect waves-light"><i class="bi bi-camera"></i></button>
                                                        <button class="btn btn-primary btn-wave waves-effect waves-light" type="button">Post</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane overflow-hidden p-0 border-0" id="files" role="tabpanel" aria-labelledby="files" tabindex="0">
                                            <ul class="list-unstyled task-files-list">
                                                <li>
                                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded p-2 bg-light">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/file-manager/1.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <a href="javascript:void(0);"><span class="d-block fw-medium">Full Project</span></a>
                                                            <span class="d-block text-muted fs-12 fw-normal">0.45MB</span>
                                                        </div>
                                                        <a href="javascript:void(0)" class="btn btn-light btn-icon btn-sm border rounded-circle">
                                                            <i class="ti ti-download"></i>
                                                        </a>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded bg-light">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/file-manager/3.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <a href="javascript:void(0);"><span class="d-block fw-medium">assets.zip</span></a>
                                                            <span class="d-block text-muted fs-12 fw-normal">0.99MB</span>
                                                        </div>
                                                        <a href="javascript:void(0)" class="btn btn-light btn-icon btn-sm border rounded-circle">
                                                            <i class="ti ti-download"></i>
                                                        </a>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded p-2 bg-light">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/file-manager/1.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <a href="javascript:void(0);"><span class="d-block fw-medium">image-1.png</span></a>
                                                            <span class="d-block text-muted fs-12 fw-normal">245KB</span>
                                                        </div>
                                                        <a href="javascript:void(0)" class="btn btn-light btn-icon btn-sm border rounded-circle">
                                                            <i class="ti ti-download"></i>
                                                        </a>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded bg-light">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/file-manager/3.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <a href="javascript:void(0);"><span class="d-block fw-medium">documentation.zip</span></a>
                                                            <span class="d-block text-muted fs-12 fw-normal">2MB</span>
                                                        </div>
                                                        <a href="javascript:void(0)" class="btn btn-light btn-icon btn-sm border rounded-circle">
                                                            <i class="ti ti-download"></i>
                                                        </a>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded bg-light">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/file-manager/3.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <a href="javascript:void(0);"><span class="d-block fw-medium">landing.zip</span></a>
                                                            <span class="d-block text-muted fs-12 fw-normal">3.46MB</span>
                                                        </div>
                                                        <a href="javascript:void(0)" class="btn btn-light btn-icon btn-sm border rounded-circle">
                                                            <i class="ti ti-download"></i>
                                                        </a>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-rounded p-2 bg-light">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/media/file-manager/1.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <a href="javascript:void(0);"><span class="d-block fw-medium">image-1.png</span></a>
                                                            <span class="d-block text-muted fs-12 fw-normal">245KB</span>
                                                        </div>
                                                        <a href="javascript:void(0)" class="btn btn-light btn-icon btn-sm border rounded-circle">
                                                            <i class="ti ti-download"></i>
                                                        </a>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Task Details Offcanvas -->
                    
                    <!-- Start::add task modal -->
                    <div class="modal fade" id="create-task" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h6 class="modal-title">Add Task</h6>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body px-4">
                                    <div class="row gy-2">
                                        <div class="col-xl-6">
                                            <label for="task-name" class="form-label">Task Name</label>
                                            <input type="text" class="form-control" id="task-name" placeholder="Task Name">
                                        </div>
                                        <div class="col-xl-6">
                                            <label for="task-id" class="form-label">Task ID</label>
                                            <input type="text" class="form-control" id="task-id" placeholder="Task ID">
                                        </div>
                                        <div class="col-xl-6">
                                            <label class="form-label">Assigned Date</label>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-text text-muted"> <i class="ri-calendar-line"></i> </div>
                                                    <input type="text" class="form-control" id="assignedDate" placeholder="Choose date and time">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <label class="form-label">Due Date</label>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-text text-muted"> <i class="ri-calendar-line"></i> </div>
                                                    <input type="text" class="form-control" id="dueDate" placeholder="Choose date and time">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <label class="form-label">Status</label>
                                            <select class="form-control" data-trigger name="choices-single-default" id="choices-single-default">
                                                <option value="New">New</option>
                                                <option value="Completed">Completed</option>
                                                <option value="Inprogress">Inprogress</option>
                                                <option value="Pending">Pending</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-6">
                                            <label class="form-label">Priority</label>
                                            <select class="form-control" data-trigger name="choices-single-default" id="choices-single-default1">
                                                <option value="High">High</option>
                                                <option value="Medium">Medium</option>
                                                <option value="Low">Low</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-12">
                                            <label class="form-label">Assigned To</label>
                                            <select class="form-control" name="choices-multiple-remove-button1" id="choices-multiple-remove-button1" multiple>
                                                <option value="Choice 1">Angelina May</option>
                                                <option value="Choice 2">Kiara advain</option>
                                                <option value="Choice 3">Hercules Jhon</option>
                                                <option value="Choice 4">Mayor Kim</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Cancel</button>
                                    <button type="button" class="btn btn-primary">Add Task</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End::add task modal -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

        <!-- Flat Picker JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/flatpickr/flatpickr.min.js"></script>

        <!-- Internal Invoice List JS -->
        <script src="<?php echo $baseUrl; ?>/assets/js/task-list.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
