<?php
/* =============================================================================
 * File: unit_hold_book.php
 * Purpose: Themed Hold/Book form with Melody base layout slots
 * Stack  : Core PHP + MySQLi (NO PDO). DB in /broker-config.php. Collation: utf8mb4_general_ci
 * Auth   : Requires logged-in username (from session)
 * ============================================================================= */

date_default_timezone_set('Asia/Kolkata');
@session_start();

/* ---- DB config (ABSOLUTE from docroot) ---- */
require_once 'broker-config.php';
if (!isset($conn) || !($conn instanceof mysqli)) { die('DB connection missing.'); }

/* ---- Charset & Collation ---- */
mysqli_set_charset($conn,'utf8mb4');
@mysqli_query($conn,"SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
@mysqli_query($conn,"SET collation_connection='utf8mb4_general_ci'");

/* ---- Helpers ---- */
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); } }

/* ---- Session & Params ---- */
$role     = isset($_SESSION['role']) ? (string)$_SESSION['role'] : '';
$username = isset($_SESSION['username']) ? (string)$_SESSION['username'] : '';
if ($username==='') { header("Location: login.php"); exit; }

$id     = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$action = isset($_GET['action']) ? strtolower(trim($_GET['action'])) : '';
if ($action==='booked') $action = 'book';
if (!in_array($action,['hold','book'],true) || $id<=0) { header('Location: units.php'); exit; }

/* ---- Load unit ---- */
$unit = null;
$sql = "SELECT u.*, p.name AS project_name, t.name AS tower_name
        FROM units u
        LEFT JOIN projects p ON p.id=u.project_id
        LEFT JOIN towers t ON t.id=u.tower_id
        WHERE u.id=$id LIMIT 1";
$rs = mysqli_query($conn,$sql);
if ($rs && mysqli_num_rows($rs)) { $unit = mysqli_fetch_assoc($rs); }
if (!$unit) { $_SESSION['flash_error']='Unit not found.'; header('Location: units.php'); exit; }

/* ---- Defaults ---- */
$today          = date('Y-m-d');
$holdExpiresVal = date('Y-m-d\T23:00', strtotime('+2 days')); // today + 2 days => 3rd day 11:00 PM
$bookedBy       = $username;
$nextStatus     = ($action==='hold') ? 'Hold' : 'Booked';

/* ---- CSRF ---- */
if (empty($_SESSION['csrf_token'])) { $_SESSION['csrf_token'] = bin2hex(random_bytes(32)); }

/* ---- Base URL for assets ---- */
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on' ? 'https://' : 'http://')
         . $_SERVER['HTTP_HOST']
         . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));

/* ================================ $styles ================================ */
ob_start(); ?>
<link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/sweetalert2/sweetalert2.min.css">
<style>
  .summary-badges .badge{ font-size:.8rem; }
  .form-section-title{ font-weight:600; margin:8px 0 14px; font-size:14px; text-transform:uppercase; letter-spacing:.4px; color:#64748b; }
</style>
<?php $styles = ob_get_clean();

/* =============================== $content =============================== */
ob_start(); ?>
<div class="page-header-breadcrumb mb-3">
  <div class="d-flex align-center justify-content-between flex-wrap">
    <h1 class="page-title fw-medium fs-18 mb-0"><?php echo ($action==='hold') ? 'Put on Hold' : 'Book Unit'; ?></h1>
    <ol class="breadcrumb mb-0">
      <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
      <li class="breadcrumb-item"><a href="javascript:void(0);">Real Estate</a></li>
      <li class="breadcrumb-item active" aria-current="page"><?php echo ($action==='hold') ? 'Hold' : 'Book'; ?></li>
    </ol>
  </div>
</div>

<?php if (!empty($_SESSION['flash_error'])): ?>
  <div class="alert alert-danger"><?php echo h($_SESSION['flash_error']); ?></div>
  <?php unset($_SESSION['flash_error']); ?>
<?php endif; ?>
<?php if (!empty($_SESSION['flash_success'])): ?>
  <div class="alert alert-success"><?php echo h($_SESSION['flash_success']); ?></div>
  <?php unset($_SESSION['flash_success']); ?>
<?php endif; ?>

<div class="row">
  <div class="col-xl-12">
    <div class="card custom-card">
      <div class="card-header justify-content-between">
        <div class="card-title">
          <i class="fa fa-file-signature me-2"></i><?php echo ($action==='hold') ? 'Confirm Hold' : 'Confirm Booking'; ?>
        </div>
        <div class="ms-auto">
          <a href="units.php" class="btn btn-outline-secondary btn-sm"><i class="fa fa-arrow-left me-2"></i>Back to Units</a>
        </div>
      </div>
      <div class="card-body">
        <div class="mb-3 summary-badges">
          <span class="me-2">Project: <span class="badge bg-light text-dark"><?php echo h($unit['project_name']); ?></span></span>
          <span class="me-2">Tower: <span class="badge bg-light text-dark"><?php echo h($unit['tower_name']); ?></span></span>
          <span class="me-2">Unit: <span class="badge bg-primary"><?php echo h($unit['unit_no']); ?></span></span>
          <span class="me-2">Type: <span class="badge bg-secondary"><?php echo h($unit['unit_type']); ?></span></span>
          <span class="me-2">Status: <span class="badge bg-dark"><?php echo h($unit['status']); ?></span></span>
        </div>

        <form method="post" action="unit_hold_book_save.php" autocomplete="off" id="holdBookForm">
          <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token']); ?>">
          <input type="hidden" name="id" value="<?php echo (int)$id; ?>">
          <input type="hidden" name="next_status" value="<?php echo h($nextStatus); ?>">

          <?php if ($action==='hold'): ?>
          <div class="form-section-title">Hold Details</div>
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Hold Expires At <small class="text-muted">(auto)</small></label>
              <input type="datetime-local" class="form-control" name="hold_expires_at" value="<?php echo h($holdExpiresVal); ?>" required>
              <small class="text-muted">Defaults to the 3rd day at 11:00 PM after today.</small>
            </div>
            <div class="col-md-6">
              <label class="form-label">Hold Reason <span class="text-danger">*</span></label>
              <input type="text" class="form-control" name="hold_reason" required>
            </div>
          </div>
          <?php endif; ?>

          <div class="form-section-title">Customer / Booking</div>
          <div class="row g-3">
            <div class="col-md-3">
              <label class="form-label">Booking Date</label>
              <input type="date" class="form-control" name="booking_date" value="<?php echo h($today); ?>">
            </div>
            <div class="col-md-3">
              <label class="form-label">Customer Name <span class="text-danger">*</span></label>
              <input type="text" class="form-control" name="customer_name" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">Customer Mobile <span class="text-danger">*</span></label>
              <input type="text" class="form-control" name="customer_mobile" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">Token Amount</label>
              <input type="number" step="0.01" class="form-control" name="token_amount" placeholder="0.00">
            </div>
          </div>

          <div class="row g-3 mt-1">
            <div class="col-md-4">
              <label class="form-label">Booked By (Broker)</label>
              <input type="text" class="form-control" name="booked_by_broker" value="<?php echo h($bookedBy); ?>" readonly>
            </div>
            <div class="col-md-8">
              <label class="form-label">Remarks</label>
              <input type="text" class="form-control" name="remarks" placeholder="Optional notes">
            </div>
          </div>

          <div class="mt-4 d-flex gap-2">
            <button class="btn btn-primary"><?php echo ($action==='hold') ? 'Confirm Hold' : 'Confirm Book'; ?></button>
            <a href="units.php" class="btn btn-light">Cancel</a>
          </div>
        </form>

      </div>
    </div>
  </div>
</div>
<?php $content = ob_get_clean();

/* =============================== $scripts =============================== */
ob_start(); ?>
<script src="<?php echo $baseUrl; ?>/assets/libs/sweetalert2/sweetalert2.min.js"></script>
<?php $scripts = ob_get_clean();

/* ------------------------------ Render base ------------------------------ */
include 'layouts/base.php';
