<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
//checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<?php ob_start(); ?>

<?php $styles = ob_get_clean(); ?>
<?php ob_start(); ?>
	
	<!-- Start::page-header -->
	<div class="page-header-breadcrumb mb-3">
		<div class="d-flex align-center justify-content-between flex-wrap">
			<h1 class="page-title fw-medium fs-18 mb-0">Edit Employee Details</h1>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="javascript:void(0);">Pages</a></li>
				<li class="breadcrumb-item active" aria-current="page">Edit Employee</li>
			</ol>
		</div>
	</div>
	<!-- End::page-header -->
	
	<!-- Start::row-1 -->
	<div class="row">
		<div class="col-xl-12">
			<div class="card custom-card">
				<div class="card-body">
<?php
$editMode = true;
$employeeData = [];

if (isset($_GET['SNo']) && is_numeric($_GET['SNo'])) {
    $SNo = intval($_GET['SNo']);

    $result = $conn_ic->query("SELECT * FROM hr_dump WHERE SNo = $SNo");
    if ($result && $result->num_rows === 1) {
        $employeeData = $result->fetch_assoc();
    } else {
        echo "<div class='alert alert-danger'>Employee not found.</div>";
        exit;
    }
} else {
    echo "<div class='alert alert-danger'>Invalid URL parameter.</div>";
    exit;
}

// On form submit
if (isset($_POST['updateEmp'])) {
    $empid = trim($_POST['Employee_Number']);
    $updated_by = trim($_POST['updated_by']);

    $stmt = $conn_ic->prepare("
        UPDATE hr_dump SET
            Status = ?, Employee_Full_Name = ?, Member_Type = ?, Employment_Status = ?, 
            Date_of_Joining = ?, Team_Name = ?, Role = ?, Department = ?, AMS_Location = ?, 
            Location_of_Work = ?, Functional_Reporting = ?, Functional_Reporting_Name = ?, 
            Reporting_Head_Code = ?, Reporting_Head_Name = ?, Team_Head_Code = ?, Team_Head_Name = ?, 
            Official_Email_Address_Long = ?, Official_Mobile_1 = ?, Weekely_Off_Day = ?, 
            Password = ?, updated_by = ?
        WHERE SNo = ?
    ");

    $stmt->bind_param("ssssssssssssssssssssss",
        $_POST['Status'], $_POST['Employee_Full_Name'], $_POST['Member_Type'], $_POST['Employment_Status'],
        $_POST['Date_of_Joining'], $_POST['Team_Name'], $_POST['Role'], $_POST['Department'],
        $_POST['AMS_Location'], $_POST['Location_of_Work'], $_POST['Functional_Reporting'], $_POST['Functional_Reporting_Name'],
        $_POST['Reporting_Head_Code'], $_POST['Reporting_Head_Name'], $_POST['Team_Head_Code'], $_POST['Team_Head_Name'],
        $_POST['Official_Email_Address_Long'], $_POST['Official_Mobile_1'], $_POST['Weekely_Off_Day'],
        $_POST['Password'], $updated_by, $SNo
    );

    $success = $stmt->execute();

    if ($success) {
		echo "<div class='alert alert-success'>Employee updated successfully!</div>";
		// Refresh employee data after update (optional but recommended)
		$result = $conn_ic->query("SELECT * FROM hr_dump WHERE SNo = $SNo");
		if ($result && $result->num_rows === 1) {
			$employeeData = $result->fetch_assoc();
		}
	} else {
        echo "<div class='alert alert-danger'>Error updating employee: " . $stmt->error . "</div>";
    }

    $stmt->close();
}
?>

					<h6>Employee Code : <?= htmlspecialchars($employeeData['empid']) ?></h6>
					<form class="form-horizontal" method="post" action="" autocomplete="off">
						<div class="row">
							<!-- Hidden fields -->
							<input type="hidden" name="Employee_Number" value="<?= htmlspecialchars($employeeData['Employee_Number'] ?? '') ?>">
							<input type="hidden" name="Status" value="<?= htmlspecialchars($employeeData['Status'] ?? '') ?>">
							<input type="hidden" name="Weekely_Off_Day" value="<?= htmlspecialchars($employeeData['Weekely_Off_Day'] ?? '') ?>">
							
							<div class="col-md-3 mt-3"><label>Employee Full Name<span class="text-danger">*</span></label>
								<input type="text" name="Employee_Full_Name" class="form-control" value="<?= htmlspecialchars($employeeData['Employee_Full_Name']) ?>" required>
							</div>

							<div class="col-md-3 mt-3"><label>Member Type<span class="text-danger">*</span></label>
								<select name="Member_Type" class="form-control" required>
									<option value="">-Select-</option>
									<?php
									$types = ['Intern', 'Retainer', 'Salaried'];
									foreach ($types as $type) {
										$selected = ($employeeData['Member_Type'] == $type) ? 'selected' : '';
										echo "<option value='$type' $selected>$type</option>";
									}
									?>
								</select>
							</div>

							<div class="col-md-3 mt-3"><label>Employment Status<span class="text-danger">*</span></label>
								<select name="Employment_Status" class="form-control" required>
									<option value="">-Select-</option>
									<option value="Off Roll" <?= ($employeeData['Employment_Status'] == 'Off Roll') ? 'selected' : '' ?>>Off Roll</option>
									<option value="On Roll" <?= ($employeeData['Employment_Status'] == 'On Roll') ? 'selected' : '' ?>>On Roll</option>
								</select>
							</div>

							<div class="col-md-3 mt-3"><label>Date of Joining<span class="text-danger">*</span></label>
								<input type="date" name="Date_of_Joining" class="form-control" value="<?= htmlspecialchars($employeeData['Date_of_Joining']) ?>" required>
							</div>

							<div class="col-md-3 mt-3"><label>Team Name<span class="text-danger">*</span></label>
								<select name="Team_Name" class="form-control" required>
									<option value="">-Select-</option>
									<?php
									$teams = $conn_ic->query("SELECT team_name FROM ic_team_name WHERE status='Active' ORDER BY team_name ASC");
									while ($row = $teams->fetch_assoc()) {
										$selected = ($employeeData['Team_Name'] == $row['team_name']) ? 'selected' : '';
										echo "<option value='{$row['team_name']}' $selected>{$row['team_name']}</option>";
									}
									?>
								</select>
							</div>

							<div class="col-md-3 mt-3"><label>Role<span class="text-danger">*</span></label>
								<select name="Role" class="form-control" required>
									<option value="">-Select-</option>
									<option value="Back Office" <?= ($employeeData['Role'] == 'Back Office') ? 'selected' : '' ?>>Back Office</option>
									<option value="Sales" <?= ($employeeData['Role'] == 'Sales') ? 'selected' : '' ?>>Sales</option>
								</select>
							</div>

							<div class="col-md-3 mt-3"><label>Department<span class="text-danger">*</span></label>
								<?php
								$departments = [
									"Accounts", "Administration", "Billing", "Builder Empanelment", "CRM",
									"Customer Service", "Digital Media", "Finance & Accounts", "Human Resources",
									"Legal", "Management", "Operations", "Revenue Assurance", "Sales",
									"Sales Operations", "Support", "Technology", "Training & Development"
								];
								?>
								<select name="Department" class="form-control" required>
									<option value="">-Select-</option>
									<?php foreach ($departments as $dept): ?>
										<option value="<?= $dept ?>" <?= ($employeeData['Department'] == $dept) ? 'selected' : '' ?>><?= $dept ?></option>
									<?php endforeach; ?>
								</select>
							</div>

							<input type="hidden" name="AMS_Location" value="ALL">

							<div class="col-md-3 mt-3"><label>Location of Work<span class="text-danger">*</span></label>
								<select name="Location_of_Work" class="form-control" required>
									<option value="">-Select-</option>
									<option value="Noida-Astralis" <?= ($employeeData['Location_of_Work'] == 'Noida-Astralis') ? 'selected' : '' ?>>Noida-Astralis</option>
									<option value="Noida-Prateek" <?= ($employeeData['Location_of_Work'] == 'Noida-Prateek') ? 'selected' : '' ?>>Noida-Prateek</option>
								</select>
							</div>

							<div class="col-md-3 mt-3"><label>Functional Reporting Code<span class="text-danger">*</span></label>
								<input type="text" name="Functional_Reporting" class="form-control" value="<?= htmlspecialchars($employeeData['Functional_Reporting']) ?>" required>
							</div>

							<div class="col-md-3 mt-3"><label>Functional Reporting Name<span class="text-danger">*</span></label>
								<input type="text" name="Functional_Reporting_Name" class="form-control" value="<?= htmlspecialchars($employeeData['Functional_Reporting_Name']) ?>" required>
							</div>

							<div class="col-md-3 mt-3"><label>Reporting Head Code<span class="text-danger">*</span></label>
								<input type="text" name="Reporting_Head_Code" class="form-control" value="<?= htmlspecialchars($employeeData['Reporting_Head_Code']) ?>" required>
							</div>

							<div class="col-md-3 mt-3"><label>Reporting Head Name<span class="text-danger">*</span></label>
								<input type="text" name="Reporting_Head_Name" class="form-control" value="<?= htmlspecialchars($employeeData['Reporting_Head_Name']) ?>" required>
							</div>

							<div class="col-md-3 mt-3"><label>Team Head Code<span class="text-danger">*</span></label>
								<input type="text" name="Team_Head_Code" class="form-control" value="<?= htmlspecialchars($employeeData['Team_Head_Code']) ?>" required>
							</div>

							<div class="col-md-3 mt-3"><label>Team Head Name<span class="text-danger">*</span></label>
								<input type="text" name="Team_Head_Name" class="form-control" value="<?= htmlspecialchars($employeeData['Team_Head_Name']) ?>" required>
							</div>

							<div class="col-md-3 mt-3"><label>Mobile Number<span class="text-danger">*</span></label>
								<input type="tel" name="Official_Mobile_1" class="form-control" value="<?= htmlspecialchars($employeeData['Official_Mobile_1']  ?? '') ?>" pattern="\d{10}" maxlength="10" required>
							</div>

							<div class="col-md-3 mt-3"><label>Official Email Address</label>
								<input type="email" name="Official_Email_Address_Long" class="form-control" value="<?= htmlspecialchars($employeeData['Official_Email_Address_Long'] ?? '') ?>">
							</div>

							<div class="col-md-3 mt-3"><label>Password<span class="text-danger">*</span></label>
								<input type="text" name="Password" class="form-control" maxlength="6" value="<?= htmlspecialchars($employeeData['Password']) ?>" required>
							</div>

							<div class="col-md-12 text-center mt-4">
								<input type="hidden" name="updated_by" value="<?= $_SESSION['user_email'] ?? '' ?>">
								<button type="submit" name="updateEmp" class="btn btn-primary">Update Employee</button>
							</div>
						</div>
					</form>					
				</div>
			</div>
		</div>
	</div>
	<!--End::row-1 -->

<script>
	function Random() {
		var rnd = Math.floor(Math.random() * 1000000);
		document.getElementById('Password').value = rnd;
	}
</script>


<?php $content = ob_get_clean(); ?>
<?php ob_start(); ?>

<?php $scripts = ob_get_clean(); ?>
<?php include 'layouts/base.php'; ?>