<?php
include("../config-pdo.php");
require '../PhpSpreadsheet/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Get the first day of last month
$start_date = date('Y-m-01', strtotime('first day of last month'));

// Get the last day of last month
$end_date = date('Y-m-t', strtotime('last day of last month'));

// Fetch data (same as HTML table)
$query = "SELECT * FROM ams_final WHERE OfficeDate BETWEEN '$start_date' AND '$end_date' ORDER BY OfficeDate ASC";
$result = mysqli_query($conn_ic, $query);

// Create new spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set headers
$headers = ['S.No.', 'Emp ID', 'Office Date', 'Location', 'In Time', 'Out Location', 'Out Time', 'Approval Status', 'Status', 'Final Status'];

$col = 1;
foreach ($headers as $header) {
    $sheet->setCellValueByColumnAndRow($col++, 1, $header);
}

// Fill data
$rowNum = 2;
$sno = 1;
while ($data = mysqli_fetch_assoc($result)) {
    $sheet->setCellValueByColumnAndRow(1, $rowNum, $sno); // S.No.
    $sheet->setCellValueByColumnAndRow(2, $rowNum, $data['empid']);
    $sheet->setCellValueByColumnAndRow(3, $rowNum, $data['OfficeDate']);
    $sheet->setCellValueByColumnAndRow(4, $rowNum, $data['location']);
    $sheet->setCellValueByColumnAndRow(5, $rowNum, $data['InTime']);
    $sheet->setCellValueByColumnAndRow(6, $rowNum, $data['out_location']);
    $sheet->setCellValueByColumnAndRow(7, $rowNum, $data['OutTime']);
    $sheet->setCellValueByColumnAndRow(8, $rowNum, $data['Approval_Status']);
    $sheet->setCellValueByColumnAndRow(9, $rowNum, $data['Status']);
    $sheet->setCellValueByColumnAndRow(10, $rowNum, $data['FinalStatus']);
    
    $rowNum++;
    $sno++;
}

// Output Excel file
$monthName = date('F'); // e.g., September
$filename = "$monthName-table-export_" . date("Y-m-d") . ".xlsx";

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=\"$filename\"");
$writer = new Xlsx($spreadsheet);
$writer->save("php://output");
exit;
?>
