<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<?php ob_start(); ?>
<!-- Optional custom styles can go here -->
<?php $styles = ob_get_clean(); ?>

<?php ob_start(); ?>
<!-- Start::page-header -->
<div class="page-header-breadcrumb mb-3">
	<div class="d-flex align-center justify-content-between flex-wrap">
		<h1 class="page-title fw-medium fs-18 mb-0">AMS Tracker</h1>
		<ol class="breadcrumb mb-0">
			<li class="breadcrumb-item"><a href="javascript:void(0);">Pages</a></li>
			<li class="breadcrumb-item active" aria-current="page">AMS Tracker</li>
		</ol>
	</div>
</div>

<!-- Controls -->
<div class="d-flex flex-wrap gap-2 mb-3">
	<a href="javascript:void(0);" class="btn btn-primary btn-wave" id="btnRefresh">
		<i class="ri-refresh-line me-1 align-middle"></i>Refresh
	</a>
	<div>
		<input id="tableSearch" class="form-control" type="text" placeholder="Search Here" aria-label="search">
	</div>
	<div class="dropdown">
		<a href="javascript:void(0);" class="btn btn-primary btn-wave" data-bs-toggle="dropdown" aria-expanded="false">
			Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
		</a>
		<ul class="dropdown-menu" role="menu" id="sortMenu">
			<li><a class="dropdown-item" data-sort="created_desc" href="javascript:void(0);">Newest</a></li>
			<li><a class="dropdown-item" data-sort="created_asc" href="javascript:void(0);">Oldest</a></li>
			<li><a class="dropdown-item" data-sort="status" href="javascript:void(0);">Status</a></li>
			<li><a class="dropdown-item" data-sort="name" href="javascript:void(0);">Employee Name</a></li>
		</ul>
	</div>
</div>

<!-- Table -->
<div class="row">
	<div class="col-xl-12">
		<table id="trackerTable" class="display nowrap table table-bordered" style="width:100%">
			<thead>
				<tr>
					<th>ID</th>
					<th>Emp ID</th>
					<th>Full Name</th>
					<th>Team</th>
					<th>Fn. Reporting</th>
					<th>In Location</th>
					<th>Out Location</th>
					<th>Status</th>
					<th>Office Date</th>
					<th>In Time</th>
					<th>Late</th>
					<th>Early</th>
					<th>Out Time</th>
				</tr>
			</thead>
			<tbody>
				<?php
				$sql = "SELECT 
							id, empid, Employee_Full_Name, Team_Name, Functional_Reporting, location, out_location, status, 
							OfficeDate, OfficeIn, OfficeLate, OfficeEarly, OfficeOut, 
							workinghr, updated_at, created_at
						FROM tracker
						ORDER BY COALESCE(updated_at, created_at) DESC
						LIMIT 100";

				$result = mysqli_query($conn_ic, $sql);

				if (!$result) {
					echo "<tr><td colspan='13'>Query error: " . mysqli_error($conn_ic) . "</td></tr>";
				} elseif (mysqli_num_rows($result) > 0) {
					while ($row = mysqli_fetch_assoc($result)) {
						echo "<tr class='tracker-row'>";
						echo "<td>" . (!empty($row['id']) ? htmlspecialchars($row['id']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['empid']) ? htmlspecialchars($row['empid']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['Employee_Full_Name']) ? htmlspecialchars($row['Employee_Full_Name']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['Team_Name']) ? htmlspecialchars($row['Team_Name']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['Functional_Reporting']) ? htmlspecialchars($row['Functional_Reporting']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['location']) ? htmlspecialchars($row['location']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['out_location']) ? htmlspecialchars($row['out_location']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['status']) ? htmlspecialchars($row['status']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['OfficeDate']) ? date('d M Y', strtotime($row['OfficeDate'])) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['OfficeIn']) ? htmlspecialchars($row['OfficeIn']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['OfficeLate']) ? htmlspecialchars($row['OfficeLate']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['OfficeEarly']) ? htmlspecialchars($row['OfficeEarly']) : 'NA') . "</td>";
						echo "<td>" . (!empty($row['OfficeOut']) ? htmlspecialchars($row['OfficeOut']) : 'NA') . "</td>";
						echo "</tr>";
					}
				} else {
					echo "<tr><td colspan='13' class='text-muted'>No records found.</td></tr>";
				}
				?>
			</tbody>
		</table>
	</div>
</div>
<?php $content = ob_get_clean(); ?>

<?php ob_start(); ?>
<script>
(function(){
	const searchInput = document.getElementById('tableSearch');
	const table = document.getElementById('trackerTable');
	const tbody = table ? table.querySelector('tbody') : null;
	const rows = tbody ? Array.from(tbody.querySelectorAll('tr.tracker-row')) : [];
	const refresh = document.getElementById('btnRefresh');
	const sortMenu = document.getElementById('sortMenu');

	function norm(s){ return (s||'').toString().toLowerCase().trim(); }

	// Client-side search
	if (searchInput && rows.length){
		searchInput.addEventListener('input', function(){
			const q = norm(this.value);
			rows.forEach(tr => {
				const show = !q || norm(tr.innerText).includes(q);
				tr.style.display = show ? '' : 'none';
			});
		});
	}

	// Refresh button
	if (refresh){
		refresh.addEventListener('click', () => location.reload());
	}

	// Sort menu
	if (sortMenu && rows.length){
		sortMenu.querySelectorAll('.dropdown-item').forEach(item => {
			item.addEventListener('click', function(){
				const mode = this.getAttribute('data-sort');

				const getName = tr => tr.querySelector('td:nth-child(3)')?.textContent.trim() || '';
				const getStatus = tr => tr.querySelector('td:nth-child(8)')?.textContent.trim() || '';
				const getDate = tr => tr.querySelector('td:nth-child(9)')?.textContent.trim() || '';

				function parseDate(txt){
					const d = Date.parse(txt);
					return isNaN(d) ? 0 : d;
				}

				const sorted = rows.slice();

				if (mode === 'name') {
					sorted.sort((a, b) => getName(a).localeCompare(getName(b)));
				} else if (mode === 'status') {
					sorted.sort((a, b) => getStatus(a).localeCompare(getStatus(b)));
				} else if (mode === 'created_asc') {
					sorted.sort((a, b) => parseDate(getDate(a)) - parseDate(getDate(b)));
				} else { // created_desc default
					sorted.sort((a, b) => parseDate(getDate(b)) - parseDate(getDate(a)));
				}

				// Re-append sorted rows
				sorted.forEach(tr => tbody.appendChild(tr));
			});
		});
	}
})();
</script>
<?php $scripts = ob_get_clean(); ?>

<?php include 'layouts/base.php'; ?>
