<?php
// Safe HTML escape
if (!function_exists('h')) {
    function h($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
}

// Optional: global base URL if your pages don't already set $baseUrl
if (!defined('BASE_URL')) {
    $isHttps  = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
    $scheme   = $isHttps ? 'https' : 'http';
    $host     = $_SERVER['HTTP_HOST'] ?? '';
    define('BASE_URL', $host ? ($scheme . '://' . $host) : '');
}

/** Resolve a path from project root (the directory that contains this file) */
if (!function_exists('root_path')) {
    function root_path(string $suffix = ''): string {
        $base = __DIR__;
        return rtrim($base, '/\\') . ($suffix ? '/' . ltrim($suffix, '/\\') : '');
    }
}
