<?php
/* View a single broker application (Admin) */
ini_set('display_errors',1); ini_set('display_startup_errors',1); error_reporting(E_ALL);
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__.'/config.php';
require_once __DIR__.'/functions.php';
mysqli_set_charset($conn,'utf8mb4');
@mysqli_query($conn,"SET collation_connection='utf8mb4_general_ci'");

if (!isset($_SESSION['role']) || $_SESSION['role']!=='Admin') { header('Location: login.php'); exit; }

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$r = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM brokers WHERE id=$id"));
if (!$r) { header('Location: broker_list.php?msg='.urlencode('Application not found.')); exit; }

require_once __DIR__.'/header.php';
?>
<div class="page-header d-flex align-items-center justify-content-between">
  <h3 class="page-title">Broker Application: <?= h($r['broker_code']) ?></h3>
  <div>
    <a class="btn btn-outline-success" href="broker_list.php?action=approve&id=<?= (int)$r['id'] ?>">Approve</a>
    <a class="btn btn-outline-danger" href="broker_list.php?action=reject&id=<?= (int)$r['id'] ?>">Reject</a>
    <a class="btn btn-light" href="broker_list.php">Back</a>
  </div>
</div>

<div class="row">
  <div class="col-12 grid-margin stretch-card">
    <div class="card"><div class="card-body">
      <h4 class="card-title"><i class="fas fa-user"></i> Personal</h4>
      <p><b>Name:</b> <?= h(($r['first_name']??'').' '.($r['last_name']??'')) ?></p>
      <p><b>Email:</b> <?= h($r['email']) ?> &nbsp; <b>Phone:</b> <?= h($r['phone']) ?></p>
      <p><b>Status:</b> <span class="badge badge-info"><?= h($r['status']) ?></span></p>
    </div></div>
  </div>
  <div class="col-12 grid-margin stretch-card">
    <div class="card"><div class="card-body">
      <h4 class="card-title"><i class="fas fa-building"></i> Firm & Compliance</h4>
      <p><b>Firm:</b> <?= h($r['firm_name']) ?> &nbsp; <b>Type:</b> <?= h($r['business_type']) ?></p>
      <p><b>RERA ID:</b> <?= h($r['rera_id']) ?> &nbsp; <b>License Till:</b> <?= h($r['license_valid_till']) ?></p>
      <p><b>GSTIN:</b> <?= h($r['gstin']) ?> &nbsp; <b>PAN:</b> <?= h($r['pan']) ?></p>
    </div></div>
  </div>
  <div class="col-12 grid-margin stretch-card">
    <div class="card"><div class="card-body">
      <h4 class="card-title"><i class="fas fa-map-marker-alt"></i> Address</h4>
      <p><?= h($r['addr_line']) ?>, <?= h($r['city']) ?>, <?= h($r['state']) ?> - <?= h($r['pincode']) ?></p>
    </div></div>
  </div>
  <div class="col-12 grid-margin stretch-card">
    <div class="card"><div class="card-body">
      <h4 class="card-title"><i class="fas fa-file"></i> Documents</h4>
      <ul>
        <?php foreach(['doc_rera_cert'=>'RERA Certificate','doc_pan_card'=>'PAN Card','doc_gst_cert'=>'GST Certificate','doc_cancelled_cheque'=>'Cancelled Cheque','doc_address_proof'=>'Address Proof'] as $k=>$label): ?>
          <li><?= $label ?>:
            <?php if(!empty($r[$k])): ?><a href="<?= h($r[$k]) ?>" target="_blank">View</a><?php else: ?>—<?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div></div>
  </div>
</div>

<?php require_once __DIR__.'/footer.php'; ?>
