<?php
// ============================================================================
// File: calling_form_new_application.php
// Purpose:
//   - New Application: Calling Form
//   - Features same as old HR calling form (toggle fields, work exp logic)
//   - Auth via signin.php (user_id, empid, username, role_id)
//   - Theme: Soziety job layout using layouts/base.php
//   - DB via config.php, COLLATE=utf8mb4_general_ci (NO PDO)
// ============================================================================

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* -------------------------- Load central config -------------------------- */
$cfgs = [
    __DIR__ . '/../config.php',
    __DIR__ . '/../../config.php',
    __DIR__ . '/config.php'
];
$cfgFound = false;
foreach ($cfgs as $c) {
    if (file_exists($c)) {
        require_once $c;
        $cfgFound = true;
        break;
    }
}
if (!$cfgFound) {
    http_response_code(500);
    die('config.php not found');
}

/* Pick mysqli connection */
if (isset($conn_user) && $conn_user instanceof mysqli) {
    $DB = $conn_user;
} elseif (isset($conn_sa) && $conn_sa instanceof mysqli) {
    $DB = $conn_sa;
} elseif (isset($conn) && $conn instanceof mysqli) {
    $DB = $conn;
} else {
    http_response_code(500);
    die('Database connection not found');
}

/* Collation / Charset */
mysqli_set_charset($DB, 'utf8mb4');
@mysqli_query($DB, "SET NAMES 'utf8mb4'");
@mysqli_query($DB, "SET collation_connection='utf8mb4_general_ci'");

/* ------------------------------ AUTH GUARD ------------------------------ */
if (empty($_SESSION['user_id'])) {
    header('Location: signin.php');
    exit;
}

$recruiterEmpid = isset($_SESSION['empid'])    ? (string)$_SESSION['empid']    : '';
$recruiterName  = isset($_SESSION['username']) ? (string)$_SESSION['username'] : '';
$roleId         = isset($_SESSION['role_id'])  ? (int)$_SESSION['role_id']     : 0;

/* -------------------------- AUTO BASE URL -------------------------- */
$rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on'
    ? 'https://' : 'http://')
    . $_SERVER['HTTP_HOST']
    . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));

/* ------------------------------ HANDLE POST ------------------------------ */
$successMsg = '';
$errorMsg   = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {

    // Input values
    $calling_date   = isset($_POST['calling_date']) ? trim($_POST['calling_date']) : date('Y-m-d');
    $team_name      = isset($_POST['team_name']) ? trim($_POST['team_name']) : 'NA';
    $username       = trim($_POST['username'] ?? '');
    $phone          = trim($_POST['phone'] ?? '');
    $calling_remark = trim($_POST['calling_remark'] ?? '');
    $calling_inputs = trim($_POST['calling_inputs'] ?? '');
    $alternatephone = trim($_POST['alternatephone'] ?? '');
    $email          = trim($_POST['email'] ?? '');
    $present_loc    = trim($_POST['present_location'] ?? '');
    $preferred_loc  = trim($_POST['preferred_location'] ?? '');
    $qualification  = trim($_POST['qualification'] ?? '');
    $job_portal     = trim($_POST['Job_Portal'] ?? '');
    $totalExp       = trim($_POST['totalExp'] ?? '');
    $current_company= trim($_POST['current_company'] ?? '');
    $industry_type  = trim($_POST['IndustryType'] ?? '');
    $current_salary = trim($_POST['current_salary'] ?? '');
    $prev_exp_ic    = trim($_POST['prev_exp_ic'] ?? '');
    $int_date       = trim($_POST['calling_interview_date'] ?? '');
    $profileName    = trim($_POST['ProfileName'] ?? '');
    $callFrom       = 'CallingForm';
    $status         = 'Pending';

    $sql = "INSERT INTO calling_form (
                calling_date,
                recruiter_FullName,
                recruiter_name,
                team_name,
                username,
                phone,
                calling_remark,
                calling_inputs,
                alternatephone,
                email,
                present_location,
                preferred_location,
                qualification,
                Job_Portal,
                totalExp,
                current_company,
                IndustryType,
                current_salary,
                prev_exp_ic,
                calling_interview_date,
                ProfileName,
                CallFrom,
                Status
            ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    if ($stmt = $DB->prepare($sql)) {
        $stmt->bind_param(
            "sssssssssssssssssssssss",
            $calling_date,
            $recruiterName,
            $recruiterEmpid,
            $team_name,
            $username,
            $phone,
            $calling_remark,
            $calling_inputs,
            $alternatephone,
            $email,
            $present_loc,
            $preferred_loc,
            $qualification,
            $job_portal,
            $totalExp,
            $current_company,
            $industry_type,
            $current_salary,
            $prev_exp_ic,
            $int_date,
            $profileName,
            $callFrom,
            $status
        );

        if ($stmt->execute()) {
            $successMsg = "Application details submitted successfully!";
        } else {
            $errorMsg = "Error executing statement: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $errorMsg = "Error preparing statement: " . $DB->error;
    }
}

/* ======================= INTERNAL STYLES ($styles) ======================= */
ob_start();
?>
<style>
    .page-title { font-weight: 600; }
    .section-title {
        font-size: 14px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: .06em;
        margin-bottom: .75rem;
        color: #6b7280;
    }
</style>
<?php
$styles = ob_get_clean();

/* ========================= PAGE CONTENT ($content) ======================== */
ob_start();
?>

<div class="page-header-breadcrumb mb-3">
    <div class="d-flex align-center justify-content-between flex-wrap">
        <h1 class="page-title fw-medium fs-18 mb-0">New Application : Calling Form</h1>
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);">HR</a></li>
            <li class="breadcrumb-item active" aria-current="page">New Calling Form</li>
        </ol>
    </div>
</div>

<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-header justify-content-between">
                <div class="card-title">
                    Calling Form
                    <div class="small text-muted mt-1">
                        Welcome:
                        <strong><?php echo htmlspecialchars($recruiterName, ENT_QUOTES, 'UTF-8'); ?></strong>
                        (<?php echo htmlspecialchars($recruiterEmpid, ENT_QUOTES, 'UTF-8'); ?>)
                        &nbsp; | &nbsp;
                        <?php echo date('d-M-Y'); ?>
                    </div>
                </div>
                <a href="applied_calling_form_applications.php" class="btn btn-outline-primary btn-wave">
                    <i class="ri-arrow-left-line me-1 align-middle"></i>Back to Applications
                </a>
            </div>

            <div class="card-body">
                <?php if ($successMsg): ?>
                    <div class="alert alert-success text-center">
                        <?php echo htmlspecialchars($successMsg, ENT_QUOTES, 'UTF-8'); ?>
                        <div class="mt-2">
                            <a href="applied_calling_form_applications.php" class="btn btn-sm btn-info">
                                View Calling List
                            </a>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if ($errorMsg): ?>
                    <div class="alert alert-danger">
                        <?php echo htmlspecialchars($errorMsg, ENT_QUOTES, 'UTF-8'); ?>
                    </div>
                <?php endif; ?>

                <form class="row g-3" method="post" action="" id="callingForm">
                    <!-- hidden recruiter details -->
                    <input type="hidden" name="team_name" value="NA">

                    <div class="col-12">
                        <div class="section-title">Basic Details</div>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Calling Date</label>
                        <input type="date" class="form-control" name="calling_date"
                               value="<?php echo htmlspecialchars(date('Y-m-d'), ENT_QUOTES, 'UTF-8'); ?>"
                               max="9999-12-31" required>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Candidate Name</label>
                        <input type="text" class="form-control" name="username"
                               maxlength="55" placeholder="Enter Candidate Name" required
                               oninput="removeSpecialChars(this)">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Contact Number</label>
                        <input type="text" class="form-control" name="phone" id="phone"
                               maxlength="10" required
                               oninput="this.value=this.value.replace(/[^0-9]/g,'');"
                               placeholder="Only 10 Digits Mobile No">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Calling Remark</label>
                        <select class="form-control" name="calling_remark"
                                id="calling_remark" onchange="toggleFields()" required>
                            <option value="">--Select--</option>
                            <option value="Interested">Interested</option>
                            <option value="Interested(Interview NA)">Interested(Interview NA)</option>
                            <option value="Not Interested">Not Interested</option>
                            <option value="Wrong Number">Wrong Number</option>
                            <option value="Not Picked">Not Picked</option>
                            <option value="Busy">Busy</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Calling Remarks Input <sup>(Optional)</sup></label>
                        <input type="text" class="form-control" name="calling_inputs"
                               maxlength="55" placeholder="Inputs for Not Interested"
                               oninput="removeSpecialChars(this)">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Alternate Phone <sup>(Optional)</sup></label>
                        <input type="text" class="form-control" name="alternatephone"
                               maxlength="10"
                               oninput="this.value=this.value.replace(/[^0-9]/g,'');"
                               placeholder="Only 10 Digits Mobile No">
                    </div>

                    <!-- Additional fields (visible only when Interested) -->
                    <div class="col-12 mt-3">
                        <div class="section-title">Candidate Details</div>
                    </div>

                    <div class="row g-3 px-2 py-3 rounded bg-info-subtle" id="additional_fields" style="display:none;">
                        <div class="col-md-3">
                            <label class="form-label">Email *</label>
                            <input type="email" class="form-control" name="email" id="email"
                                   placeholder="Enter Candidate Email"
                                   onkeyup="this.value=this.value.toLowerCase();"
                                   maxlength="55">
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Present Location</label>
                            <input type="text" class="form-control" name="present_location"
                                   maxlength="55" oninput="removeSpecialChars(this)">
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Preferred Location</label>
                            <select class="form-control" name="preferred_location">
                                <option value="">--Select Location--</option>
                                <?php
                                $cat_q = $DB->query("SELECT * FROM ic_location WHERE status='Active' ORDER BY Location_of_Work ASC");
                                if ($cat_q && $cat_q->num_rows > 0) {
                                    while ($rowcat = $cat_q->fetch_assoc()) {
                                        echo '<option value="' . htmlspecialchars($rowcat['Location_of_Work'], ENT_QUOTES, 'UTF-8') . '">'
                                            . htmlspecialchars($rowcat['Location_of_Work'], ENT_QUOTES, 'UTF-8') .
                                            '</option>';
                                    }
                                } else {
                                    echo '<option value="">No Location available</option>';
                                }
                                ?>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Qualification</label>
                            <select class="form-control" name="qualification">
                                <option value="">--Select--</option>
                                <option value="High School">High School</option>
                                <option value="Intermediate">Intermediate</option>
                                <option value="Diploma">Diploma</option>
                                <option value="Undergraduate">Undergraduate</option>
                                <option value="Graduate">Graduate</option>
                                <option value="Postgraduate">Postgraduate</option>
                                <option value="PhD">PhD</option>
                                <option value="Others">Others</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Source From</label>
                            <select class="form-control" name="Job_Portal">
                                <option value="">--Select--</option>
                                <option value="Naukri.com">Naukri.com</option>
                                <option value="Apna.co">Apna.co</option>
                                <option value="Lead">Lead</option>
                                <option value="Indeed">Indeed</option>
                                <option value="LinkedIn">LinkedIn</option>
                                <option value="Hirect.in">Hirect.in</option>
                                <option value="HR Reference">HR Reference</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Total Work Exp</label>
                            <select class="form-control" name="totalExp" id="totalExp"
                                    onchange="toggleWorkExpFields()" required>
                                <option value="">--Select Work Exp--</option>
                                <option value="Internship">Internship</option>
                                <option value="Fresher">Fresher</option>
                                <option value="06-12 Months">06-12 Months</option>
                                <option value="02 Years">02 Years</option>
                                <option value="03 Years">03 Years</option>
                                <option value="04 Years">04 Years</option>
                                <option value="05 Years">05 Years</option>
                                <option value="06 Years">06 Years</option>
                                <option value="07 Years">07 Years</option>
                                <option value="08 Years">08 Years</option>
                                <option value="09 Years">09 Years</option>
                                <option value="10 Years">10 Years</option>
                                <option value="11-15 Years">11-15 Years</option>
                                <option value="16-20 Years">16-20 Years</option>
                                <option value="21-25 Years">21-25 Years</option>
                                <option value="26-30 Years">26-30 Years</option>
                                <option value="30+ Years">30+ Years</option>
                            </select>
                        </div>

                        <div class="row g-3" id="work_exp_fields" style="display:none;">
                            <div class="col-md-3">
                                <label class="form-label">Current/Last Org Name</label>
                                <input type="text" class="form-control" name="current_company"
                                       maxlength="55" placeholder="Enter Current/Last Org Name"
                                       oninput="removeSpecialChars(this)">
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Industry Type</label>
                                <select class="form-control" name="IndustryType">
                                    <option value="">--Select--</option>
                                    <option value="Real Estate">Real Estate</option>
                                    <option value="Agriculture">Agriculture</option>
                                    <option value="Automotive">Automotive</option>
                                    <option value="Banking">Banking</option>
                                    <option value="BPO">BPO</option>
                                    <option value="Construction">Construction</option>
                                    <option value="Education">Education</option>
                                    <option value="Energy">Energy</option>
                                    <option value="Fintech">Fintech</option>
                                    <option value="FMCG">FMCG</option>
                                    <option value="Healthcare">Healthcare</option>
                                    <option value="Hospitality">Hospitality</option>
                                    <option value="InformationTechnology">Information Technology</option>
                                    <option value="Insurance">Insurance</option>
                                    <option value="Manufacturing">Manufacturing</option>
                                    <option value="Retail">Retail</option>
                                    <option value="Telecommunications">Telecommunications</option>
                                    <option value="Transportation">Transportation</option>
                                    <option value="Others">Others</option>
                                </select>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Current Salary (Per Month)</label>
                                <select class="form-control" name="current_salary">
                                    <option value="">--Select Salary--</option>
                                    <option value="Fresher">Fresher</option>
                                    <option value="05 Thousands">05 Thousands</option>
                                    <option value="06-10 Thousands">06-10 Thousands</option>
                                    <option value="11-15 Thousands">11-15 Thousands</option>
                                    <option value="16-20 Thousands">16-20 Thousands</option>
                                    <option value="21-25 Thousands">21-25 Thousands</option>
                                    <option value="26-30 Thousands">26-30 Thousands</option>
                                    <option value="31-35 Thousands">31-35 Thousands</option>
                                    <option value="36-40 Thousands">36-40 Thousands</option>
                                    <option value="41-50 Thousands">41-50 Thousands</option>
                                    <option value="51-60 Thousands">51-60 Thousands</option>
                                    <option value="61-70 Thousands">61-70 Thousands</option>
                                    <option value="71-80 Thousands">71-80 Thousands</option>
                                    <option value="81-90 Thousands">81-90 Thousands</option>
                                    <option value="91-99 Thousands">91-99 Thousands</option>
                                    <option value="01 Lacs">01 Lacs</option>
                                    <option value="02 Lacs">02 Lacs</option>
                                    <option value="03 Lacs">03 Lacs</option>
                                    <option value="04 Lacs">04 Lacs</option>
                                    <option value="05+ Lacs">05+ Lacs</option>
                                </select>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Prev Experience in IC</label>
                                <select class="form-control" name="prev_exp_ic">
                                    <option value="">--Select--</option>
                                    <option value="Yes">Yes</option>
                                    <option value="No">No</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 mt-3">
                            <label class="form-label">Interview Date</label>
                            <input type="date" class="form-control" name="calling_interview_date"
                                   max="9999-12-31" required>
                        </div>

                        <div class="col-md-3 mt-3">
                            <label class="form-label">Profile Name</label>
                            <input type="text" class="form-control" name="ProfileName" required>
                        </div>
                    </div>

                    <div class="col-12 mt-4 text-center">
                        <button type="submit" name="submit" class="btn btn-success">
                            Submit
                        </button>
                    </div>

                    <div class="col-12">
                        <p class="text-danger mb-0 mt-2">
                            * Email ID can be registered only once. All fields in Application Form are required.
                        </p>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();

/* ===================== INTERNAL SCRIPTS ($scripts) ===================== */
ob_start();
?>
<script>
function removeSpecialChars(element) {
    element.value = element.value.replace(/[^a-zA-Z0-9\s]/g, '');
}

function toggleFields() {
    var callingRemark = document.getElementById("calling_remark").value;
    var additionalFields = document.getElementById("additional_fields");
    var emailField = document.getElementById("email");
    var phoneField = document.getElementById("phone").value;

    if (callingRemark === "Interested" || callingRemark === "Interested(Interview NA)") {
        additionalFields.style.display = "block";
        setRequiredAttributes(true);
        if (emailField) emailField.value = '';
    } else {
        additionalFields.style.display = "none";
        setRequiredAttributes(false);
        if (emailField) emailField.value = phoneField ? (phoneField + "@gmail.com") : "";
    }
}

function setRequiredAttributes(isRequired) {
    const fields = document.querySelectorAll('#additional_fields .form-control');
    fields.forEach(field => {
        if (isRequired) {
            field.setAttribute('required', 'required');
        } else {
            field.removeAttribute('required');
        }
    });
}

function toggleWorkExpFields() {
    var totalExp = document.getElementById("totalExp").value;
    var workExpFields = document.getElementById("work_exp_fields");
    if (totalExp === "Internship" || totalExp === "Fresher") {
        workExpFields.style.display = "none";
        setWorkExpFieldsRequired(false);
    } else {
        workExpFields.style.display = "flex";
        setWorkExpFieldsRequired(true);
    }
}

function setWorkExpFieldsRequired(isRequired) {
    const fields = document.querySelectorAll('#work_exp_fields .form-control');
    fields.forEach(field => {
        if (isRequired) {
            field.setAttribute('required', 'required');
        } else {
            field.removeAttribute('required');
        }
    });
}
</script>
<?php
$scripts = ob_get_clean();

/* ============================ RENDER LAYOUT ============================ */
include 'layouts/base.php';
