<?php
require_once __DIR__.'/../config.php';
mysqli_set_charset($conn,'utf8mb4');
$token = $_GET['token'] ?? '';
$row = null;

if($token){
  $q=$conn->prepare("SELECT * FROM interview_links WHERE token=? AND expiry>=NOW() LIMIT 1");
  $q->bind_param("s",$token);
  $q->execute();
  $r=$q->get_result();
  $row=$r->fetch_assoc();
}

if(!$row){ die("<h3 style='color:red;text-align:center;margin-top:50px;'>Link expired or invalid</h3>"); }

$empid=$row['empid'];
$q=$conn->prepare("SELECT * FROM hrd.hr_dump WHERE EmpID=? LIMIT 1");
$q->bind_param("s",$empid);
$q->execute();
$emp=$q->get_result()->fetch_assoc();
$q->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Interview Evaluation</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<h4 class="text-primary">Interview Evaluation (Token Valid)</h4>
<div class="card p-4 shadow-sm">
  <div class="row">
    <div class="col-md-4"><b>EmpID:</b> <?php echo htmlspecialchars($emp['EmpID']); ?></div>
    <div class="col-md-4"><b>Name:</b> <?php echo htmlspecialchars($emp['Employee_Full_Name']); ?></div>
    <div class="col-md-4"><b>Team:</b> <?php echo htmlspecialchars($emp['Team_name']); ?></div>
  </div>
  <hr>
  <form method="post" action="save_decision.php">
    <input type="hidden" name="empid" value="<?php echo htmlspecialchars($empid); ?>">
    <div class="mb-3">
      <label class="form-label">Decision</label>
      <select name="decision" class="form-select" required>
        <option value="">--Select--</option>
        <option>Approve</option><option>Reject</option><option>Hold</option>
      </select>
    </div>
    <div class="mb-3">
      <label class="form-label">Remarks</label>
      <textarea name="remarks" class="form-control" rows="2" required></textarea>
    </div>
    <button class="btn btn-success">Submit</button>
  </form>
</div>
</body>
</html>
