
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Marketcap</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Crypto</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Marketcap</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start::row-1 -->
                    <div class="row">
                        <div class="col-xxl-3 col-xl-6 col-lg-12">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-4 flex-wrap">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <span class="avatar avatar-md avatar-rounded bg-light p-2">
                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/regular/Bitcoin.svg" alt="">
                                                </span>
                                            </div>
                                            <div class="mb-0 fw-medium">
                                                Bitcoin - BTC
                                            </div>
                                        </div>
                                        <div class="ms-auto">
                                            <div id="bitcoin-chart"></div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-end">
                                        <div>
                                            <p class="mb-1">BTC / USD</p>
                                            <p class="fs-20 mb-0 fw-medium lh-1 text-primary">$35,876.29</p>
                                        </div>
                                        <div class="ms-auto text-end">
                                            <p class="mb-0">$0.04</p>
                                            <p class="mb-0 text-muted"><span class="text-muted">Vol:</span>(+2.33%)</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer p-0">
                                    <div class="list-group border-0 list-group-flush">
                                        <a href="javascript:void(0);" class="list-group-item">
                                            <div class="d-flex w-100 justify-content-between align-items-center">
                                                <p class="mb-0 font-weight-semibold text-dark">Price Change <span class="badge bg-primary-transparent ms-3 text-primary">Increased</span></p>
                                                <p class="text-success mb-0 font-weight-normal fs-13">
                                                    <span class="numberfont">+280.30(0.96%)</span> today
                                                </p>
                                            </div>
                                        </a>
                                        <a href="javascript:void(0);" class="list-group-item">
                                            <div class="d-flex w-100 justify-content-between align-items-center">
                                                <p class="mb-0 font-weight-semibold text-dark">Market Rank<span class="badge bg-secondary-transparent ms-3">3 Years</span></p>
                                                <p class="text-dark mb-0 fs-15">
                                                    <span class="numberfont">#1</span>
                                                </p>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6 col-lg-12">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-4 flex-wrap">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <span class="avatar avatar-md avatar-rounded bg-light p-2">
                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/regular/Ethereum.svg" alt="">
                                                </span>
                                            </div>
                                            <div class="mb-0 fw-medium">
                                                Etherium - ETH
                                            </div>
                                        </div>
                                        <div class="ms-auto">
                                            <div id="etherium-chart"></div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-end">
                                        <div>
                                            <p class="mb-1">ETH / USD</p>
                                            <p class="fs-20 mb-0 fw-medium lh-1 text-primary">$31,244.12</p>
                                        </div>
                                        <div class="ms-auto text-end">
                                            <p class="mb-0">$2.57</p>
                                            <p class="mb-0 text-muted"><span class="text-muted">Vol:</span>(+13.45%)</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer p-0">
                                    <div class="list-group list-group-flush">
                                        <a href="javascript:void(0);" class="list-group-item">
                                            <div class="d-flex w-100 justify-content-between align-items-center">
                                                <p class="mb-0 font-weight-semibold text-dark">Price Change <span class="badge bg-primary-transparent ms-3 text-primary">Increased</span></p>
                                                <p class="text-success mb-0 font-weight-normal fs-13">
                                                    <span class="numberfont">+2,044.24(1.32%)</span> today
                                                </p>
                                            </div>
                                        </a>
                                        <a href="javascript:void(0);" class="list-group-item">
                                            <div class="d-flex w-100 justify-content-between align-items-center">
                                                <p class="mb-0 font-weight-semibold text-dark">Market Rank</p>
                                                <p class="text-dark mb-0 fs-15">
                                                    <span class="numberfont">#2</span>
                                                </p>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6 col-lg-12">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-4 flex-wrap">
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <span class="avatar avatar-md avatar-rounded bg-light p-2">
                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/regular/Dash.svg" alt="">
                                                </span>
                                            </div>
                                            <div class="mb-0 fw-medium">
                                                Dash - DASH
                                            </div>
                                        </div>
                                        <div class="ms-auto">
                                            <div id="dashcoin-chart"></div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-end">
                                        <div>
                                            <p class="mb-1">DASH / USD</p>
                                            <p class="fs-20 mb-0 fw-medium lh-1 text-primary">$26,345.000</p>
                                        </div>
                                        <div class="ms-auto text-end">
                                            <p class="mb-0">$12.32</p>
                                            <p class="mb-0 text-muted"><span class="text-muted">Vol:</span>(+112.95%)</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer p-0">
                                    <div class="list-group list-group-flush">
                                        <a href="javascript:void(0);" class="list-group-item">
                                            <div class="d-flex w-100 justify-content-between align-items-center">
                                                <p class="mb-0 font-weight-semibold text-dark">Price Change <span class="badge bg-primary-transparent ms-3 text-primary">Increased</span></p>
                                                <p class="text-success mb-0 font-weight-normal fs-13">
                                                    <span class="numberfont">+40.17 (1.52%)</span> today
                                                </p>
                                            </div>
                                        </a>
                                        <a href="javascript:void(0);" class="list-group-item">
                                            <div class="d-flex w-100 justify-content-between align-items-center">
                                                <p class="mb-0 font-weight-semibold text-dark">Market Rank</p>
                                                <p class="text-dark mb-0 fs-15">
                                                    <span class="numberfont">#105</span>
                                                </p>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-6 col-lg-12">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        My Top Currencies
                                    </div>
                                    <div>
                                        <a href="javascript:void(0);" class="fw-medium text-success fs-13 text-decoration-underline">View All</a>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center justify-content-between flex-wrap gap-3">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div>
                                                        <span class="avatar avatar-sm p-1 bg-light">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/regular/Bitcoin.svg" alt="">
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="d-block fw-medium">Bitcoin</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    <span class="fw-medium d-block">0.5 BTC</span>
                                                </div>
                                                <div>
                                                    <span class="fw-medium d-block">$22,500</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center justify-content-between flex-wrap gap-3">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div>
                                                        <span class="avatar avatar-sm p-1 bg-light">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/regular/litecoin.svg" alt="">
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="d-block fw-medium">Litecon</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    <span class="fw-medium d-block">20 LTC</span>
                                                </div>
                                                <div class="text-end">
                                                    <span class="fw-medium d-block">$4,000</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center justify-content-between flex-wrap gap-3">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div>
                                                        <span class="avatar avatar-sm p-1 bg-light">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/regular/Ethereum.svg" alt="">
                                                        </span>
                                                    </div>
                                                    <div>
                                                        <span class="d-block fw-medium">Etherium</span>
                                                    </div>
                                                </div>
                                                <div>
                                                    <span class="fw-medium d-block">5 ETH</span>
                                                </div>
                                                <div>
                                                    <span class="fw-medium d-block">$16,000</span>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--End::row-1 -->

                    <!-- Start::row-2  -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Crypto MarketCap
                                    </div>
                                    <div class="d-flex flex-wrap gap-2">
                                        <div>
                                            <input class="form-control form-control-sm" type="text" placeholder="Search Here" aria-label=".form-control-sm example">
                                        </div>
                                        <div class="dropdown">
                                            <a href="javascript:void(0);" class="btn btn-primary btn-sm btn-wave" data-bs-toggle="dropdown" aria-expanded="false">
                                                Sort By<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i>
                                            </a>
                                            <ul class="dropdown-menu" role="menu">
                                                <li><a class="dropdown-item" href="javascript:void(0);">Market Cap</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Price</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Trading Volume</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Price Change (24h)</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">Rank</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">A - Z</a></li>
                                                <li><a class="dropdown-item" href="javascript:void(0);">All-Time High (ATH)</a></li>
                                            </ul>
                                        </div>
                                        <div>
                                            <button class="btn btn-light btn-sm btn-wave border">View All</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table text-nowrap">
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th scope="col" class="fw-medium">#</th>
                                                    <th scope="col">Crypto Name</th>
                                                    <th scope="col">MarketCap</th>
                                                    <th scope="col">Price<span class="text-muted ms-1">(USD)</span></th>
                                                    <th scope="col">1h Change</th>
                                                    <th scope="col">24h Change</th>
                                                    <th scope="col">Volume (24h)</th>
                                                    <th scope="col">Circulating Supply</th>
                                                    <th scope="col">last 1Week</th>
                                                    <th scope="col">Trade</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a>
                                                    </td>
                                                    <td>1</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Bitcoin.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">Bitcoin (BTC)</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$850B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$44,500</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>+0.5%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-up fs-15 fw-medium"></i>-1.2%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$35B</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                19M BTC
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="btc-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a>
                                                    </td>
                                                    <td>2</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ethereum.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">Etherium (ETH)</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$400B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$3,200</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>-1.2%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>-1.2%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$25B</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                118M ETH
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="eth-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a></td>
                                                    <td>3</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Golem.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">Golem (GLM)</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$1.2B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$0.56</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-up fs-15 fw-medium"></i>+0.3%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>-2.0%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$15M</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                1.2B GNT
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="glm-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a></td>
                                                    <td>4</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Dash.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">Dash (DASH)</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$12B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$200</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-up fs-15 fw-medium"></i>-0.5%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>+2.8%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$5B</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                10M DASH
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="dash-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a></td>
                                                    <td>5</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Litecoin.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">Litecoin (LTC)</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$13B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$185</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-up fs-15 fw-medium"></i>+0.7%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>-1.0%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$3B</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                69M LTC
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="lite-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a></td>
                                                    <td>6</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Ripple.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">Ripple (XRP)</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$35B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$1.00</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-up fs-15 fw-medium"></i>+0.1%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>+0.5%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$2B</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                40B XRP
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="ripple-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a></td>
                                                    <td>7</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/EOS.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">EOS</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$6.5B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$7.00</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-up fs-15 fw-medium"></i>-0.3%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>+1.4%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$800M</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                1B EOS
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="eos-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a></td>
                                                    <td>8</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Bytecoin.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">Bytecoin (BCN)</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$3.5B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$0.03</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-up fs-15 fw-medium"></i>+2.1%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>+0.9%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$50M</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                184B BCN
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="bytecoin-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a></td>
                                                    <td>9</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/IOTA.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">IOTA</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$3.2B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$1.15</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-success fw-medium"><i class="ti ti-arrow-narrow-up fs-15 fw-medium"></i>+0.2%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>-0.4%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$100M</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                2.7B IOTA
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="iota-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0);"><i class="ri-star-line fs-16 text-muted"></i></a></td>
                                                    <td>10</td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-xs avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/crypto-currencies/square-color/Monero.svg" alt="">
                                                                </span>
                                                            </div>
                                                            <div class="fw-medium"><a href="javascript:void(0);">Monero</a></div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">$3.8B</span>
                                                    </td>
                                                    <td>
                                                        <span class="fw-medium">
                                                            <a href="javascript:void(0);">$200</a>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-up fs-15 fw-medium"></i>-0.8%</span>
                                                    </td>
                                                    <td>
                                                        <span class="text-danger fw-medium"><i class="ti ti-arrow-narrow-down fs-15 fw-medium"></i>-1.3%</span>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)">
                                                            <span class="d-block fw-medium">$200M</span>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0);">
                                                            <span class="fw-medium d-block">
                                                                18M XMR
                                                            </span>
                                                        </a>    
                                                    </td>
                                                    <td>
                                                        <div id="monero-chart"></div>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-success-light btn-sm">Trade</button>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="card-footer border-top-0">
                                    <nav aria-label="Page navigation" class="pagination-style-2">
                                        <ul class="pagination mb-0 flex-wrap justify-content-end">
                                            <li class="page-item disabled">
                                                <a class="page-link" href="javascript:void(0);">
                                                    Prev
                                                </a>
                                            </li>
                                            <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                            <li class="page-item active"><a class="page-link" href="javascript:void(0);">2</a></li>
                                            <li class="page-item">
                                                <a class="page-link" href="javascript:void(0);">
                                                    <i class="bi bi-three-dots"></i>
                                                </a>
                                            </li>
                                            <li class="page-item"><a class="page-link" href="javascript:void(0);">17</a></li>
                                            <li class="page-item">
                                                <a class="page-link text-primary" href="javascript:void(0);">
                                                    next
                                                </a>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End::row-2  -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

        <!-- Crypto MarketCap JS -->
        <script src="<?php echo $baseUrl; ?>/assets/js/crypto-marketcap.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
