<?php
// functions.php - small helpers (mysqli, sanitize, redirects, computed price)
function h($s){ return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8'); }
function post($key,$default=''){ return isset($_POST[$key]) ? trim($_POST[$key]) : $default; }
function get($key,$default=''){ return isset($_GET[$key]) ? trim($_GET[$key]) : $default; }
function redirect($url){ header('Location: '.$url); exit; }
function compute_total_price($saleable_area,$base_rate,$plc_amount,$other_charges,$gst_rate){
    $base = floatval($saleable_area)*floatval($base_rate);
    $taxable = $base + floatval($plc_amount) + floatval($other_charges);
    $gst = ($taxable * floatval($gst_rate))/100.0;
    return round($taxable + $gst,2);
}
?>