<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function getUserPermissions($roleId, $conn_user) {
    if ($roleId == 1) {
        return ['all'];
    }

    $permissions = [];
    $stmt = $conn_user->prepare("SELECT permissions FROM roles WHERE id = ?");
    if (!$stmt) {
        return $permissions;
    }

    $stmt->bind_param("i", $roleId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        if (!empty($row['permissions']) && is_string($row['permissions'])) {
            $decoded = json_decode($row['permissions'], true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                $permissions = $decoded;
            }
        }
    }
    $stmt->close();

    return $permissions;
}

function checkPageAccessOrRedirect($currentPage, $conn_user) {
    if (!isset($_SESSION['role_id'])) {
        header("Location: login.php");
        exit;
    }

    $roleId = (int)$_SESSION['role_id'];
    $permissions = getUserPermissions($roleId, $conn_user);
    $currentPage = basename($currentPage);

    // Super admin or explicit permission
    if (in_array('all', $permissions, true) || in_array($currentPage, $permissions, true)) {
        return;
    }

    // Try redirect to any allowed page if exists
    if (!empty($permissions)) {
        foreach ($permissions as $page) {
            if (is_string($page) && str_ends_with($page, '.php') && $page !== $currentPage) {
                header("Location: $page");
                exit;
            }
        }
    }

    echo "<h3>You don't have access to this page.</h3>";
    exit;
}
?>
