<?php
/* ============================================================================
 * File: includes/crm-common.php
 * Purpose: Shared helpers (escaping, tags list), shared modals (Tags & Quick Action),
 *          and shared JS/CSS utilities used by both leads.php and opportunities.php.
 * Stack : Core PHP. No DB connection here. Collation not required (no queries).
 * ========================================================================== */

if(!function_exists('h')){
  function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}

if(!function_exists('crm_all_tags')){
  function crm_all_tags(){
    return [
      'New Lead','Prospect','Customer','Hot Lead','Partner','LostCustomer','Influencer','Subscriber',
      'Interested','VIP','Follow-up','High Priority','Converted','Potential'
    ];
  }
}

/* ---------- Shared MODALS Renderers ---------- */
if(!function_exists('crm_render_tags_modal')){
  function crm_render_tags_modal(array $ALL_TAGS){
    ob_start(); ?>
    <div class="modal fade" id="tagsManageModal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
        <form class="modal-content" method="post">
          <input type="hidden" name="action" value="update_tags">
          <input type="hidden" name="id" id="tags-id">
          <div class="modal-header">
            <h6 class="modal-title">Change Tag Status</h6>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body px-4">
            <div class="row">
              <?php foreach($ALL_TAGS as $tg): ?>
                <div class="col-6 mb-2">
                  <label class="form-check">
                    <input class="form-check-input tags-check" type="checkbox" name="tags[]" value="<?php echo h($tg); ?>">
                    <span class="form-check-label"><?php echo h($tg); ?></span>
                  </label>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
          <div class="modal-footer"><button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button><button type="submit" class="btn btn-primary">Save</button></div>
        </form>
      </div>
    </div>
    <?php
    return ob_get_clean();
  }
}

if(!function_exists('crm_render_quick_action_modal')){
  function crm_render_quick_action_modal(){
    ob_start(); ?>
    <button type="button" class="d-none" data-bs-toggle="modal" data-bs-target="#exampleModalScrollable4" id="qa-launcher">Launch</button>
    <div class="modal fade" id="exampleModalScrollable4" tabindex="-1" aria-labelledby="exampleModalScrollable4" data-bs-keyboard="false" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
          <div class="modal-header">
            <h6 class="modal-title" id="staticBackdropLabel4">Quick Action</h6>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body" id="qa-body"><div class="text-center text-muted">Select an action.</div></div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="button" class="btn btn-primary" id="qa-save">Save Changes</button>
          </div>
        </div>
      </div>
    </div>
    <?php
    return ob_get_clean();
  }
}

/* ---------- Shared CSS snippet ---------- */
if(!function_exists('crm_common_styles')){
  function crm_common_styles(){
    return '<style>.quick-action-icon{width:32px;height:32px;display:inline-flex;align-items:center;justify-content:center;border-radius:8px}.quick-action-icon i{font-size:16px}</style>';
  }
}

/* ---------- Shared JS (Quick actions + Tags modal) ---------- */
if(!function_exists('crm_common_scripts')){
  function crm_common_scripts($baseUrl){
    ob_start(); ?>
<script>
function crmEsc(s){ return (s||'').replace(/[&<>"']/g, m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;' }[m])); }

/* Builders for quick actions */
function crmBuildCallHTML(d){
  const telHref = d.phone ? 'tel:'+encodeURIComponent(d.phone) : 'javascript:void(0);';
  const now = new Date().toISOString().slice(0,16).replace('T',' ');
  return `
    <h5 class="mb-3">Log a Call</h5>
    <div class="mb-2"><strong>Lead:</strong> ${crmEsc(d.name)}${d.company? ' <span class="text-muted">('+crmEsc(d.company)+')</span>':''}</div>
    <div class="mb-3"><strong>Phone:</strong> ${crmEsc(d.phone||'')} ${d.phone? `<a class="btn btn-sm btn-primary ms-2" href="${telHref}"><i class="ri-phone-fill me-1"></i> Call</a>`:'<span class="text-muted">Not provided</span>'}</div>
    <div class="row g-2">
      <div class="col-md-6"><label class="form-label">Call Time</label><input type="text" class="form-control" value="${now}"></div>
      <div class="col-md-6"><label class="form-label">Duration (mins)</label><input type="number" min="0" step="1" class="form-control" placeholder="e.g. 5"></div>
    </div>
    <div class="mt-3"><label class="form-label">Notes</label><textarea class="form-control" rows="3" placeholder="Call summary, next steps..."></textarea></div>
  `;
}
function crmBuildMailHTML(d){
  const subject = encodeURIComponent('Regarding your enquiry - ' + (d.company||''));
  const body = encodeURIComponent(`Hi ${d.name||''},\n\n—\nSent from CRM`);
  const mailHref = d.email ? `mailto:${encodeURIComponent(d.email)}?subject=${subject}&body=${body}` : 'javascript:void(0);';
  return `
    <h5 class="mb-3">Send Email</h5>
    <div class="mb-2"><strong>Lead:</strong> ${crmEsc(d.name)}${d.company? ' <span class="text-muted">('+crmEsc(d.company)+')</span>':''}</div>
    <div class="mb-3"><strong>Email:</strong> ${crmEsc(d.email||'')} ${d.email? `<a class="btn btn-sm btn-primary ms-2" href="${mailHref}"><i class="ri-mail-send-line me-1"></i> Open Mail</a>`:'<span class="text-muted">Not provided</span>'}</div>
    <div class="mb-2"><label class="form-label">Subject</label><input type="text" class="form-control" value="Regarding your enquiry - ${crmEsc(d.company||'')}"></div>
    <div class="mb-0"><label class="form-label">Message</label><textarea class="form-control" rows="6">Hi ${crmEsc(d.name||'')},

</textarea></div>
  `;
}
function crmBuildTaskHTML(d){
  const tomorrow = new Date(Date.now()+86400000).toISOString().slice(0,10);
  return `
    <h5 class="mb-3">Add Task</h5>
    <div class="mb-2"><strong>Lead:</strong> ${crmEsc(d.name)}${d.company? ' <span class="text-muted">('+crmEsc(d.company)+')</span>':''}</div>
    <div class="mb-2"><label class="form-label">Title</label><input type="text" class="form-control" value="Follow up with ${crmEsc(d.name||'Lead')}"></div>
    <div class="row g-2">
      <div class="col-md-6"><label class="form-label">Due Date</label><input type="date" class="form-control" value="${tomorrow}"></div>
      <div class="col-md-6"><label class="form-label">Priority</label><select class="form-select"><option>Normal</option><option>High</option><option>Low</option></select></div>
    </div>
    <div class="mt-3"><label class="form-label">Notes</label><textarea class="form-control" rows="3" placeholder="What needs to be done?"></textarea></div>
  `;
}

/* Wire quick actions */
function crmWireQuickActions(){
  const qaBody = document.getElementById('qa-body');
  const qaModalEl = document.getElementById('exampleModalScrollable4');
  const qaSaveBtn = document.getElementById('qa-save');
  document.querySelectorAll('.btn-quick-action').forEach(btn=>{
    btn.addEventListener('click', function(){
      const d = this.dataset;
      const titleEl = qaModalEl.querySelector('.modal-title');
      if(d.action==='call'){ titleEl.textContent = 'Call Lead'; qaBody.innerHTML = crmBuildCallHTML(d); }
      else if(d.action==='mail'){ titleEl.textContent = 'Email Lead'; qaBody.innerHTML = crmBuildMailHTML(d); }
      else { titleEl.textContent = 'New Task'; qaBody.innerHTML = crmBuildTaskHTML(d); }
      new bootstrap.Modal(qaModalEl).show();
    });
  });
  if(qaSaveBtn){ qaSaveBtn.addEventListener('click', ()=>{ (bootstrap.Modal.getInstance(qaModalEl)||new bootstrap.Modal(qaModalEl)).hide(); }); }
}

/* Wire Tags modal (clicking on tags cell or "Change") */
function crmWireTagsModal(){
  const tagsModalEl = document.getElementById('tagsManageModal');
  document.querySelectorAll('.tags-cell, .tags-trigger').forEach(node=>{
    node.addEventListener('click', function(){
      const td = this.closest('.tags-cell') || this;
      const id = td.getAttribute('data-id');
      const tags = (td.getAttribute('data-tags')||'').split(',').map(s=>s.trim()).filter(Boolean);
      document.getElementById('tags-id').value = id || '';
      tagsModalEl.querySelectorAll('.tags-check').forEach(ch => { ch.checked = tags.includes(ch.value); });
      new bootstrap.Modal(tagsModalEl).show();
    });
  });
}
</script>
<?php
    return ob_get_clean();
  }
}
