
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap gap-1">
                            <h1 class="page-title fw-medium fs-18 mb-0">Dashboard</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item">
                                    <a href="javascript:void(0);">
                                        Dashboards
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="javascript:void(0);">
                                        Ecommerce
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row">
                        <div class="col-xxl-6">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="card custom-card dashboard-main-card primary">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div>
                                                    <h5 class="fw-semibold">$43,038.00</h5>
                                                    <span class="d-block fs-12 text-muted">Total Sales</span>
                                                </div>
                                                <div>
                                                    <span class="avatar avatar-lg bg-primary-transparent svg-primary">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M5 22h14a2 2 0 0 0 2-2V9a1 1 0 0 0-1-1h-3v-.777c0-2.609-1.903-4.945-4.5-5.198A5.005 5.005 0 0 0 7 7v1H4a1 1 0 0 0-1 1v11a2 2 0 0 0 2 2zm12-12v2h-2v-2h2zM9 7c0-1.654 1.346-3 3-3s3 1.346 3 3v1H9V7zm-2 3h2v2H7v-2z"></path></svg>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="card custom-card dashboard-main-card secondary">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div>
                                                    <h5 class="fw-semibold">$28,346.00</h5>
                                                    <span class="d-block fs-12 text-muted">Total Expenses</span>
                                                </div>
                                                <div>
                                                    <span class="avatar avatar-lg bg-secondary-transparent svg-secondary">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M20 12v6a1 1 0 0 1-2 0V4a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v14c0 1.654 1.346 3 3 3h14c1.654 0 3-1.346 3-3v-6h-2zm-6-1v2H6v-2h8zM6 9V7h8v2H6zm8 6v2h-3v-2h3z"></path></svg>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="card custom-card dashboard-main-card warning">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div>
                                                    <h5 class="fw-semibold">1,29,368</h5>
                                                    <span class="d-block fs-12 text-muted">Total Visitors</span>
                                                </div>
                                                <div>
                                                    <span class="avatar avatar-lg bg-warning-transparent svg-warning">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M7.5 6.5C7.5 8.981 9.519 11 12 11s4.5-2.019 4.5-4.5S14.481 2 12 2 7.5 4.019 7.5 6.5zM20 21h1v-1c0-3.859-3.141-7-7-7h-4c-3.86 0-7 3.141-7 7v1h17z"></path></svg>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="card custom-card dashboard-main-card success">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div>
                                                    <h5 class="fw-semibold">35,367</h5>
                                                    <span class="d-block fs-12 text-muted">Total Orders</span>
                                                </div>
                                                <div>
                                                    <span class="avatar avatar-lg bg-success-transparent svg-success">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M21.822 7.431A1 1 0 0 0 21 7H7.333L6.179 4.23A1.994 1.994 0 0 0 4.333 3H2v2h2.333l4.744 11.385A1 1 0 0 0 10 17h8c.417 0 .79-.259.937-.648l3-8a1 1 0 0 0-.115-.921z"></path><circle cx="10.5" cy="19.5" r="1.5"></circle><circle cx="17.5" cy="19.5" r="1.5"></circle></svg>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Sales Statistics
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="row sales-stats mb-3">
                                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4">
                                                    <div>Orders</div>
                                                    <div class="d-flex align-items-center gap-1">
                                                        <span class="fs-16 fw-semibold">3,542</span>
                                                        <span class="text-success"><i class="ti ti-arrow-narrow-up align-middle"></i>
                                                        <span class="badge bg-success-transparent">0.9%</span></span>
                                                    </div>
                                                </div>
                                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4">
                                                    <div>Revenue</div>
                                                    <div class="d-flex align-items-center gap-1">
                                                        <span class="fs-16 fw-semibold">$52,38,346</span>
                                                        <span class="text-success"><i class="ti ti-arrow-narrow-up align-middle"></i>
                                                        <span class="badge bg-success-transparent">0.39%</span></span>
                                                    </div>
                                                </div>
                                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4">
                                                    <div>Conversion Ratio</div>
                                                    <div class="d-flex align-items-center gap-1">
                                                        <span class="fs-16 fw-semibold text-secondary">33.7%</span>
                                                        <span class="text-success"><i class="ti ti-arrow-narrow-up align-middle"></i>
                                                        <span class="badge bg-success-transparent">0.5%</span></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="sale-stats"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Top Selling Products
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <div class="table-responsive">
                                                <table class="table text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th>s.no</th>
                                                            <th>Product Category</th>
                                                            <th class="text-center">Sale Value</th>
                                                            <th class="text-center">Total Sales</th>
                                                            <th>Status</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>1</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/11.png" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold">TaoTronics Wall Clock</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td class="text-center">
                                                                $699
                                                            </td>
                                                            <td class="text-center">1000</td>
                                                            <td>
                                                                <span class="badge bg-success-transparent">In Stock</span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>2</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/12.png" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold">Club Fleece Hoodie</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td class="text-center">
                                                                $55
                                                            </td>
                                                            <td class="text-center">3,100</td>
                                                            <td>
                                                                <span class="badge bg-success-transparent">In Stock</span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>3</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/14.png" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold">SmartGizmo Pro</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td class="text-center">
                                                                $199
                                                            </td>
                                                            <td class="text-center">1,250</td>
                                                            <td>
                                                                <span class="badge bg-success-transparent">In Stock</span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>4</td>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/16.png" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold">TaoTronics Cattle</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td class="text-center">
                                                                $699
                                                            </td>
                                                            <td class="text-center">1000</td>
                                                            <td>
                                                                <span class="badge bg-danger-transparent">Out Of Stock</span>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="border-bottom-0">5</td>
                                                            <td class="border-bottom-0">
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-sm avatar-rounded bg-light">
                                                                            <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/13.png" alt="">
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <span class="fw-semibold">UltraMaze School Bag</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td class="border-bottom-0 text-center">
                                                                $89
                                                            </td>
                                                            <td class="border-bottom-0 text-center">2,150</td>
                                                            <td class="border-bottom-0">
                                                                <span class="badge bg-success-transparent">In Stock</span>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Recent Orders
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-unstyled ecommerce-recent-orders-list">
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/13.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold"><a href="javascript:void(0);">Urban Chic Satchel</a></span>
                                                            <span class="text-muted fs-12">Fashion & Accessories</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$90</div>
                                                            <span class="fs-12 text-muted">Price</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/15.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold"><a href="javascript:void(0);">TrailBlaze Runners</a></span>
                                                            <span class="text-muted fs-12">Sports & Fitness</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$60</div>
                                                            <span class="fs-12 text-muted">Price</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/19.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold"><a href="javascript:void(0);">VisionTech SLR</a></span>
                                                            <span class="text-muted fs-12">Electronics</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$375</div>
                                                            <span class="fs-12 text-muted">Price</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/6.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold"><a href="javascript:void(0);">FlexiSeat Office Chair</a></span>
                                                            <span class="text-muted fs-12">Furniture</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$150</div>
                                                            <span class="fs-12 text-muted">Price</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-3">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/11.png" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <span class="d-block fw-semibold"><a href="javascript:void(0);">DecoDial Classic</a></span>
                                                            <span class="text-muted fs-12">Home Decor</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$35</div>
                                                            <span class="fs-12 text-muted">Price</span>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Top Categories
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div id="top-categories"></div>
                                            <ul class="list-unstyled top-categories-list mt-3">
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="flex-fill">Mobile</div>
                                                        <div class="fw-semibold">$46,000</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="flex-fill">Desktop</div>
                                                        <div class="fw-semibold">$28,500</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="flex-fill">Tablet</div>
                                                        <div class="fw-semibold">$24,500</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="flex-fill">Others</div>
                                                        <div class="fw-semibold">$19,600</div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-header">
                                            <div class="card-title">
                                                Top Countries By Sales
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3 flex-wrap">
                                                <div>
                                                    <h4 class="mb-0 lh-1">38,256</h4>
                                                </div>
                                                <div><span class="badge bg-primary-transparent ms-2 me-1">12.24%</span><span class="text-muted fs-11">Since last week</span></div>
                                            </div>
                                            <ul class="pt-2 list-unstyled top-country-sales-list">
                                                <li>
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="d-flex align-items-center lh-1 gap-2">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/flags/french_flag.jpg" alt="">
                                                            </span>
                                                            <span class="top-country-name">France</span>
                                                        </div>
                                                        <div>
                                                            <i class="ti ti-trending-up fs-16 text-success"></i>
                                                        </div>
                                                        <div class="fs-14">5,932</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="d-flex align-items-center lh-1 gap-2">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/flags/spain_flag.jpg" alt="">
                                                            </span>
                                                            <span class="top-country-name">spain</span>
                                                        </div>
                                                        <div>
                                                            <i class="ti ti-trending-down fs-16 text-danger"></i>
                                                        </div>
                                                        <div class="fs-14">5,383</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="d-flex align-items-center lh-1 gap-2">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/flags/argentina_flag.jpg" alt="">
                                                            </span>
                                                            <span class="top-country-name">Argentina</span>
                                                        </div>
                                                        <div>
                                                            <i class="ti ti-trending-up fs-16 text-success"></i>
                                                        </div>
                                                        <div class="fs-14">4,825</div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="d-flex align-items-center lh-1 gap-2">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/flags/uae_flag.jpg" alt="">
                                                            </span>
                                                            <span class="top-country-name">Uae</span>
                                                        </div>
                                                        <div>
                                                            <i class="ti ti-trending-up fs-16 text-success"></i>
                                                        </div>
                                                        <div class="fs-14">4,527</div>
                                                    </div>
                                                </li>
                                                <li class="mb-0">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="d-flex align-items-center lh-1 gap-2">
                                                            <span class="avatar avatar-xs avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/flags/germany_flag.jpg" alt="">
                                                            </span>
                                                            <span class="top-country-name">Germany</span>
                                                        </div>
                                                        <div>
                                                            <i class="ti ti-trending-down fs-16 text-danger"></i>
                                                        </div>
                                                        <div class="fs-14">4,501</div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="card custom-card atm-card border-0 overflow-hidden">
                                        <div class="card-body">
                                            <div class="atm-card-background-container">
                                                <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/21.png" alt="">
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div>
                                                    <svg width="50" xmlns="http://www.w3.org/2000/svg" data-name="Layer 3" viewBox="0 0 128 128"><path fill="#ffd66e" d="M30.07,31.722H97.931a12.415,12.415,0,0,1,12.415,12.415V83.865A12.413,12.413,0,0,1,97.933,96.278H30.069A12.415,12.415,0,0,1,17.654,83.864V44.138A12.416,12.416,0,0,1,30.07,31.722Z"></path><path fill="#005f75" d="M97.931,30.047H30.069A14.1,14.1,0,0,0,15.98,44.135V83.862A14.106,14.106,0,0,0,30.069,97.953H97.931A14.106,14.106,0,0,0,112.02,83.862V44.135A14.1,14.1,0,0,0,97.931,30.047ZM71.883,51.653c0,.034.014.064.02.1a1.628,1.628,0,0,0,.173.511c.017.03.039.056.058.086a1.638,1.638,0,0,0,.351.4c.016.013.023.033.04.046a14.084,14.084,0,0,1-.008,22.421c-.023.018-.034.045-.056.064a1.523,1.523,0,0,0-.544.909,1.655,1.655,0,0,0-.042.207c0,.053-.031.1-.031.153V94.6H56.155V76.531c0-.048-.023-.089-.028-.137a1.607,1.607,0,0,0-.042-.209,1.632,1.632,0,0,0-.147-.433c-.02-.036-.047-.067-.069-.1a1.635,1.635,0,0,0-.358-.407c-.011-.008-.015-.021-.026-.029a14.081,14.081,0,0,1,0-22.429c.011-.008.015-.021.026-.029a1.635,1.635,0,0,0,.358-.407c.023-.035.049-.066.069-.1a1.632,1.632,0,0,0,.147-.433,1.607,1.607,0,0,0,.042-.209c0-.047.028-.088.028-.137V33.4H71.845V51.463A1.564,1.564,0,0,0,71.883,51.653ZM108.672,71.1H79.905a17.275,17.275,0,0,0,.133-13.878h28.633ZM19.328,57.218H47.962A17.274,17.274,0,0,0,48.1,71.1H19.328ZM30.069,33.4H52.807V50.678a17.492,17.492,0,0,0-2.967,3.191H19.328V44.135A10.751,10.751,0,0,1,30.069,33.4ZM19.328,83.862V74.444H50.07a17.517,17.517,0,0,0,2.736,2.878V94.6H30.069A10.753,10.753,0,0,1,19.328,83.862ZM97.931,94.6H75.193V77.325a17.509,17.509,0,0,0,2.738-2.88h30.74v9.418A10.753,10.753,0,0,1,97.931,94.6Zm10.74-40.735H78.16a17.492,17.492,0,0,0-2.966-3.191V33.4H97.931a10.751,10.751,0,0,1,10.74,10.739Z"></path></svg>
                                                </div>
                                                <h6 class="fw-semibold mb-0 flex-fill text-fixed-black">Debit Card</h6>
                                                <div><span class="float-end badge badge-sm bg-primary rounded-pill">Max Bank</span></div>
                                            </div>
                                            <p class="fs-18 mb-3 text-fixed-black">**** **** **** ****</p>
                                            <div class="fs-15 mb-3 text-fixed-black">ELISA GIBSON ANABELLA</div>
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <div class="flex-fill">
                                                    <span class="fs-13 mb-1 text-white-75 text-fixed-black">Exp Date:05/27</span>
                                                </div>
                                                <div>
                                                    <span class="fs-14 mb-1"><svg xmlns="http://www.w3.org/2000/svg" width="32.003" height="20"><path fill="#26A6D1" d="M19.994 10c0 5.524-4.475 10-9.997 10s-9.997-4.477-9.997-10 4.476-10 9.997-10 9.997 4.477 9.997 10z"></path><path fill="#E2574C" d="M22.003 0c-2.242 0-4.306.747-5.974 1.994l.008.001c.328.317.69.54.969.905l-2.08.033c-.326.329-.623.687-.903 1.059h3.668c.279.335.537.626.771.996h-5.104c-.187.322-.36.653-.511.997h6.196c.162.343.307.602.43.965h-6.993c-.111.345-.206.698-.278 1.058h7.564c.074.346.131.666.17.992h-7.884c-.033.329-.05.663-.05 1h7.991c0 .354-.025.682-.061 1h-7.88c.034.339.084.672.15 1h7.552c-.078.324-.168.65-.281.988h-7.016c.106.342.235.674.376.998h6.21c-.172.364-.367.655-.582.996h-5.121c.202.35.425.684.667 1.004l3.684.055c-.314.377-.717.604-1.084.934.02.016-.587-.002-1.782-.021 1.818 1.876 4.359 3.046 7.178 3.046 5.523 0 10-4.477 10-10s-4.476-10-10-10z"></path></svg></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Customers Satisfaction
                                                <a href="javascript:void(0);" class="d-block fs-12 text-muted fw-normal text-decoration-underline">View report <i class="ti ti-arrow-narrow-right"></i></a>
                                            </div>
                                            <div class="text-end">
                                                <span class="d-block fw-semibold">25,765</span>
                                                <span class="d-block fs-12 text-muted">Total Customers</span>
                                            </div>
                                        </div>
                                        <div class="card-body p-0">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 mb-1">
                                                        <div class="fs-14 fw-semibold mb-0 text-primary">85%</div>
                                                        <div class="text-muted flex-fill fs-12">   
                                                            Excellent
                                                        </div>
                                                        <div>
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/emojis/1.png" alt="">
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="85" aria-valuemin="0" aria-valuemax="100">
                                                        <div class="progress-bar bg-primary" style="width: 85%"></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 mb-1">
                                                        <div class="fs-14 fw-semibold mb-0 text-success">65%</div>
                                                        <div class="text-muted flex-fill fs-12">   
                                                            Good
                                                        </div>
                                                        <div>
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/emojis/2.png" alt="">
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="65" aria-valuemin="0" aria-valuemax="100">
                                                        <div class="progress-bar bg-success" style="width: 65%"></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 mb-1">
                                                        <div class="fs-14 fw-semibold mb-0 text-info">64%</div>
                                                        <div class="text-muted flex-fill fs-12">   
                                                            Neutral
                                                        </div>
                                                        <div>
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/emojis/3.png" alt="">
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="64" aria-valuemin="0" aria-valuemax="100">
                                                        <div class="progress-bar bg-info" style="width: 64%"></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 mb-1">
                                                        <div class="fs-14 fw-semibold mb-0 text-warning">44%</div>
                                                        <div class="text-muted flex-fill fs-12">   
                                                            Unsatisfied
                                                        </div>
                                                        <div>
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/emojis/4.png" alt="">
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="44" aria-valuemin="0" aria-valuemax="100">
                                                        <div class="progress-bar bg-warning" style="width: 44%"></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 mb-1">
                                                        <div class="fs-14 fw-semibold mb-0 text-orange">35%</div>
                                                        <div class="text-muted flex-fill fs-12">   
                                                            Very Unsatisfied
                                                        </div>
                                                        <div>
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/emojis/5.png" alt="">
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="35" aria-valuemin="0" aria-valuemax="100">
                                                        <div class="progress-bar bg-orange" style="width: 35%"></div>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <div class="d-flex align-items-center gap-2 mb-1">
                                                        <div class="fs-14 fw-semibold mb-0 text-danger">24%</div>
                                                        <div class="text-muted flex-fill fs-12">   
                                                            Poor
                                                        </div>
                                                        <div>
                                                            <span class="avatar avatar-xs">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/emojis/6.png" alt="">
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="progress progress-xs progress-animate" role="progressbar" aria-valuenow="24" aria-valuemin="0" aria-valuemax="100">
                                                        <div class="progress-bar bg-danger" style="width: 24%"></div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card overflow-hidden">
                                        <div class="card-header justify-content-between">
                                            <div class="card-title">
                                                Transaction History
                                            </div>
                                            <a href="javascript:void(0);" class="text-muted text-decoration-underline fs-12">View All <i class="ti ti-arrow-narrow-right"></i></a>
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-unstyled transaction-history-list">
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <div class="fw-semibold">John Doe</div>
                                                            <span class="text-muted fs-12">Credit Card</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$120.50</div>
                                                            <span class="badge bg-success-transparent">Completed</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <div class="fw-semibold">Jane Smith</div>
                                                            <span class="text-muted fs-12">PayPal</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$45.00</div>
                                                            <span class="badge bg-warning-transparent">Pending</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <div class="fw-semibold">Robert Brown</div>
                                                            <span class="text-muted fs-12">Debit Card</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$75.75</div>
                                                            <span class="badge bg-danger-transparent">Failed</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <div class="fw-semibold">Emma Williams</div>
                                                            <span class="text-muted fs-12">Credit Card</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$220.00</div>
                                                            <span class="badge bg-success-transparent">Completed</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <div class="fw-semibold">Michael Johnson</div>
                                                            <span class="text-muted fs-12">PayPal</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$89.99</div>
                                                            <span class="badge bg-success-transparent">Completed</span>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="lh-1">
                                                            <span class="avatar avatar-md avatar-rounded">
                                                                <img src="<?php echo $baseUrl; ?>/assets/images/faces/7.jpg" alt="">
                                                            </span>
                                                        </div>
                                                        <div class="flex-fill">
                                                            <div class="fw-semibold">Sarah Jones</div>
                                                            <span class="text-muted fs-12">Credit Card</span>
                                                        </div>
                                                        <div class="text-end">
                                                            <div class="fw-semibold">$129.99</div>
                                                            <span class="badge bg-warning-transparent">Pending</span>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-1 -->

                    <!-- Start:: row-2 -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card overflow-hidden">
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Order History
                                    </div>
                                    <div class="d-flex flex-wrap gap-2"> 
                                        <div class="dropdown"> 
                                            <a href="javascript:void(0);" class="btn btn-outline-light btn-wave waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="false">Filters<i class="ri-arrow-down-s-line align-middle ms-1 d-inline-block"></i> </a> 
                                            <ul class="dropdown-menu" role="menu"> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">New</a></li> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">Popular</a></li> 
                                                <li><a class="dropdown-item" href="javascript:void(0);">Relevant</a></li> 
                                            </ul> 
                                        </div> 
                                        <div> 
                                            <input class="form-control" type="text" placeholder="Search Here" aria-label=".form-control-sm example"> 
                                        </div> 
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table text-nowrap">
                                            <thead>
                                                <tr>
                                                    <th>Order ID</th>
                                                    <th>Customer</th>
                                                    <th>Product</th>
                                                    <th class="text-center">Quantity</th>
                                                    <th>Total Amount</th>
                                                    <th>Payment Method</th>
                                                    <th>Date</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td><a href="javascript:void(0);">$SPK15432</a></td>
                                                    <td><a href="javascript:void(0);">John Doe</a></td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/13.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>Urban Chic Ladies Bag</div>
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        2
                                                    </td>
                                                    <td>$150.00</td>
                                                    <td>Credit Card</td>
                                                    <td>
                                                        2025-02-10
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-success">Completed</span>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><a href="javascript:void(0);">$SPK15433</a></td>
                                                    <td><a href="javascript:void(0);">Jane Smith</a></td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/15.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>TrailBlaze Runners</div>
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        1
                                                    </td>
                                                    <td>$230.75</td>
                                                    <td>PayPal</td>
                                                    <td>
                                                        2025-02-11
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-warning">Pending</span>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><a href="javascript:void(0);">$SPK15434</a></td>
                                                    <td><a href="javascript:void(0);">Michael Green</a></td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/19.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>VisionTech SLR</div>
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        3
                                                    </td>
                                                    <td>$95.50</td>
                                                    <td>Debit Card</td>
                                                    <td>
                                                        2025-02-12
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-danger">Failed</span>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><a href="javascript:void(0);">$SPK15435</a></td>
                                                    <td><a href="javascript:void(0);">Sarah Johnson</a></td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/6.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div> FlexiSeat Sofa Chair</div>
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        1
                                                    </td>
                                                    <td>$112.00</td>
                                                    <td>Credit Card</td>
                                                    <td>
                                                        2025-02-13
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-success">Completed</span>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><a href="javascript:void(0);">$SPK15436</a></td>
                                                    <td><a href="javascript:void(0);">William Brown</a></td>
                                                    <td>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/11.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>DecoDial Classic</div>
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        5
                                                    </td>
                                                    <td>$60.25</td>
                                                    <td>Credit Card</td>
                                                    <td>
                                                        2025-02-14
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-warning">Pending</span>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="border-bottom-0"><a href="javascript:void(0);">$SPK15437</a></td>
                                                    <td class="border-bottom-0"><a href="javascript:void(0);">Emma White</a></td>
                                                    <td class="border-bottom-0">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <div class="lh-1">
                                                                <span class="avatar avatar-sm avatar-rounded">
                                                                    <img src="<?php echo $baseUrl; ?>/assets/images/ecommerce/png/12.png" alt="">
                                                                </span>
                                                            </div>
                                                            <div>Club Fleece Hoodie</div>
                                                        </div>
                                                    </td>
                                                    <td class="text-center border-bottom-0">
                                                        2
                                                    </td>
                                                    <td class="border-bottom-0">$145.80</td>
                                                    <td class="border-bottom-0">PayPal</td>
                                                    <td class="border-bottom-0">
                                                        2025-02-14
                                                    </td>
                                                    <td class="border-bottom-0">
                                                        <span class="badge bg-success">Completed</span>
                                                    </td>
                                                    <td class="border-bottom-0">
                                                        <div class="dropdown"> 
                                                            <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-light border" data-bs-toggle="dropdown" aria-expanded="false"> <i class="fe fe-more-vertical"></i> </a> 
                                                            <ul class="dropdown-menu"> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-2"></i>View</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-2"></i>Edit</a></li> 
                                                                <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-2"></i>Delete</a></li> 
                                                            </ul> 
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="d-flex align-items-center flex-wrap"> 
                                        <div> Showing 6 Entries <i class="bi bi-arrow-right ms-2 fw-semibold"></i> </div> 
                                        <div class="ms-auto"> 
                                            <nav aria-label="Page navigation" class="pagination-style-2">
                                                <ul class="pagination mb-0 flex-wrap">
                                                    <li class="page-item disabled">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            Prev
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                                    <li class="page-item active"><a class="page-link" href="javascript:void(0);">2</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link" href="javascript:void(0);">
                                                            <i class="bi bi-three-dots"></i>
                                                        </a>
                                                    </li>
                                                    <li class="page-item"><a class="page-link" href="javascript:void(0);">17</a></li>
                                                    <li class="page-item">
                                                        <a class="page-link text-primary" href="javascript:void(0);">
                                                            next
                                                        </a>
                                                    </li>
                                                </ul>
                                            </nav>
                                        </div> 
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-2 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>

        <!-- Ecommerce Dashboard --> 
        <script src="<?php echo $baseUrl; ?>/assets/js/ecommerce-dashboard.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
