<?php
/* admin/applications/kra-upload.php
 * Purpose: Handle per-row KRA file upload for employee applications.
 * Stack  : Core PHP + MySQLi (no PDO). DB connection from ../config.php
 */

session_start();

require_once __DIR__ . '/../config.php';
require_once 'includes/check-permission.php';

$currentPage = basename(__FILE__);
checkPageAccessOrRedirect('approved-list.php', $conn_sa);

function h($v){ return htmlspecialchars((string)($v??''), ENT_QUOTES, 'UTF-8'); }

$redirect = isset($_POST['redirect']) && $_POST['redirect'] !== '' ? $_POST['redirect'] : 'approved-list.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: '.$redirect);
    exit;
}

$appId = isset($_POST['application_id']) ? (int)$_POST['application_id'] : 0;

if ($appId <= 0 || !isset($_FILES['kra_file'])) {
    header('Location: '.$redirect);
    exit;
}

$file = $_FILES['kra_file'];

if ($file['error'] !== UPLOAD_ERR_OK) {
    header('Location: '.$redirect);
    exit;
}

// Basic validation
$allowed_exts = ['pdf','doc','docx','png','jpg','jpeg'];
$max_size     = 5 * 1024 * 1024; // 5 MB

$originalName = $file['name'];
$tmpPath      = $file['tmp_name'];
$size         = (int)$file['size'];

$ext = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));
if (!in_array($ext, $allowed_exts, true)) {
    header('Location: '.$redirect);
    exit;
}
if ($size <= 0 || $size > $max_size) {
    header('Location: '.$redirect);
    exit;
}

// Destination directory
$uploadDir = dirname(__DIR__, 2) . '/uploads/kra/';
if (!is_dir($uploadDir)) {
    @mkdir($uploadDir, 0777, true);
}

// Unique file name
$newName = 'kra_'.$appId.'_'.date('Ymd_His').'.'.$ext;
$destPath = $uploadDir . $newName;

// Move uploaded file
if (!move_uploaded_file($tmpPath, $destPath)) {
    header('Location: '.$redirect);
    exit;
}

// Store relative path (from web root)
$kraPath = 'uploads/kra/' . $newName;

// Update DB
$stmt = mysqli_prepare($conn, "UPDATE employee_applications SET kra_file = ? WHERE id = ?");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'si', $kraPath, $appId);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}

header('Location: '.$redirect);
exit;
