<?php
// layouts/components/load_theme_settings.php
// Returns GLOBAL theme settings so every user gets the same look.

@session_start();

/* include config.php (no PDO) */
$__candidates = [
  __DIR__ . '/../../config.php',
  __DIR__ . '/../config.php',
  __DIR__ . '/config.php',
  dirname(__DIR__, 3) . '/config.php'
];
foreach ($__candidates as $__c) { if (is_file($__c)) { require_once $__c; break; } }

if (!isset($conn) || !$conn) {
  http_response_code(500);
  header('Content-Type: application/json');
  echo json_encode(['ok'=>false,'msg'=>'DB connection not found (config.php)']);
  exit;
}
mysqli_set_charset($conn, 'utf8mb4');

/* ensure table exists (harmless if present) */
@mysqli_query($conn, "CREATE TABLE IF NOT EXISTS `theme_settings` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `scope` ENUM('global','user') NOT NULL DEFAULT 'global',
  `user_id` INT UNSIGNED NOT NULL DEFAULT 0,
  `settings_json` JSON NOT NULL,
  `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_scope_user` (`scope`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci");

/* fetch GLOBAL row */
$settings = [];
$res = mysqli_query($conn, "SELECT settings_json FROM theme_settings WHERE scope='global' AND user_id=0 LIMIT 1");
if ($res && $row = mysqli_fetch_assoc($res)) {
  $settings = json_decode($row['settings_json'], true) ?: [];
  mysqli_free_result($res);
}

header('Content-Type: application/json');
echo json_encode(['ok'=>true,'settings'=>$settings]);
