<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$permissions = [];

if (isset($_SESSION['role_id'])) {
    $roleId = (int)$_SESSION['role_id'];

    if ($roleId === 1) {
        $permissions = ['all'];
    } else {
        if (isset($conn_user) && $conn_user instanceof mysqli) {
            $stmt = $conn_user->prepare("SELECT permissions FROM roles WHERE id = ?");
            if ($stmt) {
                $stmt->bind_param("i", $roleId);
                $stmt->execute();
                $result = $stmt->get_result();

                if ($row = $result->fetch_assoc()) {
                    if (!empty($row['permissions']) && is_string($row['permissions'])) {
                        $decoded = json_decode($row['permissions'], true);
                        if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                            $permissions = $decoded;
                        }
                    }
                }

                $stmt->close();
            }
        }
    }
} else {
    echo "Error: Role ID not found in session.";
}

$permMaster = [];
if (!empty($permissions) && isset($conn_user) && $conn_user instanceof mysqli) {
    $sqlM = "SELECT main_title, page_name, label
             FROM role_permission_master
             WHERE is_active = 1
             ORDER BY main_title, sort_order, label";
    $resM = $conn_user->query($sqlM);
    if ($resM) {
        while ($row = $resM->fetch_assoc()) {
            $mt  = trim($row['main_title']);
            $pg  = trim($row['page_name']);
            $lbl = trim($row['label']);
            if ($mt === '' || $pg === '' || $lbl === '') {
                continue;
            }
            if (!in_array('all', $permissions, true) && !in_array($pg, $permissions, true)) {
                continue;
            }
            if (!isset($permMaster[$mt])) {
                $permMaster[$mt] = [];
            }
            $permMaster[$mt][$pg] = $lbl;
        }
    }
}

$staticPages = [];
?>

<aside class="app-sidebar sticky" id="sidebar">
    <!-- Start::main-sidebar-header -->
    <div class="main-sidebar-header">
        <a href="" class="header-logo">
            <img src="<?php echo $baseUrl; ?>/assets/images/brand-logos/desktop-logo.png" alt="logo" class="desktop-logo">
            <img src="<?php echo $baseUrl; ?>/assets/images/brand-logos/toggle-dark.png" alt="logo" class="toggle-dark">
            <img src="<?php echo $baseUrl; ?>/assets/images/brand-logos/desktop-dark.png" alt="logo" class="desktop-dark">
            <img src="<?php echo $baseUrl; ?>/assets/images/brand-logos/toggle-logo.png" alt="logo" class="toggle-logo">
        </a>
    </div>
    <!-- End::main-sidebar-header -->

    <!-- Start::main-sidebar -->
    <div class="main-sidebar" id="sidebar-scroll">

        <!-- Start::nav -->
        <nav class="main-menu-container nav nav-pills flex-column sub-open">
            <div class="slide-left" id="slide-left">
                <svg xmlns="http://www.w3.org/2000/svg" fill="#7b8191" width="24" height="24" viewBox="0 0 24 24">
                    <path d="M13.293 6.293 7.586 12l5.707 5.707 1.414-1.414L10.414 12l4.293-4.293z"></path>
                </svg>
            </div>
            <ul class="main-menu">
                <!-- Start::slide__category -->
                <li class="slide__category"><span class="category-name">Main</span></li>
                <!-- End::slide__category -->
                
                <!-- Start::Calling Form -->
                <?php
                $callingPages = ['applied_calling_form_applications.php'];
                $staticPages = array_merge($staticPages, $callingPages);
                if (in_array('all', $permissions, true) || in_array('applied_calling_form_applications.php', $permissions, true)): ?>
                <li class="slide">
                    <a href="applied_calling_form_applications.php" class="side-menu__item">
                        <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M16 2H8a2 2 0 0 0-2 2v16l6-3 6 3V4a2 2 0 0 0-2-2z"/>
                            <path d="M15 7h-6"/>
                            <path d="M15 11h-6"/>
                            <path d="M10 15h-1"/>
                            <path d="M19.5 9.5a3.5 3.5 0 0 1-3.5-3.5"/>
                            <path d="M19.5 13a7 7 0 0 1-7-7"/>
                        </svg>
                        <span class="side-menu__label">Calling Form</span>
                    </a>
                </li>
                <?php endif; ?>
                <!-- End::Calling Form -->
                
                <!-- Start::slide PIF Applications -->
                <?php
                $pifPages = ['pif-submitted.php', 'pif-approved.php', 'pif-rejected.php'];
                $staticPages = array_merge($staticPages, $pifPages);
                
                $hasPIF = in_array('all', $permissions, true)
                    || count(array_intersect($pifPages, $permissions)) > 0;
                
                if ($hasPIF):
                ?>
                <li class="slide has-sub">
                    <a href="javascript:void(0);" class="side-menu__item">
                        <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 256 256">
                            <rect width="256" height="256" fill="none"/>
                            <path d="M216,80H40A16,16,0,0,0,24,96V200a16,16,0,0,0,16,16H216a16,16,0,0,0,16-16V96A16,16,0,0,0,216,80ZM128,160a24,24,0,1,1,24-24A24,24,0,0,1,128,160Z"
                                opacity="0.2"/>
                            <path d="M216,80H40A16,16,0,0,0,24,96V200a16,16,0,0,0,16,16H216a16,16,0,0,0,16-16V96A16,16,0,0,0,216,80ZM128,160a24,24,0,1,1,24-24A24,24,0,0,1,128,160Z"
                                fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="40" y1="80" x2="216" y2="80" stroke="currentColor" stroke-width="16" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <span class="side-menu__label">PIF Applications</span>
                        <i class="ri-arrow-right-s-line side-menu__angle"></i>
                    </a>
                
                    <ul class="slide-menu child1">
                
                        <?php if (in_array('all', $permissions, true) || in_array('pif-submitted.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="pif-submitted.php" class="side-menu__item">PIF Submitted</a>
                        </li>
                        <?php endif; ?>
                
                        <?php if (in_array('all', $permissions, true) || in_array('pif-approved.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="pif-approved.php" class="side-menu__item">PIF Approved</a>
                        </li>
                        <?php endif; ?>
                
                        <?php if (in_array('all', $permissions, true) || in_array('pif-rejected.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="pif-rejected.php" class="side-menu__item">PIF Rejected</a>
                        </li>
                        <?php endif; ?>
                
                    </ul>
                </li>
                <?php endif; ?>
                <!-- End::slide PIF Applications -->

                <!-- Start::slide Emp Onboarding -->
                <?php
                $onboardingMenuFiles = [
                    'onb-dashboard.php',
                    'onb-submitted-application.php',
                    'onb-approved-application.php',
                    'onb-inprogress-application.php',
                    'onb-rejected-application.php',
                    'onb-without-applications.php'
                ];
                $staticPages = array_merge($staticPages, $onboardingMenuFiles);

                $hasOnboarding = in_array('all', $permissions, true)
                    || count(array_intersect($onboardingMenuFiles, $permissions)) > 0
                    || (!empty($permMaster['Onboarding'] ?? []));
                if ($hasOnboarding):
                ?>
                <li class="slide has-sub">
                    <a href="javascript:void(0);" class="side-menu__item">
                        <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 256 256">
                            <rect width="256" height="256" fill="none"/>
                            <path d="M133.66,34.34a8,8,0,0,0-11.32,0L40,116.69V216h64V152h48v64h64V116.69Z" opacity="0.2"/>
                            <line x1="16" y1="216" x2="240" y2="216" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <polyline points="152 216 152 152 104 152 104 216" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="40" y1="116.69" x2="40" y2="216" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="216" y1="216" x2="216" y2="116.69" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <path d="M24,132.69l98.34-98.35a8,8,0,0,1,11.32,0L232,132.69" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                        </svg>
                        <span class="side-menu__label">Emp Onboarding</span>
                        <i class="ri-arrow-right-s-line side-menu__angle"></i>
                    </a>
                    <ul class="slide-menu child1">
                        <?php if (in_array('all', $permissions, true) || in_array('onb-dashboard.php', $permissions, true)): ?>
                            <li class="slide">
                                <a href="onb-dashboard.php" class="side-menu__item">Dashboard</a>
                            </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('onb-submitted-application.php', $permissions, true)): ?>
                            <li class="slide">
                                <a href="onb-submitted-application.php" class="side-menu__item">Submitted</a>
                            </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('onb-approved-application.php', $permissions, true)): ?>
                            <li class="slide">
                                <a href="onb-approved-application.php" class="side-menu__item">Approved</a>
                            </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('onb-inprogress-application.php', $permissions, true)): ?>
                            <li class="slide">
                                <a href="onb-inprogress-application.php" class="side-menu__item">In-Progress</a>
                            </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('onb-rejected-application.php', $permissions, true)): ?>
                            <li class="slide">
                                <a href="onb-rejected-application.php" class="side-menu__item">Rejected</a>
                            </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('onb-without-applications.php', $permissions, true)): ?>
                            <li class="slide">
                                <a href="onb-without-applications.php" class="side-menu__item">Without Applications</a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                <!-- End::slide Emp Onboarding -->

                <!-- Start::slide AMS -->
                <?php
                $amsPages = [
                    'ams-dasboard.php',
                    'ams-employee-add.php',
                    'ams-employee-list.php',
                    'ams-employee-edit.php',
                    'ams-tracker.php',
                    'ams-final-cm.php',
                    'ams-final-lm.php',
                    'ams-report-ap-cm.php',
                    'ams-leaves.php',
                    'ams-locations.php'
                ];
                $staticPages = array_merge($staticPages, $amsPages);

                $hasAMS = in_array('all', $permissions, true)
                    || count(array_intersect($amsPages, $permissions)) > 0;
                if ($hasAMS):
                ?>
                <li class="slide has-sub">
                    <a href="javascript:void(0);" class="side-menu__item">
                        <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 256 256">
                            <rect width="256" height="256" fill="none"/>
                            <rect x="48" y="48" width="64" height="64" rx="8" opacity="0.2"/>
                            <rect x="144" y="48" width="64" height="64" rx="8" opacity="0.2"/>
                            <rect x="48" y="144" width="64" height="64" rx="8" opacity="0.2"/>
                            <rect x="144" y="144" width="64" height="64" rx="8" opacity="0.2"/>
                            <rect x="144" y="144" width="64" height="64" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <rect x="48" y="48" width="64" height="64" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <rect x="144" y="48" width="64" height="64" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <rect x="48" y="144" width="64" height="64" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                        </svg>
                        <span class="side-menu__label">AMS</span>
                        <i class="ri-arrow-right-s-line side-menu__angle"></i>
                    </a>
                    <ul class="slide-menu child1">

                        <?php if (in_array('all', $permissions, true) || in_array('ams-dasboard.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="ams-dasboard.php" class="side-menu__item">Dashboard</a>
                        </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('ams-employee-add.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="ams-employee-add.php" class="side-menu__item">Add Employee +</a>
                        </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('ams-employee-list.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="ams-employee-list.php" class="side-menu__item">Employee List</a>
                        </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('ams-tracker.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="ams-tracker.php" class="side-menu__item">Office In/Out (Tracker)</a>
                        </li>
                        <?php endif; ?>

                        <!-- Report Final submenu -->
                        <?php if (in_array('all', $permissions, true) || in_array('ams-final-cm.php', $permissions, true)): ?>
                        <li class="slide has-sub">
                            <a href="javascript:void(0);" class="side-menu__item">
                                Report Final
                                <i class="ri-arrow-right-s-line side-menu__angle"></i>
                            </a>
                            <ul class="slide-menu child2">
                                <?php if (in_array('all', $permissions, true) || in_array('ams-final-cm.php', $permissions, true)): ?>
                                <li class="slide">
                                    <a href="ams-final-cm.php" class="side-menu__item">Current Month</a>
                                </li>
                                <?php endif; ?>
                                <?php if (in_array('all', $permissions, true) || in_array('ams-final-lm.php', $permissions, true)): ?>
                                <li class="slide">
                                    <a href="ams-final-lm.php" class="side-menu__item">Last Month</a>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                        <?php endif; ?>

                        <!-- Report A/P Format submenu -->
                        <?php if (in_array('all', $permissions, true) || in_array('ams-report-ap-cm.php', $permissions, true)): ?>
                        <li class="slide has-sub">
                            <a href="javascript:void(0);" class="side-menu__item">
                                Report A/P Format
                                <i class="ri-arrow-right-s-line side-menu__angle"></i>
                            </a>
                            <ul class="slide-menu child2">
                                <?php if (in_array('all', $permissions, true) || in_array('ams-report-ap-cm.php', $permissions, true)): ?>
                                <li class="slide">
                                    <a href="ams-report-ap-cm.php" class="side-menu__item">Current Month A/P</a>
                                </li>
                                <?php endif; ?>

                                <?php if (in_array('all', $permissions, true) || in_array('ams-report-ap-lm.php', $permissions, true)): ?>
                                <li class="slide">
                                    <a href="ams-report-ap-lm.php" class="side-menu__item">Last Month A/P</a>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('ams-leaves.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="ams-leaves.php" class="side-menu__item">Leaves</a>
                        </li>
                        <?php endif; ?>

                        <?php if (in_array('all', $permissions, true) || in_array('ams-locations.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="ams-locations.php" class="side-menu__item">Locations</a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </li>
                <?php endif; ?>
                <!-- End::slide AMS-->


                <!-- Start::User Roles -->
                <?php
                $userRolesPages = ['user-roles.php', 'user-list.php', 'user-create.php', 'grid-tables.php', 'data-tables.php'];
                $staticPages = array_merge($staticPages, $userRolesPages);

                $hasUserRoles = in_array('all', $permissions, true)
                    || count(array_intersect($userRolesPages, $permissions)) > 0;
                if ($hasUserRoles):
                ?>
                <li class="slide has-sub">
                    <a href="javascript:void(0);" class="side-menu__item" title="User Roles">
                        <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 256 256">
                            <rect width="256" height="256" fill="none"/>
                            <rect x="32" y="104" width="56" height="96" opacity="0.2"/>
                            <path d="M32,56H224a0,0,0,0,1,0,0V192a8,8,0,0,1-8,8H40a8,8,0,0,1-8-8V56A0,0,0,0,1,32,56Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="32" y1="104" x2="224" y2="104" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="32" y1="152" x2="224" y2="152" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="88" y1="104" x2="88" y2="200" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                        </svg>
                        <span class="side-menu__label">User Roles</span>
                        <i class="ri-arrow-right-s-line side-menu__angle"></i>
                    </a>
                    <ul class="slide-menu child1">
                        <?php if (in_array('all', $permissions, true) || in_array('user-roles.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="user-roles.php" class="side-menu__item">
                                Roles
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (in_array('all', $permissions, true) || in_array('user-list.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="user-list.php" class="side-menu__item">
                                User List
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (in_array('all', $permissions, true) || in_array('user-create.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="user-create.php" class="side-menu__item">
                                Create User
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (in_array('all', $permissions, true) || in_array('grid-tables.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="grid-tables.php" class="side-menu__item">
                                Grid JS Tables
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (in_array('all', $permissions, true) || in_array('data-tables.php', $permissions, true)): ?>
                        <li class="slide">
                            <a href="data-tables.php" class="side-menu__item">
                                Data Tables
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                <!-- End::User Roles -->

                <!-- ========== DYNAMIC "MORE" SECTION FOR NEW PAGES ========== -->
                <?php
                $extraSections = [];
                if (!empty($permMaster)) {
                    foreach ($permMaster as $section => $items) {
                        foreach ($items as $pg => $lbl) {
                            if (in_array($pg, $staticPages, true)) {
                                continue; // already shown in static menu
                            }
                            if (!isset($extraSections[$section])) {
                                $extraSections[$section] = [];
                            }
                            $extraSections[$section][$pg] = $lbl;
                        }
                    }
                }

                if (!empty($extraSections)):
                ?>
                    <li class="slide__category"><span class="category-name">More</span></li>
                    <?php foreach ($extraSections as $section => $items): ?>
                        <li class="slide has-sub">
                            <a href="javascript:void(0);" class="side-menu__item">
                                <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 256 256">
                                    <rect width="256" height="256" fill="none"/>
                                    <circle cx="128" cy="128" r="96" opacity="0.2"/>
                                    <circle cx="128" cy="128" r="96" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                    <polyline points="96 120 128 88 160 120" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                    <polyline points="96 160 128 128 160 160" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                </svg>
                                <span class="side-menu__label"><?= htmlspecialchars($section); ?></span>
                                <i class="ri-arrow-right-s-line side-menu__angle"></i>
                            </a>
                            <ul class="slide-menu child1">
                                <?php foreach ($items as $pg => $lbl): ?>
                                    <li class="slide">
                                        <a href="<?= htmlspecialchars($pg); ?>" class="side-menu__item">
                                            <?= htmlspecialchars($lbl); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </li>
                    <?php endforeach; ?>
                <?php endif; ?>
                <!-- ========== END "MORE" SECTION ========== -->

            </ul>

            <!-- Bottom menu -->
            <ul class="doublemenu_bottom-menu main-menu mb-0 border-top">
                <!-- Theme Settings -->
                <li class="slide">
                    <a href="javascript:void(0);" class="side-menu__item layout-setting-doublemenu">
                        <span class="light-layout">
                            <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 256 256">
                                <rect width="256" height="256" fill="none"/>
                                <path d="M108.11,28.11A96.09,96.09,0,0,0,227.89,147.89,96,96,0,1,1,108.11,28.11Z" opacity="0.2"/>
                                <path d="M108.11,28.11A96.09,96.09,0,0,0,227.89,147.89,96,96,0,1,1,108.11,28.11Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            </svg>
                        </span>
                        <span class="dark-layout">
                            <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 256 256">
                                <rect width="256" height="256" fill="none"/>
                                <circle cx="128" cy="128" r="56" opacity="0.2"/>
                                <line x1="128" y1="40" x2="128" y2="32" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                <circle cx="128" cy="128" r="56" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                <line x1="64" y1="64" x2="56" y2="56" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                <line x1="64" y1="192" x2="56" y2="200" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                <line x1="192" y1="64" x2="200" y2="56" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                <line x1="192" y1="192" x2="200" y2="200" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                <line x1="40" y1="128" x2="32" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                <line x1="128" y1="216" x2="128" y2="224" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                                <line x1="216" y1="128" x2="224" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            </svg>
                        </span>
                        <span class="side-menu__label">Theme Settings</span>
                    </a>
                </li>

                <!-- Logout -->
                <li class="slide">
                    <a href="sign-in-cover.php" class="side-menu__item">
                        <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 256 256">
                            <rect width="256" height="256" fill="none"/>
                            <path d="M48,40H208a16,16,0,0,1,16,16V200a16,16,0,0,1-16,16H48a0,0,0,0,1,0,0V40A0,0,0,0,1,48,40Z" opacity="0.2"/>
                            <polyline points="112 40 48 40 48 216 112 216" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="112" y1="128" x2="224" y2="128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <polyline points="184 88 224 128 184 168" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                        </svg>
                        <span class="side-menu__label">Logout</span>
                    </a>
                </li>

                <!-- Profile Settings -->
                <li class="slide">
                    <a href="profile-settings.php" class="side-menu__item">
                        <svg xmlns="http://www.w3.org/2000/svg" class="side-menu__icon" viewBox="0 0 256 256">
                            <rect width="256" height="256" fill="none"/>
                            <path d="M205.31,71.08a16,16,0,0,1-20.39-20.39A96,96,0,0,0,63.8,199.38h0A72,72,0,0,1,128,160a40,40,0,1,1,40-40,40,40,0,0,1-40,40,72,72,0,0,1,64.2,39.37A96,96,0,0,0,205.31,71.08Z" opacity="0.2"/>
                            <line x1="200" y1="40" x2="200" y2="28" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <circle cx="200" cy="56" r="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="186.14" y1="48" x2="175.75" y2="42" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="186.14" y1="64" x2="175.75" y2="70" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="200" y1="72" x2="200" y2="84" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="213.86" y1="64" x2="224.25" y2="70" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <line x1="213.86" y1="48" x2="224.25" y2="42" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <circle cx="128" cy="120" r="40" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <path d="M63.8,199.37a72,72,0,0,1,128.4,0" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                            <path d="M222.67,112A95.92,95.92,0,1,1,144,33.33" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/>
                        </svg>
                        <span class="side-menu__label">Profile Settings</span>
                    </a>
                </li>

                <!-- Profile Avatar -->
                <li class="slide">
                    <a href="profile.php" class="side-menu__item p-1 rounded-circle mb-0">
                        <span class="avatar avatar-md avatar-rounded">
                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="">
                        </span>
                    </a>
                </li>
            </ul>

            <div class="slide-right" id="slide-right">
                <svg xmlns="http://www.w3.org/2000/svg" fill="#7b8191" width="24" height="24" viewBox="0 0 24 24">
                    <path d="M10.707 17.707 16.414 12l-5.707-5.707-1.414 1.414L13.586 12l-4.293 4.293z"></path>
                </svg>
            </div>
        </nav>
        <!-- End::nav -->
    </div>
    <!-- End::main-sidebar -->
</aside>
