<?php
session_start();
require_once __DIR__ . '/../config.php';
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_user);

function h($v){ return htmlspecialchars((string)($v??''), ENT_QUOTES, 'UTF-8'); }

/* ---------- Pagination ---------- */
$allowed_per = [10,25,50,500];
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 10;
if (!in_array($per_page, $allowed_per, true)) { $per_page = 10; }
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($page - 1) * $per_page;

/* ---------- Totals ---------- */
$total_q = mysqli_query($conn_onb, "SELECT COUNT(*) AS c FROM user_pif WHERE st1_status='Rejected'");
$total = ($total_q && ($r=mysqli_fetch_assoc($total_q))) ? (int)$r['c'] : 0;
$total_pages = max(1, (int)ceil($total / $per_page));

/* ---------- Data query ---------- */
$sql = "SELECT * FROM user_pif WHERE st1_status='Rejected' ORDER BY created_at DESC LIMIT {$offset}, {$per_page}";
$q = mysqli_query($conn_onb, $sql);

/* ---------- Styles ---------- */
ob_start();
?>
<style>
.avatar-initial{
    width:40px;height:40px;border-radius:50%;display:flex;align-items:center;justify-content:center;
    font-weight:600;color:#fff;background:#dc3545;
}
.joblist-list .text-sub{font-size:12px;color:#6c757d;margin:0;}
.badge-rejected{background:rgba(220,53,69,.12);color:#dc3545;border:1px solid rgba(220,53,69,.3);}
.table-hover tbody tr:hover{background:rgba(220,53,69,.05);}
</style>
<?php
$styles = ob_get_clean();

/* ---------- Content ---------- */
ob_start();
?>
<div class="page-header-breadcrumb mb-3">
    <div class="d-flex align-center justify-content-between flex-wrap">
        <h1 class="page-title fw-medium fs-18 mb-0">PIF Rejected</h1>
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item">Dashboard</li>
            <li class="breadcrumb-item">PIF-Applications</li>
            <li class="breadcrumb-item active">PIF-Rejected</li>
        </ol>
    </div>
</div>

<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card overflow-hidden">
            <div class="card-header justify-content-between">
                <div class="card-title">All PIF-Rejected Applications</div>
                <div class="d-flex flex-wrap gap-2">
                    <a class="btn btn-danger btn-wave" id="btnRefresh">
                        <i class="ri-refresh-line me-1"></i> Refresh
                    </a>
                    <div>
                        <input id="tableSearch" class="form-control" type="text" placeholder="Search Here">
                    </div>
                    <div class="dropdown">
                        <a href="javascript:void(0);" class="btn btn-danger btn-wave" data-bs-toggle="dropdown">
                            Sort By<i class="ri-arrow-down-s-line align-middle ms-1"></i>
                        </a>
                        <ul class="dropdown-menu" id="sortMenu">
                            <li><a class="dropdown-item" data-sort="created_desc" href="javascript:void(0);">Newest</a></li>
                            <li><a class="dropdown-item" data-sort="created_asc" href="javascript:void(0);">Oldest</a></li>
                            <li><a class="dropdown-item" data-sort="name" href="javascript:void(0);">Applicant Name</a></li>
                        </ul>
                    </div>
                    <div class="dropdown">
                        <a href="javascript:void(0);" class="btn btn-outline-danger btn-wave" data-bs-toggle="dropdown">
                            Rows<i class="ri-arrow-down-s-line align-middle ms-1"></i>
                        </a>
                        <ul class="dropdown-menu">
                            <?php foreach ([10,25,50,500] as $opt): 
                                $active = ($opt===$per_page)?' active':'';
                                $link = '?per_page='.$opt.'&page=1';
                            ?>
                                <li><a class="dropdown-item<?= $active ?>" href="<?= h($link) ?>"><?= h($opt) ?></a></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover text-nowrap" id="appsTable">
                        <thead>
                        <tr>
                            <th>PIF-ID</th>
                            <th>Applicant</th>
                            <th>Email</th>
                            <th>Contact</th>
                            <th>Applied For</th>
                            <th>Date</th>
                            <th>Status</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if($q && mysqli_num_rows($q)>0): ?>
                            <?php while($r=mysqli_fetch_assoc($q)):
                                $name = $r['username'] ?: 'Unknown';
                                $email = $r['email'] ?: '-';
                                $contact = $r['phone'] ?? $r['contact_no'] ?? '-';
                                $applied_for = $r['appliedfor'] ?? '-';
                                $date = $r['created_at'] ? date("M d, Y", strtotime($r['created_at'])) : '-';
                                $initial = strtoupper(substr($name,0,1));
                            ?>
                            <tr class="joblist-list">
                                <td><?= (int)$r['idpif']; ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-initial"><?= h($initial) ?></div>
                                        <div class="ms-2">
                                            <p class="fw-medium mb-0"><?= h($name) ?></p>
                                            <p class="text-sub"><?= h($r['country'] ?? '-') ?></p>
                                        </div>
                                    </div>
                                </td>
                                <td><a href="mailto:<?= h($email) ?>"><?= h($email) ?></a></td>
                                <td><?= h($contact) ?></td>
                                <td><?= h($applied_for) ?></td>
                                <td><?= h($date) ?></td>
                                <td><span class="badge rounded-pill badge-rejected">Rejected</span></td>
                            </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center py-4 text-muted">
                                    No rejected applications found.
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer border-top-0">
                <div class="d-flex align-items-center flex-wrap overflow-auto">
                    <?php
                        $showing_from = ($total === 0) ? 0 : ($offset + 1);
                        $showing_to   = min($offset + $per_page, $total);
                    ?>
                    <div class="mb-2 mb-sm-0">
                        Showing <b><?= h($showing_from); ?></b> to <b><?= h($showing_to); ?></b> of <b><?= h($total); ?></b> entries
                    </div>
                    <div class="ms-auto">
                        <ul class="pagination mb-0 overflow-auto">
                            <?php
                            $prev_disabled = ($page<=1) ? ' disabled' : '';
                            $next_disabled = ($page>=$total_pages) ? ' disabled' : '';
                            $linkBase = '?per_page='.$per_page.'&page=';
                            ?>
                            <li class="page-item<?= $prev_disabled ?>"><a class="page-link" href="<?= h($linkBase . max(1,$page-1)); ?>">Previous</a></li>
                            <?php
                            $window = 5;
                            $start = max(1, $page - (int)floor($window/2));
                            $end   = min($total_pages, $start + $window - 1);
                            $start = max(1, min($start, $end - $window + 1));
                            for ($p=$start; $p<=$end; $p++):
                                $active = ($p===$page) ? ' active' : '';
                            ?>
                                <li class="page-item<?= $active ?>"><a class="page-link" href="<?= h($linkBase.$p); ?>"><?= h($p); ?></a></li>
                            <?php endfor; ?>
                            <li class="page-item<?= $next_disabled ?>"><a class="page-link" href="<?= h($linkBase . min($total_pages,$page+1)); ?>">Next</a></li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php
$content = ob_get_clean();

/* ---------- Scripts ---------- */
ob_start();
?>
<script>
(function(){
    const searchInput = document.getElementById('tableSearch');
    const table = document.getElementById('appsTable');
    const tbody = table ? table.querySelector('tbody') : null;
    const rows = tbody ? Array.from(tbody.querySelectorAll('tr.joblist-list')) : [];
    const refresh = document.getElementById('btnRefresh');

    function norm(s){ return (s||'').toString().toLowerCase().trim(); }

    if (searchInput && rows.length){
        searchInput.addEventListener('input', function(){
            const q = norm(this.value);
            rows.forEach(tr=>{
                const show = !q || norm(tr.innerText).includes(q);
                tr.style.display = show ? '' : 'none';
            });
        });
    }

    const sortMenu = document.getElementById('sortMenu');
    if (sortMenu && rows.length){
        sortMenu.querySelectorAll('.dropdown-item').forEach(item=>{
            item.addEventListener('click', function(){
                const mode = this.getAttribute('data-sort');
                const getName = (tr)=>tr.querySelector('td:nth-child(2) .fw-medium')?.textContent?.trim()||'';
                const getDate = (tr)=>tr.querySelector('td:nth-child(6)')?.textContent?.trim()||'';
                function parseDate(txt){ const d = Date.parse(txt); return isNaN(d)?0:d; }
                const sorted = rows.slice();
                if (mode==='name') sorted.sort((a,b)=>getName(a).localeCompare(getName(b)));
                else if (mode==='created_asc') sorted.sort((a,b)=>parseDate(getDate(a))-parseDate(getDate(b)));
                else sorted.sort((a,b)=>parseDate(getDate(b))-parseDate(getDate(a)));
                sorted.forEach(tr=>tbody.appendChild(tr));
            });
        });
    }

    if (refresh) refresh.addEventListener('click', ()=>location.reload());
})();
</script>
<?php
$scripts = ob_get_clean();

include 'layouts/base.php';
