<?php
session_start();
require_once __DIR__ . '/../config.php';
require_once 'includes/check-permission.php';

$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_user);

function h($v){ return htmlspecialchars((string)($v??''), ENT_QUOTES, 'UTF-8'); }
$loggedEmpid = '';
$loggedName  = '';
if (!empty($_SESSION['user_empid'])) {
    $loggedEmpid = (string)$_SESSION['user_empid'];
} elseif (!empty($_SESSION['hr_empid'])) {
    $loggedEmpid = (string)$_SESSION['hr_empid'];
}
if (!empty($_SESSION['username'])) {
    $loggedName = (string)$_SESSION['username'];
} elseif (!empty($_SESSION['namevfied1'])) {
    $loggedName = (string)$_SESSION['namevfied1'];
}
$allowed_status = ['Submitted','Approved','Rejected'];
$status = isset($_GET['status']) ? $_GET['status'] : 'Submitted';
if (!in_array($status, $allowed_status)) {
    $status = 'Submitted';
}
$btnClass = "btn-success";
if ($status === "Rejected") $btnClass = "btn-danger";
else if ($status === "Approved") $btnClass = "btn-primary";
$allowed_per = [10,25,50,500];
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 10;
if (!in_array($per_page, $allowed_per, true)) { $per_page = 10; }
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($page - 1) * $per_page;

$total_q = mysqli_query($conn_onb, 
    "SELECT COUNT(*) AS c FROM user_pif WHERE st1_status='{$status}'"
);
$total = ($total_q && ($r=mysqli_fetch_assoc($total_q))) ? (int)$r['c'] : 0;
$total_pages = max(1, ceil($total / $per_page));
$sql = "SELECT * FROM user_pif 
        WHERE st1_status='$status'
        ORDER BY created_at DESC
        LIMIT {$offset}, {$per_page}";
$q = mysqli_query($conn_onb, $sql);

if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['approve_idpif'], $_POST['action'])) {
    $pid = (int)$_POST['approve_idpif'];
    $action = $_POST['action'];

    if (in_array($action, ['Approved','Rejected'])) {
        mysqli_query($conn_onb, 
            "UPDATE user_pif 
             SET st1_status='$action', st1_date=CURDATE() 
             WHERE idpif=$pid LIMIT 1"
        );
        $_SESSION['flash_success'] = "Application #$pid marked as $action.";
    }

    header("Location: ?status=".$status."&per_page=".$per_page."&page=".$page);
    exit;
}
ob_start(); ?>
<style>
.avatar-initial {width:40px;height:40px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-weight:600;color:#fff;background:#37d280;}
.joblist-list .text-sub{font-size:12px;color:#6c757d;margin:0;}
.status-btn {font-weight:600; padding:8px 20px;}
.status-active { background:#8f46ff !important; color:#fff !important; }
.pif-title{ font-weight:700; color:#0d6efd; }

/* GLASS CARD */
.glass-card{
    background: rgba(255,255,255,0.8);
    backdrop-filter: blur(10px);
    border-radius: 15px;
    padding: 20px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
}

/* Section Heading */
.section-title{
    font-weight:600;
    color:#333;
    border-left:5px solid #0d6efd;
    padding-left:10px;
}

/* Fields */
.field-label{ font-weight:600; color:#555; }
.field-value{ float:right; color:#111; font-weight:500; }
.field-row{ border-bottom:1px dashed #e5e5e5; }
.job-info-row {
    display: flex;
    flex-wrap: wrap;
    gap: 20px !important;    /* 🔥 REAL GAP APPLY */
}
.job-info-row .col-md-6 {
    flex: 0 0 calc(50% - 10px); /* gap adjust */
}

/* Inner Job Cards */
.inner-card{
    background:#f9f9fc;
    border-radius:12px;
    padding:15px;
    box-shadow:0 4px 15px rgba(0,0,0,0.05);
}

.inner-title{
    font-weight:600;
    border-bottom:1px solid #ddd;
    margin-bottom:8px;
}

/* Stage Cards */
.stage-card{
    background:#fff;
    border-radius:12px;
    padding:15px;
    box-shadow:0 5px 15px rgba(0,0,0,0.08);
}

.stage-head{
    padding:8px;
    border-radius:10px;
    color:#fff;
    margin-bottom:12px;
    text-align:center;
}

.resume-btn{
    padding:10px 25px;
    color:white !important;
    border-radius:10px;
    display:inline-block;
}
.inner-card,
.stage-card {
    position: relative;
    overflow: hidden;
    transition: all 0.35s ease;
}
.inner-card:hover,
.stage-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 12px 28px rgba(0,0,0,0.15);
    background: #ffffff;
}

/* Shine Swipe Effect */
.inner-card::after,
.stage-card::after {
    content: "";
    position: absolute;
    top: 0;
    left: -120%;
    width: 60%;
    height: 100%;
    background: linear-gradient(
        120deg,
        transparent,
        rgba(255,255,255,0.55),
        transparent
    );
    transform: skewX(-25deg);
    transition: 0.7s;
}

/* On Hover: Shine Runs Across Card */
.inner-card:hover::after,
.stage-card:hover::after {
    left: 120%;
}

/* Slight Gradient Edge */
.inner-card::before,
.stage-card::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    height: 4px;
    width: 100%;
    background: linear-gradient(90deg,#0d6efd,#6f42c1);
    opacity: 0;
    transition: 0.4s;
}

/* Show gradient bar only on hover */
.inner-card:hover::before,
.stage-card:hover::before {
    opacity: 1;
}

.animate-fadein{ animation:fadeIn .4s ease; }
@keyframes fadeIn{
    from{ opacity:0; transform:translateY(10px); }
    to{ opacity:1; transform:translateY(0); }
}
</style>
<?php $styles = ob_get_clean(); ?>


<?php ob_start(); ?>

<div class="page-header-breadcrumb mb-3">
    <div class="d-flex align-center justify-content-between flex-wrap">
        <h1 class="page-title fw-medium fs-18 mb-0">PIF Applications</h1>
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item">Dashboard</li>
            <li class="breadcrumb-item">PIF</li>
            <li class="breadcrumb-item active"><?= h($status) ?> Applications</li>
        </ol>
    </div>
</div>
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card overflow-hidden">
            <div class="card-header justify-content-between">
                <div class="card-title">
                    PIF Applications Data
                    <div class="small text-muted mt-1">
                        Welcome:
                        <strong><?php echo htmlspecialchars((string)$loggedName, ENT_QUOTES, 'UTF-8'); ?></strong>
                        (<?php echo htmlspecialchars((string)$loggedEmpid, ENT_QUOTES, 'UTF-8'); ?>)
                        &nbsp; | &nbsp;
                        <?php echo date('d-M-Y'); ?>
                        &nbsp; | &nbsp;
                        <span class="badge rounded-pill <?= $btnClass ?> btn-wave">
                            Total Records: <?php echo (int)$total; ?>
                        </span>
                    </div>
                </div>
                <div class="d-flex flex-wrap gap-2">
                    <div class="dropdown">
                        <a href="#" class="btn <?= $btnClass ?> dropdown-toggle status-btn" data-bs-toggle="dropdown">
                            <?= h($status) ?>
                        </a>
                        <ul class="dropdown-menu">
                            <?php foreach ($allowed_status as $st): ?>
                                <li>
                                    <a class="dropdown-item <?= ($st==$status?'status-active':'') ?>"
                                       href="?status=<?= h($st) ?>&per_page=<?= h($per_page) ?>&page=1">
                                       <?= h($st) ?>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <a class="btn <?= $btnClass ?> btn-wave" id="btnRefresh">
                        <i class="ri-refresh-line me-1"></i> Refresh
                    </a>
                    <div>
                        <input id="tableSearch" class="form-control" type="text" placeholder="Search Here">
                    </div>
                    <div class="dropdown">
                        <a href="javascript:void(0);" class="btn <?= $btnClass ?> btn-wave" data-bs-toggle="dropdown">
                            Sort By<i class="ri-arrow-down-s-line align-middle ms-1"></i>
                        </a>
                        <ul class="dropdown-menu" id="sortMenu">
                            <li><a class="dropdown-item" data-sort="created_desc" href="javascript:void(0);">Newest</a></li>
                            <li><a class="dropdown-item" data-sort="created_asc" href="javascript:void(0);">Oldest</a></li>
                            <li><a class="dropdown-item" data-sort="name" href="javascript:void(0);">Applicant Name</a></li>
                        </ul>
                    </div>
                    <div class="dropdown">
                        <a href="javascript:void(0);" class="btn btn-outline-success btn-wave" data-bs-toggle="dropdown">
                            Rows<i class="ri-arrow-down-s-line align-middle ms-1"></i>
                        </a>
                        <ul class="dropdown-menu">
                            <?php foreach ([10,25,50,500] as $opt): 
                                $active = ($opt===$per_page)?' active':'';
                                $link = '?per_page='.$opt.'&page=1';
                            ?>
                                <li><a class="dropdown-item<?= $active ?>" href="<?= h($link) ?>"><?= h($opt) ?></a></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover text-nowrap" id="appsTable">
                <thead>
                    <tr>
                        <th>PIF-ID</th>
                        <th>Applicant</th>
                        <th>Email</th>
                        <th>Contact</th>
                        <th>Applied For</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                <?php if($q && mysqli_num_rows($q) > 0): ?>
                    <?php while($r=mysqli_fetch_assoc($q)): ?>
                        <tr class="joblist-list">
                            <td><?= $r['idpif'] ?></td>

                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar-initial <?= $btnClass ?> btn-wave"><?= strtoupper(substr($r['username'],0,1)) ?></div>
                                    <div class="ms-2">
                                        <strong><?= h($r['username']) ?></strong>
                                        <p class="text-sub"><?= h($r['currentCity'])?? '-' ?></p>
                                    </div>
                                </div>
                            </td>

                            <td><?= h($r['email']) ?></td>
                            <td><?= h($r['phone']) ?></td>
                            <td><?= h($r['appliedfor']) ?></td>
                            <td><?= h($r['st1_status']) ?></td>
                            <td><?= date("M d, Y", strtotime($r['created_at'])) ?></td>

                            <td>
                                <button class="btn <?= $btnClass ?> btn-sm btn-preview"
                                    data-id="<?= $r['idpif'] ?>"
                                    data-callingid="<?= h($r['callingid']) ?>"
                                    data-recruiter_name="<?= h($r['recruiter_name']) ?>"
                                    data-team_name="<?= h($r['team_name']) ?>"
                                    data-appliedfor="<?= h($r['appliedfor']) ?>"
                                    data-current_salary="<?= h($r['current_salary']) ?>"
                                    data-expected_salary="<?= h($r['expected_salary']) ?>"
                                    data-notice_period="<?= h($r['notice_period']) ?>"
                                    data-qualification="<?= h($r['qualification']) ?>"
                                    data-lastorg="<?= h($r['lastorg']) ?>"
                                    data-last_designation="<?= h($r['last_designation']) ?>"
                                    data-jobtype="<?= h($r['jobType']) ?>"
                                    data-totalexp="<?= h($r['totalExp']) ?>"
                                    data-reason="<?= h($r['reason']) ?>"
                                    data-lastorgemail="<?= h($r['lastOrgEmail']) ?>"
                                    data-know_about="<?= h($r['know_about']) ?>"
                                    data-others="<?= h($r['others']) ?>"
                                    data-ref="<?= h($r['ref']) ?>"
                                    data-refname="<?= h($r['refname']) ?>"
                                    data-empl="<?= h($r['empl']) ?>"
                                    data-earlier_team="<?= h($r['earlier_team']) ?>"
                                    data-earlier_employment="<?= h($r['earlier_employment']) ?>"
                                    data-earlier_position="<?= h($r['earlier_position']) ?>"
                                    data-earlier_leaving="<?= h($r['earlier_leaving']) ?>"
                                    data-username="<?= h($r['username']) ?>"
                                    data-phone="<?= h($r['phone']) ?>"
                                    data-email="<?= h($r['email']) ?>"
                                    data-gender="<?= h($r['gender']) ?>"
                                    data-marital_status="<?= h($r['marital_status']) ?>"
                                    data-dob="<?= h($r['dob']) ?>"
                                    data-currentaddress="<?= h($r['currentAddress']) ?>"
                                    data-currentcity="<?= h($r['currentCity']) ?>"
                                    data-conveyance="<?= h($r['conveyance']) ?>"
                                    data-convyes="<?= h($r['convyes']) ?>"
                                    data-own_device="<?= h($r['own_device']) ?>"
                                    data-device_type="<?= h($r['device_type']) ?>"
                                    data-interview_date_empid="<?= h($r['interview_date_EMPID']) ?>"
                                    data-st1_feedback="<?= h($r['st1_feedback']) ?>"
                                    data-st1_status="<?= h($r['st1_status']) ?>"
                                    data-st1_date="<?= h($r['st1_date']) ?>"
                                    data-st2_feedback="<?= h($r['st2_feedback']) ?>"
                                    data-st2_status="<?= h($r['st2_status']) ?>"
                                    data-st2_date="<?= h($r['st2_date']) ?>"
                                    data-st3_feedback="<?= h($r['st3_feedback']) ?>"
                                    data-st3_status="<?= h($r['st3_status']) ?>"
                                    data-st3_date="<?= h($r['st3_date']) ?>"
                                    data-resume="<?= h($r['resume']) ?>"
                                    data-created_at="<?= h($r['created_at']) ?>"
                                    data-updated_at="<?= h($r['updated_at']) ?>"
                                
                                    data-bs-toggle="modal"
                                    data-bs-target="#previewModal">
                                
                                    <i class="ri-eye-line"></i>
                                    Preview
                                </button>

                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="7" class="text-center py-4 text-muted">No Records Found.</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
   <div class="card-footer border-top-0">
                <div class="d-flex align-items-center flex-wrap overflow-auto">
                    <?php
                        $showing_from = ($total === 0) ? 0 : ($offset + 1);
                        $showing_to   = min($offset + $per_page, $total);
                    ?>
                    <div class="mb-2 mb-sm-0">
                        Showing <b><?= h($showing_from); ?></b> to <b><?= h($showing_to); ?></b> of <b><?= h($total); ?></b> entries
                    </div>
                    <div class="ms-auto">
                        <ul class="pagination mb-0 overflow-auto">
                            <?php
                            $prev_disabled = ($page<=1) ? ' disabled' : '';
                            $next_disabled = ($page>=$total_pages) ? ' disabled' : '';
                            $linkBase = '?per_page='.$per_page.'&page=';
                            ?>
                            <li class="page-item<?= $prev_disabled ?>"><a class="page-link" href="<?= h($linkBase . max(1,$page-1)); ?>">Previous</a></li>
                            <?php
                            $window = 5;
                            $start = max(1, $page - (int)floor($window/2));
                            $end   = min($total_pages, $start + $window - 1);
                            $start = max(1, min($start, $end - $window + 1));
                            for ($p=$start; $p<=$end; $p++):
                                $active = ($p===$page) ? ' active' : '';
                            ?>
                                <li class="page-item<?= $active ?>"><a class="page-link" href="<?= h($linkBase.$p); ?>"><?= h($p); ?></a></li>
                            <?php endfor; ?>
                            <li class="page-item<?= $next_disabled ?>"><a class="page-link" href="<?= h($linkBase . min($total_pages,$page+1)); ?>">Next</a></li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- ================== MODAL ================== -->
<div class="modal fade" id="previewModal">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Application Preview</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body" id="previewBody"></div>

            <!-- FOOTER (Approve/Reject) -->
            <div class="modal-footer d-none" id="previewFooter">
                <form method="POST" class="d-flex gap-2 m-0">
                    <input type="hidden" name="approve_idpif" id="approve_id">
                    <input type="hidden" name="action" id="action_type">

                    <button class="btn btn-success" onclick="setAction('Approved')">Approve</button>
                    <button class="btn btn-danger" onclick="setAction('Rejected')">Reject</button>
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </form>
            </div>

        </div>
    </div>
</div>


<?php
$content = ob_get_clean();
ob_start(); ?>
<script>
function setAction(a){
    document.getElementById("action_type").value = a;
}
document.getElementById("btnRefresh").onclick = () => location.reload();
document.getElementById("tableSearch").addEventListener("keyup", function () {
    let filter = this.value.toLowerCase();
    let rows = document.querySelectorAll("#appsTable tbody tr");

    rows.forEach(row => {
        let text = row.innerText.toLowerCase();
        row.style.display = text.includes(filter) ? "" : "none";
    });
});
document.querySelectorAll("#sortMenu .dropdown-item").forEach(item => {
    item.addEventListener("click", () => {
        let sortType = item.dataset.sort;
        let tbody = document.querySelector("#appsTable tbody");
        let rows = Array.from(tbody.querySelectorAll("tr"));

        rows.sort((a, b) => {
            if (sortType === "created_desc") { 
                return new Date(b.cells[6].innerText) - new Date(a.cells[6].innerText);
            }
            if (sortType === "created_asc") {
                return new Date(a.cells[6].innerText) - new Date(b.cells[6].innerText);
            }
            if (sortType === "name") {
                return a.cells[1].innerText.localeCompare(b.cells[1].innerText);
            }
        });

        rows.forEach(r => tbody.appendChild(r));
    });
});

document.querySelectorAll('.dropdown-menu a').forEach(a => {
    if (a.closest('.dropdown').previousElementSibling?.innerText.includes("Rows")) {
        a.addEventListener("click", function(){
            location.href = this.getAttribute("href");
        });
    }
});
document.querySelectorAll(".btn-preview").forEach(btn => {
    btn.addEventListener("click", () => {

        const footer = document.getElementById("previewFooter");
        footer.classList.toggle("d-none", btn.dataset.st1_status !== "Submitted");

        const id = btn.dataset.id;
        document.getElementById("approve_id").value = id;

        function stageBadge(status){
            let color = "secondary";
            if(status === "Approved") color = "primary";
            if(status === "Rejected") color = "danger";
            if(status === "Submitted") color = "success";

            return `<span class="badge bg-${color}">${status}</span>`;
        }

        document.getElementById("previewBody").innerHTML = `
        
            <div class="container-fluid py-3 animate-fadein">

                <h4 class="pif-title"><i class="bi bi-folder2-open"></i> PIF ID: ${id}</h4>
                <hr>

                <!-- PERSONAL INFO -->
                <div class="glass-card mb-4">
                    <h5 class="section-title">
                        <i class="bi bi-person-lines-fill me-2"></i>Personal Information
                    </h5>

                    <div class="row mt-3">
                        ${makeField("Name", btn.dataset.username)}
                        ${makeField("Email", btn.dataset.email)}
                        ${makeField("Phone", btn.dataset.phone)}
                        ${makeField("DOB", btn.dataset.dob)}
                        ${makeField("Gender", btn.dataset.gender)}
                        ${makeField("Marital Status", btn.dataset.marital_status)}
                        ${makeField("City", btn.dataset.currentcity)}
                        ${makeField("Address", btn.dataset.currentaddress)}
                    </div>
                </div>

                <!-- JOB INFO -->
                <div class="glass-card mb-4">
                    <h5 class="section-title"><i class="bi bi-briefcase-fill me-2"></i>Job Information</h5>

                    <div class="row mt-3 job-info-row">
                        <div class="col-md-6 mb-3 inner-card">
                            <h6 class="inner-title">Recruitment</h6>
                            ${makeField("Calling ID", btn.dataset.callingid)}
                            ${makeField("Recruiter Name", btn.dataset.recruiter_name)}
                            ${makeField("Team Name", btn.dataset.team_name)}
                            ${makeField("Applied For", btn.dataset.appliedfor)}
                        </div>

                        <div class="col-md-6 mb-3 inner-card">
                            <h6 class="inner-title">Experience</h6>
                            ${makeField("Last Organization", btn.dataset.lastorg)}
                            ${makeField("Last Designation", btn.dataset.last_designation)}
                            ${makeField("Total Experience", btn.dataset.totalexp)}
                        </div>

                        <div class="col-md-6 mb-3 inner-card">
                            <h6 class="inner-title">Salary</h6>
                            ${makeField("Current Salary", btn.dataset.current_salary)}
                            ${makeField("Expected Salary", btn.dataset.expected_salary)}
                            ${makeField("Notice Period", btn.dataset.notice_period)}
                        </div>

                        <div class="col-md-6 mb-3 inner-card">
                            <h6 class="inner-title">Additional</h6>
                            ${makeField("Job Type", btn.dataset.jobtype)}
                            ${makeField("Conveyance", btn.dataset.conveyance)}
                            ${makeField("Own Device", btn.dataset.own_device)}
                            ${makeField("Device Type", btn.dataset.device_type)}
                            ${makeField("Reference", btn.dataset.ref)}
                            ${makeField("Reference Name", btn.dataset.refname)}
                            ${makeField("Know About", btn.dataset.know_about)}
                            ${makeField("Others", btn.dataset.others)}
                        </div>
                    </div>
                </div>

                <!-- STAGES -->
                <h5 class="section-title mb-3"><i class="bi bi-flag-fill me-2"></i>Candidate Progress</h5>

                <div class="row mb-4">
                    <div class="col-md-4">
                        <div class="stage-card">
                            <h6 class="stage-head <?= $btnClass ?> btn-wave">Stage 1</h6>
                            ${makeField("Status", stageBadge(btn.dataset.st1_status))}
                            ${makeField("Feedback", btn.dataset.st1_feedback)}
                            ${makeField("Date", btn.dataset.st1_date)}
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="stage-card">
                            <h6 class="stage-head <?= $btnClass ?> btn-wave">Stage 2</h6>
                            ${makeField("Status", stageBadge(btn.dataset.st2_status))}
                            ${makeField("Feedback", btn.dataset.st2_feedback)}
                            ${makeField("Date", btn.dataset.st2_date)}
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="stage-card">
                            <h6 class="stage-head <?= $btnClass ?> btn-wave">Stage 3</h6>
                            ${makeField("Status", stageBadge(btn.dataset.st3_status))}
                            ${makeField("Feedback", btn.dataset.st3_feedback)}
                            ${makeField("Date", btn.dataset.st3_date)}
                        </div>
                    </div>
                </div>

                <!-- RESUME -->
                <div class="text-center mt-4">
                    <a href="<?= BASE_URL_DOCUMENT ?>employee/employee-app/uploads/${id}/${btn.dataset.resume}" 
                       class="resume-btn <?= $btnClass ?> btn-wave" target="_blank">
                       <i class="bi bi-file-earmark-text me-2"></i>View Resume
                    </a>
                </div>

            </div>

        `;
    });
});



function makeField(label, value) {
    value = value || '-';
    return `<div class="col-md-6 mb-2"><strong>${label}:</strong> ${value}</div>`;
}
</script>

<?php $scripts = ob_get_clean();

include 'layouts/base.php';
