<?php
// project_cover_delete.php (revised)
// - Resolves projects table dynamically
// - Removes DB value + local file if under /uploads

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* ---------- Config + DB ---------- */
$cfgs = [ __DIR__.'/../config.php', __DIR__.'/../../config.php', __DIR__.'/config.php' ];
foreach ($cfgs as $c) { if (file_exists($c)) { require_once $c; break; } }

$DB = null;
if (isset($conn_crm) && $conn_crm instanceof mysqli) $DB=$conn_crm;
elseif (isset($conn_crmplus) && $conn_crmplus instanceof mysqli) $DB=$conn_crmplus;
elseif (isset($conn) && $conn instanceof mysqli) $DB=$conn;
elseif (isset($conn_sa) && $conn_sa instanceof mysqli) $DB=$conn_sa;
if(!$DB instanceof mysqli) die('DB connection missing');

@mysqli_set_charset($DB,'utf8mb4'); @mysqli_query($DB,"SET NAMES 'utf8mb4'");

/* ---------- Helpers ---------- */
function table_exists($name){ global $DB;
  $name = mysqli_real_escape_string($DB,$name);
  $r=@mysqli_query($DB,"SHOW TABLES LIKE '{$name}'"); $ok=$r && mysqli_num_rows($r)>0; if($r) @mysqli_free_result($r); return $ok;
}
function col_exists($tbl,$col){ global $DB;
  $tbl = mysqli_real_escape_string($DB,$tbl);
  $col = mysqli_real_escape_string($DB,$col);
  $r=@mysqli_query($DB,"SHOW COLUMNS FROM `{$tbl}` LIKE '{$col}'");
  $ok=$r && mysqli_num_rows($r)>0; if($r) @mysqli_free_result($r); return $ok;
}

/* ---------- Resolve table ---------- */
$PROJECTS_TABLE = null;
foreach (['projects','project','tbl_projects','pp_projects'] as $t) {
  if (table_exists($t)) { $PROJECTS_TABLE = $t; break; }
}
if (!$PROJECTS_TABLE) die('Projects table not found.');

$pid = isset($_GET['pid']) ? (int)$_GET['pid'] : 0;

if ($pid>0 && col_exists($PROJECTS_TABLE,'cover_image')) {
  // fetch current cover
  $r = @mysqli_query($DB,"SELECT cover_image FROM `{$PROJECTS_TABLE}` WHERE id={$pid} LIMIT 1");
  $row = $r ? mysqli_fetch_assoc($r) : null; if ($r) @mysqli_free_result($r);

  // null it
  @mysqli_query($DB,"UPDATE `{$PROJECTS_TABLE}` SET cover_image=NULL WHERE id={$pid} LIMIT 1");

  // unlink if local
  if ($row && !empty($row['cover_image'])) {
    $p = parse_url($row['cover_image'], PHP_URL_PATH);
    if ($p && strpos($p, '/uploads/projects/') !== false) {
      $abs = realpath(__DIR__ . '/..' . $p);
      $uploadsRoot = realpath(__DIR__ . '/../uploads/projects');
      if ($abs && $uploadsRoot && strpos($abs, $uploadsRoot) === 0 && file_exists($abs)) { @unlink($abs); }
    }
  }
}

header("Location: project_form.php?id=".$pid);
exit;
