<?php
// project_media_delete.php (revised)
// - Works with url/file_url columns
// - Safely unlinks local files under /uploads/projects
// - Redirects back to project_form.php?id={pid}

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* ---------- Config + DB ---------- */
$cfgs = [ __DIR__.'/../config.php', __DIR__.'/../../config.php', __DIR__.'/config.php' ];
foreach ($cfgs as $c) { if (file_exists($c)) { require_once $c; break; } }

$DB = null;
if (isset($conn_crm) && $conn_crm instanceof mysqli) $DB=$conn_crm;
elseif (isset($conn_crmplus) && $conn_crmplus instanceof mysqli) $DB=$conn_crmplus;
elseif (isset($conn) && $conn instanceof mysqli) $DB=$conn;
elseif (isset($conn_sa) && $conn_sa instanceof mysqli) $DB=$conn_sa;
if(!$DB instanceof mysqli) die('DB connection missing');

@mysqli_set_charset($DB,'utf8mb4'); @mysqli_query($DB,"SET NAMES 'utf8mb4'");

/* ---------- Helpers ---------- */
function col_exists($tbl,$col){ global $DB;
  $tbl = mysqli_real_escape_string($DB,$tbl);
  $col = mysqli_real_escape_string($DB,$col);
  $r=@mysqli_query($DB,"SHOW COLUMNS FROM `{$tbl}` LIKE '{$col}'");
  $ok=$r && mysqli_num_rows($r)>0; if($r) @mysqli_free_result($r); return $ok;
}

/* ---------- Params ---------- */
$id  = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$pid = isset($_GET['pid']) ? (int)$_GET['pid'] : 0;

$MEDIA_TABLE = 'project_media';
$urlCol = col_exists($MEDIA_TABLE,'url') ? 'url' : (col_exists($MEDIA_TABLE,'file_url') ? 'file_url' : null);

if ($id>0 && $urlCol) {
  $r = @mysqli_query($DB,"SELECT `$urlCol` AS file_url FROM `{$MEDIA_TABLE}` WHERE id={$id} LIMIT 1");
  $row = $r ? mysqli_fetch_assoc($r) : null; if ($r) @mysqli_free_result($r);

  @mysqli_query($DB,"DELETE FROM `{$MEDIA_TABLE}` WHERE id={$id} LIMIT 1");

  if ($row && !empty($row['file_url'])) {
    $p = parse_url($row['file_url'], PHP_URL_PATH);
    if ($p && strpos($p, '/uploads/projects/') !== false) {
      $abs = realpath(__DIR__ . '/..' . $p);
      $uploadsRoot = realpath(__DIR__ . '/../uploads/projects');
      if ($abs && $uploadsRoot && strpos($abs, $uploadsRoot) === 0 && file_exists($abs)) { @unlink($abs); }
    }
  }
}

header("Location: project_form.php?id=".$pid);
exit;
