<?php
// project_save.php (revised for multi-config + project_tag)
// - Handles: project_tag (Exclusive / Featured), property_type, listing_type,
//            BHK configs -> bhk_config_json + legacy columns,
//            amenities pivot, gallery, docs, video, floor plans, nearby, etc.
if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* ---------- Config + DB ---------- */
$cfgs=[__DIR__.'/../config.php',__DIR__.'/../../config.php',__DIR__.'/config.php'];
foreach($cfgs as $c){ if(file_exists($c)){ require_once $c; break; } }

$DB = null;
if (isset($conn_crm)     && $conn_crm     instanceof mysqli) $DB = $conn_crm;
elseif (isset($conn_crmplus) && $conn_crmplus instanceof mysqli) $DB = $conn_crmplus;
elseif (isset($conn)     && $conn     instanceof mysqli) $DB = $conn;
elseif (isset($conn_sa)  && $conn_sa  instanceof mysqli) $DB = $conn_sa;
if(!$DB instanceof mysqli){ http_response_code(500); exit('DB not ready'); }

@mysqli_set_charset($DB,'utf8mb4');
@mysqli_query($DB,"SET NAMES 'utf8mb4'");
@mysqli_query($DB,"SET collation_connection='utf8mb4_general_ci'");

/* ---------- Helpers ---------- */
function q($s){ global $DB; return mysqli_real_escape_string($DB,(string)$s); }
function table_exists($n){
    global $DB;
    $r=@mysqli_query($DB,"SHOW TABLES LIKE '".q($n)."'");
    $ok=$r&&mysqli_num_rows($r)>0;
    if($r)@mysqli_free_result($r);
    return $ok;
}
function col_exists($t,$c){
    global $DB;
    $r=@mysqli_query($DB,"SHOW COLUMNS FROM `".q($t)."` LIKE '".q($c)."'");
    $ok=$r&&mysqli_num_rows($r)>0;
    if($r)@mysqli_free_result($r);
    return $ok;
}

function web_origin(){
    $https=(!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off')?'https':'http';
    $host=$_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? 'localhost');
    return $https.'://'.$host;
}
function app_base_path(){
    $dir=rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? '/'),'/');
    if(substr($dir,-6)==='/pages') $dir=rtrim(substr($dir,0,-6),'/');
    return $dir ?: '';
}
function uploads_url($p){ return web_origin().app_base_path().'/uploads/'.ltrim($p,'/'); }
function ensure_dir($p){
    if(!is_dir($p)) @mkdir($p,0775,true);
    @chmod($p,0775);
    return is_dir($p)&&is_writable($p);
}

/* ---------- Resolve tables ---------- */
$PROJECTS_TABLE=null;
foreach(['projects','project','tbl_projects','pp_projects'] as $t){
    if(table_exists($t)){ $PROJECTS_TABLE=$t; break; }
}
if (!$PROJECTS_TABLE) {
    $_SESSION['flash_error']='Projects table not found';
    header('Location: project_form.php');
    exit;
}
$MEDIA_TABLE=table_exists('project_media')?'project_media':null;
$AMENITY_MASTER = table_exists('property_ameneties') ? 'property_ameneties' : null;
$AMENITY_PIVOT  = table_exists('project_ameneties') ? 'project_ameneties' : null;

/* ---------- Media URL column (url/file_url) ---------- */
$MediaURLCol = null;
if ($MEDIA_TABLE) {
  $MediaURLCol = col_exists($MEDIA_TABLE,'url')
    ? 'url'
    : (col_exists($MEDIA_TABLE,'file_url') ? 'file_url' : null);
}

/* ---------- Validate method ---------- */
if($_SERVER['REQUEST_METHOD']!=='POST'){
    header('Location: project_form.php');
    exit;
}
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;

/* Ensure project_tag default = Exclusive if missing */
if (!isset($_POST['project_tag']) || $_POST['project_tag'] === '') {
    $_POST['project_tag'] = 'Exclusive';
}

/* ---------- Basic fields (incl. project_tag) ---------- */
$fields=[
  'title','city','address','configuration','carpet_area','price_text','price_min',
  'website_url','lat','lng',
  'listing_type',
  'property_type',
  'project_tag',      // NEW: Properties (Exclusive / Featured)
  'bedrooms','bathrooms','floors','area_sqft','area_unit',
  'amenities','description','sort_order','is_active',
  'bhk_config_json'
  // property_video handled separately
  // features_json handled separately (nearby)
];

$data=[];
foreach($fields as $f){
  if(!col_exists($PROJECTS_TABLE,$f)) continue;
  $v=$_POST[$f] ?? null;

  if($f==='price_min' || $f==='area_sqft'){
      $data[$f]=($v!==null&&$v!=='')?(string)((float)$v):null;
  } elseif(in_array($f,['bedrooms','bathrooms','floors','sort_order'],true)){
      $data[$f]=($v!==null&&$v!=='')?(string)((int)$v):null;
  } elseif($f==='is_active'){
      $data[$f]=isset($_POST['is_active'])?'1':'0';
  } else {
      $data[$f]=($v!==null?(string)$v:null);
  }
}

/* ---------- Insert/Update project ---------- */
$cols=[];$vals=[];$set=[];
foreach($data as $k=>$v){
    if($id>0){
        $set[]="`$k`=".($v===null?"NULL":"'".q($v)."'");
    } else {
        $cols[]="`$k`";
        $vals[]=($v===null?"NULL":"'".q($v)."'");
    }
}

if($id>0){
  if($set){
      @mysqli_query($DB,"UPDATE `{$PROJECTS_TABLE}` SET ".implode(',',$set)." WHERE id={$id} LIMIT 1");
  }
} else {
  if(!$cols){
      $_SESSION['flash_error']='Nothing to save';
      header('Location: project_form.php');
      exit;
  }
  $sql="INSERT INTO `{$PROJECTS_TABLE}`(".implode(',',$cols).") VALUES(".implode(',',$vals).")";
  if(!@mysqli_query($DB,$sql)){
      $_SESSION['flash_error']='Insert failed: '.mysqli_error($DB);
      header('Location: project_form.php');
      exit;
  }
  $id=(int)mysqli_insert_id($DB);
}

/* ---------- Cover: URL > upload ---------- */
if(col_exists($PROJECTS_TABLE,'cover_image')){
  $coverUrl=trim($_POST['cover_image_url'] ?? '');
  if($coverUrl!==''){
    @mysqli_query($DB,"UPDATE `{$PROJECTS_TABLE}` SET cover_image='".q($coverUrl)."' WHERE id={$id} LIMIT 1");
  } elseif(!empty($_FILES['cover_image_upload']['tmp_name'])){
    $dir=__DIR__.'/../uploads/projects/'.$id.'/images';
    if(ensure_dir($dir)){
      $ext=pathinfo($_FILES['cover_image_upload']['name'],PATHINFO_EXTENSION);
      $ext=$ext?'.'.strtolower(preg_replace('~[^a-z0-9]~i','',$ext)):'.jpg';
      $fname='cover-'.date('YmdHis').'-'.substr(md5(mt_rand()),0,6).$ext;
      $dest=$dir.'/'.$fname;
      if(@move_uploaded_file($_FILES['cover_image_upload']['tmp_name'],$dest)){
        @chmod($dest,0644);
        $url=uploads_url('projects/'.$id.'/images/'.$fname);
        @mysqli_query($DB,"UPDATE `{$PROJECTS_TABLE}` SET cover_image='".q($url)."' WHERE id={$id} LIMIT 1");
      }
    }
  }
}

/* ---------- Gallery (project_media, media_type=image) ---------- */
if(!empty($_FILES['project_images']['name']) && $MEDIA_TABLE && $MediaURLCol){
  $dir=__DIR__.'/../uploads/projects/'.$id.'/images';
  if(ensure_dir($dir)){
    $cnt=is_array($_FILES['project_images']['name'])?count($_FILES['project_images']['name']):0;
    for($i=0;$i<$cnt;$i++){
      if(!isset($_FILES['project_images']['error'][$i]) || $_FILES['project_images']['error'][$i]!==UPLOAD_ERR_OK) continue;
      $tmp=$_FILES['project_images']['tmp_name'][$i];
      $ext=pathinfo($_FILES['project_images']['name'][$i],PATHINFO_EXTENSION);
      $ext=$ext?'.'.strtolower(preg_replace('~[^a-z0-9]~i','',$ext)):'.jpg';
      $fname='img-'.date('YmdHis').'-'.substr(md5(mt_rand()),0,6).$ext;
      $dest=$dir.'/'.$fname;
      if(@move_uploaded_file($tmp,$dest)){
        @chmod($dest,0644);
        $url=uploads_url('projects/'.$id.'/images/'.$fname);
        @mysqli_query($DB,"INSERT INTO `{$MEDIA_TABLE}`(project_id,media_type,title,`{$MediaURLCol}`,sort_order,is_active)
                           VALUES({$id},'image','Image','".q($url)."',10,1)");
      }
    }
  }
}

/* ---------- Documents (project_media, media_type=doc) ---------- */
if(!empty($_FILES['project_docs']['name']) && $MEDIA_TABLE && $MediaURLCol){
  $dir=__DIR__.'/../uploads/projects/'.$id.'/docs';
  if(ensure_dir($dir)){
    $cnt=is_array($_FILES['project_docs']['name'])?count($_FILES['project_docs']['name']):0;
    for($i=0;$i<$cnt;$i++){
      if(!isset($_FILES['project_docs']['error'][$i]) || $_FILES['project_docs']['error'][$i]!==UPLOAD_ERR_OK) continue;
      $tmp=$_FILES['project_docs']['tmp_name'][$i];
      $ext=pathinfo($_FILES['project_docs']['name'][$i],PATHINFO_EXTENSION);
      $ext=$ext?'.'.strtolower(preg_replace('~[^a-z0-9]~i','',$ext)):'';
      $fname='doc-'.date('YmdHis').'-'.substr(md5(mt_rand()),0,6).$ext;
      $dest=$dir.'/'.$fname;
      if(@move_uploaded_file($tmp,$dest)){
        @chmod($dest,0644);
        $url=uploads_url('projects/'.$id.'/docs/'.$fname);
        @mysqli_query($DB,"INSERT INTO `{$MEDIA_TABLE}`(project_id,media_type,title,`{$MediaURLCol}`,sort_order,is_active)
                           VALUES({$id},'doc','Document','".q($url)."',100,1)");
      }
    }
  }
}

/* ---------- Property Video (projects.property_video) ---------- */
if (col_exists($PROJECTS_TABLE,'property_video')) {
  $vurl = trim($_POST['property_video_url'] ?? '');
  if ($vurl !== '') {
    @mysqli_query($DB,"UPDATE `{$PROJECTS_TABLE}` SET property_video='".q($vurl)."' WHERE id={$id} LIMIT 1");
  } elseif (!empty($_FILES['property_video_upload']['tmp_name'])) {
    $dir=__DIR__.'/../uploads/projects/'.$id.'/video';
    if (ensure_dir($dir)) {
      $ext=pathinfo($_FILES['property_video_upload']['name'],PATHINFO_EXTENSION);
      $ext=$ext?'.'.strtolower(preg_replace('~[^a-z0-9]~i','',$ext)):'.mp4';
      $fname='video-'.date('YmdHis').'-'.substr(md5(mt_rand()),0,6).$ext;
      $dest=$dir.'/'.$fname;
      if(@move_uploaded_file($_FILES['property_video_upload']['tmp_name'],$dest)){
        @chmod($dest,0644);
        $url=uploads_url('projects/'.$id.'/video/'.$fname);
        @mysqli_query($DB,"UPDATE `{$PROJECTS_TABLE}` SET property_video='".q($url)."' WHERE id={$id} LIMIT 1");
      }
    }
  }
}

/* ---------- Floor Plans (project_media, media_type=floor) ---------- */
$floor_titles = $_POST['floor_plan_titles'] ?? [];
$floor_urls   = $_POST['floor_plan_urls'] ?? [];
$has_floor_files = !empty($_FILES['floor_plan_images']['name']);

if ($MEDIA_TABLE && $MediaURLCol && (is_array($floor_titles) || is_array($floor_urls) || $has_floor_files)) {
  $dir=__DIR__.'/../uploads/projects/'.$id.'/floors';
  if(ensure_dir($dir)){
    $n = max(
      is_array($floor_titles)?count($floor_titles):0,
      is_array($floor_urls)?count($floor_urls):0,
      (is_array($_FILES['floor_plan_images']['name'])?count($_FILES['floor_plan_images']['name']):0)
    );
    for($i=0;$i<$n;$i++){
      $title = trim($floor_titles[$i] ?? '');
      $urlVal = trim($floor_urls[$i] ?? '');

      $movedUrl = '';
      if(isset($_FILES['floor_plan_images']['error'][$i]) && $_FILES['floor_plan_images']['error'][$i]===UPLOAD_ERR_OK){
        $tmp=$_FILES['floor_plan_images']['tmp_name'][$i];
        $ext=pathinfo($_FILES['floor_plan_images']['name'][$i],PATHINFO_EXTENSION);
        $ext=$ext?'.'.strtolower(preg_replace('~[^a-z0-9]~i','',$ext)):'.jpg';
        $fname='floor-'.date('YmdHis').'-'.substr(md5(mt_rand()),0,6).$ext;
        $dest=$dir.'/'.$fname;
        if(@move_uploaded_file($tmp,$dest)){
          @chmod($dest,0644);
          $movedUrl=uploads_url('projects/'.$id.'/floors/'.$fname);
        }
      }
      $finalUrl = $movedUrl ?: $urlVal;
      if ($finalUrl!=='') {
        $t = ($title!=='') ? $title : 'Floor Plan';
        @mysqli_query($DB,"INSERT INTO `{$MEDIA_TABLE}`(project_id,media_type,title,`{$MediaURLCol}`,sort_order,is_active)
                           VALUES({$id},'floor','".q($t)."','".q($finalUrl)."',50,1)");
      }
    }
  }
}

/* ---------- Amenities Pivot (project_ameneties) ---------- */
if ($AMENITY_PIVOT) {
  $ids = $_POST['amenity_ids'] ?? [];
  $clean = [];
  foreach ((array)$ids as $v) {
      $v=(int)$v;
      if($v>0) $clean[$v]=true;
  }
  @mysqli_query($DB,"DELETE FROM `{$AMENITY_PIVOT}` WHERE project_id={$id}");
  if (!empty($clean)) {
    $values = [];
    foreach (array_keys($clean) as $aid) { $values[] = "({$id},".(int)$aid.")"; }
    @mysqli_query($DB,"INSERT IGNORE INTO `{$AMENITY_PIVOT}`(project_id,amenity_id) VALUES ".implode(',',$values));
  }
}

/* ---------- Nearby -> features_json ---------- */
if (col_exists($PROJECTS_TABLE,'features_json')) {
  $nearby = ['schools'=>[], 'food'=>[]];
  foreach (['schools','food'] as $cat) {
    $src = $_POST["nearby_{$cat}"] ?? [];
    $N = isset($src['name']) ? count($src['name']) : 0;
    for ($i=0;$i<$N;$i++) {
      $name = trim($src['name'][$i] ?? '');
      if ($name==='') continue;
      $nearby[$cat][] = [
        'name'     => $name,
        'distance' => trim($src['distance'][$i] ?? ''),
        'rating'   => (float)($src['rating'][$i] ?? 0),
        'reviews'  => (int)($src['reviews'][$i] ?? 0),
      ];
    }
  }
  $fx = [];
  $existingRaw = $_POST['features_json_existing'] ?? '';
  if ($existingRaw) { $fx = json_decode($existingRaw, true) ?: []; }
  $fx['nearby'] = $nearby;
  $features_json = json_encode($fx, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  @mysqli_query($DB,"UPDATE `{$PROJECTS_TABLE}` SET features_json='".q($features_json)."' WHERE id={$id} LIMIT 1");
}

/* ---------- Done ---------- */
$_SESSION['flash_success']='Saved successfully.';
header('Location: project_form.php?id='.$id.'&ok=1');
