<?php
session_start();
include('../config.php');

$currentPage = basename(__FILE__);

// Handle CRUD operations
$message = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add'])) {
        $amenity_name = $conn->real_escape_string($_POST['amenity_name']);
        $is_active = isset($_POST['is_active']) ? 1 : 0;
        $sort_order = (int)$_POST['sort_order'];
        $sql = "INSERT INTO property_ameneties (amenity_name, is_active, sort_order) VALUES ('$amenity_name', $is_active, $sort_order)";
        if ($conn->query($sql) === TRUE) {
            $message = 'Amenity added successfully.';
        } else {
            $message = 'Error: ' . $conn->error;
        }
    } elseif (isset($_POST['edit'])) {
        $id = (int)$_POST['id'];
        $amenity_name = $conn->real_escape_string($_POST['amenity_name']);
        $is_active = isset($_POST['is_active']) ? 1 : 0;
        $sort_order = (int)$_POST['sort_order'];
        $sql = "UPDATE property_ameneties SET amenity_name='$amenity_name', is_active=$is_active, sort_order=$sort_order WHERE id=$id";
        if ($conn->query($sql) === TRUE) {
            $message = 'Amenity updated successfully.';
        } else {
            $message = 'Error: ' . $conn->error;
        }
    } elseif (isset($_POST['delete'])) {
        $id = (int)$_POST['id'];
        $sql = "DELETE FROM property_ameneties WHERE id=$id";
        if ($conn->query($sql) === TRUE) {
            $message = 'Amenity deleted successfully.';
        } else {
            $message = 'Error: ' . $conn->error;
        }
    }
}


$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

// Get items per page from GET parameter or default to 10
$items_per_page_options = [10, 50, 100, 500];
$items_per_page = isset($_GET['items_per_page']) ? (int)$_GET['items_per_page'] : 10;
if (!in_array($items_per_page, $items_per_page_options)) {
    $items_per_page = 10;
}

// Get search query from GET parameter
$search = isset($_GET['search']) ? $conn->real_escape_string(trim($_GET['search'])) : '';

// Calculate offset based on current page and items per page
$offset = ($page - 1) * $items_per_page;

$where_clause = '';
if ($search !== '') {
    $where_clause = "WHERE amenity_name LIKE '%$search%'";
}

// Fetch total count of filtered amenities for pagination
$count_query = "SELECT COUNT(*) as total FROM property_ameneties $where_clause";
$count_result = $conn->query($count_query);
$total_amenities = 0;
if ($count_result) {
    $row = $count_result->fetch_assoc();
    $total_amenities = (int)$row['total'];
}

// Fetch current page's amenities with filtering, sorting, limit and offset
$amenities = [];
$sql = "SELECT * FROM property_ameneties $where_clause ORDER BY sort_order LIMIT $items_per_page OFFSET $offset";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $amenities[] = $row;
    }
}

?>

<?php ob_start(); ?>

<?php $styles = ob_get_clean(); ?>

<!-- Responsive CSS for mobile view -->
<style>
@media (max-width: 768px) {
    /* Make the amenities table horizontally scrollable on small screens */
    .table-responsive-mobile {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        width: 100%;
        margin-bottom: 1rem;
    }

    table.table {
        width: 100%;
        min-width: 600px; /* allow scrolling if too wide */
    }

    /* Stack form inputs and buttons vertically with spacing */
    form.mb-4 .row > div {
        width: 100% !important;
        margin-bottom: 0.75rem;
    }

    form.mb-4 .btn-primary {
        width: 100%;
    }

    /* Adjust search form inline inputs to stack */
    form.d-flex {
        flex-direction: column !important;
        align-items: stretch !important;
    }

    form.d-flex .input-group, 
    form.d-flex select, 
    form.d-flex button {
        width: 100% !important;
        margin-bottom: 0.5rem;
    }

    /* Modal adjustments */
    #editModal .modal-dialog {
        max-width: 95% !important;
        margin: 1.75rem auto;
    }

    #editModal .modal-content {
        height: auto;
    }
}
</style>

<?php ob_start(); ?>

                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Input Forms</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Datails</li>
                            </ol>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Property Amenities Management</h5>
<form class="d-flex" method="get" action="">
    <div class="input-group me-2" style="width: 300px;">
        <input type="text" class="form-control" name="search" placeholder="Search amenities..." value="<?php echo htmlspecialchars($search); ?>">
        <button class="btn btn-outline-secondary" type="submit">Search</button>
    </div>
    <select name="items_per_page" class="form-select" onchange="this.form.submit()" style="width: 80px;">
        <?php foreach ($items_per_page_options as $option): ?>
            <option value="<?php echo $option; ?>" <?php if ($option == $items_per_page) echo 'selected'; ?>>
                <?php echo $option; ?>
            </option>
        <?php endforeach; ?>
    </select>
    <input type="hidden" name="page" value="1">
</form>
                                </div>
                                <div class="card-body">
                                    <?php if ($message): ?>
                                        <div class="alert alert-info"><?php echo $message; ?></div>
                                    <?php endif; ?>

                                    <!-- Add Form -->
                                    <form method="post" class="mb-4">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <input type="text" name="amenity_name" class="form-control" placeholder="Amenity Name" required>
                                            </div>
                                            <div class="col-md-2">
                                                <input type="number" name="sort_order" class="form-control" placeholder="Sort Order" value="0">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="is_active" checked>
                                                    <label class="form-check-label">Active</label>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <button type="submit" name="add" class="btn btn-primary">Add Amenity</button>
                                            </div>
                                        </div>
                                    </form>

                                    <!-- Amenities Table - wrapped in responsive div for mobile scroll -->
                                    <div class="table-responsive-mobile">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Amenity Name</th>
                                                <th>Sort Order</th>
                                                <th>Active</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($amenities as $amenity): ?>
                                                <tr>
                                                    <td><?php echo $amenity['id']; ?></td>
                                                    <td><?php echo htmlspecialchars($amenity['amenity_name']); ?></td>
                                                    <td><?php echo $amenity['sort_order']; ?></td>
                                                    <td><?php echo $amenity['is_active'] ? 'Yes' : 'No'; ?></td>
                                                    <td>
                                                        <button class="btn btn-sm btn-warning edit-btn" data-id="<?php echo $amenity['id']; ?>" data-name="<?php echo htmlspecialchars($amenity['amenity_name']); ?>" data-sort="<?php echo $amenity['sort_order']; ?>" data-active="<?php echo $amenity['is_active']; ?>">Edit</button>
                                                        <form method="post" style="display:inline;">
                                                            <input type="hidden" name="id" value="<?php echo $amenity['id']; ?>">
                                                            <button type="submit" name="delete" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                    </div> 

                                    <!-- Pagination controls -->
                                        <nav aria-label="Page navigation example">
                                        <ul class="pagination justify-content-center">
                                            <li class="page-item <?php if($page <= 1) echo 'disabled'; ?>">
                                                <a class="page-link" href="?<?php echo http_build_query(['page' => max(1, $page - 1), 'items_per_page' => $items_per_page, 'search' => $search]); ?>" tabindex="-1">Previous</a>
                                            </li>

                                            <li class="page-item disabled">
                                                <a class="page-link" href="#">Page <?php echo $page; ?></a>
                                            </li>

                                            <li class="page-item <?php if (($page * $items_per_page) >= $total_amenities) echo 'disabled'; ?>">
                                                <a class="page-link" href="?<?php echo http_build_query(['page' => $page + 1, 'items_per_page' => $items_per_page, 'search' => $search]); ?>">Next</a>
                                            </li>
                                        </ul>
                                    </nav>

                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Edit Modal -->
                    <div class="modal fade" id="editModal" tabindex="-1">
                        <div class="modal-dialog">
                            <form method="post" class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Edit Amenity</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <input type="hidden" name="id" id="edit-id">
                                    <div class="mb-3">
                                        <label>Amenity Name</label>
                                        <input type="text" name="amenity_name" id="edit-name" class="form-control" required>
                                    </div>
                                    <div class="mb-3">
                                        <label>Sort Order</label>
                                        <input type="number" name="sort_order" id="edit-sort" class="form-control">
                                    </div>
                                    <div class="mb-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="is_active" id="edit-active">
                                            <label class="form-check-label">Active</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                    <button type="submit" name="edit" class="btn btn-primary">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>

<?php $content = ob_get_clean(); ?>

<?php ob_start(); ?>

        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/js/school-dashboard.js"></script>
        <script>
            document.querySelectorAll('.edit-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    document.getElementById('edit-id').value = this.dataset.id;
                    document.getElementById('edit-name').value = this.dataset.name;
                    document.getElementById('edit-sort').value = this.dataset.sort;
                    document.getElementById('edit-active').checked = this.dataset.active == 1;
                    new bootstrap.Modal(document.getElementById('editModal')).show();
                });
            });
        </script>

<?php $scripts = ob_get_clean(); ?>

<?php include 'layouts/base.php'; ?>
