<?php
// File: send_welcome_example.php
// Demo: send a "welcome_email" template on button click.

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['btn_send_welcome'])) {
    require_once __DIR__ . '/zeptomail_helper.php';

    $toEmail = isset($_POST['email']) ? trim($_POST['email']) : '';
    $toName  = isset($_POST['name']) ? trim($_POST['name']) : '';

    // Placeholders used in this template (must match {{NAME}} etc. in template)
    $placeholders = array(
        '{{NAME}}' => $toName
    );

    $result = zepto_send_template($toEmail, $toName, 'welcome_email', $placeholders);

    if (!empty($result['success'])) {
        $msg = 'Welcome email sent successfully!';
    } else {
        $msg = 'Failed to send email: ' . ($result['error'] ?? 'Unknown error');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Send Welcome Email Demo</title>
</head>
<body>
<?php if (!empty($msg)): ?>
    <p><?php echo htmlspecialchars($msg); ?></p>
<?php endif; ?>
<form method="post">
    <label>
        Name:
        <input type="text" name="name" required>
    </label><br>
    <label>
        Email:
        <input type="email" name="email" required>
    </label><br>
    <button type="submit" name="btn_send_welcome" value="1">Send Welcome Email</button>
</form>
</body>
</html>
